/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.build.internal.core.scannerconfig;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.core.settings.model.extension.CConfigurationData;
import org.eclipse.cdt.core.settings.model.extension.CFileData;
import org.eclipse.cdt.core.settings.model.extension.CFolderData;
import org.eclipse.cdt.core.settings.model.extension.CLanguageData;
import org.eclipse.cdt.core.settings.model.extension.CResourceData;
import org.eclipse.cdt.core.settings.model.util.CDataUtil;
import org.eclipse.cdt.core.settings.model.util.IPathSettingsContainerVisitor;
import org.eclipse.cdt.core.settings.model.util.PathSettingsContainer;
import org.eclipse.cdt.make.core.scannerconfig.IDiscoveredPathManager;
import org.eclipse.cdt.make.core.scannerconfig.PathInfo;
import org.eclipse.cdt.managedbuilder.core.ManagedBuilderCorePlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

public class PerFileSettingsCalculator {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];

    private static HashMap<String, ExtsSetSettings> calcExtToExtSetSettingsMap(Map<ExtsSet, ExtsSetSettings> extsSetMap) {
        HashMap<String, ExtsSetSettings> result = null;
        Collection<ExtsSetSettings> values = extsSetMap.values();
        for (ExtsSetSettings setting : values) {
            result = PerFileSettingsCalculator.addExtsInfoToMap(setting, result);
        }
        return result;
    }

    private static HashMap<String, ExtsSetSettings> addExtsInfoToMap(ExtsSetSettings setting, HashMap<String, ExtsSetSettings> map) {
        boolean forceAdd = false;
        String[] exts = setting.fExtsSet.fExts;
        if (map == null) {
            map = new HashMap();
            forceAdd = true;
        }
        int i = 0;
        while (i < exts.length) {
            String ext = exts[i];
            if (forceAdd || !map.containsKey(ext)) {
                map.put(ext, setting);
            }
            ++i;
        }
        return map;
    }

    private RcSetSettings createRcSetInfo(CConfigurationData data) {
        CFolderData rootData = data.getRootFolderData();
        PathSettingsContainer container = PathSettingsContainer.createRootContainer();
        RcSetSettings rcSet = new RcSetSettings(container, (CResourceData)rootData, false);
        rcSet.internalSetSettingsMap(PerFileSettingsCalculator.createExtsSetSettingsMap(rootData));
        CResourceData[] rcDatas = data.getResourceDatas();
        int i = 0;
        while (i < rcDatas.length) {
            CResourceData rcData = rcDatas[i];
            if (rcData != rootData && this.includeRcDataInCalculation(data, rcData)) {
                IPath path = rcData.getPath();
                RcSetSettings curRcSet = rcSet.createChild(path, rcData, false);
                if (rcData.getType() == 8) {
                    HashMap<ExtsSet, ExtsSetSettings> fileMap = new HashMap<ExtsSet, ExtsSetSettings>(1);
                    ExtsSetSettings fileSetting = PerFileSettingsCalculator.createExtsSetSettings(path, (CFileData)rcData);
                    fileMap.put(fileSetting.fExtsSet, fileSetting);
                    curRcSet.internalSetSettingsMap(fileMap);
                } else {
                    curRcSet.internalSetSettingsMap(PerFileSettingsCalculator.createExtsSetSettingsMap((CFolderData)rcData));
                }
            }
            ++i;
        }
        return rcSet;
    }

    protected boolean includeRcDataInCalculation(CConfigurationData cfgData, CResourceData rcData) {
        return true;
    }

    protected CFileData createFileData(CConfigurationData cfgData, IPath path, CFileData base) throws CoreException {
        return cfgData.createFileData(path, base);
    }

    protected CFileData createFileData(CConfigurationData cfgData, IPath path, CFolderData base, CLanguageData langBase) throws CoreException {
        return cfgData.createFileData(path, base, langBase);
    }

    protected CFolderData createFolderData(CConfigurationData cfgData, IPath path, CFolderData base) throws CoreException {
        return cfgData.createFolderData(path, base);
    }

    private RcSetSettings createRcSetSettings(CConfigurationData data, IDiscoveredPathManager.IPerFileDiscoveredPathInfo2 discoveredInfo) {
        RcSetSettings rcSet = this.createRcSetInfo(data);
        Map map = discoveredInfo.getPathInfoMap();
        PathFilePathInfo[] pInfos = PerFileSettingsCalculator.createOrderedInfo(map);
        PerFileSettingsCalculator.mapDiscoveredInfo(rcSet, pInfos);
        PerFileSettingsCalculator.checkRemoveDups(rcSet);
        return rcSet;
    }

    public static IRcSettingInfo createEmptyRcSettingInfo(CFolderData data) {
        RcSettingInfo rcInfo = new RcSettingInfo((CResourceData)data);
        CLanguageData[] lDatas = data.getLanguageDatas();
        PerFileSettingsCalculator.addEmptyLanguageInfos(rcInfo, lDatas);
        return rcInfo;
    }

    private static void addEmptyLanguageInfos(RcSettingInfo rcInfo, CLanguageData[] lDatas) {
        ArrayList<LangSettingInfo> list = rcInfo.fLangInfoList;
        if (list == null) {
            list = new ArrayList<LangSettingInfo>(lDatas.length);
            rcInfo.fLangInfoList = list;
        } else {
            list.ensureCapacity(lDatas.length);
        }
        int i = 0;
        while (i < lDatas.length) {
            list.add(new LangSettingInfo(lDatas[i], PathInfo.EMPTY_INFO));
            ++i;
        }
    }

    private IRcSettingInfo[] mapFileDiscoveredInfo(IProject project, CConfigurationData data, RcSetSettings rcSet, PathFilePathInfo[] pfpis) {
        ArrayList<RcSettingInfo> list = new ArrayList<RcSettingInfo>(pfpis.length);
        int i = 0;
        while (i < pfpis.length) {
            PathFilePathInfo pfpi = pfpis[i];
            IPath projRelPath = pfpi.fPath;
            PathInfo pInfo = pfpi.fInfo;
            if (!pInfo.isEmpty()) {
                LangSettingInfo lInfo;
                ArrayList<LangSettingInfo> tmpList;
                CLanguageData lData;
                RcSettingInfo rcInfo;
                if (projRelPath.segmentCount() == 0) {
                    CFolderData rootData = (CFolderData)rcSet.fRcData;
                    CLanguageData[] lDatas = rootData.getLanguageDatas();
                    IPath[] incPaths = pInfo.getIncludePaths();
                    IPath[] quotedIncPaths = pInfo.getQuoteIncludePaths();
                    IPath[] incFiles = pInfo.getIncludeFiles();
                    IPath[] macroFiles = pInfo.getMacroFiles();
                    Map symbolMap = pInfo.getSymbols();
                    int kinds = 0;
                    if (incPaths.length != 0 || quotedIncPaths.length != 0) {
                        kinds |= 1;
                    }
                    if (incFiles.length != 0) {
                        kinds |= 2;
                    }
                    if (macroFiles.length != 0) {
                        kinds |= 8;
                    }
                    if (symbolMap.size() != 0) {
                        kinds |= 4;
                    }
                    rcInfo = null;
                    int k = 0;
                    while (k < lDatas.length) {
                        lData = lDatas[k];
                        if ((lData.getSupportedEntryKinds() & kinds) != 0) {
                            if (rcInfo == null) {
                                rcInfo = new RcSettingInfo((CResourceData)rootData);
                                tmpList = new ArrayList(lDatas.length - k);
                                rcInfo.fLangInfoList = tmpList;
                            }
                            lInfo = new LangSettingInfo(lData, pInfo);
                            rcInfo.add(lInfo);
                        }
                        ++k;
                    }
                    if (rcInfo != null) {
                        list.add(rcInfo);
                    }
                } else {
                    CResourceData rcData = rcSet.getChild(projRelPath, false).fRcData;
                    if (!rcData.getPath().equals((Object)projRelPath)) {
                        if (rcData.getType() == 4) {
                            CFolderData foData = (CFolderData)rcData;
                            lData = CDataUtil.findLanguagDataForFile((String)projRelPath.lastSegment(), (IProject)project, (CFolderData)((CFolderData)rcData));
                            try {
                                rcData = this.createFileData(data, projRelPath, foData, lData);
                            }
                            catch (CoreException e) {
                                rcData = null;
                                ManagedBuilderCorePlugin.log(e);
                            }
                        } else {
                            try {
                                rcData = this.createFileData(data, projRelPath, (CFileData)rcData);
                            }
                            catch (CoreException e) {
                                rcData = null;
                                ManagedBuilderCorePlugin.log(e);
                            }
                        }
                    }
                    if (rcData != null && (lData = rcData.getType() == 8 ? ((CFileData)rcData).getLanguageData() : CDataUtil.findLanguagDataForFile((String)projRelPath.lastSegment(), (IProject)project, (CFolderData)((CFolderData)rcData))) != null) {
                        rcInfo = new RcSettingInfo(rcData);
                        lInfo = new LangSettingInfo(lData, pInfo);
                        tmpList = new ArrayList<LangSettingInfo>(1);
                        tmpList.add(lInfo);
                        rcInfo.fLangInfoList = tmpList;
                        list.add(rcInfo);
                    }
                }
            }
            ++i;
        }
        return list.toArray(new RcSettingInfo[list.size()]);
    }

    public IRcSettingInfo[] getSettingInfos(IProject project, CConfigurationData data, IDiscoveredPathManager.IPerFileDiscoveredPathInfo2 discoveredInfo, boolean fileDataMode) {
        if (fileDataMode) {
            RcSetSettings rcSettings = this.createRcSetInfo(data);
            PathFilePathInfo[] pInfos = PerFileSettingsCalculator.createOrderedInfo(discoveredInfo.getPathInfoMap());
            return this.mapFileDiscoveredInfo(project, data, rcSettings, pInfos);
        }
        RcSetSettings settings = this.createRcSetSettings(data, discoveredInfo);
        return this.createInfos(data, settings);
    }

    private IRcSettingInfo[] createInfos(CConfigurationData data, RcSetSettings rootSetting) {
        RcSetSettings[] settings = rootSetting.getChildren(true);
        ArrayList<RcSettingInfo> resultList = new ArrayList<RcSettingInfo>();
        int i = 0;
        while (i < settings.length) {
            block16: {
                RcSettingInfo rcInfo;
                CResourceData rcData;
                RcSetSettings setting;
                block17: {
                    setting = settings[i];
                    rcData = setting.fRcData;
                    if (rcData == null) break block16;
                    if (!setting.fIsDerived) break block17;
                    try {
                        rcData = this.createFolderData(data, rcData, setting);
                    }
                    catch (CoreException e) {
                        rcData = null;
                        ManagedBuilderCorePlugin.log(e);
                    }
                    if (rcData == null) break block16;
                    setting.updateRcData(rcData, false);
                }
                if (rcData.getType() == 8) {
                    PathInfo pathInfo;
                    ExtsSetSettings extSetting = (ExtsSetSettings)setting.fExtToExtsSetMap.get(PerFileSettingsCalculator.getFileExt(rcData.getPath()));
                    if (extSetting != null && (pathInfo = extSetting.fMaxMatchInfo) != null) {
                        LangSettingInfo langInfo = new LangSettingInfo(extSetting.fBaseLangData, pathInfo);
                        rcInfo = new RcSettingInfo(rcData);
                        rcInfo.fLangInfoList = new ArrayList(1);
                        rcInfo.fLangInfoList.add(langInfo);
                        resultList.add(rcInfo);
                    }
                } else if (setting.fExtsSetToExtsSetSettingsMap.size() != 0) {
                    rcInfo = new RcSettingInfo(rcData);
                    rcInfo.fLangInfoList = new ArrayList(setting.fExtsSetToExtsSetSettingsMap.size());
                    resultList.add(rcInfo);
                    Collection values = setting.fExtsSetToExtsSetSettingsMap.values();
                    for (ExtsSetSettings extSetting : values) {
                        if (extSetting.fMaxMatchInfo == null || extSetting.fBaseLangData == null) continue;
                        if (extSetting.fIsDerived) {
                            throw new IllegalStateException();
                        }
                        rcInfo.add(new LangSettingInfo(extSetting.fBaseLangData, extSetting.fMaxMatchInfo));
                        if (!extSetting.isMultiple()) continue;
                        Set<Map.Entry<PathInfo, List<PathFilePathInfo>>> entrySet = extSetting.fPathFilePathInfoMap.entrySet();
                        for (Map.Entry<PathInfo, List<PathFilePathInfo>> entry : entrySet) {
                            if (entry.getKey().equals((Object)extSetting.fMaxMatchInfo)) continue;
                            List<PathFilePathInfo> piList = entry.getValue();
                            for (PathFilePathInfo pi : piList) {
                                try {
                                    CFileData fiData = this.createFileData(data, pi.fPath, (CFolderData)rcData, extSetting.fBaseLangData);
                                    CLanguageData fiLangData = fiData.getLanguageData();
                                    if (fiLangData == null) continue;
                                    RcSettingInfo fiInfo = new RcSettingInfo((CResourceData)fiData);
                                    fiInfo.add(new LangSettingInfo(fiLangData, pi.fInfo));
                                    resultList.add(fiInfo);
                                }
                                catch (CoreException e) {
                                    ManagedBuilderCorePlugin.log(e);
                                }
                            }
                        }
                    }
                }
            }
            ++i;
        }
        return resultList.toArray(new RcSettingInfo[resultList.size()]);
    }

    private CFolderData createFolderData(CConfigurationData cfg, CResourceData base, RcSetSettings setting) throws CoreException {
        if (base.getType() == 4) {
            return this.createFolderData(cfg, setting.getPath(), (CFolderData)base);
        }
        throw new IllegalStateException();
    }

    private static void checkRemoveDups(RcSetSettings rcSet) {
        RcSetSettings[] settings = rcSet.getChildren(true);
        int i = 0;
        while (i < settings.length) {
            RcSetSettings parent;
            RcSetSettings setting = settings[i];
            if (setting.fIsDerived && (parent = setting.getParent()) != null && parent.containsEqualMaxMatches(setting, true)) {
                PerFileSettingsCalculator.removeChildAddingChildSettings(parent, setting);
            }
            ++i;
        }
    }

    private static void removeChildAddingChildSettings(RcSetSettings parent, RcSetSettings child) {
        parent.internalAddSettingsMap(child.fExtsSetToExtsSetSettingsMap);
        parent.removeChild(child);
    }

    private static void mapDiscoveredInfo(RcSetSettings rcSet, PathFilePathInfo[] pInfos) {
        int i = 0;
        while (i < pInfos.length) {
            IPath dirPath;
            PathFilePathInfo pInfo = pInfos[i];
            RcSetSettings child = rcSet.getChild(pInfo.fPath);
            if (child == null && (child = rcSet.getChild(dirPath = pInfo.fPath.removeLastSegments(1))) == null && (child = rcSet.createChild(dirPath, null, true)).fExtToExtsSetMap == null) {
                RcSetSettings parent = child.getParent();
                child.fRcData = parent.fRcData;
                child.internalSetSettingsMap(PerFileSettingsCalculator.createEmptyExtSetMapCopy(parent.fExtsSetToExtsSetSettingsMap));
            }
            if (pInfo.fPath.segmentCount() == 0) {
                PerFileSettingsCalculator.processProjectPaths(child, pInfo);
            } else {
                String ext = PerFileSettingsCalculator.getFileExt(pInfo.fPath);
                ExtsSetSettings extsSet = (ExtsSetSettings)child.fExtToExtsSetMap.get(ext);
                if (extsSet == null) {
                    extsSet = new ExtsSetSettings(null, new ExtsSet(new String[]{ext}), false);
                    child.internalAdd(extsSet);
                }
                extsSet.add(pInfo);
            }
            ++i;
        }
    }

    private static void processProjectPaths(RcSetSettings rcSet, PathFilePathInfo pfpi) {
        Collection settings = rcSet.fExtsSetToExtsSetSettingsMap.values();
        for (ExtsSetSettings setting : settings) {
            setting.add(pfpi);
        }
    }

    private static String getFileExt(IPath path) {
        String ext = path.getFileExtension();
        if (ext != null) {
            return ext;
        }
        return "";
    }

    private static HashMap<ExtsSet, ExtsSetSettings> createEmptyExtSetMapCopy(HashMap<ExtsSet, ExtsSetSettings> base) {
        HashMap map = (HashMap)base.clone();
        Set entrySet = map.entrySet();
        for (Map.Entry entry : entrySet) {
            ExtsSetSettings extsSet = (ExtsSetSettings)entry.getValue();
            extsSet = new ExtsSetSettings(extsSet.fBaseLangData, extsSet.fExtsSet, true);
            entry.setValue(extsSet);
        }
        return map;
    }

    private static ExtsSetSettings createExtsSetSettings(IPath path, CFileData data) {
        CLanguageData lData = data.getLanguageData();
        if (lData != null) {
            String ext = PerFileSettingsCalculator.getFileExt(path);
            return PerFileSettingsCalculator.createExtsSetSettings(lData, new String[]{ext});
        }
        return new ExtsSetSettings(null, new ExtsSet(EMPTY_STRING_ARRAY), false);
    }

    private static ExtsSetSettings createExtsSetSettings(CLanguageData lData, String[] exts) {
        return new ExtsSetSettings(lData, new ExtsSet(exts), false);
    }

    private static HashMap<ExtsSet, ExtsSetSettings> createExtsSetSettingsMap(CFolderData data) {
        CLanguageData[] lDatas = data.getLanguageDatas();
        HashMap<ExtsSet, ExtsSetSettings> map = new HashMap<ExtsSet, ExtsSetSettings>(lDatas.length);
        if (lDatas.length != 0) {
            int i = 0;
            while (i < lDatas.length) {
                CLanguageData lData = lDatas[i];
                ExtsSetSettings settings = PerFileSettingsCalculator.createExtsSetSettings(lData, lData.getSourceExtensions());
                map.put(settings.fExtsSet, settings);
                ++i;
            }
        }
        return map;
    }

    private static PathFilePathInfo[] createOrderedInfo(Map<IResource, PathInfo> map) {
        ListIndexStore store = new ListIndexStore(10);
        HashMap<PathInfo, PathInfo> infoMap = new HashMap<PathInfo, PathInfo>();
        Set<Map.Entry<IResource, PathInfo>> entrySet = map.entrySet();
        for (Map.Entry<IResource, PathInfo> entry : entrySet) {
            IResource rc = entry.getKey();
            IPath path = rc.getProjectRelativePath();
            int segCount = path.segmentCount();
            PathInfo info = entry.getValue();
            PathInfo storedInfo = (PathInfo)infoMap.get(info);
            if (storedInfo == null) {
                storedInfo = info;
                infoMap.put(storedInfo, storedInfo);
            }
            store.add(segCount, new PathFilePathInfo(path, storedInfo));
        }
        List<PathFilePathInfo>[] lists = store.getLists();
        int size = 0;
        int i = 0;
        while (i < lists.length) {
            size += lists[i].size();
            ++i;
        }
        PathFilePathInfo[] infos = new PathFilePathInfo[size];
        int num = 0;
        int i2 = 0;
        while (i2 < lists.length) {
            List<PathFilePathInfo> list = lists[i2];
            int listSize = list.size();
            int k = 0;
            while (k < listSize) {
                infos[num++] = list.get(k);
                ++k;
            }
            ++i2;
        }
        return infos;
    }

    private static class ExtsSet {
        private String[] fExts;
        private HashSet<String> fExtsSet;
        private int fHash;

        public ExtsSet(String[] exts) {
            this.fExts = exts == null || exts.length == 0 ? EMPTY_STRING_ARRAY : (String[])exts.clone();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ExtsSet)) {
                return false;
            }
            ExtsSet other = (ExtsSet)obj;
            if (this.fExts.length != other.fExts.length) {
                return false;
            }
            if (this.fExts.length != 0) {
                HashSet set = (HashSet)this.calcExtsSet().clone();
                set.removeAll(other.calcExtsSet());
                if (set.size() != 0) {
                    return false;
                }
            }
            return true;
        }

        public int hashCode() {
            int hash = this.fHash;
            if (hash == 0) {
                hash = 47;
                int i = 0;
                while (i < this.fExts.length) {
                    hash += this.fExts[i].hashCode();
                    ++i;
                }
                this.fHash = hash;
            }
            return hash;
        }

        private HashSet<String> calcExtsSet() {
            if (this.fExtsSet == null) {
                this.fExtsSet = new HashSet<String>(Arrays.asList(this.fExts));
            }
            return this.fExtsSet;
        }

        public String toString() {
            if (this.fExts.length == 0) {
                return "<empty>";
            }
            StringBuilder buf = new StringBuilder();
            int i = 0;
            while (i < this.fExts.length) {
                if (i != 0) {
                    buf.append(",");
                }
                buf.append(this.fExts[i]);
                ++i;
            }
            return buf.toString();
        }
    }

    private static class ExtsSetSettings {
        private ExtsSet fExtsSet;
        Map<PathInfo, List<PathFilePathInfo>> fPathFilePathInfoMap;
        CLanguageData fBaseLangData;
        boolean fIsDerived;
        private PathInfo fMaxMatchInfo;
        private List<PathFilePathInfo> fMaxMatchInfoList;
        private int fHash;

        public ExtsSetSettings(CLanguageData baseLangData, ExtsSet extsSet, boolean isDerived) {
            this.fExtsSet = extsSet;
            this.fBaseLangData = baseLangData;
            this.fIsDerived = isDerived;
        }

        void add(ExtsSetSettings setting) {
            if (setting.fPathFilePathInfoMap != null) {
                Collection<List<PathFilePathInfo>> values = setting.fPathFilePathInfoMap.values();
                for (List<PathFilePathInfo> list : values) {
                    for (PathFilePathInfo pInfo : list) {
                        this.add(pInfo);
                    }
                }
            }
        }

        public void add(PathFilePathInfo pInfo) {
            PathInfo fileInfo;
            List<PathFilePathInfo> list;
            if (this.fPathFilePathInfoMap == null) {
                this.fPathFilePathInfoMap = new HashMap<PathInfo, List<PathFilePathInfo>>(3);
            }
            List<PathFilePathInfo> list2 = list = (fileInfo = pInfo.fInfo) == this.fMaxMatchInfo ? this.fMaxMatchInfoList : this.fPathFilePathInfoMap.get(fileInfo);
            if (list == null) {
                ArrayList<PathFilePathInfo> emptyList = new ArrayList<PathFilePathInfo>();
                this.fPathFilePathInfoMap.put(fileInfo, emptyList);
                if (this.fMaxMatchInfo == null) {
                    this.fMaxMatchInfo = fileInfo;
                    this.fMaxMatchInfoList = emptyList;
                }
            } else if (this.fMaxMatchInfoList != list && this.fMaxMatchInfoList.size() == list.size()) {
                this.fMaxMatchInfoList = list;
                this.fMaxMatchInfo = fileInfo;
            }
            list.add(pInfo);
        }

        public boolean isMultiple() {
            return this.fPathFilePathInfoMap != null && this.fPathFilePathInfoMap.size() > 1;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (this.isMultiple()) {
                return false;
            }
            if (!(obj instanceof ExtsSetSettings)) {
                return false;
            }
            ExtsSetSettings other = (ExtsSetSettings)obj;
            if (other.isMultiple()) {
                return false;
            }
            if (!this.fExtsSet.equals(other.fExtsSet)) {
                return false;
            }
            return CDataUtil.objectsEqual((Object)this.fMaxMatchInfo, (Object)other.fMaxMatchInfo);
        }

        public int hashCode() {
            int hash = this.fHash;
            if (hash == 0) {
                if (this.isMultiple()) {
                    hash = super.hashCode();
                } else {
                    hash = this.fExtsSet.hashCode();
                    if (this.fMaxMatchInfo != null) {
                        hash += this.fMaxMatchInfo.hashCode();
                    }
                }
                this.fHash = hash;
            }
            return hash;
        }
    }

    public static interface ILangSettingInfo {
        public CLanguageData getLanguageData();

        public PathInfo getFilePathInfo();
    }

    public static interface IRcSettingInfo {
        public CResourceData getResourceData();

        public ILangSettingInfo[] getLangInfos();
    }

    private static class LangSettingInfo
    implements ILangSettingInfo {
        private CLanguageData fLangData;
        private PathInfo fPathInfo;

        LangSettingInfo(CLanguageData langData, PathInfo info) {
            this.fLangData = langData;
            this.fPathInfo = info;
        }

        @Override
        public PathInfo getFilePathInfo() {
            return this.fPathInfo;
        }

        @Override
        public CLanguageData getLanguageData() {
            return this.fLangData;
        }
    }

    private static class ListIndexStore {
        private int fMaxIndex;
        private List<PathFilePathInfo>[] fStore;

        private List<PathFilePathInfo>[] emptyStore(int size) {
            return new List[size];
        }

        public ListIndexStore(int size) {
            if (size < 0) {
                size = 0;
            }
            this.fStore = this.emptyStore(size);
        }

        public void add(int index, PathFilePathInfo value) {
            List<Object> list;
            List<Object> list2 = list = this.checkResize(index) ? new ArrayList() : this.fStore[index];
            if (list == null) {
                list = new ArrayList();
                this.fStore[index] = list;
            }
            if (this.fMaxIndex < index) {
                this.fMaxIndex = index;
            }
            list.add(value);
        }

        private boolean checkResize(int index) {
            if (index >= this.fStore.length) {
                int newSize = ++index;
                List<PathFilePathInfo>[] resized = this.emptyStore(newSize);
                if (this.fStore != null && this.fStore.length != 0) {
                    System.arraycopy(this.fStore, 0, resized, 0, this.fStore.length);
                }
                this.fStore = resized;
                return true;
            }
            return false;
        }

        public List<PathFilePathInfo>[] getLists() {
            int size = this.fMaxIndex + 1;
            ArrayList<List<PathFilePathInfo>> list = new ArrayList<List<PathFilePathInfo>>(size);
            int i = 0;
            while (i < size) {
                List<PathFilePathInfo> l = this.fStore[i];
                if (l != null) {
                    list.add(l);
                }
                ++i;
            }
            return list.toArray(this.emptyStore(list.size()));
        }
    }

    private static class PathFilePathInfo {
        IPath fPath;
        PathInfo fInfo;

        PathFilePathInfo(IPath path, PathInfo info) {
            this.fPath = path;
            this.fInfo = info;
        }
    }

    private static class RcSetSettings {
        private CResourceData fRcData;
        private HashMap<String, ExtsSetSettings> fExtToExtsSetMap;
        private HashMap<ExtsSet, ExtsSetSettings> fExtsSetToExtsSetSettingsMap;
        private PathSettingsContainer fContainer;
        private boolean fIsDerived;

        RcSetSettings(PathSettingsContainer cr, CResourceData rcData, boolean isDerived) {
            this.fContainer = cr;
            this.fRcData = rcData;
            this.fIsDerived = isDerived;
            cr.setValue((Object)this);
        }

        public RcSetSettings getChild(IPath path, boolean exactPath) {
            PathSettingsContainer cr = this.fContainer.getChildContainer(path, false, exactPath);
            if (cr != null) {
                return (RcSetSettings)cr.getValue();
            }
            return null;
        }

        public RcSetSettings getChild(IPath path) {
            PathSettingsContainer cr = this.fContainer.getChildContainer(path, false, true);
            if (cr != null) {
                return (RcSetSettings)cr.getValue();
            }
            return null;
        }

        public RcSetSettings createChild(IPath path, CResourceData data, boolean isDerived) {
            PathSettingsContainer cr = this.fContainer.getChildContainer(path, true, true);
            RcSetSettings child = (RcSetSettings)cr.getValue();
            if (child == null) {
                child = new RcSetSettings(cr, data, isDerived);
            }
            return child;
        }

        void updateRcData(CResourceData data, boolean isDerived) {
            this.fRcData = data;
            this.fIsDerived = data != null ? isDerived : false;
            this.updateLangDatas();
        }

        private void updateLangDatas() {
            block7: {
                block6: {
                    if (this.fRcData.getType() != 8) break block6;
                    CLanguageData lData = ((CFileData)this.fRcData).getLanguageData();
                    ExtsSetSettings extSetting = this.fExtToExtsSetMap.get(PerFileSettingsCalculator.getFileExt(this.fRcData.getPath()));
                    if (extSetting != null) {
                        extSetting.fBaseLangData = lData;
                        boolean bl = extSetting.fIsDerived = lData != null ? this.fIsDerived : false;
                    }
                    if (!(extSetting != null ? this.fExtsSetToExtsSetSettingsMap.size() > 1 : this.fExtsSetToExtsSetSettingsMap.size() > 0)) break block7;
                    Collection<ExtsSetSettings> values = this.fExtsSetToExtsSetSettingsMap.values();
                    for (ExtsSetSettings s : values) {
                        if (s == extSetting) continue;
                        s.fBaseLangData = null;
                        s.fIsDerived = false;
                    }
                    break block7;
                }
                CLanguageData[] lDatas = ((CFolderData)this.fRcData).getLanguageDatas();
                HashMap map = (HashMap)this.fExtsSetToExtsSetSettingsMap.clone();
                int i = 0;
                while (i < lDatas.length) {
                    CLanguageData lData = lDatas[i];
                    ExtsSetSettings extSetting = (ExtsSetSettings)map.remove(new ExtsSet(lData.getSourceExtensions()));
                    if (extSetting != null) {
                        extSetting.fBaseLangData = lData;
                        extSetting.fIsDerived = this.fIsDerived;
                    }
                    ++i;
                }
                if (map.size() != 0) {
                    Collection values = map.values();
                    for (ExtsSetSettings extSetting : values) {
                        extSetting.fBaseLangData = null;
                        extSetting.fIsDerived = false;
                    }
                }
            }
        }

        public IPath getPath() {
            return this.fContainer.getPath();
        }

        public RcSetSettings getParent() {
            PathSettingsContainer cr = this.fContainer.getParentContainer();
            if (cr != null) {
                return (RcSetSettings)cr.getValue();
            }
            return null;
        }

        void internalSetSettingsMap(HashMap<ExtsSet, ExtsSetSettings> map) {
            this.fExtsSetToExtsSetSettingsMap = map;
            this.fExtToExtsSetMap = PerFileSettingsCalculator.calcExtToExtSetSettingsMap(map);
        }

        void internalAdd(ExtsSetSettings setting) {
            ExtsSetSettings cur;
            if (this.fExtsSetToExtsSetSettingsMap == null) {
                this.fExtsSetToExtsSetSettingsMap = new HashMap();
            }
            if ((cur = this.fExtsSetToExtsSetSettingsMap.get(setting.fExtsSet)) != null) {
                cur.add(setting);
            } else {
                this.fExtsSetToExtsSetSettingsMap.put(setting.fExtsSet, setting);
                this.fExtToExtsSetMap = PerFileSettingsCalculator.addExtsInfoToMap(setting, this.fExtToExtsSetMap);
            }
        }

        void internalAddSettingsMap(HashMap<ExtsSet, ExtsSetSettings> map) {
            Collection<ExtsSetSettings> values = map.values();
            for (ExtsSetSettings setting : values) {
                this.internalAdd(setting);
            }
        }

        public RcSetSettings[] getChildren(final boolean includeCurrent) {
            final ArrayList list = new ArrayList();
            this.fContainer.accept(new IPathSettingsContainerVisitor(){

                public boolean visit(PathSettingsContainer container) {
                    if (includeCurrent || container != fContainer) {
                        RcSetSettings value = (RcSetSettings)container.getValue();
                        list.add(value);
                    }
                    return true;
                }
            });
            return list.toArray(new RcSetSettings[list.size()]);
        }

        public boolean containsEqualMaxMatches(RcSetSettings other, boolean ignoreGenerated) {
            if (!ignoreGenerated && this.fExtsSetToExtsSetSettingsMap.size() < other.fExtsSetToExtsSetSettingsMap.size()) {
                return false;
            }
            Set<Map.Entry<ExtsSet, ExtsSetSettings>> entrySet = other.fExtsSetToExtsSetSettingsMap.entrySet();
            for (Map.Entry<ExtsSet, ExtsSetSettings> entry : entrySet) {
                ExtsSetSettings otherSetting = entry.getValue();
                if (ignoreGenerated && otherSetting.fBaseLangData == null) continue;
                ExtsSetSettings thisSetting = this.fExtsSetToExtsSetSettingsMap.get(entry.getKey());
                if (thisSetting == null) {
                    return false;
                }
                if (otherSetting.fMaxMatchInfo == null || otherSetting.fMaxMatchInfo.equals((Object)thisSetting.fMaxMatchInfo)) continue;
                return false;
            }
            return true;
        }

        void removeChild(RcSetSettings setting) {
            IPath path = setting.fContainer.getPath();
            IPath thisPath = this.fContainer.getPath();
            if (!thisPath.isPrefixOf(path)) {
                throw new IllegalArgumentException();
            }
            path = path.removeFirstSegments(thisPath.segmentCount());
            this.fContainer.removeChildContainer(path);
        }
    }

    private static class RcSettingInfo
    implements IRcSettingInfo {
        private ArrayList<ILangSettingInfo> fLangInfoList;
        private CResourceData fRcData;

        RcSettingInfo(CResourceData rcData) {
            this.fRcData = rcData;
        }

        @Override
        public ILangSettingInfo[] getLangInfos() {
            if (this.fLangInfoList != null && this.fLangInfoList.size() != 0) {
                return this.fLangInfoList.toArray(new ILangSettingInfo[this.fLangInfoList.size()]);
            }
            return new ILangSettingInfo[0];
        }

        @Override
        public CResourceData getResourceData() {
            return this.fRcData;
        }

        void add(ILangSettingInfo info) {
            if (this.fLangInfoList == null) {
                this.fLangInfoList = new ArrayList();
            }
            this.fLangInfoList.add(info);
        }
    }
}

