/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.language.settings.providers;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.CommandLauncherManager;
import org.eclipse.cdt.core.ErrorParserManager;
import org.eclipse.cdt.core.ICommandLauncher;
import org.eclipse.cdt.core.IMarkerGenerator;
import org.eclipse.cdt.core.ProblemMarkerInfo;
import org.eclipse.cdt.core.cdtvariables.ICdtVariableManager;
import org.eclipse.cdt.core.envvar.EnvironmentVariable;
import org.eclipse.cdt.core.envvar.IEnvironmentVariable;
import org.eclipse.cdt.core.envvar.IEnvironmentVariableManager;
import org.eclipse.cdt.core.language.settings.providers.ICBuildOutputParser;
import org.eclipse.cdt.core.language.settings.providers.ICListenerAgent;
import org.eclipse.cdt.core.language.settings.providers.IWorkingDirectoryTracker;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.model.ILanguageDescriptor;
import org.eclipse.cdt.core.model.LanguageManager;
import org.eclipse.cdt.core.resources.IConsole;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICLanguageSettingEntry;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.internal.core.BuildRunnerHelper;
import org.eclipse.cdt.internal.core.XmlUtil;
import org.eclipse.cdt.internal.core.envvar.EnvironmentVariableManager;
import org.eclipse.cdt.managedbuilder.core.ManagedBuilderCorePlugin;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedMakeMessages;
import org.eclipse.cdt.managedbuilder.language.settings.providers.AbstractLanguageSettingsOutputScanner;
import org.eclipse.cdt.utils.CommandLineUtil;
import org.eclipse.cdt.utils.PathUtil;
import org.eclipse.cdt.utils.envvar.IEnvironmentChangeEvent;
import org.eclipse.cdt.utils.envvar.IEnvironmentChangeListener;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class AbstractBuiltinSpecsDetector
extends AbstractLanguageSettingsOutputScanner
implements ICListenerAgent,
IEnvironmentChangeListener {
    public static final String JOB_FAMILY_BUILTIN_SPECS_DETECTOR = "org.eclipse.cdt.managedbuilder.AbstractBuiltinSpecsDetector";
    protected static final String COMPILER_MACRO = "${COMMAND}";
    protected static final String FLAGS_MACRO = "${FLAGS}";
    protected static final String SPEC_FILE_MACRO = "${INPUTS}";
    protected static final String SPEC_EXT_MACRO = "${EXT}";
    protected static final String SPEC_FILE_BASE = "spec";
    private static final String CDT_MANAGEDBUILDER_UI_PLUGIN_ID = "org.eclipse.cdt.managedbuilder.ui";
    private static final String SCANNER_DISCOVERY_CONSOLE = "org.eclipse.cdt.managedbuilder.ScannerDiscoveryConsole";
    private static final String SCANNER_DISCOVERY_GLOBAL_CONSOLE = "org.eclipse.cdt.managedbuilder.ScannerDiscoveryGlobalConsole";
    private static final String DEFAULT_CONSOLE_ICON = "icons/obj16/inspect_sys.gif";
    private static final String GMAKE_ERROR_PARSER_ID = "org.eclipse.cdt.core.GmakeErrorParser";
    private static final String ATTR_PARAMETER = "parameter";
    private static final String ATTR_CONSOLE = "console";
    private static final String ATTR_ENV_HASH = "env-hash";
    private static final String ENV_LANGUAGE = "LANGUAGE";
    private static final String ENV_LC_ALL = "LC_ALL";
    private static final String ENV_PATH = "PATH";
    private static final int MONITOR_SCALE = 100;
    private static final int TICKS_REMOVE_MARKERS = 100;
    private static final int TICKS_RUN_FOR_ONE_LANGUAGE = 1000;
    private static final int TICKS_SERIALIZATION = 100;
    private static final int TICKS_OUTPUT_PARSING = 100;
    private static final int TICKS_EXECUTE_COMMAND = 100;
    protected URI mappedRootURI = null;
    protected URI buildDirURI = null;
    protected File specFile = null;
    protected boolean preserveSpecFile = false;
    protected IEnvironmentVariableManager envMngr = null;
    protected volatile Map<String, String> environmentMap = null;
    protected List<ICLanguageSettingEntry> detectedSettingEntries = null;
    protected int collected = 0;
    protected volatile boolean isExecuted = false;
    private static final int HASH_NOT_INITIALIZED = -1;
    private long envPathHash = -1L;
    private BuildRunnerHelper buildRunnerHelper;
    private SDMarkerGenerator markerGenerator = new SDMarkerGenerator();
    private boolean isConsoleEnabled = false;
    private String currentCommandResolved = null;

    protected abstract String getCompilerCommand(String var1);

    public String getCommand() {
        return this.getProperty(ATTR_PARAMETER);
    }

    public void setCommand(String command) {
        this.setProperty(ATTR_PARAMETER, command);
    }

    public boolean isConsoleEnabled() {
        return this.isConsoleEnabled;
    }

    public void setConsoleEnabled(boolean enable) {
        this.isConsoleEnabled = enable;
    }

    protected String resolveCommand(String languageId) throws CoreException {
        String cmd = this.getCommand();
        if (cmd != null) {
            String specFileExt;
            String specFileName;
            String flags;
            String compiler;
            if (cmd.contains(COMPILER_MACRO) && (compiler = this.getCompilerCommand(languageId)) != null) {
                cmd = cmd.replace(COMPILER_MACRO, compiler);
            }
            if (cmd.contains(FLAGS_MACRO) && (flags = this.getToolOptions(languageId)) != null) {
                cmd = cmd.replace(FLAGS_MACRO, flags);
            }
            if (cmd.contains(SPEC_FILE_MACRO) && (specFileName = this.getSpecFile(languageId)) != null) {
                cmd = cmd.replace(SPEC_FILE_MACRO, specFileName);
            }
            if (cmd.contains(SPEC_EXT_MACRO) && (specFileExt = this.getSpecFileExtension(languageId)) != null) {
                cmd = cmd.replace(SPEC_EXT_MACRO, specFileExt);
            }
            if (cmd.contains("${")) {
                ICdtVariableManager varManager = CCorePlugin.getDefault().getCdtVariableManager();
                try {
                    cmd = varManager.resolveValue(cmd, "", null, this.currentCfgDescription);
                }
                catch (Exception e) {
                    ManagedBuilderCorePlugin.log(e);
                }
            }
        }
        return cmd;
    }

    @Override
    protected String parseResourceName(String line) {
        return null;
    }

    @Override
    protected String determineLanguage() {
        return this.currentLanguageId;
    }

    @Override
    protected URI getMappedRootURI(IResource sourceFile, String parsedResourceName) {
        if (this.mappedRootURI == null) {
            this.mappedRootURI = super.getMappedRootURI(sourceFile, parsedResourceName);
        }
        return this.mappedRootURI;
    }

    @Override
    protected URI getBuildDirURI(URI mappedRootURI) {
        if (this.buildDirURI == null) {
            this.buildDirURI = this.currentProject != null ? this.currentProject.getLocationURI() : null;
        }
        return this.buildDirURI;
    }

    public void registerListener(ICConfigurationDescription cfgDescription) {
        this.currentCfgDescription = cfgDescription;
        EnvironmentVariableManager.fUserSupplier.registerEnvironmentChangeListener((IEnvironmentChangeListener)this);
        this.execute();
    }

    public void unregisterListener() {
        EnvironmentVariableManager.fUserSupplier.unregisterEnvironmentChangeListener((IEnvironmentChangeListener)this);
    }

    public void handleEvent(IEnvironmentChangeEvent event) {
        this.execute();
    }

    @Override
    public void startup(ICConfigurationDescription cfgDescription, IWorkingDirectoryTracker cwdTracker) throws CoreException {
        super.startup(cfgDescription, cwdTracker);
        this.mappedRootURI = null;
        this.buildDirURI = this.getBuildDirURI(this.mappedRootURI);
        this.environmentMap = this.createEnvironmentMap(this.currentCfgDescription);
    }

    @Override
    public void shutdown() {
        this.mappedRootURI = null;
        this.buildDirURI = null;
        super.shutdown();
    }

    private long calculateEnvHash() {
        String envPathValue = this.environmentMap.get(ENV_PATH);
        long envHashNew = envPathValue != null ? envPathValue.hashCode() : 0;
        ArrayList<Object> languageIds = this.getLanguageScope();
        if (languageIds == null) {
            languageIds = new ArrayList<Object>(1);
            languageIds.add(null);
        }
        for (String string : languageIds) {
            try {
                String[] cmdArray;
                String command = this.resolveCommand(string);
                if (command != null) {
                    envHashNew = 31L * envHashNew + (long)command.hashCode();
                }
                if ((cmdArray = CommandLineUtil.argumentsToArray((String)command)) == null || cmdArray.length <= 0) continue;
                Path location = new Path(cmdArray[0]);
                if (!location.isAbsolute()) {
                    location = PathUtil.findProgramLocation((String)cmdArray[0], (String)envPathValue);
                }
                if (location == null) continue;
                File file = new File(location.toString());
                try {
                    file = file.getCanonicalFile();
                }
                catch (IOException e) {
                    ManagedBuilderCorePlugin.log(e);
                }
                long lastModified = file.lastModified();
                envHashNew = 31L * envHashNew + (long)location.hashCode();
                envHashNew = 31L * envHashNew + lastModified;
            }
            catch (CoreException e) {
                ManagedBuilderCorePlugin.log(e);
            }
        }
        return envHashNew;
    }

    protected boolean validateEnvironment() {
        long envHashNew = this.calculateEnvHash();
        if (envHashNew != this.envPathHash) {
            this.envPathHash = envHashNew;
            return false;
        }
        return true;
    }

    protected void execute() {
        ICProjectDescription prjDescription;
        this.environmentMap = this.createEnvironmentMap(this.currentCfgDescription);
        if (this.validateEnvironment() && this.isExecuted) {
            return;
        }
        WorkspaceJob job = new WorkspaceJob(ManagedMakeMessages.getResourceString("AbstractBuiltinSpecsDetector.DiscoverBuiltInSettingsJobName")){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                IStatus status;
                AbstractBuiltinSpecsDetector.this.isExecuted = false;
                if (!AbstractBuiltinSpecsDetector.this.isEmpty()) {
                    AbstractBuiltinSpecsDetector.this.clear();
                    AbstractBuiltinSpecsDetector.this.serializeLanguageSettings(AbstractBuiltinSpecsDetector.this.currentCfgDescription);
                }
                try {
                    try {
                        AbstractBuiltinSpecsDetector.this.startup(AbstractBuiltinSpecsDetector.this.currentCfgDescription, null);
                        status = AbstractBuiltinSpecsDetector.this.runForEachLanguage(monitor);
                    }
                    catch (CoreException e) {
                        ManagedBuilderCorePlugin.log(e);
                        status = new Status(4, "org.eclipse.cdt.managedbuilder.core", 4, "Error running Builtin Specs Detector", (Throwable)e);
                        AbstractBuiltinSpecsDetector.this.isExecuted = true;
                        AbstractBuiltinSpecsDetector.this.shutdown();
                    }
                }
                finally {
                    AbstractBuiltinSpecsDetector.this.isExecuted = true;
                    AbstractBuiltinSpecsDetector.this.shutdown();
                }
                return status;
            }

            public boolean belongsTo(Object family) {
                return family == AbstractBuiltinSpecsDetector.JOB_FAMILY_BUILTIN_SPECS_DETECTOR;
            }
        };
        IWorkspaceRoot rule = null;
        if (this.currentCfgDescription != null && (prjDescription = this.currentCfgDescription.getProjectDescription()) != null) {
            rule = prjDescription.getProject();
        }
        if (rule == null) {
            rule = ResourcesPlugin.getWorkspace().getRoot();
        }
        job.setRule((ISchedulingRule)rule);
        job.schedule();
    }

    protected IStatus runForEachLanguage(IProgressMonitor monitor) {
        MultiStatus status = new MultiStatus("org.eclipse.cdt.managedbuilder.core", 0, "Problem running CDT Scanner Discovery provider " + this.getId(), null);
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            try {
                boolean isChanged = false;
                List languageIds = this.getLanguageScope();
                if (languageIds != null) {
                    monitor.beginTask(ManagedMakeMessages.getResourceString("AbstractBuiltinSpecsDetector.ScannerDiscoveryTaskTitle"), 100 + languageIds.size() * 1000 + 100);
                    IProject markersResource = this.currentProject != null ? this.currentProject : ResourcesPlugin.getWorkspace().getRoot();
                    monitor.subTask(ManagedMakeMessages.getFormattedString("AbstractBuiltinSpecsDetector.ClearingMarkers", markersResource.getFullPath().toString()));
                    this.markerGenerator.deleteMarkers((IResource)markersResource);
                    if (monitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    monitor.worked(100);
                    for (String languageId : languageIds) {
                        List oldEntries;
                        block18: {
                            oldEntries = this.getSettingEntries(this.currentCfgDescription, null, languageId);
                            try {
                                try {
                                    this.startupForLanguage(languageId);
                                    this.runForLanguage((IProgressMonitor)new SubProgressMonitor(monitor, 1000));
                                }
                                catch (Exception e) {
                                    Status s = new Status(4, "org.eclipse.cdt.managedbuilder.core", 4, "Error running Builtin Specs Detector", (Throwable)e);
                                    ManagedBuilderCorePlugin.log((IStatus)s);
                                    status.merge((IStatus)s);
                                    this.shutdownForLanguage();
                                    break block18;
                                }
                            }
                            catch (Throwable throwable) {
                                this.shutdownForLanguage();
                                throw throwable;
                            }
                            this.shutdownForLanguage();
                        }
                        if (!isChanged) {
                            List newEntries = this.getSettingEntries(this.currentCfgDescription, null, languageId);
                            boolean bl = isChanged = newEntries != oldEntries;
                        }
                        if (!monitor.isCanceled()) continue;
                        throw new OperationCanceledException();
                    }
                }
                monitor.subTask(ManagedMakeMessages.getResourceString("AbstractBuiltinSpecsDetector.SerializingResults"));
                if (isChanged) {
                    IStatus s = this.serializeLanguageSettings(this.currentCfgDescription);
                    status.merge(s);
                }
                monitor.worked(100);
            }
            catch (OperationCanceledException isChanged) {
                monitor.done();
            }
            catch (Exception e) {
                status.merge((IStatus)new Status(4, "org.eclipse.cdt.managedbuilder.core", 4, "Error running Builtin Specs Detector", (Throwable)e));
                ManagedBuilderCorePlugin.log((IStatus)status);
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
        return status;
    }

    protected void startupForLanguage(String languageId) throws CoreException {
        this.currentLanguageId = languageId;
        this.specFile = null;
        this.currentCommandResolved = this.resolveCommand(this.currentLanguageId);
        this.detectedSettingEntries = new ArrayList<ICLanguageSettingEntry>();
        this.collected = 0;
    }

    protected void shutdownForLanguage() {
        if (this.detectedSettingEntries != null && this.detectedSettingEntries.size() > 0) {
            this.collected = this.detectedSettingEntries.size();
            this.setSettingEntries(this.currentCfgDescription, this.currentResource, this.currentLanguageId, this.detectedSettingEntries);
        }
        this.detectedSettingEntries = null;
        this.currentCommandResolved = null;
        if (this.specFile != null && !this.preserveSpecFile) {
            this.specFile.delete();
            this.specFile = null;
        }
        this.currentLanguageId = null;
    }

    private void runForLanguage(IProgressMonitor monitor) throws CoreException {
        this.buildRunnerHelper = new BuildRunnerHelper(this.currentProject);
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            try {
                monitor.beginTask(ManagedMakeMessages.getFormattedString("AbstractBuiltinSpecsDetector.RunningScannerDiscovery", this.getName()), 200);
                IConsole console = this.isConsoleEnabled ? this.startProviderConsole() : CCorePlugin.getDefault().getConsole("org.eclipse.cdt.managedbuilder.core.console.hidden");
                console.start(this.currentProject);
                ICommandLauncher launcher = CommandLauncherManager.getInstance().getCommandLauncher(this.currentCfgDescription);
                launcher.setProject(this.currentProject);
                Path program = new Path("");
                String[] args = new String[]{};
                String[] cmdArray = CommandLineUtil.argumentsToArray((String)this.currentCommandResolved);
                if (cmdArray != null && cmdArray.length > 0) {
                    program = new Path(cmdArray[0]);
                    if (cmdArray.length > 1) {
                        args = new String[cmdArray.length - 1];
                        System.arraycopy(cmdArray, 1, args, 0, args.length);
                    }
                }
                String[] envp = this.toEnvp(this.environmentMap);
                ErrorParserManager epm = new ErrorParserManager(this.currentProject, this.buildDirURI, (IMarkerGenerator)this.markerGenerator, new String[]{GMAKE_ERROR_PARSER_ID});
                ConsoleParserAdapter consoleParser = new ConsoleParserAdapter();
                consoleParser.startup(this.currentCfgDescription, (IWorkingDirectoryTracker)epm);
                ArrayList<ConsoleParserAdapter> parsers = new ArrayList<ConsoleParserAdapter>();
                parsers.add(consoleParser);
                this.buildRunnerHelper.setLaunchParameters(launcher, (IPath)program, args, this.buildDirURI, envp);
                this.buildRunnerHelper.prepareStreams(epm, parsers, console, (IProgressMonitor)new SubProgressMonitor(monitor, 100));
                this.buildRunnerHelper.greeting(ManagedMakeMessages.getFormattedString("AbstractBuiltinSpecsDetector.RunningScannerDiscovery", this.getName()));
                OutputStream outStream = this.buildRunnerHelper.getOutputStream();
                OutputStream errStream = this.buildRunnerHelper.getErrorStream();
                this.runProgramForLanguage(this.currentLanguageId, this.currentCommandResolved, envp, this.buildDirURI, outStream, errStream, (IProgressMonitor)new SubProgressMonitor(monitor, 100, 4));
                this.buildRunnerHelper.close();
                this.buildRunnerHelper.goodbye();
            }
            catch (Exception e) {
                ManagedBuilderCorePlugin.log(new CoreException((IStatus)new Status(4, "org.eclipse.cdt.managedbuilder.core", "Error running Builtin Specs Detector", (Throwable)e)));
                try {
                    this.buildRunnerHelper.close();
                }
                catch (IOException e2) {
                    ManagedBuilderCorePlugin.log(e2);
                }
                monitor.done();
            }
        }
        finally {
            try {
                this.buildRunnerHelper.close();
            }
            catch (IOException e) {
                ManagedBuilderCorePlugin.log(e);
            }
            monitor.done();
        }
    }

    protected List<IEnvironmentVariable> getEnvironmentVariables() {
        if (this.envMngr == null) {
            this.envMngr = CCorePlugin.getDefault().getBuildEnvironmentManager();
        }
        ArrayList<IEnvironmentVariable> vars = new ArrayList<IEnvironmentVariable>(Arrays.asList(this.envMngr.getVariables(this.currentCfgDescription, true)));
        vars.add((IEnvironmentVariable)new EnvironmentVariable(ENV_LANGUAGE, "en"));
        vars.add((IEnvironmentVariable)new EnvironmentVariable(ENV_LC_ALL, "C.UTF-8"));
        return vars;
    }

    private Map<String, String> createEnvironmentMap(ICConfigurationDescription cfgDescription) {
        HashMap<String, String> envMap = new HashMap<String, String>();
        for (IEnvironmentVariable var : this.getEnvironmentVariables()) {
            String name = var.getName();
            if (!this.envMngr.isVariableCaseSensitive()) {
                name = name.toUpperCase();
            }
            envMap.put(name, var.getValue());
        }
        return envMap;
    }

    private String[] toEnvp(Map<String, String> environmentMap) {
        HashSet<String> envp = new HashSet<String>();
        for (Map.Entry<String, String> var : environmentMap.entrySet()) {
            envp.add(String.valueOf(var.getKey()) + '=' + var.getValue());
        }
        return envp.toArray(new String[envp.size()]);
    }

    protected int runProgramForLanguage(String languageId, String command, String[] envp, URI workingDirectoryURI, OutputStream consoleOut, OutputStream consoleErr, IProgressMonitor monitor) throws CoreException, IOException {
        return this.buildRunnerHelper.build(monitor);
    }

    @Override
    protected void setSettingEntries(List<? extends ICLanguageSettingEntry> entries) {
        if (entries != null) {
            for (ICLanguageSettingEntry iCLanguageSettingEntry : entries) {
                if (this.detectedSettingEntries == null || this.detectedSettingEntries.contains(iCLanguageSettingEntry)) continue;
                this.detectedSettingEntries.add(iCLanguageSettingEntry);
            }
        }
    }

    private IConsole startProviderConsole() {
        IConsole console = null;
        if (this.isConsoleEnabled && this.currentLanguageId != null) {
            String extConsoleId = this.currentProject != null ? SCANNER_DISCOVERY_CONSOLE : SCANNER_DISCOVERY_GLOBAL_CONSOLE;
            ILanguage ld = LanguageManager.getInstance().getLanguage(this.currentLanguageId);
            if (ld != null) {
                String consoleId = "org.eclipse.cdt.managedbuilder.core." + this.getId() + '.' + this.currentLanguageId;
                String consoleName = String.valueOf(this.getName()) + ", " + ld.getName();
                URL defaultIcon = Platform.getBundle((String)CDT_MANAGEDBUILDER_UI_PLUGIN_ID).getEntry(DEFAULT_CONSOLE_ICON);
                if (defaultIcon == null) {
                    String msg = "Unable to find icon icons/obj16/inspect_sys.gif in plugin org.eclipse.cdt.managedbuilder.ui";
                    ManagedBuilderCorePlugin.log((IStatus)new Status(4, "org.eclipse.cdt.managedbuilder.core", msg));
                }
                console = CCorePlugin.getDefault().getConsole(extConsoleId, consoleId, consoleName, defaultIcon);
            }
        }
        if (console == null) {
            console = CCorePlugin.getDefault().getConsole("org.eclipse.cdt.managedbuilder.core.console.hidden");
        }
        return console;
    }

    protected String getSpecFile(String languageId) {
        String specExt = this.getSpecFileExtension(languageId);
        String ext = "";
        if (specExt != null) {
            ext = String.valueOf('.') + specExt;
        }
        String specFileName = SPEC_FILE_BASE + ext;
        IPath workingLocation = ManagedBuilderCorePlugin.getDefault().getStateLocation();
        IPath fileLocation = workingLocation.append(specFileName);
        this.specFile = new File(fileLocation.toOSString());
        this.preserveSpecFile = this.specFile.exists();
        if (!this.preserveSpecFile) {
            try {
                this.specFile.createNewFile();
            }
            catch (IOException e) {
                ManagedBuilderCorePlugin.log(e);
            }
        }
        return fileLocation.toString();
    }

    protected String getSpecFileExtension(String languageId) {
        String[] fileExtensions;
        IContentType[] contentTypes;
        Optional<Object> extension = Optional.empty();
        ILanguageDescriptor langDescriptor = LanguageManager.getInstance().getLanguageDescriptor(languageId);
        if (langDescriptor != null && (contentTypes = langDescriptor.getContentTypes()) != null && contentTypes.length > 0 && (fileExtensions = contentTypes[0].getFileSpecs(8)) != null) {
            List<String> extensions = Arrays.asList(fileExtensions);
            extension = extensions.stream().filter(s -> s != null && !s.isEmpty()).findFirst();
            extension = extension.map(ext2 -> {
                if ("C".equals(ext2) && extensions.contains("cpp")) {
                    return "cpp";
                }
                return ext2;
            });
        }
        if (!extension.isPresent()) {
            ManagedBuilderCorePlugin.log((IStatus)new Status(4, "org.eclipse.cdt.managedbuilder.core", "Unable to find file extension for language " + languageId));
            return null;
        }
        return (String)extension.get();
    }

    protected String getToolOptions(String languageId) {
        return "";
    }

    @Override
    public Element serializeAttributes(Element parentElement) {
        Element elementProvider = super.serializeAttributes(parentElement);
        elementProvider.setAttribute(ATTR_CONSOLE, Boolean.toString(this.isConsoleEnabled));
        if (this.envPathHash != -1L) {
            elementProvider.setAttribute(ATTR_ENV_HASH, Long.toString(this.envPathHash));
        }
        return elementProvider;
    }

    @Override
    public void loadAttributes(Element providerNode) {
        super.loadAttributes(providerNode);
        String consoleValue = XmlUtil.determineAttributeValue((Node)providerNode, (String)ATTR_CONSOLE);
        if (consoleValue != null) {
            this.isConsoleEnabled = Boolean.parseBoolean(consoleValue);
        }
        this.envPathHash = -1L;
        String envPathHashStr = XmlUtil.determineAttributeValue((Node)providerNode, (String)ATTR_ENV_HASH);
        if (envPathHashStr != null) {
            try {
                this.envPathHash = Long.parseLong(envPathHashStr);
            }
            catch (Exception e) {
                ManagedBuilderCorePlugin.log((IStatus)new Status(4, "org.eclipse.cdt.managedbuilder.core", "Wrong integer format [" + envPathHashStr + "]", (Throwable)e));
            }
        }
    }

    public void loadEntries(Element providerNode) {
        super.loadEntries(providerNode);
        if (!this.isEmpty()) {
            this.isExecuted = true;
        }
    }

    public boolean isEmpty() {
        return !this.isExecuted && super.isEmpty();
    }

    public void clear() {
        super.clear();
        this.isExecuted = false;
    }

    protected AbstractBuiltinSpecsDetector cloneShallow() throws CloneNotSupportedException {
        AbstractBuiltinSpecsDetector clone = (AbstractBuiltinSpecsDetector)super.cloneShallow();
        clone.isExecuted = false;
        clone.envMngr = null;
        clone.environmentMap = null;
        clone.envPathHash = -1L;
        this.properties.remove(ATTR_ENV_HASH);
        return clone;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.isConsoleEnabled ? 1231 : 1237);
        result = 31 * result + (this.isExecuted ? 1231 : 1237);
        result = 31 * result + Long.valueOf(this.envPathHash).hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        AbstractBuiltinSpecsDetector other = (AbstractBuiltinSpecsDetector)((Object)obj);
        if (this.isConsoleEnabled != other.isConsoleEnabled) {
            return false;
        }
        if (this.isExecuted != other.isExecuted) {
            return false;
        }
        return this.envPathHash == other.envPathHash;
    }

    private class ConsoleParserAdapter
    implements ICBuildOutputParser {
        private ConsoleParserAdapter() {
        }

        public void startup(ICConfigurationDescription cfgDescription, IWorkingDirectoryTracker cwdTracker) throws CoreException {
            AbstractBuiltinSpecsDetector.this.cwdTracker = cwdTracker;
        }

        public boolean processLine(String line) {
            return AbstractBuiltinSpecsDetector.this.processLine(line);
        }

        public void shutdown() {
            AbstractBuiltinSpecsDetector.this.cwdTracker = null;
        }
    }

    private class SDMarkerGenerator
    implements IMarkerGenerator {
        protected static final String SCANNER_DISCOVERY_PROBLEM_MARKER = "org.eclipse.cdt.managedbuilder.core.scanner.discovery.problem";
        protected static final String ATTR_PROVIDER = "provider";

        private SDMarkerGenerator() {
        }

        public void addMarker(IResource rc, int lineNumber, String errorDesc, int severity, String errorVar) {
            ProblemMarkerInfo info = new ProblemMarkerInfo(rc, lineNumber, errorDesc, severity, errorVar);
            this.addMarker(info);
        }

        public void addMarker(final ProblemMarkerInfo problemMarkerInfo) {
            final String providerName = AbstractBuiltinSpecsDetector.this.getName();
            final String providerId = AbstractBuiltinSpecsDetector.this.getId();
            Job markerJob = new Job(ManagedMakeMessages.getResourceString("AbstractBuiltinSpecsDetector.AddScannerDiscoveryMarkers")){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        IMarker[] markers;
                        IMarker[] iMarkerArray = markers = problemMarkerInfo.file.findMarkers(SDMarkerGenerator.SCANNER_DISCOVERY_PROBLEM_MARKER, false, 0);
                        int n = markers.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String msg;
                            IMarker marker = iMarkerArray[n2];
                            int sev = (Integer)marker.getAttribute("severity");
                            if (sev == problemMarkerInfo.severity && (msg = (String)marker.getAttribute("message")) != null && msg.equals(problemMarkerInfo.description)) {
                                return Status.OK_STATUS;
                            }
                            ++n2;
                        }
                    }
                    catch (CoreException e) {
                        return new Status(4, "org.eclipse.cdt.managedbuilder.core", "Error checking markers.", (Throwable)e);
                    }
                    try {
                        IMarker marker = problemMarkerInfo.file.createMarker(SDMarkerGenerator.SCANNER_DISCOVERY_PROBLEM_MARKER);
                        marker.setAttribute("message", (Object)problemMarkerInfo.description);
                        marker.setAttribute("severity", problemMarkerInfo.severity);
                        marker.setAttribute(SDMarkerGenerator.ATTR_PROVIDER, (Object)providerId);
                        if (problemMarkerInfo.file instanceof IWorkspaceRoot) {
                            String msgPreferences = ManagedMakeMessages.getFormattedString("AbstractBuiltinSpecsDetector.ScannerDiscoveryMarkerLocationPreferences", providerName);
                            marker.setAttribute("location", (Object)msgPreferences);
                        } else {
                            String msgProperties = ManagedMakeMessages.getFormattedString("AbstractBuiltinSpecsDetector.ScannerDiscoveryMarkerLocationProperties", providerName);
                            marker.setAttribute("location", (Object)msgProperties);
                        }
                    }
                    catch (CoreException e) {
                        return new Status(4, "org.eclipse.cdt.managedbuilder.core", "Error adding markers.", (Throwable)e);
                    }
                    return Status.OK_STATUS;
                }
            };
            markerJob.setRule((ISchedulingRule)problemMarkerInfo.file);
            markerJob.schedule();
        }

        public void deleteMarkers(IResource rc) {
            if (!rc.isAccessible()) {
                return;
            }
            String providerId = AbstractBuiltinSpecsDetector.this.getId();
            try {
                IMarker[] markers;
                IMarker[] iMarkerArray = markers = rc.findMarkers(SCANNER_DISCOVERY_PROBLEM_MARKER, false, 0);
                int n = markers.length;
                int n2 = 0;
                while (n2 < n) {
                    IMarker marker = iMarkerArray[n2];
                    if (providerId.equals(marker.getAttribute(ATTR_PROVIDER))) {
                        marker.delete();
                    }
                    ++n2;
                }
            }
            catch (CoreException e) {
                ManagedBuilderCorePlugin.log((IStatus)new Status(4, "org.eclipse.cdt.managedbuilder.core", "Error deleting markers.", (Throwable)e));
            }
        }
    }
}

