/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.text;

import java.util.Arrays;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.gnu.cpp.GPPLanguage;
import org.eclipse.cdt.core.model.ICLanguageKeywords;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.core.model.LanguageManager;
import org.eclipse.cdt.internal.core.model.ProgressMonitorAndCanceler;
import org.eclipse.cdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.cdt.internal.ui.editor.CDocumentProvider;
import org.eclipse.cdt.internal.ui.text.CAutoIndentStrategy;
import org.eclipse.cdt.internal.ui.text.CCodeScanner;
import org.eclipse.cdt.internal.ui.text.CCommentScanner;
import org.eclipse.cdt.internal.ui.text.CCompositeReconcilingStrategy;
import org.eclipse.cdt.internal.ui.text.CDoubleClickSelector;
import org.eclipse.cdt.internal.ui.text.CFormattingStrategy;
import org.eclipse.cdt.internal.ui.text.COutlineInformationControl;
import org.eclipse.cdt.internal.ui.text.CPreprocessorScanner;
import org.eclipse.cdt.internal.ui.text.CPresentationReconciler;
import org.eclipse.cdt.internal.ui.text.CReconciler;
import org.eclipse.cdt.internal.ui.text.CStringAutoIndentStrategy;
import org.eclipse.cdt.internal.ui.text.CStringDoubleClickSelector;
import org.eclipse.cdt.internal.ui.text.HTMLAnnotationHover;
import org.eclipse.cdt.internal.ui.text.PartitionDamager;
import org.eclipse.cdt.internal.ui.text.SingleTokenCScanner;
import org.eclipse.cdt.internal.ui.text.TokenStore;
import org.eclipse.cdt.internal.ui.text.c.hover.CEditorTextHoverDescriptor;
import org.eclipse.cdt.internal.ui.text.c.hover.CEditorTextHoverProxy;
import org.eclipse.cdt.internal.ui.text.c.hover.CInformationProvider;
import org.eclipse.cdt.internal.ui.text.c.hover.CMacroExpansionExplorationControl;
import org.eclipse.cdt.internal.ui.text.c.hover.CMacroExpansionInformationProvider;
import org.eclipse.cdt.internal.ui.text.contentassist.CContentAssistProcessor;
import org.eclipse.cdt.internal.ui.text.contentassist.ContentAssistPreference;
import org.eclipse.cdt.internal.ui.text.correction.CCorrectionAssistant;
import org.eclipse.cdt.internal.ui.text.doctools.DocCommentOwnerManager;
import org.eclipse.cdt.internal.ui.typehierarchy.THInformationControl;
import org.eclipse.cdt.internal.ui.typehierarchy.THInformationProvider;
import org.eclipse.cdt.ui.CElementContentProvider;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.ILanguageUI;
import org.eclipse.cdt.ui.text.AbstractCScanner;
import org.eclipse.cdt.ui.text.ICTokenScanner;
import org.eclipse.cdt.ui.text.IColorManager;
import org.eclipse.cdt.ui.text.ITokenStore;
import org.eclipse.cdt.ui.text.ITokenStoreFactory;
import org.eclipse.cdt.ui.text.doctools.DefaultMultilineCommentAutoEditStrategy;
import org.eclipse.cdt.ui.text.doctools.IDocCommentOwner;
import org.eclipse.cdt.ui.text.doctools.IDocCommentViewerConfiguration;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.AbstractInformationControlManager;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.DefaultTextDoubleClickStrategy;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.formatter.IContentFormatter;
import org.eclipse.jface.text.formatter.IFormattingStrategy;
import org.eclipse.jface.text.formatter.MultiPassContentFormatter;
import org.eclipse.jface.text.information.IInformationPresenter;
import org.eclipse.jface.text.information.IInformationProvider;
import org.eclipse.jface.text.information.InformationPresenter;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.quickassist.IQuickAssistAssistant;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.editors.text.ILocationProvider;
import org.eclipse.ui.editors.text.TextSourceViewerConfiguration;
import org.eclipse.ui.ide.ResourceUtil;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class CSourceViewerConfiguration
extends TextSourceViewerConfiguration {
    protected ITextEditor fTextEditor;
    protected String fDocumentPartitioning;
    protected AbstractCScanner fCodeScanner;
    protected ICTokenScanner fMultilineCommentScanner;
    protected ICTokenScanner fSinglelineCommentScanner;
    protected ICTokenScanner fMultilineDocCommentScanner;
    protected ICTokenScanner fSinglelineDocCommentScanner;
    protected AbstractCScanner fStringScanner;
    protected AbstractCScanner fPreprocessorScanner;
    protected IColorManager fColorManager;

    public CSourceViewerConfiguration(IColorManager colorManager, IPreferenceStore preferenceStore, ITextEditor editor, String partitioning) {
        super(preferenceStore);
        this.fColorManager = colorManager;
        this.fTextEditor = editor;
        this.fDocumentPartitioning = partitioning;
        this.initializeScanners();
    }

    protected RuleBasedScanner getStringScanner() {
        return this.fStringScanner;
    }

    protected RuleBasedScanner getPreprocessorScanner(ILanguage language) {
        ICLanguageKeywords keywords;
        if (this.fPreprocessorScanner != null) {
            return this.fPreprocessorScanner;
        }
        CPreprocessorScanner scanner = null;
        ICLanguageKeywords iCLanguageKeywords = keywords = language == null ? null : (ICLanguageKeywords)language.getAdapter(ICLanguageKeywords.class);
        if (keywords != null) {
            scanner = new CPreprocessorScanner(this.getTokenStoreFactory(), keywords);
        }
        if (scanner == null) {
            keywords = (ICLanguageKeywords)GPPLanguage.getDefault().getAdapter(ICLanguageKeywords.class);
            scanner = new CPreprocessorScanner(this.getTokenStoreFactory(), keywords);
        }
        this.fPreprocessorScanner = scanner;
        return this.fPreprocessorScanner;
    }

    protected IColorManager getColorManager() {
        return this.fColorManager;
    }

    public ITextEditor getEditor() {
        return this.fTextEditor;
    }

    public IInformationPresenter getOutlinePresenter(ISourceViewer sourceViewer) {
        IInformationControlCreator outlineControlCreator = this.getOutlineControlCreator();
        InformationPresenter presenter = new InformationPresenter(outlineControlCreator);
        presenter.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
        presenter.setAnchor(AbstractInformationControlManager.ANCHOR_GLOBAL);
        CElementContentProvider provider = new CElementContentProvider(this.getEditor());
        String[] contentTypes = this.getConfiguredContentTypes(sourceViewer);
        int i = 0;
        while (i < contentTypes.length) {
            presenter.setInformationProvider((IInformationProvider)provider, contentTypes[i]);
            ++i;
        }
        presenter.setSizeConstraints(50, 20, true, false);
        return presenter;
    }

    public IInformationPresenter getHierarchyPresenter(ISourceViewer sourceViewer) {
        IInformationControlCreator hierarchyControlCreator = this.getHierarchyControlCreator();
        InformationPresenter presenter = new InformationPresenter(hierarchyControlCreator);
        presenter.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
        presenter.setAnchor(AbstractInformationControlManager.ANCHOR_GLOBAL);
        THInformationProvider provider = new THInformationProvider(this.getEditor());
        String[] contentTypes = this.getConfiguredContentTypes(sourceViewer);
        int i = 0;
        while (i < contentTypes.length) {
            presenter.setInformationProvider((IInformationProvider)provider, contentTypes[i]);
            ++i;
        }
        presenter.setSizeConstraints(50, 20, true, false);
        return presenter;
    }

    protected void initializeScanners() {
        this.fStringScanner = new SingleTokenCScanner(this.getTokenStoreFactory(), "c_string");
        this.fMultilineCommentScanner = new CCommentScanner(this.getTokenStoreFactory(), "c_multi_line_comment");
        this.fSinglelineCommentScanner = new CCommentScanner(this.getTokenStoreFactory(), "c_single_line_comment");
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        ICTokenScanner docCommentMultiScanner;
        CPresentationReconciler reconciler = new CPresentationReconciler();
        reconciler.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
        ILanguage language = this.getLanguage();
        RuleBasedScanner scanner = this.getCodeScanner(language);
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer((ITokenScanner)scanner);
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getSinglelineCommentScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__c_singleline_comment");
        reconciler.setRepairer((IPresentationRepairer)dr, "__c_singleline_comment");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getMultilineCommentScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__c_multiline_comment");
        reconciler.setRepairer((IPresentationRepairer)dr, "__c_multiline_comment");
        ICTokenScanner docCommentSingleScanner = this.getSinglelineDocCommentScanner((IResource)this.getProject());
        if (docCommentSingleScanner != null) {
            dr = new DefaultDamagerRepairer((ITokenScanner)docCommentSingleScanner);
            reconciler.setDamager((IPresentationDamager)dr, "__c_singleline_doc_comment");
            reconciler.setRepairer((IPresentationRepairer)dr, "__c_singleline_doc_comment");
        }
        if ((docCommentMultiScanner = this.getMultilineDocCommentScanner((IResource)this.getProject())) != null) {
            dr = new DefaultDamagerRepairer((ITokenScanner)docCommentMultiScanner);
            reconciler.setDamager((IPresentationDamager)dr, "__c_multiline_doc_comment");
            reconciler.setRepairer((IPresentationRepairer)dr, "__c_multiline_doc_comment");
        }
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getStringScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__c_string");
        reconciler.setRepairer((IPresentationRepairer)dr, "__c_string");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getStringScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__c_character");
        reconciler.setRepairer((IPresentationRepairer)dr, "__c_character");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getPreprocessorScanner(language));
        reconciler.setDamager(new PartitionDamager(), "__c_preprocessor");
        reconciler.setRepairer((IPresentationRepairer)dr, "__c_preprocessor");
        return reconciler;
    }

    protected ICTokenScanner getMultilineCommentScanner() {
        return this.fMultilineCommentScanner;
    }

    protected ICTokenScanner getSinglelineCommentScanner() {
        return this.fSinglelineCommentScanner;
    }

    protected ICTokenScanner getMultilineDocCommentScanner(IResource resource) {
        if (this.fMultilineDocCommentScanner == null) {
            if (resource == null) {
                resource = ResourcesPlugin.getWorkspace().getRoot();
            }
            IDocCommentViewerConfiguration owner = DocCommentOwnerManager.getInstance().getCommentOwner(resource).getMultilineConfiguration();
            this.fMultilineDocCommentScanner = owner.createCommentScanner(this.getTokenStoreFactory());
            if (this.fMultilineDocCommentScanner == null) {
                this.fMultilineDocCommentScanner = this.fMultilineCommentScanner;
            }
        }
        return this.fMultilineDocCommentScanner;
    }

    protected ICTokenScanner getSinglelineDocCommentScanner(IResource resource) {
        if (this.fSinglelineDocCommentScanner == null) {
            if (resource == null) {
                resource = ResourcesPlugin.getWorkspace().getRoot();
            }
            IDocCommentViewerConfiguration owner = DocCommentOwnerManager.getInstance().getCommentOwner(resource).getSinglelineConfiguration();
            this.fSinglelineDocCommentScanner = owner.createCommentScanner(this.getTokenStoreFactory());
            if (this.fSinglelineDocCommentScanner == null) {
                this.fSinglelineDocCommentScanner = this.fSinglelineCommentScanner;
            }
        }
        return this.fSinglelineDocCommentScanner;
    }

    protected RuleBasedScanner getCodeScanner(ILanguage language) {
        if (this.fCodeScanner != null) {
            return this.fCodeScanner;
        }
        CCodeScanner scanner = null;
        if (language != null) {
            ICLanguageKeywords keywords = (ICLanguageKeywords)language.getAdapter(ICLanguageKeywords.class);
            if (keywords != null) {
                scanner = new CCodeScanner(this.getTokenStoreFactory(), keywords);
            } else {
                ILanguageUI languageUI = (ILanguageUI)language.getAdapter(ILanguageUI.class);
                if (languageUI != null) {
                    scanner = languageUI.getCodeScanner();
                }
            }
        }
        if (scanner == null) {
            scanner = new CCodeScanner(this.getTokenStoreFactory(), (ICLanguageKeywords)GPPLanguage.getDefault());
        }
        if (scanner instanceof AbstractCScanner) {
            this.fCodeScanner = scanner;
        }
        return scanner;
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        if (this.getEditor() == null) {
            return null;
        }
        ContentAssistant assistant = new ContentAssistant();
        assistant.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
        assistant.setRestoreCompletionProposalSize(this.getSettings("completion_proposal_size"));
        CContentAssistProcessor processor = new CContentAssistProcessor((IEditorPart)this.getEditor(), assistant, "__dftl_partition_content_type");
        assistant.setContentAssistProcessor((IContentAssistProcessor)processor, "__dftl_partition_content_type");
        processor = new CContentAssistProcessor((IEditorPart)this.getEditor(), assistant, "__c_multiline_comment");
        assistant.setContentAssistProcessor((IContentAssistProcessor)processor, "__c_multiline_comment");
        processor = new CContentAssistProcessor((IEditorPart)this.getEditor(), assistant, "__c_singleline_comment");
        assistant.setContentAssistProcessor((IContentAssistProcessor)processor, "__c_singleline_comment");
        processor = new CContentAssistProcessor((IEditorPart)this.getEditor(), assistant, "__c_multiline_doc_comment");
        assistant.setContentAssistProcessor((IContentAssistProcessor)processor, "__c_multiline_doc_comment");
        processor = new CContentAssistProcessor((IEditorPart)this.getEditor(), assistant, "__c_singleline_doc_comment");
        assistant.setContentAssistProcessor((IContentAssistProcessor)processor, "__c_singleline_doc_comment");
        processor = new CContentAssistProcessor((IEditorPart)this.getEditor(), assistant, "__c_string");
        assistant.setContentAssistProcessor((IContentAssistProcessor)processor, "__c_string");
        processor = new CContentAssistProcessor((IEditorPart)this.getEditor(), assistant, "__c_preprocessor");
        assistant.setContentAssistProcessor((IContentAssistProcessor)processor, "__c_preprocessor");
        ContentAssistPreference.configure(assistant, this.fPreferenceStore);
        assistant.setProposalPopupOrientation(10);
        assistant.setContextInformationPopupOrientation(20);
        assistant.setInformationControlCreator(this.getInformationControlCreator(sourceViewer));
        return assistant;
    }

    protected IDialogSettings getSettings(String sectionName) {
        IDialogSettings settings = CUIPlugin.getDefault().getDialogSettings().getSection(sectionName);
        if (settings == null) {
            settings = CUIPlugin.getDefault().getDialogSettings().addNewSection(sectionName);
        }
        return settings;
    }

    public IQuickAssistAssistant getQuickAssistAssistant(ISourceViewer sourceViewer) {
        if (this.getEditor() != null) {
            return new CCorrectionAssistant(this.getEditor());
        }
        return null;
    }

    public IReconciler getReconciler(ISourceViewer sourceViewer) {
        if (this.fTextEditor != null) {
            CCompositeReconcilingStrategy strategy = new CCompositeReconcilingStrategy(sourceViewer, this.fTextEditor, this.getConfiguredDocumentPartitioning(sourceViewer));
            CReconciler reconciler = new CReconciler(this.fTextEditor, strategy);
            reconciler.setIsIncrementalReconciler(false);
            reconciler.setProgressMonitor((IProgressMonitor)new ProgressMonitorAndCanceler());
            reconciler.setDelay(500);
            return reconciler;
        }
        return null;
    }

    public IAutoEditStrategy[] getAutoEditStrategies(ISourceViewer sourceViewer, String contentType) {
        String partitioning = this.getConfiguredDocumentPartitioning(sourceViewer);
        IDocCommentOwner owner = DocCommentOwnerManager.getInstance().getCommentOwner((IResource)this.getProject());
        IAutoEditStrategy single = owner.getSinglelineConfiguration().createAutoEditStrategy();
        IAutoEditStrategy multi = owner.getMultilineConfiguration().createAutoEditStrategy();
        IAutoEditStrategy[] NONE = new IAutoEditStrategy[]{};
        if ("__c_multiline_comment".equals(contentType)) {
            return new IAutoEditStrategy[]{new DefaultMultilineCommentAutoEditStrategy(this.getCProject())};
        }
        if ("__c_singleline_doc_comment".equals(contentType)) {
            IAutoEditStrategy[] iAutoEditStrategyArray;
            if (single != null) {
                IAutoEditStrategy[] iAutoEditStrategyArray2 = new IAutoEditStrategy[1];
                iAutoEditStrategyArray = iAutoEditStrategyArray2;
                iAutoEditStrategyArray2[0] = single;
            } else {
                iAutoEditStrategyArray = NONE;
            }
            return iAutoEditStrategyArray;
        }
        if ("__c_multiline_doc_comment".equals(contentType)) {
            IAutoEditStrategy[] iAutoEditStrategyArray;
            if (multi != null) {
                IAutoEditStrategy[] iAutoEditStrategyArray3 = new IAutoEditStrategy[1];
                iAutoEditStrategyArray = iAutoEditStrategyArray3;
                iAutoEditStrategyArray3[0] = multi;
            } else {
                iAutoEditStrategyArray = NONE;
            }
            return iAutoEditStrategyArray;
        }
        if ("__c_string".equals(contentType)) {
            return new IAutoEditStrategy[]{new CStringAutoIndentStrategy(partitioning, this.getCProject())};
        }
        return new IAutoEditStrategy[]{new CAutoIndentStrategy(partitioning, this.getCProject())};
    }

    public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer sourceViewer, String contentType) {
        if ("__c_multiline_comment".equals(contentType) || "__c_singleline_comment".equals(contentType)) {
            return new DefaultTextDoubleClickStrategy();
        }
        if ("__c_singleline_doc_comment".equals(contentType)) {
            IDocCommentOwner owner = DocCommentOwnerManager.getInstance().getCommentOwner((IResource)this.getProject());
            ITextDoubleClickStrategy single = owner.getSinglelineConfiguration().createDoubleClickStrategy();
            return single != null ? single : new DefaultTextDoubleClickStrategy();
        }
        if ("__c_multiline_doc_comment".equals(contentType)) {
            IDocCommentOwner owner = DocCommentOwnerManager.getInstance().getCommentOwner((IResource)this.getProject());
            ITextDoubleClickStrategy multi = owner.getMultilineConfiguration().createDoubleClickStrategy();
            return multi != null ? multi : new DefaultTextDoubleClickStrategy();
        }
        if ("__c_string".equals(contentType) || "__c_character".equals(contentType)) {
            return new CStringDoubleClickSelector(this.getConfiguredDocumentPartitioning(sourceViewer));
        }
        if ("__c_preprocessor".equals(contentType)) {
            return new CStringDoubleClickSelector(this.getConfiguredDocumentPartitioning(sourceViewer), new CDoubleClickSelector());
        }
        return new CDoubleClickSelector();
    }

    public String[] getDefaultPrefixes(ISourceViewer sourceViewer, String contentType) {
        return new String[]{"//", "//!", ""};
    }

    public String[] getIndentPrefixes(ISourceViewer sourceViewer, String contentType) {
        boolean useSpaces;
        int indentWidth;
        ICProject project = this.getCProject();
        int tabWidth = CodeFormatterUtil.getTabWidth(project);
        boolean allowTabs = tabWidth <= (indentWidth = CodeFormatterUtil.getIndentWidth(project));
        String indentMode = project == null ? CCorePlugin.getOption((String)"org.eclipse.cdt.core.formatter.tabulation.char") : project.getOption("org.eclipse.cdt.core.formatter.tabulation.char", true);
        boolean bl = useSpaces = "space".equals(indentMode) || "mixed".equals(indentMode);
        if (!allowTabs) {
            return new String[]{CSourceViewerConfiguration.getStringWithSpaces(indentWidth), ""};
        }
        if (!useSpaces) {
            return this.getIndentPrefixesForTab(tabWidth);
        }
        return this.getIndentPrefixesForSpaces(tabWidth);
    }

    protected String[] getIndentPrefixesForSpaces(int tabWidth) {
        String[] indentPrefixes = new String[tabWidth + 2];
        indentPrefixes[0] = CSourceViewerConfiguration.getStringWithSpaces(tabWidth);
        int i = 0;
        while (i < tabWidth) {
            String spaces = CSourceViewerConfiguration.getStringWithSpaces(i);
            indentPrefixes[i + 1] = i < tabWidth ? String.valueOf(spaces) + '\t' : spaces;
            ++i;
        }
        indentPrefixes[tabWidth + 1] = "";
        return indentPrefixes;
    }

    protected static String getStringWithSpaces(int count) {
        char[] spaceChars = new char[count];
        Arrays.fill(spaceChars, ' ');
        return new String(spaceChars);
    }

    protected ICProject getCProject() {
        ITextEditor editor = this.getEditor();
        if (editor == null) {
            return null;
        }
        IWorkingCopy element = null;
        IEditorInput input = editor.getEditorInput();
        IDocumentProvider provider = editor.getDocumentProvider();
        if (provider instanceof CDocumentProvider) {
            CDocumentProvider cudp = (CDocumentProvider)provider;
            element = cudp.getWorkingCopy(input);
        }
        if (element == null) {
            return null;
        }
        return element.getCProject();
    }

    public int getTabWidth(ISourceViewer sourceViewer) {
        return CodeFormatterUtil.getTabWidth(this.getCProject());
    }

    public int getIndentWidth(ISourceViewer sourceViewer) {
        return CodeFormatterUtil.getIndentWidth(this.getCProject());
    }

    public boolean useSpacesOnly(ISourceViewer sourceViewer) {
        ICProject project = this.getCProject();
        String option = project == null ? CCorePlugin.getOption((String)"org.eclipse.cdt.core.formatter.tabulation.char") : project.getOption("org.eclipse.cdt.core.formatter.tabulation.char", true);
        return "space".equals(option);
    }

    public IAnnotationHover getAnnotationHover(ISourceViewer sourceViewer) {
        return new HTMLAnnotationHover(){

            protected boolean isIncluded(Annotation annotation) {
                return CSourceViewerConfiguration.this.isShowInVerticalRuler(annotation);
            }
        };
    }

    public int[] getConfiguredTextHoverStateMasks(ISourceViewer sourceViewer, String contentType) {
        CEditorTextHoverDescriptor[] hoverDescs = CUIPlugin.getDefault().getCEditorTextHoverDescriptors();
        int[] stateMasks = new int[hoverDescs.length];
        int stateMasksLength = 0;
        CEditorTextHoverDescriptor[] cEditorTextHoverDescriptorArray = hoverDescs;
        int n = hoverDescs.length;
        int n2 = 0;
        while (n2 < n) {
            CEditorTextHoverDescriptor hoverDesc = cEditorTextHoverDescriptorArray[n2];
            if (hoverDesc.isEnabled()) {
                int j = 0;
                int stateMask = hoverDesc.getStateMask();
                while (j < stateMasksLength) {
                    if (stateMasks[j] == stateMask) break;
                    ++j;
                }
                if (j == stateMasksLength) {
                    stateMasks[stateMasksLength++] = stateMask;
                }
            }
            ++n2;
        }
        if (stateMasksLength == hoverDescs.length) {
            return stateMasks;
        }
        int[] shortenedStateMasks = new int[stateMasksLength];
        System.arraycopy(stateMasks, 0, shortenedStateMasks, 0, stateMasksLength);
        return shortenedStateMasks;
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType, int stateMask) {
        CEditorTextHoverDescriptor[] hoverDescs = CUIPlugin.getDefault().getCEditorTextHoverDescriptors();
        int i = 0;
        while (i < hoverDescs.length) {
            if (hoverDescs[i].isEnabled() && hoverDescs[i].getStateMask() == stateMask) {
                return new CEditorTextHoverProxy(hoverDescs[i], (IEditorPart)this.getEditor());
            }
            ++i;
        }
        return null;
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType) {
        return this.getTextHover(sourceViewer, contentType, 255);
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return new String[]{"__dftl_partition_content_type", "__c_multiline_comment", "__c_singleline_comment", "__c_string", "__c_character", "__c_preprocessor", "__c_singleline_doc_comment", "__c_multiline_doc_comment"};
    }

    public IContentFormatter getContentFormatter(ISourceViewer sourceViewer) {
        MultiPassContentFormatter formatter = new MultiPassContentFormatter(this.getConfiguredDocumentPartitioning(sourceViewer), "__dftl_partition_content_type");
        formatter.setMasterStrategy((IFormattingStrategy)new CFormattingStrategy());
        return formatter;
    }

    public boolean affectsBehavior(PropertyChangeEvent event) {
        if (this.fMultilineDocCommentScanner != null && this.fMultilineDocCommentScanner.affectsBehavior(event) || this.fSinglelineDocCommentScanner != null && this.fSinglelineDocCommentScanner.affectsBehavior(event) || this.fMultilineCommentScanner.affectsBehavior(event) || this.fSinglelineCommentScanner.affectsBehavior(event) || this.fStringScanner.affectsBehavior(event)) {
            return true;
        }
        if (this.fCodeScanner != null && this.fCodeScanner.affectsBehavior(event)) {
            return true;
        }
        return this.fPreprocessorScanner != null && this.fPreprocessorScanner.affectsBehavior(event);
    }

    public IInformationControlCreator getInformationControlCreator(ISourceViewer sourceViewer) {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                return new DefaultInformationControl(parent, false);
            }
        };
    }

    protected IInformationControlCreator getInformationPresenterControlCreator(ISourceViewer sourceViewer) {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                return new DefaultInformationControl(parent, true);
            }
        };
    }

    public IInformationPresenter getInformationPresenter(ISourceViewer sourceViewer) {
        String[] contentTypes;
        InformationPresenter presenter = new InformationPresenter(this.getInformationPresenterControlCreator(sourceViewer));
        presenter.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
        CInformationProvider provider = new CInformationProvider((IEditorPart)this.getEditor());
        String[] stringArray = contentTypes = this.getConfiguredContentTypes(sourceViewer);
        int n = contentTypes.length;
        int n2 = 0;
        while (n2 < n) {
            String contentType = stringArray[n2];
            presenter.setInformationProvider((IInformationProvider)provider, contentType);
            ++n2;
        }
        presenter.setSizeConstraints(60, 10, true, true);
        return presenter;
    }

    public boolean affectsTextPresentation(PropertyChangeEvent event) {
        return this.affectsBehavior(event);
    }

    public void handlePropertyChangeEvent(PropertyChangeEvent event) {
        if (this.fCodeScanner != null && this.fCodeScanner.affectsBehavior(event)) {
            this.fCodeScanner.adaptToPreferenceChange(event);
        }
        if (this.fMultilineDocCommentScanner != null && this.fMultilineDocCommentScanner.affectsBehavior(event)) {
            this.fMultilineDocCommentScanner.adaptToPreferenceChange(event);
        }
        if (this.fSinglelineDocCommentScanner != null && this.fSinglelineDocCommentScanner.affectsBehavior(event)) {
            this.fSinglelineDocCommentScanner.adaptToPreferenceChange(event);
        }
        if (this.fMultilineCommentScanner.affectsBehavior(event)) {
            this.fMultilineCommentScanner.adaptToPreferenceChange(event);
        }
        if (this.fSinglelineCommentScanner.affectsBehavior(event)) {
            this.fSinglelineCommentScanner.adaptToPreferenceChange(event);
        }
        if (this.fStringScanner.affectsBehavior(event)) {
            this.fStringScanner.adaptToPreferenceChange(event);
        }
        if (this.fPreprocessorScanner != null && this.fPreprocessorScanner.affectsBehavior(event)) {
            this.fPreprocessorScanner.adaptToPreferenceChange(event);
        }
    }

    public String getConfiguredDocumentPartitioning(ISourceViewer sourceViewer) {
        if (this.fDocumentPartitioning != null) {
            return this.fDocumentPartitioning;
        }
        return super.getConfiguredDocumentPartitioning(sourceViewer);
    }

    protected IInformationControlCreator getOutlineControlCreator() {
        IInformationControlCreator conrolCreator = new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                int shellStyle = 16;
                int treeStyle = 768;
                return new COutlineInformationControl(parent, shellStyle, treeStyle);
            }
        };
        return conrolCreator;
    }

    protected IInformationControlCreator getHierarchyControlCreator() {
        IInformationControlCreator conrolCreator = new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                int shellStyle = 16;
                int treeStyle = 768;
                return new THInformationControl(parent, shellStyle, treeStyle);
            }
        };
        return conrolCreator;
    }

    protected ILanguage getLanguage() {
        if (this.fTextEditor == null) {
            return GPPLanguage.getDefault();
        }
        IWorkingCopy element = CUIPlugin.getDefault().getWorkingCopyManager().getWorkingCopy(this.fTextEditor.getEditorInput());
        if (element instanceof ITranslationUnit) {
            try {
                return ((ITranslationUnit)element).getLanguage();
            }
            catch (CoreException e) {
                CUIPlugin.log(e);
            }
        } else {
            IContentType contentType = null;
            IEditorInput input = this.fTextEditor.getEditorInput();
            IFile file = ResourceUtil.getFile((IEditorInput)input);
            if (file != null) {
                contentType = CCorePlugin.getContentType((IProject)file.getProject(), (String)file.getName());
            } else if (input instanceof IPathEditorInput) {
                IPath path = ((IPathEditorInput)input).getPath();
                contentType = CCorePlugin.getContentType((String)path.lastSegment());
            } else {
                IPath path;
                ILocationProvider locationProvider = (ILocationProvider)input.getAdapter(ILocationProvider.class);
                if (locationProvider != null && (path = locationProvider.getPath((Object)input)) != null) {
                    contentType = CCorePlugin.getContentType((String)path.lastSegment());
                }
            }
            if (contentType != null) {
                return LanguageManager.getInstance().getLanguage(contentType);
            }
        }
        return GPPLanguage.getDefault();
    }

    public void resetScanners() {
        this.fCodeScanner = null;
        this.fMultilineDocCommentScanner = null;
        this.fSinglelineDocCommentScanner = null;
        this.fPreprocessorScanner = null;
    }

    public IInformationPresenter getMacroExplorationPresenter(ISourceViewer sourceViewer) {
        IInformationControlCreator controlCreator = this.getMacroExplorationControlCreator();
        InformationPresenter presenter = new InformationPresenter(controlCreator);
        presenter.setRestoreInformationControlBounds(this.getDialogSettings("org.eclipse.cdt.ui.text.hover.CMacroExpansionExploration"), true, true);
        presenter.setSizeConstraints(320, 120, true, false);
        presenter.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
        presenter.setAnchor(AbstractInformationControlManager.ANCHOR_GLOBAL);
        CMacroExpansionInformationProvider provider = new CMacroExpansionInformationProvider(this.getEditor());
        String[] contentTypes = this.getConfiguredContentTypes(sourceViewer);
        int i = 0;
        while (i < contentTypes.length) {
            presenter.setInformationProvider((IInformationProvider)provider, contentTypes[i]);
            ++i;
        }
        presenter.setSizeConstraints(50, 20, true, false);
        return presenter;
    }

    protected IDialogSettings getDialogSettings(String sectionName) {
        if (sectionName == null) {
            return null;
        }
        IDialogSettings settings = CUIPlugin.getDefault().getDialogSettings().getSection(sectionName);
        if (settings == null) {
            settings = CUIPlugin.getDefault().getDialogSettings().addNewSection(sectionName);
        }
        return settings;
    }

    protected IInformationControlCreator getMacroExplorationControlCreator() {
        IInformationControlCreator conrolCreator = new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                return new CMacroExpansionExplorationControl(parent);
            }
        };
        return conrolCreator;
    }

    protected IProject getProject() {
        ICProject cproject = this.getCProject();
        return cproject != null ? cproject.getProject() : null;
    }

    protected ITokenStoreFactory getTokenStoreFactory() {
        return new ITokenStoreFactory(){

            @Override
            public ITokenStore createTokenStore(String[] propertyColorNames) {
                return new TokenStore(CSourceViewerConfiguration.this.getColorManager(), CSourceViewerConfiguration.this.fPreferenceStore, propertyColorNames);
            }
        };
    }

    protected Map<String, IAdaptable> getHyperlinkDetectorTargets(ISourceViewer sourceViewer) {
        Map targets = super.getHyperlinkDetectorTargets(sourceViewer);
        targets.put("org.eclipse.cdt.ui.cCode", this.fTextEditor);
        return targets;
    }
}

