/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.modelbase.sql.schema.helper;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.schema.helper.DatabaseHelper;
import org.eclipse.datatools.modelbase.sql.tables.PersistentTable;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.datatools.modelbase.sql.tables.ViewTable;

public class SchemaHelper {
    public static Table findTable(Schema schema, String tableName) {
        Table returnTable = null;
        for (Table table : schema.getTables()) {
            if (DatabaseHelper.compareIdentifiers(schema.getDatabase(), table.getName(), tableName) != 0) continue;
            returnTable = table;
        }
        return returnTable;
    }

    public static List getTables(Schema schema) {
        ArrayList<Table> tables = new ArrayList<Table>();
        for (Table currentTable : schema.getTables()) {
            if (!(currentTable instanceof PersistentTable)) continue;
            tables.add(currentTable);
        }
        return tables;
    }

    public static List getViews(Schema schema) {
        ArrayList<Table> views = new ArrayList<Table>();
        for (Table currentTable : schema.getTables()) {
            if (!(currentTable instanceof ViewTable)) continue;
            views.add(currentTable);
        }
        return views;
    }
}

