/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.data.internal.ui;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.datatools.sqltools.data.internal.ui.DataUIPlugin;
import org.eclipse.datatools.sqltools.data.internal.ui.Messages;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.BidiSegmentEvent;
import org.eclipse.swt.custom.BidiSegmentListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class FileFormatWizardPage
extends WizardPage {
    protected StyledText fileText;
    protected Combo columnDelimiterCombo;
    protected Combo stringDelimiterCombo;
    protected boolean extract;
    protected String endl = System.getProperty("line.separator");
    protected String[][] COL_DELIMS = new String[][]{{Messages.getString("FileFormatWizardPage.Comma"), ","}, {Messages.getString("FileFormatWizardPage.Semicolon"), ";"}, {Messages.getString("FileFormatWizardPage.Space"), " "}, {Messages.getString("FileFormatWizardPage.Tab"), "\t"}, {Messages.getString("FileFormatWizardPage.Pipe"), "|"}};
    protected String[][] STRING_DELIMS = new String[][]{{Messages.getString("FileFormatWizardPage.DoubleQuote"), "\""}, {Messages.getString("FileFormatWizardPage.SingleQuote"), "'"}, {Messages.getString("FileFormatWizardPage.None"), ""}};
    protected static final String SETTINGS_SECTION_NAME = "Extract/Load file format wizard page";
    protected static final String SETTING_FILE_PATH = "File path";
    protected static final String SETTING_COL_DELIM = "Column delimiter";
    protected static final String SETTING_STRING_DELIM = "String delimiter";

    public FileFormatWizardPage(String pageName, boolean extract) {
        super(pageName);
        this.setTitle(Messages.getString("FileFormatWizardPage.Title"));
        this.extract = extract;
    }

    public void createControl(Composite parent) {
        this.createControl1(parent);
        this.loadSettings();
        this.validateInput();
        this.setErrorMessage(null);
    }

    protected void createControl1(Composite parent) {
        Composite c = new Composite(parent, 0);
        c.setLayout((Layout)new GridLayout(3, false));
        if (this.getHelpID() != null) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)c, this.getHelpID());
        }
        Label l = new Label(c, 0);
        if (this.extract) {
            l.setText(Messages.getString("FileFormatWizardPage.OutputFile"));
        } else {
            l.setText(Messages.getString("FileFormatWizardPage.InputFile"));
        }
        this.fileText = new StyledText(c, 2052);
        this.fileText.addBidiSegmentListener(new BidiSegmentListener(){

            public void lineGetSegments(BidiSegmentEvent evt) {
                String separator = System.getProperty("file.separator");
                ArrayList<Integer> list = new ArrayList<Integer>();
                int beginSearchIndex = 0;
                boolean done = false;
                String lineText = evt.lineText;
                while (lineText != null && !lineText.equals("") && !done) {
                    int index = lineText.indexOf(separator, beginSearchIndex);
                    if (index != -1) {
                        if (index > 0) {
                            list.add(new Integer(index));
                        }
                        beginSearchIndex = index + 1;
                        continue;
                    }
                    done = true;
                }
                if (list.size() > 0) {
                    int[] segments = new int[list.size() + 1];
                    segments[0] = 0;
                    int i = 0;
                    while (i < list.size()) {
                        segments[i + 1] = (Integer)list.get(i);
                        ++i;
                    }
                    evt.segments = segments;
                }
            }
        });
        this.fileText.setLayoutData((Object)new GridData(768));
        this.fileText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FileFormatWizardPage.this.validateInput();
            }
        });
        Button fileButton = new Button(c, 8);
        fileButton.setText(Messages.getString("FileFormatWizardPage.Browse"));
        fileButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                FileFormatWizardPage.this.handleBrowse();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                FileFormatWizardPage.this.handleBrowse();
            }
        });
        Group g = new Group(c, 0);
        GridData gd = new GridData(256);
        gd.horizontalSpan = 3;
        g.setLayoutData((Object)gd);
        g.setText(Messages.getString("FileFormatWizardPage.FileFormat"));
        g.setLayout((Layout)new GridLayout(2, false));
        l = new Label((Composite)g, 0);
        l.setText(Messages.getString("FileFormatWizardPage.ColumnDelimiter"));
        this.columnDelimiterCombo = new Combo((Composite)g, 2048);
        this.columnDelimiterCombo.setLayoutData((Object)new GridData(768));
        FileFormatWizardPage.initCombo(this.columnDelimiterCombo, this.COL_DELIMS);
        this.columnDelimiterCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FileFormatWizardPage.this.validateInput();
            }
        });
        l = new Label((Composite)g, 0);
        l.setText(Messages.getString("FileFormatWizardPage.StringDelimiter"));
        this.stringDelimiterCombo = new Combo((Composite)g, 2048);
        this.stringDelimiterCombo.setLayoutData((Object)new GridData(768));
        FileFormatWizardPage.initCombo(this.stringDelimiterCombo, this.STRING_DELIMS);
        this.stringDelimiterCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FileFormatWizardPage.this.validateInput();
            }
        });
        this.setControl((Control)c);
    }

    protected void validateInput() {
        File f = new File(this.fileText.getText());
        if (!this.extract && !f.isFile()) {
            this.setErrorMessage(Messages.getString("FileFormatWizardPage.InvalidPath"));
            this.setPageComplete(false);
            return;
        }
        if (this.extract && this.fileText.getText().length() == 0) {
            this.setPageComplete(false);
            return;
        }
        if (this.getColumnDelimiter().length() != 1) {
            this.setErrorMessage(Messages.getString("FileFormatWizardPage.IncorectColumnDelimiter"));
            this.setPageComplete(false);
            return;
        }
        if (this.getStringDelimiter().length() > 1) {
            this.setErrorMessage(Messages.getString("FileFormatWizardPage.IncorectColumnDelimiter"));
            this.setPageComplete(false);
            return;
        }
        this.setErrorMessage(null);
        this.setPageComplete(true);
    }

    protected void loadSettings() {
        IDialogSettings settings = DataUIPlugin.getDefault().getDialogSettings().getSection(SETTINGS_SECTION_NAME);
        if (settings != null) {
            if (settings.get(SETTING_FILE_PATH) != null) {
                this.fileText.setText(settings.get(SETTING_FILE_PATH));
            }
            if (settings.get(SETTING_COL_DELIM) != null) {
                this.columnDelimiterCombo.setText(settings.get(SETTING_COL_DELIM));
            }
            if (settings.get(SETTING_STRING_DELIM) != null) {
                this.stringDelimiterCombo.setText(settings.get(SETTING_STRING_DELIM));
            }
        }
    }

    public void saveSettings() {
        IDialogSettings settings = DataUIPlugin.getDefault().getDialogSettings();
        settings = settings.getSection(SETTINGS_SECTION_NAME) != null ? settings.getSection(SETTINGS_SECTION_NAME) : settings.addNewSection(SETTINGS_SECTION_NAME);
        settings.put(SETTING_FILE_PATH, this.fileText.getText());
        settings.put(SETTING_COL_DELIM, this.columnDelimiterCombo.getText());
        settings.put(SETTING_STRING_DELIM, this.stringDelimiterCombo.getText());
    }

    protected void handleBrowse() {
        int style = this.extract ? 8192 : 4096;
        FileDialog dilaog = new FileDialog(Display.getCurrent().getActiveShell(), style);
        dilaog.setFilterExtensions(new String[]{"*.data", "*.csv", "*.*"});
        dilaog.setFilterNames(null);
        dilaog.setFilterPath(this.fileText.getText());
        String s = dilaog.open();
        if (s != null && s.length() > 0) {
            this.fileText.setText(s);
        }
    }

    protected static void initCombo(Combo c, String[][] delims) {
        int i = 0;
        while (i < delims.length) {
            c.add(delims[i][0]);
            c.setData(delims[i][0], (Object)delims[i][1]);
            ++i;
        }
        c.setText(delims[0][0]);
    }

    public String getFilePath() {
        return this.fileText.getText();
    }

    public String getColumnDelimiter() {
        String s = this.columnDelimiterCombo.getText();
        if (this.columnDelimiterCombo.getData(s) != null) {
            return (String)this.columnDelimiterCombo.getData(s);
        }
        return s;
    }

    public String getStringDelimiter() {
        String s = this.stringDelimiterCombo.getText();
        if (this.stringDelimiterCombo.getData(s) != null) {
            return (String)this.stringDelimiterCombo.getData(s);
        }
        return s;
    }

    public String getHelpID() {
        return null;
    }
}

