/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.admin;

import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.internal.p2.ui.ProvUI;
import org.eclipse.equinox.internal.p2.ui.ProvUIImages;
import org.eclipse.equinox.internal.p2.ui.admin.ProvAdminUIMessages;
import org.eclipse.equinox.internal.p2.ui.admin.ProvView;
import org.eclipse.equinox.internal.p2.ui.model.IRepositoryElement;
import org.eclipse.equinox.internal.p2.ui.viewers.RepositoryContentProvider;
import org.eclipse.equinox.internal.p2.ui.viewers.StructuredViewerProvisioningListener;
import org.eclipse.equinox.internal.provisional.p2.core.eventbus.ProvisioningListener;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.operations.ProvisioningSession;
import org.eclipse.equinox.p2.operations.RepositoryTracker;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.dialogs.PropertyDialogAction;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;

abstract class RepositoriesView
extends ProvView {
    private Action addRepositoryAction;
    private Action removeRepositoryAction;
    private PropertyDialogAction propertiesAction;
    private StructuredViewerProvisioningListener listener;

    @Override
    protected void addListeners() {
        super.addListeners();
        this.listener = new StructuredViewerProvisioningListener(((Object)((Object)this)).getClass().getName(), (StructuredViewer)this.viewer, this.getListenerEventTypes(), this.ui.getOperationRunner()){

            protected void refreshViewer() {
                RepositoriesView.this.refreshAll(false);
            }
        };
        ProvUI.getProvisioningEventBus((ProvisioningSession)this.ui.getSession()).addListener((ProvisioningListener)this.listener);
    }

    @Override
    protected void removeListeners() {
        super.removeListeners();
        ProvUI.getProvisioningEventBus((ProvisioningSession)this.ui.getSession()).removeListener((ProvisioningListener)this.listener);
    }

    @Override
    protected void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.addRepositoryAction);
        manager.add((IAction)this.removeRepositoryAction);
        manager.add((IAction)this.propertiesAction);
    }

    @Override
    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.addRepositoryAction);
        if (this.removeRepositoryAction.isEnabled()) {
            manager.add((IAction)this.removeRepositoryAction);
        }
        if (this.propertiesAction.isEnabled()) {
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)this.propertiesAction);
        }
    }

    @Override
    protected void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.addRepositoryAction);
        manager.add((IAction)this.removeRepositoryAction);
    }

    @Override
    protected void makeActions() {
        super.makeActions();
        this.addRepositoryAction = new AddRepositoryAction();
        this.removeRepositoryAction = new RemoveRepositoryAction();
        this.getViewSite().getActionBars().setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)this.removeRepositoryAction);
        this.propertiesAction = new PropertyDialogAction((IShellProvider)this.getSite(), (ISelectionProvider)this.viewer);
        this.getViewSite().getActionBars().setGlobalActionHandler(ActionFactory.PROPERTIES.getId(), (IAction)this.propertiesAction);
        IStructuredSelection selection = this.getSelection();
        if (selection.size() == 1 && this.isRepository(selection.getFirstElement())) {
            this.propertiesAction.setEnabled(true);
            this.removeRepositoryAction.setEnabled(true);
        } else {
            this.propertiesAction.setEnabled(false);
            this.removeRepositoryAction.setEnabled(false);
        }
        this.viewer.addSelectionChangedListener(event -> {
            IStructuredSelection ss = event.getStructuredSelection();
            this.selectionChanged(ss);
        });
    }

    @Override
    protected IAction getDoubleClickAction() {
        return this.propertiesAction;
    }

    @Override
    protected void selectionChanged(IStructuredSelection selection) {
        Object[] selectionArray;
        this.propertiesAction.setEnabled(selection.size() == 1 && (ProvUI.getAdapter((Object)selection.getFirstElement(), IInstallableUnit.class) != null || this.isRepository(selection.getFirstElement())));
        boolean enabled = false;
        Object[] objectArray = selectionArray = selection.toArray();
        int n = selectionArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object selectionArray1 = objectArray[n2];
            if (!this.isRepository(selectionArray1)) {
                enabled = false;
                break;
            }
            enabled = true;
            ++n2;
        }
        this.removeRepositoryAction.setEnabled(enabled);
    }

    @Override
    protected IContentProvider getContentProvider() {
        return new RepositoryContentProvider();
    }

    protected abstract RepositoryTracker getRepositoryTracker();

    protected abstract int openAddRepositoryDialog(Shell var1);

    protected abstract String getAddCommandLabel();

    protected abstract String getAddCommandTooltip();

    protected String getRemoveCommandLabel() {
        return ProvAdminUIMessages.RepositoriesView_RemoveCommandLabel;
    }

    protected abstract String getRemoveCommandTooltip();

    protected boolean isRepository(Object element) {
        return element instanceof IRepositoryElement;
    }

    protected abstract int getListenerEventTypes();

    @Override
    protected List<String> getVisualProperties() {
        List<String> list = super.getVisualProperties();
        list.add("org.eclipse.equinox.internal.provisional.p2.ui.admin.hideSystemRepos");
        return list;
    }

    @Override
    protected void refreshUnderlyingModel() {
        IWorkbenchSiteProgressService service = (IWorkbenchSiteProgressService)this.getSite().getAdapter(IWorkbenchSiteProgressService.class);
        if (service != null) {
            try {
                service.run(true, false, monitor -> this.getRepositoryTracker().refreshRepositories(this.getRepositoryTracker().getKnownRepositories(this.getProvisioningUI().getSession()), this.getProvisioningUI().getSession(), monitor));
            }
            catch (InvocationTargetException e) {
                ProvUI.handleException((Throwable)e, null, (int)2);
            }
            catch (InterruptedException interruptedException) {}
        } else {
            this.getRepositoryTracker().refreshRepositories(this.getRepositoryTracker().getKnownRepositories(this.getProvisioningUI().getSession()), this.getProvisioningUI().getSession(), (IProgressMonitor)new NullProgressMonitor());
        }
    }

    private class AddRepositoryAction
    extends Action {
        AddRepositoryAction() {
            this.setText(RepositoriesView.this.getAddCommandLabel());
            this.setToolTipText(RepositoriesView.this.getAddCommandTooltip());
            this.setImageDescriptor(ProvUIImages.getImageDescriptor((String)"obj/artifact_repo_obj.png"));
        }

        public void run() {
            Object[] elements = ((ITreeContentProvider)RepositoriesView.this.viewer.getContentProvider()).getElements(RepositoriesView.this.getInput());
            ArrayList<URI> urls = new ArrayList<URI>();
            Object[] objectArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                if (element instanceof IRepositoryElement) {
                    urls.add(((IRepositoryElement)element).getLocation());
                }
                ++n2;
            }
            RepositoriesView.this.openAddRepositoryDialog(RepositoriesView.this.getShell());
        }
    }

    private class RemoveRepositoryAction
    extends Action {
        RemoveRepositoryAction() {
            this.setText(RepositoriesView.this.getRemoveCommandLabel());
            this.setToolTipText(RepositoriesView.this.getRemoveCommandTooltip());
            this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_DELETE"));
            this.setDisabledImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_DELETE_DISABLED"));
        }

        public void run() {
            RepositoryTracker tracker = RepositoriesView.this.getRepositoryTracker();
            Object[] elements = RepositoriesView.this.getSelection().toArray();
            ArrayList<URI> uris = new ArrayList<URI>(elements.length);
            Object[] objectArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                if (element instanceof IRepositoryElement) {
                    uris.add(((IRepositoryElement)element).getLocation());
                }
                ++n2;
            }
            tracker.removeRepositories(uris.toArray(new URI[uris.size()]), RepositoriesView.this.getProvisioningUI().getSession());
        }
    }
}

