/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.dot.internal.ui.language.hover;

import com.google.inject.Injector;
import java.io.Reader;
import java.io.StringReader;
import org.eclipse.gef.dot.internal.language.DotAstHelper;
import org.eclipse.gef.dot.internal.language.color.Color;
import org.eclipse.gef.dot.internal.language.color.DotColors;
import org.eclipse.gef.dot.internal.language.color.HSVColor;
import org.eclipse.gef.dot.internal.language.color.RGBColor;
import org.eclipse.gef.dot.internal.language.color.StringColor;
import org.eclipse.gef.dot.internal.language.dot.Attribute;
import org.eclipse.gef.dot.internal.language.terminals.ID;
import org.eclipse.gef.dot.internal.ui.language.DotActivator;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.parser.IParser;

public class DotHoverUtils {
    static String colorDescription(Attribute color, ID attributeValue) {
        return DotHoverUtils.colorDescription(color, attributeValue.toString(), attributeValue.toValue());
    }

    static String colorDescription(Attribute attribute, String encoded, String value) {
        Color color = DotHoverUtils.parse(encoded);
        String colorScheme = null;
        String colorName = null;
        String colorCode = null;
        if (color instanceof StringColor) {
            StringColor stringColor = (StringColor)color;
            colorScheme = stringColor.getScheme();
            if (colorScheme == null) {
                colorScheme = DotAstHelper.getColorSchemeAttributeValue((Attribute)attribute);
            }
            if (colorScheme == null) {
                colorScheme = "x11";
            }
            colorName = stringColor.getName();
            colorCode = DotColors.get((String)colorScheme, (String)colorName);
        }
        if (color instanceof RGBColor) {
            colorCode = value;
        }
        boolean cfr_ignored_0 = color instanceof HSVColor;
        return DotColors.getColorDescription((String)colorScheme, colorName, (String)colorCode);
    }

    private static Color parse(String attributeValue) {
        Injector dotColorInjector = DotActivator.getInstance().getInjector("org.eclipse.gef.dot.internal.language.DotColor");
        IParser parser = (IParser)dotColorInjector.getInstance(IParser.class);
        IParseResult result = parser.parse((Reader)new StringReader(attributeValue));
        return (Color)result.getRootASTElement();
    }
}

