/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.mvc.fx.handlers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import org.eclipse.gef.common.adapt.AdapterKey;
import org.eclipse.gef.common.adapt.IAdaptable;
import org.eclipse.gef.geometry.planar.Dimension;
import org.eclipse.gef.mvc.fx.handlers.ISnapToStrategy;
import org.eclipse.gef.mvc.fx.models.SnappingModel;
import org.eclipse.gef.mvc.fx.parts.IContentPart;
import org.eclipse.gef.mvc.fx.providers.ISnappingLocationProvider;
import org.eclipse.gef.mvc.fx.viewer.IViewer;

public class SnapToSupport
extends IAdaptable.Bound.Impl<IViewer> {
    private IContentPart<? extends Node> snappedPart;
    private List<ISnapToStrategy> supportedSnapToStrategies = new ArrayList<ISnapToStrategy>();
    private List<ISnapToStrategy> applicableSnapToStrategies = new ArrayList<ISnapToStrategy>();
    private Map<ISnapToStrategy, List<SnappingModel.SnappingLocation>> hSourceLocations = new IdentityHashMap<ISnapToStrategy, List<SnappingModel.SnappingLocation>>();
    private Map<ISnapToStrategy, List<SnappingModel.SnappingLocation>> vSourceLocations = new IdentityHashMap<ISnapToStrategy, List<SnappingModel.SnappingLocation>>();

    public void clearSnappingFeedback() {
        SnappingModel snappingModel = this.getSnappingModel();
        if (snappingModel != null) {
            snappingModel.setSnappingLocations(Collections.emptyList());
        }
    }

    private Dimension determineMinimum(ISnapToStrategy snapper, List<SnappingModel.SnappingLocation> locs, Dimension delta) {
        Dimension min = null;
        double minLenSq = 0.0;
        if (locs != null) {
            for (SnappingModel.SnappingLocation sl : locs) {
                double d = sl.getOrientation() == Orientation.HORIZONTAL ? delta.width : delta.height;
                Dimension snapDelta = snapper.snap(sl.getOrientation(), sl.getPositionInScene() + d);
                if (snapDelta == null) continue;
                double lenSq = snapDelta.width * snapDelta.width + snapDelta.height * snapDelta.height;
                if (min != null && !(lenSq < minLenSq)) continue;
                min = snapDelta;
                minLenSq = lenSq;
            }
        }
        return min;
    }

    private SnappingModel getSnappingModel() {
        return (SnappingModel)((IViewer)this.getAdaptable()).getAdapter(SnappingModel.class);
    }

    private List<SnappingModel.SnappingLocation> getTranslated(Map<ISnapToStrategy, List<SnappingModel.SnappingLocation>> locs, Dimension delta, Dimension snapDelta) {
        ArrayList<SnappingModel.SnappingLocation> translated = new ArrayList<SnappingModel.SnappingLocation>();
        for (Map.Entry<ISnapToStrategy, List<SnappingModel.SnappingLocation>> e : locs.entrySet()) {
            for (SnappingModel.SnappingLocation sl : e.getValue()) {
                double p = sl.getPositionInScene();
                double np = sl.getOrientation() == Orientation.HORIZONTAL ? p + delta.width + snapDelta.width : p + delta.height + snapDelta.height;
                translated.add(new SnappingModel.SnappingLocation(sl.getPart(), sl.getOrientation(), np));
            }
        }
        return translated;
    }

    private void initializeLocations(Map<ISnapToStrategy, List<SnappingModel.SnappingLocation>> horizontalSourceSnappingLocations, Map<ISnapToStrategy, List<SnappingModel.SnappingLocation>> verticalSourceSnappingLocations) {
        this.applicableSnapToStrategies.clear();
        this.hSourceLocations.clear();
        this.vSourceLocations.clear();
        for (ISnapToStrategy strategy : this.supportedSnapToStrategies) {
            List<SnappingModel.SnappingLocation> vssls;
            if (!horizontalSourceSnappingLocations.containsKey(strategy) && !verticalSourceSnappingLocations.containsKey(strategy)) continue;
            this.applicableSnapToStrategies.add(strategy);
            strategy.setSnappedPart(this.snappedPart);
            List<SnappingModel.SnappingLocation> hssls = horizontalSourceSnappingLocations.get(strategy);
            if (hssls != null && !hssls.isEmpty()) {
                this.hSourceLocations.put(strategy, new ArrayList<SnappingModel.SnappingLocation>(hssls));
            }
            if ((vssls = verticalSourceSnappingLocations.get(strategy)) == null || vssls.isEmpty()) continue;
            this.vSourceLocations.put(strategy, new ArrayList<SnappingModel.SnappingLocation>(vssls));
        }
        SnappingModel snappingModel = this.getSnappingModel();
        if (snappingModel != null) {
            snappingModel.setSnappingLocations(Collections.emptyList());
        }
    }

    private void initializePartAndStrategies(IContentPart<? extends Node> snappedPart) {
        if (snappedPart == null) {
            throw new IllegalArgumentException("snappedPart may not be null");
        }
        this.snappedPart = snappedPart;
        this.supportedSnapToStrategies.clear();
        SnappingModel snappingModel = this.getSnappingModel();
        if (snappingModel != null) {
            this.supportedSnapToStrategies.addAll((Collection<ISnapToStrategy>)snappingModel.snapToStrategiesProperty());
        }
    }

    public Dimension snap(Dimension delta) {
        Dimension totalHMin = null;
        Dimension totalVMin = null;
        for (ISnapToStrategy strategy : this.applicableSnapToStrategies) {
            Dimension hmin = this.determineMinimum(strategy, this.hSourceLocations.get(strategy), delta);
            Dimension vmin = this.determineMinimum(strategy, this.vSourceLocations.get(strategy), delta);
            if (totalHMin == null) {
                if (hmin != null && Math.abs(hmin.width) < strategy.getMaximumSnappingDistance()) {
                    totalHMin = hmin;
                }
            } else if (hmin != null && Math.abs(hmin.width) < Math.abs(totalHMin.width)) {
                totalHMin = hmin;
            }
            if (totalVMin == null) {
                if (vmin == null || !(Math.abs(vmin.height) < strategy.getMaximumSnappingDistance())) continue;
                totalVMin = vmin;
                continue;
            }
            if (vmin == null || !(Math.abs(vmin.height) < Math.abs(totalVMin.height))) continue;
            totalVMin = vmin;
        }
        List<SnappingModel.SnappingLocation> hTranslated = totalHMin == null ? Collections.emptyList() : this.getTranslated(this.hSourceLocations, delta, totalHMin);
        List<SnappingModel.SnappingLocation> vTranslated = totalVMin == null ? Collections.emptyList() : this.getTranslated(this.vSourceLocations, delta, totalVMin);
        ArrayList<SnappingModel.SnappingLocation> matchingHSLs = new ArrayList<SnappingModel.SnappingLocation>();
        ArrayList<SnappingModel.SnappingLocation> matchingVSLs = new ArrayList<SnappingModel.SnappingLocation>();
        for (ISnapToStrategy snapper : this.supportedSnapToStrategies) {
            List<SnappingModel.SnappingLocation> horizontalSnappingLocations = snapper.getHorizontalTargetLocations();
            List<SnappingModel.SnappingLocation> verticalSnappingLocations = snapper.getVerticalTargetLocations();
            for (SnappingModel.SnappingLocation mySL : hTranslated) {
                for (SnappingModel.SnappingLocation sl : horizontalSnappingLocations) {
                    if (mySL.getPositionInScene() != sl.getPositionInScene()) continue;
                    matchingHSLs.add(sl);
                }
            }
            for (SnappingModel.SnappingLocation mySL : vTranslated) {
                for (SnappingModel.SnappingLocation sl : verticalSnappingLocations) {
                    if (mySL.getPositionInScene() != sl.getPositionInScene()) continue;
                    matchingVSLs.add(sl);
                }
            }
        }
        SnappingModel snappingModel = this.getSnappingModel();
        if (snappingModel != null) {
            ArrayList<SnappingModel.SnappingLocation> feedbackLocs = new ArrayList<SnappingModel.SnappingLocation>();
            feedbackLocs.addAll(matchingHSLs);
            feedbackLocs.addAll(matchingVSLs);
            snappingModel.setSnappingLocations(feedbackLocs);
        }
        Dimension composite = new Dimension(0.0, 0.0);
        if (totalHMin != null) {
            composite.setWidth(totalHMin.width);
        }
        if (totalVMin != null) {
            composite.setHeight(totalVMin.height);
        }
        return composite;
    }

    public void startSnapping(IContentPart<? extends Node> snappedPart) {
        this.initializePartAndStrategies(snappedPart);
        IdentityHashMap<ISnapToStrategy, List<SnappingModel.SnappingLocation>> hsrc = new IdentityHashMap<ISnapToStrategy, List<SnappingModel.SnappingLocation>>();
        IdentityHashMap<ISnapToStrategy, List<SnappingModel.SnappingLocation>> vsrc = new IdentityHashMap<ISnapToStrategy, List<SnappingModel.SnappingLocation>>();
        for (ISnapToStrategy strategy : this.supportedSnapToStrategies) {
            ISnappingLocationProvider slocProvider = (ISnappingLocationProvider)snappedPart.getAdapter(AdapterKey.get(ISnappingLocationProvider.class, (String)strategy.getSourceLocationProviderRole()));
            if (slocProvider == null) continue;
            List<SnappingModel.SnappingLocation> hssls = slocProvider.getHorizontalSnappingLocations(snappedPart);
            List<SnappingModel.SnappingLocation> vssls = slocProvider.getVerticalSnappingLocations(snappedPart);
            hsrc.put(strategy, new ArrayList<SnappingModel.SnappingLocation>(hssls));
            vsrc.put(strategy, new ArrayList<SnappingModel.SnappingLocation>(vssls));
        }
        this.initializeLocations(hsrc, vsrc);
    }

    public void startSnapping(IContentPart<? extends Node> snappedPart, List<SnappingModel.SnappingLocation> snappingLocations) {
        this.initializePartAndStrategies(snappedPart);
        IdentityHashMap<ISnapToStrategy, List<SnappingModel.SnappingLocation>> hsrc = new IdentityHashMap<ISnapToStrategy, List<SnappingModel.SnappingLocation>>();
        IdentityHashMap<ISnapToStrategy, List<SnappingModel.SnappingLocation>> vsrc = new IdentityHashMap<ISnapToStrategy, List<SnappingModel.SnappingLocation>>();
        ArrayList<SnappingModel.SnappingLocation> hssls = new ArrayList<SnappingModel.SnappingLocation>();
        ArrayList<SnappingModel.SnappingLocation> vssls = new ArrayList<SnappingModel.SnappingLocation>();
        for (SnappingModel.SnappingLocation sl : snappingLocations) {
            if (sl.getOrientation() == Orientation.HORIZONTAL) {
                hssls.add(sl);
                continue;
            }
            vssls.add(sl);
        }
        for (ISnapToStrategy strategy : this.supportedSnapToStrategies) {
            hsrc.put(strategy, new ArrayList(hssls));
            vsrc.put(strategy, new ArrayList(vssls));
        }
        this.initializeLocations(hsrc, vsrc);
    }

    public void startSnapping(IContentPart<? extends Node> snappedPart, Map<ISnapToStrategy, List<SnappingModel.SnappingLocation>> horizontalSourceSnappingLocations, Map<ISnapToStrategy, List<SnappingModel.SnappingLocation>> verticalSourceSnappingLocations) {
        this.initializePartAndStrategies(snappedPart);
        this.initializeLocations(horizontalSourceSnappingLocations, verticalSourceSnappingLocations);
    }

    public void stopSnapping() {
        if (this.snappedPart != null) {
            SnappingModel snappingModel = this.getSnappingModel();
            if (snappingModel != null) {
                snappingModel.setSnappingLocations(Collections.emptyList());
            }
            this.snappedPart = null;
        }
        this.supportedSnapToStrategies.clear();
        this.applicableSnapToStrategies.clear();
        this.hSourceLocations.clear();
        this.vSourceLocations.clear();
    }
}

