/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jpt.common.ui.internal.WorkbenchTools;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.collection.CollectionTools;
import org.eclipse.jpt.common.utility.internal.collection.HashBag;
import org.eclipse.jpt.jpa.core.JpaFile;
import org.eclipse.jpt.jpa.core.JpaStructureNode;
import org.eclipse.jpt.jpa.core.context.XmlFile;
import org.eclipse.jpt.jpa.ui.JpaWorkbench;
import org.eclipse.jpt.jpa.ui.JptJpaUiImages;
import org.eclipse.jpt.jpa.ui.JptJpaUiMessages;
import org.eclipse.jpt.jpa.ui.internal.DefaultJpaXmlCompletionProposalComputer;
import org.eclipse.jpt.jpa.ui.internal.plugin.JptJpaUiPlugin;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.wst.sse.ui.contentassist.CompletionProposalInvocationContext;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.ui.internal.XMLUIMessages;
import org.eclipse.wst.xml.ui.internal.contentassist.ContentAssistRequest;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class JpaXmlCompletionProposalComputer
extends DefaultJpaXmlCompletionProposalComputer {
    @Override
    public List<ICompletionProposal> computeCompletionProposals(CompletionProposalInvocationContext context, IProgressMonitor monitor) {
        try {
            return super.computeCompletionProposals(context, monitor);
        }
        catch (RuntimeException ex) {
            JptJpaUiPlugin.instance().logError(ex);
            return Collections.emptyList();
        }
    }

    @Override
    protected void addAttributeValueProposals(ContentAssistRequest contentAssistRequest, CompletionProposalInvocationContext context) {
        List<String> proposedValues = this.getProposedValues(context);
        if (proposedValues.size() > 0) {
            String matchString = contentAssistRequest.getMatchString();
            if (matchString == null) {
                matchString = "";
            }
            String newMatchString = "";
            if (matchString.length() > 0 && (matchString.startsWith("\"") || matchString.startsWith("'"))) {
                newMatchString = matchString.substring(1);
            }
            int rOffset = contentAssistRequest.getReplacementBeginPosition();
            int rLength = contentAssistRequest.getReplacementLength();
            for (String possibleValue : proposedValues) {
                if (newMatchString.length() != 0 && !StringTools.startsWithIgnoreCase((String)possibleValue, (String)newMatchString)) continue;
                String convertedPossibleValue = null;
                convertedPossibleValue = matchString.startsWith("\"") ? StringTools.convertToDoubleQuotedXmlAttributeValue((String)possibleValue) : (matchString.startsWith("'") ? StringTools.convertToSingleQuotedXmlAttributeValue((String)possibleValue) : StringTools.convertToXmlAttributeValue((String)possibleValue));
                CompletionProposal proposal = null;
                proposal = possibleValue.startsWith("\"") ? (matchString.startsWith("\"") && newMatchString.startsWith("\"") ? new CompletionProposal(convertedPossibleValue, rOffset, rLength + 1, convertedPossibleValue.length(), null, possibleValue, null, JptJpaUiMessages.JPA_XML_COMPLETION_PROPOSAL_COMPUTER_SPECIAL_NAME_MSG) : new CompletionProposal(convertedPossibleValue, rOffset, rLength, convertedPossibleValue.length(), null, possibleValue, null, JptJpaUiMessages.JPA_XML_COMPLETION_PROPOSAL_COMPUTER_SPECIAL_NAME_MSG)) : new CompletionProposal(convertedPossibleValue, rOffset, rLength, convertedPossibleValue.length(), null, possibleValue, null, null);
                contentAssistRequest.addProposal((ICompletionProposal)proposal);
            }
        } else {
            this.setErrorMessage(XMLUIMessages.Content_Assist_not_availab_UI_);
        }
    }

    @Override
    protected void addTagInsertionProposals(ContentAssistRequest contentAssistRequest, int childPosition, CompletionProposalInvocationContext context) {
        List<String> proposedValues;
        Node parent = contentAssistRequest.getParent();
        if (parent != null && parent.getNodeType() == 9 && ((IDOMDocument)parent).isXMLType() && !this.isCursorAfterXMLPI(contentAssistRequest)) {
            return;
        }
        if (!this.isCursorAfterDoctype(contentAssistRequest)) {
            return;
        }
        if (parent != null && parent instanceof IDOMNode && this.isCommentNode((IDOMNode)parent)) {
            while (parent != null && this.isCommentNode((IDOMNode)parent)) {
                parent = parent.getParentNode();
            }
        }
        if ((proposedValues = this.getProposedValues(context)).size() > 0) {
            String matchString = contentAssistRequest.getMatchString();
            if (matchString == null) {
                matchString = "";
            }
            int begin = contentAssistRequest.getReplacementBeginPosition();
            int length = contentAssistRequest.getReplacementLength();
            if (parent instanceof IDOMNode && parent.getNodeType() == 1 && ((IDOMNode)parent).getLastStructuredDocumentRegion() != ((IDOMNode)parent).getFirstStructuredDocumentRegion()) {
                begin = ((IDOMNode)parent).getFirstStructuredDocumentRegion().getEndOffset();
                length = ((IDOMNode)parent).getLastStructuredDocumentRegion().getStartOffset() - begin;
            }
            for (String proposedValue : proposedValues) {
                if (matchString.length() != 0 && !StringTools.startsWithIgnoreCase((String)proposedValue, (String)matchString)) continue;
                String convertedProposedValue = StringTools.convertToXmlElementText((String)proposedValue);
                CompletionProposal proposal = null;
                proposal = proposedValue.startsWith("\"") ? new CompletionProposal(convertedProposedValue, begin, length, convertedProposedValue.length(), this.getImage(context, JptJpaUiImages.JPA_CONTENT), proposedValue, null, JptJpaUiMessages.JPA_XML_COMPLETION_PROPOSAL_COMPUTER_SPECIAL_NAME_MSG) : new CompletionProposal(convertedProposedValue, begin, length, convertedProposedValue.length(), this.getImage(context, JptJpaUiImages.JPA_CONTENT), proposedValue, null, null);
                contentAssistRequest.addProposal((ICompletionProposal)proposal);
            }
        } else {
            this.setErrorMessage(XMLUIMessages.Content_Assist_not_availab_UI_);
        }
    }

    private List<String> getProposedValues(CompletionProposalInvocationContext context) {
        int documentPosition = context.getInvocationOffset();
        if (documentPosition == -1) {
            return Collections.emptyList();
        }
        ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
        ITextFileBuffer buffer = manager.getTextFileBuffer(context.getDocument());
        if (buffer == null) {
            return Collections.emptyList();
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IFile file = root.getFile(buffer.getLocation());
        JpaFile jpaFile = (JpaFile)file.getAdapter(JpaFile.class);
        if (jpaFile == null) {
            return Collections.emptyList();
        }
        HashBag rootStructureNodes = CollectionTools.hashBag((Iterable)jpaFile.getRootStructureNodes());
        if (rootStructureNodes.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> list = new ArrayList<String>();
        for (JpaStructureNode node : rootStructureNodes) {
            Iterable proposals = ((XmlFile.Root)node).getCompletionProposals(documentPosition);
            if (proposals == null) continue;
            CollectionTools.addAll(list, (Iterable)proposals);
        }
        return list;
    }

    protected boolean isCursorAfterXMLPI(ContentAssistRequest car) {
        Node aNode = car.getNode();
        boolean xmlpiFound = false;
        Document parent = aNode.getOwnerDocument();
        int xmlpiNodePosition = -1;
        boolean isAfterXMLPI = false;
        if (parent == null) {
            return true;
        }
        Node child = parent.getFirstChild();
        while (child != null) {
            boolean xmlpi = child.getNodeType() == 7 && child.getNodeName().equals("xml");
            boolean bl = xmlpiFound = xmlpiFound || xmlpi;
            if (xmlpiFound) {
                if (!(child instanceof IDOMNode)) break;
                xmlpiNodePosition = ((IDOMNode)child).getEndOffset();
                isAfterXMLPI = car.getReplacementBeginPosition() >= xmlpiNodePosition;
                break;
            }
            child = child.getNextSibling();
        }
        return isAfterXMLPI;
    }

    private boolean isCursorAfterDoctype(ContentAssistRequest car) {
        Node aNode = car.getNode();
        Document parent = aNode.getOwnerDocument();
        int xmldoctypeNodePosition = -1;
        boolean isAfterDoctype = true;
        if (parent == null) {
            return true;
        }
        Node child = parent.getFirstChild();
        while (child != null) {
            if (child instanceof IDOMNode && child.getNodeType() == 10) {
                xmldoctypeNodePosition = ((IDOMNode)child).getEndOffset();
                isAfterDoctype = car.getReplacementBeginPosition() >= xmldoctypeNodePosition;
                break;
            }
            child = child.getNextSibling();
        }
        return isAfterDoctype;
    }

    private boolean isCommentNode(IDOMNode node) {
        return node != null && node instanceof IDOMElement && ((IDOMElement)node).isCommentTag();
    }

    private Image getImage(CompletionProposalInvocationContext context, ImageDescriptor descriptor) {
        return this.getImage((Control)context.getViewer().getTextWidget(), descriptor);
    }

    private Image getImage(Control control, ImageDescriptor descriptor) {
        return this.getResourceManager(control).createImage(descriptor);
    }

    private ResourceManager getResourceManager(Control control) {
        return this.getJpaWorkbench().getResourceManager(control);
    }

    private JpaWorkbench getJpaWorkbench() {
        return (JpaWorkbench)WorkbenchTools.getAdapter(JpaWorkbench.class);
    }
}

