/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.businessprocess.db;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jubula.client.core.businessprocess.db.NodeBP;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.IEventExecTestCasePO;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.model.NodeMaker;
import org.eclipse.jubula.client.core.persistence.EditSupport;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.NodePM;
import org.eclipse.jubula.client.core.persistence.PMAlreadyLockedException;
import org.eclipse.jubula.client.core.persistence.PMDirtyVersionException;
import org.eclipse.jubula.client.core.persistence.PMException;
import org.eclipse.jubula.client.core.persistence.PMObjectDeletedException;
import org.eclipse.jubula.client.core.persistence.PMSaveException;
import org.eclipse.jubula.tools.internal.exception.InvalidDataException;
import org.eclipse.jubula.tools.internal.exception.ProjectDeletedException;

public class TestCaseBP
extends NodeBP {
    private TestCaseBP() {
    }

    public static IExecTestCasePO addReferencedTestCase(EditSupport editSupport, INodePO targetTC, ISpecTestCasePO referencedTC, Integer position) throws PMAlreadyLockedException, PMDirtyVersionException, PMObjectDeletedException {
        TestCaseBP.handleFirstReference(editSupport, referencedTC, false);
        IExecTestCasePO newExecTC = NodeMaker.createExecTestCasePO(referencedTC);
        return TestCaseBP.addReferencedTestCase(targetTC, newExecTC, position);
    }

    public static IExecTestCasePO addReferencedTestCase(INodePO targetTC, IExecTestCasePO newExecTC, Integer position) {
        if (position != null) {
            targetTC.addNode(position, newExecTC);
        } else {
            targetTC.addNode(newExecTC);
        }
        DataEventDispatcher.getInstance().fireDataChangedListener(newExecTC, DataEventDispatcher.DataState.StructureModified, DataEventDispatcher.UpdateState.onlyInEditor);
        return newExecTC;
    }

    public static void handleFirstReference(EditSupport editSupport, ISpecTestCasePO referencedTC, boolean isReferencedByThisAction) throws PMAlreadyLockedException, PMDirtyVersionException, PMObjectDeletedException {
        int minSize = 0;
        if (isReferencedByThisAction) {
            minSize = 1;
        }
        if (NodePM.getInternalExecTestCases(referencedTC.getGuid(), referencedTC.getParentProjectId()).size() <= minSize) {
            TestCaseBP.lockPO(editSupport, referencedTC);
        }
    }

    public static void addEventHandler(EditSupport editSupport, ISpecTestCasePO targetTC, IEventExecTestCasePO eventHandlerTC) throws InvalidDataException, PMAlreadyLockedException, PMDirtyVersionException, PMObjectDeletedException {
        TestCaseBP.handleFirstReference(editSupport, eventHandlerTC.getSpecTestCase(), true);
        targetTC.addEventTestCase(eventHandlerTC);
    }

    public static ISpecTestCasePO createNewSpecTestCase(String name, INodePO parent) throws PMSaveException, PMAlreadyLockedException, PMException, ProjectDeletedException {
        ISpecTestCasePO specTC = NodeMaker.createSpecTestCasePO(name);
        NodePM.addAndPersistChildNode(parent, specTC, null);
        return specTC;
    }

    public static List<ISpecTestCasePO> fixSpecsWithProjectAsParent() throws PMException, ProjectDeletedException {
        List<? extends INodePO> specs = NodeBP.getAllNodesForGivenTypeInCurrentProject(NodeMaker.getSpecTestCasePOClass());
        ArrayList<ISpecTestCasePO> specsWithProjectAsParent = new ArrayList<ISpecTestCasePO>();
        for (ISpecTestCasePO iSpecTestCasePO : specs) {
            if (iSpecTestCasePO.getParentNode() != null && !iSpecTestCasePO.getParentNode().equals(GeneralStorage.getInstance().getProject())) continue;
            specsWithProjectAsParent.add(iSpecTestCasePO);
        }
        for (ISpecTestCasePO iSpecTestCasePO : specsWithProjectAsParent) {
            NodePM.addAndPersistChildNode(GeneralStorage.getInstance().getProject().getSpecObjCont(), iSpecTestCasePO, 0);
        }
        return specsWithProjectAsParent;
    }
}

