/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.widgets;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jubula.client.core.functions.FunctionDefinition;
import org.eclipse.jubula.client.core.functions.FunctionRegistry;
import org.eclipse.jubula.client.core.functions.ParameterDefinition;
import org.eclipse.jubula.client.core.functions.VarArgsDefinition;
import org.eclipse.jubula.client.core.gen.parser.parameter.lexer.LexerException;
import org.eclipse.jubula.client.core.gen.parser.parameter.node.TBeginFunctionArgsToken;
import org.eclipse.jubula.client.core.gen.parser.parameter.node.TEndFunctionArgsToken;
import org.eclipse.jubula.client.core.i18n.Messages;
import org.eclipse.jubula.client.core.parser.parameter.FunctionLocator;
import org.eclipse.jubula.client.ui.rcp.widgets.ParamProposalProvider;
import org.eclipse.osgi.util.NLS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FunctionProposalProvider
implements IContentProposalProvider {
    private static final Logger LOG = LoggerFactory.getLogger(FunctionProposalProvider.class);
    private static final String ARG_SEPARATOR = ",";
    private static final String BASE_VARARG_NAME = "varArg";

    public IContentProposal[] getProposals(String contents, int position) {
        String proposalSubstring = contents.substring(0, position);
        try {
            FunctionLocator locator = new FunctionLocator(proposalSubstring);
            String startingFunctionText = locator.getCurrentFunction();
            if (startingFunctionText != null) {
                return this.getProposalsForFunction(startingFunctionText);
            }
        }
        catch (LexerException e) {
            LOG.warn(NLS.bind((String)Messages.ParamProposal_ParsingError, (Object)proposalSubstring), (Throwable)e);
        }
        catch (IOException e) {
            LOG.warn(NLS.bind((String)Messages.ParamProposal_ParsingError, (Object)proposalSubstring), (Throwable)e);
        }
        return new IContentProposal[0];
    }

    private IContentProposal[] getProposalsForFunction(String startingFunctionText) {
        ArrayList<ParamProposalProvider.ParamProposal> proposals = new ArrayList<ParamProposalProvider.ParamProposal>();
        for (FunctionDefinition function : FunctionRegistry.getInstance().getAllFunctions()) {
            if (!function.getName().startsWith(startingFunctionText)) continue;
            StringBuilder displayBuilder = new StringBuilder();
            displayBuilder.append(function.getName()).append(new TBeginFunctionArgsToken().getText());
            ParameterDefinition[] parameters = function.getParameters();
            ArrayList<String> parameterNames = new ArrayList<String>();
            ParameterDefinition[] parameterDefinitionArray = parameters;
            int n = parameters.length;
            int n2 = 0;
            while (n2 < n) {
                ParameterDefinition param = parameterDefinitionArray[n2];
                parameterNames.add(param.getName());
                ++n2;
            }
            VarArgsDefinition varArgs = function.getVarArgs();
            if (varArgs != null) {
                int i = 0;
                while (i < varArgs.getDefaultNumberOfArgs()) {
                    StringBuilder varArgNameBuilder = new StringBuilder(BASE_VARARG_NAME);
                    varArgNameBuilder.append(i + 1);
                    parameterNames.add(varArgNameBuilder.toString());
                    ++i;
                }
            }
            displayBuilder.append(StringUtils.join(parameterNames, (String)ARG_SEPARATOR));
            displayBuilder.append(new TEndFunctionArgsToken().getText());
            String displayString = displayBuilder.toString();
            proposals.add(new ParamProposalProvider.ParamProposal(displayString.substring(startingFunctionText.length()), displayString));
        }
        return proposals.toArray(new IContentProposal[proposals.size()]);
    }
}

