/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.javafx.tester.adapter;

import java.util.List;
import java.util.concurrent.Callable;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.TextField;
import org.eclipse.jubula.rc.common.adaptable.AdapterFactoryRegistry;
import org.eclipse.jubula.rc.common.driver.ClickOptions;
import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.rc.common.tester.adapter.interfaces.IComboComponent;
import org.eclipse.jubula.rc.common.tester.adapter.interfaces.IComponent;
import org.eclipse.jubula.rc.common.tester.adapter.interfaces.ITextComponent;
import org.eclipse.jubula.rc.javafx.driver.EventThreadQueuerJavaFXImpl;
import org.eclipse.jubula.rc.javafx.tester.adapter.JavaFXComponentAdapter;
import org.eclipse.jubula.rc.javafx.tester.adapter.ListViewAdapter;
import org.eclipse.jubula.rc.javafx.tester.util.NodeTraverseHelper;
import org.eclipse.jubula.rc.javafx.tester.util.compatibility.ComboBoxUtils;
import org.eclipse.jubula.toolkit.enums.ValueSets;
import org.eclipse.jubula.tools.internal.objects.event.EventFactory;
import org.eclipse.jubula.tools.internal.utils.TimeUtil;

public class ComboBoxAdapter<T extends ComboBox<?>>
extends JavaFXComponentAdapter<T>
implements IComboComponent {
    public ComboBoxAdapter(T objectToAdapt) {
        super(objectToAdapt);
    }

    public String getText() {
        return EventThreadQueuerJavaFXImpl.invokeAndWait("getText", new Callable<String>(){

            @Override
            public String call() throws Exception {
                TextField editor;
                ComboBox comboBox = (ComboBox)ComboBoxAdapter.this.getRealComponent();
                if (comboBox.isEditable() && (editor = comboBox.getEditor()) != null) {
                    return editor.getText();
                }
                ObservableList children = comboBox.getChildrenUnmodifiable();
                for (Node node : children) {
                    IComponent adapter;
                    if (!(node instanceof ListCell) || (adapter = (IComponent)AdapterFactoryRegistry.getInstance().getAdapter(IComponent.class, (Object)node)) == null || !(adapter instanceof ITextComponent)) continue;
                    return ((ITextComponent)adapter).getText();
                }
                return null;
            }
        });
    }

    public boolean isEditable() {
        return EventThreadQueuerJavaFXImpl.invokeAndWait("isEditable", new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return ((ComboBox)ComboBoxAdapter.this.getRealComponent()).isEditable();
            }
        });
    }

    public void selectAll() {
        this.getRobot().clickAtCurrentPosition(this.getRealComponent(), 1, 1);
        TimeUtil.delay((long)100L);
        ((ComboBox)this.getRealComponent()).getEditor().selectAll();
    }

    public int getSelectedIndex() {
        return EventThreadQueuerJavaFXImpl.invokeAndWait("getSelectedIndex", new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return ((ComboBox)ComboBoxAdapter.this.getRealComponent()).getSelectionModel().getSelectedIndex();
            }
        });
    }

    public void select(int index) {
        ListView<?> lv = this.getComboBoxList();
        ComboBox comboBox = (ComboBox)this.getRealComponent();
        this.setOpenedStatus(comboBox, true);
        try {
            ListViewAdapter listViewAdapter = new ListViewAdapter(lv);
            listViewAdapter.clickOnIndex(index, ClickOptions.create().setClickCount(1).setMouseButton(1));
            TimeUtil.delayDefaultOrExternalTime((long)100L, (String)"TEST_COMBOBOX_DELAY_AFTER_SELECTION");
        }
        finally {
            this.setOpenedStatus(comboBox, false);
        }
    }

    public void input(String text, boolean replace) throws StepExecutionException, IllegalArgumentException {
        if (!this.hasFocus()) {
            TimeUtil.delay((long)100L);
            this.getRobot().clickAtCurrentPosition(this.getRealComponent(), 1, 1);
        }
        if (this.isEditable()) {
            if (replace) {
                this.selectAll();
                if ("".equals(text)) {
                    this.getRobot().keyStroke(ValueSets.KeyStroke.delete.rcValue());
                }
            }
        } else {
            throw new StepExecutionException("The combobox is not editable", EventFactory.createActionError((String)"The combobox is not editable"));
        }
        this.getRobot().type(this.getRealComponent(), text);
    }

    public String[] getValues() {
        ListView<?> lv = this.getComboBoxList();
        ComboBox comboBox = (ComboBox)this.getRealComponent();
        this.setOpenedStatus(comboBox, true);
        String[] values = new String[]{};
        try {
            ListViewAdapter listViewAdapter = new ListViewAdapter(lv);
            values = listViewAdapter.getValues();
        }
        finally {
            this.setOpenedStatus(comboBox, false);
        }
        return values;
    }

    private ListView<?> getComboBoxList() {
        return (ListView)EventThreadQueuerJavaFXImpl.invokeAndWait("getValues", new Callable<ListView<?>>(){

            @Override
            public ListView<?> call() throws Exception {
                ComboBox comboBox = (ComboBox)ComboBoxAdapter.this.getRealComponent();
                List<ListView> listViewList = NodeTraverseHelper.getInstancesOf((Parent)comboBox, ListView.class);
                if (listViewList.size() == 1) {
                    return listViewList.get(0);
                }
                return ComboBoxUtils.getPopUpContent(comboBox);
            }
        });
    }

    private void setOpenedStatus(T comboBox, boolean openStatus) {
        if (comboBox.isShowing() != openStatus) {
            this.getRobot().click((Object)this.getArrowButton(comboBox), null, ClickOptions.create().setClickCount(1).setMouseButton(1).setConfirmClick(false));
        }
    }

    private Node getArrowButton(T comboBox) {
        return ComboBoxUtils.getArrowButton(comboBox);
    }
}

