/*******************************************************************************
 * Copyright (c) 2016 BREDEX GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BREDEX GmbH - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.jubula.toolkit.concrete.internal.impl.handler;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jubula.client.AUTRegistry;
import org.eclipse.jubula.client.Result;
import org.eclipse.jubula.communication.CAP;
import org.eclipse.jubula.toolkit.CapBuilder;
import org.eclipse.jubula.toolkit.annotations.Beta;
import org.eclipse.jubula.toolkit.enums.ValueSets.*;
import javax.annotation.Generated;

import org.apache.commons.lang.Validate;
import org.apache.commons.lang.StringUtils;

import org.eclipse.jubula.communication.internal.message.MessageCap;
import org.eclipse.jubula.communication.internal.message.MessageParam;
import org.eclipse.jubula.tools.ComponentIdentifier;
import org.eclipse.jubula.tools.internal.constants.TestDataConstants;
import org.eclipse.jubula.tools.internal.objects.IComponentIdentifier;
import org.eclipse.jubula.toolkit.internal.annotations.RealizedType;
import org.eclipse.jubula.toolkit.internal.annotations.TesterClass;

/**
 * An ActionHandler directly executes the remote controlling commands for a
 * registered AUT - see {@link org.eclipse.jubula.client.AUTRegistry}
 *
 * Class representing the SliderComponentActionHandler component from the concrete toolkit.
 * @since 4.0
 */
@RealizedType(realizedType="guidancer.abstract.Widget")
@Generated(value = "org.eclipse.jubula.toolkit.api.gen.ActionHandlerGenerator", 
           date =  "2020-04-15T07:16:39.278Z")
public class SliderComponentActionHandler extends org.eclipse.jubula.toolkit.base.internal.impl.handler.GraphicsComponentActionHandler implements org.eclipse.jubula.toolkit.concrete.components.handler.SliderComponentActionHandler {
            public SliderComponentActionHandler(@NonNull ComponentIdentifier componentIdentifier) {
                super(componentIdentifier);
            }
    
    
        /**
         * 
         * @param position 
         *        the position to use
         * @param operator 
         *        the operator used for comparison
         * @param measure 
         *        the way to measure a unit
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @since 4.1
         */
        public Result checkPosition(
            @Nullable String position,
            @Nullable Operator operator,
            @Nullable Measure measure,
            @Nullable Integer timeoutInMs
        )  {
            if (position == null) return null;
            
            if (operator == null) return null;
            
            if (measure == null) return null;
            
            if (timeoutInMs == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcVerifyPosition")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(position)
                            .addParameter(operator.rcValue())
                            .addParameter(measure.rcValue())
                            .addParameter(timeoutInMs)
                            .build(), null);
        }
        /**
         * 
         * @param position 
         *        the position to use
         * @param operator 
         *        the operator used for comparison
         * @param measure 
         *        the way to measure a unit
         * @since 4.1
         */
        public Result checkPosition(
            @Nullable String position,
            @Nullable Operator operator,
            @Nullable Measure measure
        )  {
            if (position == null) return null;
            
            if (operator == null) return null;
            
            if (measure == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcVerifyPosition")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(position)
                            .addParameter(operator.rcValue())
                            .addParameter(measure.rcValue())
                            .addParameter(0)
                            .build(), null);
        }
        
        /**
         * 
         * @param position 
         *        the position to use
         * @param operator 
         *        the operator used for comparison
         * @param measure 
         *        the way to measure a unit
         * 
         */
        public Result selectPosition(
            @Nullable String position,
            @Nullable Operator operator,
            @Nullable Measure measure
        )  {
            if (position == null) return null;
            
            if (operator == null) return null;
            
            if (measure == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcSelectPosition")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(position)
                            .addParameter(operator.rcValue())
                            .addParameter(measure.rcValue())
                            .build(), null);
        }
        
} 