/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.launchbar.ui.controls.internal;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.debug.core.ILaunchMode;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.launchbar.core.ILaunchBarListener;
import org.eclipse.launchbar.core.ILaunchBarManager;
import org.eclipse.launchbar.core.ILaunchDescriptor;
import org.eclipse.launchbar.core.target.ILaunchTarget;
import org.eclipse.launchbar.ui.controls.internal.Activator;
import org.eclipse.launchbar.ui.controls.internal.ConfigSelector;
import org.eclipse.launchbar.ui.controls.internal.LaunchBarButtonImageDescriptor;
import org.eclipse.launchbar.ui.controls.internal.Messages;
import org.eclipse.launchbar.ui.controls.internal.ModeSelector;
import org.eclipse.launchbar.ui.controls.internal.TargetSelector;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;

public class LaunchBarControl
implements ILaunchBarListener {
    public static final String ID = "org.eclipse.launchbar";
    public static final String CLASS_URI = "bundleclass://org.eclipse.launchbar.ui.controls/" + LaunchBarControl.class.getName();
    private ILaunchBarManager manager = Activator.getService(ILaunchBarManager.class);
    private Composite container;
    private ConfigSelector configSelector;
    private ModeSelector modeSelector;
    private Label onLabel;
    private TargetSelector targetSelector;
    private static final int SELECTION_DELAY = 200;

    @PostConstruct
    public void createControl(Composite parent) {
        boolean supportsTargets;
        this.manager.addListener((ILaunchBarListener)this);
        this.container = new Composite(parent, 0);
        this.container.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        GridLayout layout = new GridLayout(5, false);
        layout.marginHeight = 2;
        layout.marginWidth = 2;
        this.container.setLayout((Layout)layout);
        this.container.addDisposeListener(e -> this.dispose());
        ToolBar toolBar = new ToolBar(this.container, 0x800000);
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        boolean buildEnabled = store.getBoolean("enableBuildButton");
        if (buildEnabled) {
            this.createButton((Composite)toolBar, "build", Messages.LaunchBarControl_Build, "org.eclipse.launchbar.ui.command.buildActive");
        }
        this.createButton((Composite)toolBar, "launch", Messages.LaunchBarControl_Launch, "org.eclipse.launchbar.ui.command.launchActive");
        this.createButton((Composite)toolBar, "stop", Messages.LaunchBarControl_Stop, "org.eclipse.launchbar.ui.command.stop");
        this.modeSelector = new ModeSelector(this.container, 0);
        this.modeSelector.setLayoutData(new GridData(16384, 0x1000000, false, false));
        this.modeSelector.setInput(this.manager);
        this.configSelector = new ConfigSelector(this.container, 0);
        this.configSelector.setLayoutData(new GridData(16384, 0x1000000, false, false));
        this.configSelector.setInput(this.manager);
        try {
            supportsTargets = this.supportsTargets(this.manager.getActiveLaunchDescriptor());
        }
        catch (CoreException e2) {
            Activator.log(e2);
            supportsTargets = true;
        }
        if (supportsTargets) {
            this.createTargetSelector();
        }
        this.syncSelectors();
    }

    private void createTargetSelector() {
        if (this.container.isDisposed()) {
            return;
        }
        this.onLabel = new Label(this.container, 0);
        this.onLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.onLabel.setText(String.valueOf(Messages.LaunchBarControl_0) + ":");
        this.targetSelector = new TargetSelector(this.container, 0);
        this.targetSelector.setLayoutData(new GridData(16384, 0x1000000, false, false));
        this.targetSelector.setInput(this.manager);
    }

    protected void syncSelectors() {
        try {
            if (this.configSelector != null) {
                this.configSelector.setSelection(this.manager.getActiveLaunchDescriptor());
            }
            if (this.modeSelector != null) {
                this.modeSelector.setSelection(this.manager.getActiveLaunchMode());
            }
            if (this.targetSelector != null) {
                this.targetSelector.setSelection(this.manager.getActiveLaunchTarget());
            }
        }
        catch (CoreException e) {
            Activator.log(e);
        }
    }

    @PreDestroy
    public void dispose() {
        this.manager.removeListener((ILaunchBarListener)this);
    }

    private ToolItem createButton(Composite parent, String imageName, String toolTipText, final String commandId) {
        ToolItem button = new ToolItem((ToolBar)parent, 0x800000);
        Image bgImage = Activator.getDefault().getImageRegistry().get("bgButton");
        Image fgImage = Activator.getDefault().getImageRegistry().get(imageName);
        LaunchBarButtonImageDescriptor imageDesc = new LaunchBarButtonImageDescriptor(fgImage, bgImage);
        Image image = imageDesc.createImage();
        button.setImage(image);
        button.setToolTipText(toolTipText);
        button.setData("command", (Object)commandId);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
                Command command = commandService.getCommand(commandId);
                Event trigger = new Event();
                IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
                ExecutionEvent executionEvent = handlerService.createExecutionEvent(command, trigger);
                try {
                    command.executeWithChecks(executionEvent);
                }
                catch (OperationCanceledException operationCanceledException) {
                }
                catch (Exception ex) {
                    Activator.log(ex);
                }
            }
        });
        button.addDisposeListener(e -> image.dispose());
        return button;
    }

    public void activeLaunchDescriptorChanged(ILaunchDescriptor descriptor) {
        if (this.container == null || this.container.isDisposed()) {
            return;
        }
        this.container.getDisplay().asyncExec(() -> {
            if (this.configSelector != null) {
                this.configSelector.setDelayedSelection(descriptor, 200L);
            }
            if (this.supportsTargets(descriptor)) {
                if (this.targetSelector == null || this.targetSelector.isDisposed()) {
                    this.createTargetSelector();
                    this.syncSelectors();
                    if (!this.container.isDisposed()) {
                        Composite parent = this.container.getParent();
                        parent.layout(true);
                    }
                }
            } else if (this.targetSelector != null && !this.targetSelector.isDisposed()) {
                this.onLabel.dispose();
                this.targetSelector.dispose();
                if (!this.container.isDisposed()) {
                    Composite parent = this.container.getParent();
                    parent.layout(true);
                }
            }
        });
    }

    private boolean supportsTargets(ILaunchDescriptor descriptor) {
        if (descriptor == null) {
            return true;
        }
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        if (store.getBoolean("alwaysTargetSelector")) {
            return true;
        }
        try {
            return descriptor.getType().supportsTargets();
        }
        catch (CoreException e) {
            Activator.log(e);
            return true;
        }
    }

    public void activeLaunchModeChanged(ILaunchMode mode) {
        if (this.modeSelector != null) {
            this.modeSelector.setDelayedSelection(mode, 200L);
        }
    }

    public void activeLaunchTargetChanged(ILaunchTarget target) {
        if (this.targetSelector != null) {
            this.targetSelector.setDelayedSelection(target, 200L);
        }
    }

    public void launchTargetsChanged() {
        if (this.targetSelector != null) {
            this.targetSelector.refresh();
        }
    }

    public ConfigSelector getConfigSelector() {
        return this.configSelector;
    }
}

