/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.libra.facet.ui.popup.actions;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.libra.facet.OSGiBundleFacetUtils;
import org.eclipse.libra.facet.internal.ui.LibraFacetUIPlugin;
import org.eclipse.libra.facet.ui.popup.actions.Messages;
import org.eclipse.libra.facet.ui.wizards.ConvertProjectsToBundlesWizard;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class ConvertProjectsToBundlesAction
implements IObjectActionDelegate {
    private ISelection fSelection;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        IProject[] unconverted = this.getUnconvertedProjects();
        if (unconverted.length == 0) {
            MessageDialog.openInformation((Shell)this.getDisplay().getActiveShell(), (String)Messages.ConvertProjectsToBundlesAction_NoProjectToConvertTitle, (String)Messages.ConvertProjectsToBundlesAction_NoProjectToConvertDescription);
            return;
        }
        IProject[] selected = this.getSelectedProjects();
        ConvertProjectsToBundlesWizard wizard = new ConvertProjectsToBundlesWizard(unconverted, selected);
        Display display = this.getDisplay();
        final WizardDialog dialog = new WizardDialog(display.getActiveShell(), (IWizard)wizard){

            protected Point getInitialSize() {
                return this.getShell().computeSize(500, -1);
            }
        };
        BusyIndicator.showWhile((Display)display, (Runnable)new Runnable(){

            public void run() {
                dialog.open();
            }
        });
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.fSelection = selection;
    }

    public Display getDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    private IProject[] getUnconvertedProjects() {
        IProject[] projects;
        ArrayList<IProject> unconverted = new ArrayList<IProject>();
        IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            try {
                if (project.isOpen() && !OSGiBundleFacetUtils.hasFeatureNature((IProject)project) && !OSGiBundleFacetUtils.hasUpdateSiteNature((IProject)project) && !OSGiBundleFacetUtils.isOSGiBundle((IProject)project)) {
                    unconverted.add(project);
                }
            }
            catch (CoreException e) {
                LibraFacetUIPlugin.logError(e);
            }
            ++n2;
        }
        return unconverted.toArray(new IProject[unconverted.size()]);
    }

    private IProject[] getSelectedProjects() {
        ArrayList<IProject> selected = new ArrayList<IProject>();
        if (this.fSelection instanceof IStructuredSelection) {
            Object[] objs;
            Object[] objectArray = objs = ((IStructuredSelection)this.fSelection).toArray();
            int n = objs.length;
            int n2 = 0;
            while (n2 < n) {
                Object obj = objectArray[n2];
                IProject project = null;
                if (obj instanceof IProject) {
                    project = (IProject)obj;
                } else if (obj instanceof IAdaptable) {
                    project = (IProject)((IAdaptable)obj).getAdapter(IProject.class);
                } else {
                    IAdapterManager manager = Platform.getAdapterManager();
                    project = (IProject)manager.getAdapter(obj, IProject.class);
                }
                if (project != null) {
                    selected.add(project);
                }
                ++n2;
            }
        }
        return selected.toArray(new IProject[selected.size()]);
    }
}

