/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.libra.framework.core.publish;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.libra.framework.core.FrameworkInstanceConfiguration;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.ModelEntry;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.core.target.TargetBundle;
import org.eclipse.pde.internal.core.WorkspaceModelManager;
import org.eclipse.pde.internal.core.exports.FeatureExportInfo;
import org.eclipse.pde.internal.core.exports.PluginExportOperation;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.ui.progress.IProgressConstants;
import org.eclipse.wst.server.core.IModule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PublishHelper {
    protected abstract IPath getPublishFolder();

    public String getServerModules(List modules, String prefix, String spacer) {
        StringBuilder builder = new StringBuilder();
        for (Object object : modules) {
            IModule[] moduleArr;
            IModule[] iModuleArray = moduleArr = (IModule[])object;
            int n = moduleArr.length;
            int n2 = 0;
            while (n2 < n) {
                IModule module = iModuleArray[n2];
                if (builder.length() > 0) {
                    builder.append(spacer);
                }
                IPluginModelBase[] models = PluginRegistry.getActiveModels();
                IPath publishFolder = this.getPublishFolder();
                IPluginModelBase[] iPluginModelBaseArray = models;
                int n3 = models.length;
                int n4 = 0;
                while (n4 < n3) {
                    IPluginModelBase iPluginModelBase = iPluginModelBaseArray[n4];
                    if (iPluginModelBase.getBundleDescription().getName().equalsIgnoreCase(module.getName()) && builder.indexOf(String.valueOf(iPluginModelBase.getPluginBase().getId()) + "_" + iPluginModelBase.getPluginBase().getVersion() + ".jar") < 0) {
                        builder.append(String.valueOf(prefix) + publishFolder.append(String.valueOf(iPluginModelBase.getPluginBase().getId()) + "_" + iPluginModelBase.getPluginBase().getVersion() + ".jar").toOSString());
                        break;
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return builder.toString();
    }

    public String getTargetBundles(FrameworkInstanceConfiguration config, String prefix, String spacer) {
        StringBuffer buffer = new StringBuffer();
        String[] paths = this.getTargetBundlePaths(config);
        int i = 0;
        while (i < paths.length) {
            String path = paths[i];
            if (buffer.length() > 0) {
                buffer.append(spacer);
            }
            buffer.append(String.valueOf(prefix) + path);
            ++i;
        }
        return buffer.toString();
    }

    public String[] getTargetBundlePaths(FrameworkInstanceConfiguration config) {
        TargetBundle[] targetBundles;
        ArrayList<String> all = new ArrayList<String>();
        ITargetDefinition targetDefinition = config.getTargetDefinition();
        targetDefinition.resolve((IProgressMonitor)new NullProgressMonitor());
        TargetBundle[] targetBundleArray = targetBundles = targetDefinition.getBundles();
        int n = targetBundles.length;
        int n2 = 0;
        while (n2 < n) {
            TargetBundle b = targetBundleArray[n2];
            if (b.getStatus().getSeverity() == 0) {
                all.add(b.getBundleInfo().getLocation().getRawPath());
            }
            ++n2;
        }
        return all.toArray(new String[all.size()]);
    }

    public TargetBundle[] getTargetBundles(FrameworkInstanceConfiguration config) {
        new ArrayList();
        ITargetDefinition targetDefinition = config.getTargetDefinition();
        targetDefinition.resolve((IProgressMonitor)new NullProgressMonitor());
        TargetBundle[] targetBundles = targetDefinition.getBundles();
        return targetBundles;
    }

    public String[] getTargetBundleIds(FrameworkInstanceConfiguration config) {
        TargetBundle[] targetBundles;
        ArrayList<String> all = new ArrayList<String>();
        ITargetDefinition targetDefinition = config.getTargetDefinition();
        targetDefinition.resolve((IProgressMonitor)new NullProgressMonitor());
        TargetBundle[] targetBundleArray = targetBundles = targetDefinition.getBundles();
        int n = targetBundles.length;
        int n2 = 0;
        while (n2 < n) {
            TargetBundle b = targetBundleArray[n2];
            if (b.getStatus().getSeverity() == 0) {
                all.add(b.getBundleInfo().getSymbolicName());
            }
            ++n2;
        }
        return all.toArray(new String[all.size()]);
    }

    public void exportBundles(List modules, FrameworkInstanceConfiguration config, IPath location) {
        this.exportBundles(modules, config, location, null);
    }

    public void exportBundles(List modules, FrameworkInstanceConfiguration config, final IPath location, final IPath tmpLocation) {
        FeatureExportInfo info = new FeatureExportInfo();
        info.toDirectory = true;
        info.useJarFormat = true;
        info.exportSource = true;
        info.exportSourceBundle = false;
        info.allowBinaryCycles = true;
        info.useWorkspaceCompiledClasses = true;
        info.destinationDirectory = tmpLocation == null ? location.makeAbsolute().toOSString() : tmpLocation.makeAbsolute().toOSString();
        ArrayList<IPluginModelBase> allWsBundles = new ArrayList<IPluginModelBase>();
        ArrayList<IProject> allBinBundles = new ArrayList<IProject>();
        for (Object module : modules) {
            try {
                IModule[] moduleArr;
                IModule[] iModuleArray = moduleArr = (IModule[])module;
                int n = moduleArr.length;
                int n2 = 0;
                while (n2 < n) {
                    IModule iModule = iModuleArray[n2];
                    IProject project = iModule.getProject();
                    IPluginModelBase pmb = PluginRegistry.findModel((IProject)project);
                    ModelEntry entry = null;
                    if (pmb != null) {
                        entry = PluginRegistry.findEntry((String)pmb.getBundleDescription().getSymbolicName());
                    }
                    if (!WorkspaceModelManager.isBinaryProject((IProject)project) && WorkspaceModelManager.isPluginProject((IProject)project)) {
                        if (entry.getModel() != null && this.isValidModel((IModel)entry.getModel()) && this.hasBuildProperties(entry.getModel())) {
                            allWsBundles.add(entry.getModel());
                        } else {
                            allBinBundles.add(project);
                        }
                    } else if (WorkspaceModelManager.isBinaryProject((IProject)project) && WorkspaceModelManager.isPluginProject((IProject)project)) {
                        allBinBundles.add(project);
                    }
                    ++n2;
                }
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
        this.copyBinaryJars(allBinBundles, tmpLocation == null ? location : tmpLocation);
        info.items = allWsBundles.toArray();
        info.signingInfo = null;
        info.qualifier = "qualifier";
        PluginExportOperation job = new PluginExportOperation(info, PDEUIMessages.PluginExportJob_name);
        job.setUser(true);
        job.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        job.setProperty(IProgressConstants.ICON_PROPERTY, (Object)PDEPluginImages.DESC_PLUGIN_OBJ);
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                block10: {
                    if (event.getResult().isOK()) {
                        try {
                            if (tmpLocation == null) break block10;
                            File sourceFiles = tmpLocation.append("/plugins").toFile();
                            File[] fileArray = sourceFiles.listFiles();
                            int n = fileArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                File jars = fileArray[n2];
                                File destFile = location.append(jars.getName()).toFile();
                                if (!destFile.exists()) {
                                    destFile.createNewFile();
                                }
                                FileChannel source = null;
                                AbstractInterruptibleChannel destination = null;
                                try {
                                    source = new FileInputStream(jars).getChannel();
                                    destination = new FileOutputStream(destFile).getChannel();
                                    ((FileChannel)destination).transferFrom(source, 0L, source.size());
                                }
                                finally {
                                    if (source != null) {
                                        source.close();
                                    }
                                    if (destination != null) {
                                        destination.close();
                                    }
                                }
                                ++n2;
                            }
                        }
                        catch (Exception exception) {}
                    }
                }
            }
        });
        job.schedule();
    }

    private void copyBinaryJars(List<IProject> list, IPath location) {
        AbstractInterruptibleChannel inChannel = null;
        AbstractInterruptibleChannel outChannel = null;
        try {
            try {
                block23: for (IProject project : list) {
                    IResource[] iResourceArray = project.members(true);
                    int n = iResourceArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IResource resource = iResourceArray[n2];
                        if ("jar".equalsIgnoreCase(resource.getFileExtension())) {
                            IPluginModelBase[] models;
                            String jarId = "";
                            IPluginModelBase[] iPluginModelBaseArray = models = PluginRegistry.getWorkspaceModels();
                            int n3 = models.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                IPluginModelBase iPluginModelBase = iPluginModelBaseArray[n4];
                                if (iPluginModelBase.getPluginBase().getId().equalsIgnoreCase(resource.getProject().getName())) {
                                    iPluginModelBase.getPluginBase().getId();
                                    jarId = String.valueOf(iPluginModelBase.getPluginBase().getId()) + "_" + iPluginModelBase.getPluginBase().getVersion() + ".jar";
                                }
                                ++n4;
                            }
                            inChannel = new FileInputStream(new File(resource.getLocationURI())).getChannel();
                            outChannel = new FileOutputStream(new File(location.append(jarId).makeAbsolute().toPortableString())).getChannel();
                            ((FileChannel)inChannel).transferTo(0L, ((FileChannel)inChannel).size(), (WritableByteChannel)((Object)outChannel));
                            continue block23;
                        }
                        ++n2;
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                if (inChannel != null) {
                    try {
                        inChannel.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
                if (outChannel != null) {
                    try {
                        outChannel.close();
                    }
                    catch (IOException e3) {
                        e3.printStackTrace();
                    }
                }
            }
            catch (CoreException e) {
                block34: {
                    e.printStackTrace();
                    if (inChannel == null) break block34;
                    try {
                        inChannel.close();
                    }
                    catch (IOException e4) {
                        e4.printStackTrace();
                    }
                }
                if (outChannel != null) {
                    try {
                        outChannel.close();
                    }
                    catch (IOException e5) {
                        e5.printStackTrace();
                    }
                }
            }
        }
        finally {
            if (inChannel != null) {
                try {
                    inChannel.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (outChannel != null) {
                try {
                    outChannel.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private boolean hasBuildProperties(IPluginModelBase model) {
        File file = new File(model.getInstallLocation(), "build.properties");
        return file.exists();
    }

    protected boolean isValidModel(IModel model) {
        return model != null && model instanceof IPluginModelBase;
    }
}

