/**
 * Copyright (c) 2010, 2011 Tasktop Technologies and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Tasktop Technologies - initial API and implementation
 */
package org.eclipse.mylyn.builds.core;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/**
 * <!-- begin-user-doc --> A representation of the literals of the enumeration '<em><b>Test Case Result</b></em>', and
 * utility methods for working with them. <!-- end-user-doc -->
 * 
 * @see org.eclipse.mylyn.builds.internal.core.BuildPackage#getTestCaseResult()
 * @generated
 */
public enum TestCaseResult implements InternalTestCaseResult {
	/**
	 * The '<em><b>PASSED</b></em>' literal object. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see #PASSED_VALUE
	 * @generated
	 * @ordered
	 */
	PASSED(1, "PASSED", "PASSED"), //$NON-NLS-1$ //$NON-NLS-2$

	/**
	 * The '<em><b>SKIPPED</b></em>' literal object. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see #SKIPPED_VALUE
	 * @generated
	 * @ordered
	 */
	SKIPPED(2, "SKIPPED", "SKIPPED"), //$NON-NLS-1$ //$NON-NLS-2$

	/**
	 * The '<em><b>FAILED</b></em>' literal object. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see #FAILED_VALUE
	 * @generated
	 * @ordered
	 */
	FAILED(3, "FAILED", "FAILED"), //$NON-NLS-1$ //$NON-NLS-2$

	/**
	 * The '<em><b>FIXED</b></em>' literal object. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see #FIXED_VALUE
	 * @generated
	 * @ordered
	 */
	FIXED(4, "FIXED", "FIXED"), //$NON-NLS-1$ //$NON-NLS-2$

	/**
	 * The '<em><b>REGRESSION</b></em>' literal object. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see #REGRESSION_VALUE
	 * @generated
	 * @ordered
	 */
	REGRESSION(5, "REGRESSION", "REGRESSION"); //$NON-NLS-1$ //$NON-NLS-2$

	/**
	 * The '<em><b>PASSED</b></em>' literal value. <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>PASSED</b></em>' literal object isn't clear, there really should be more of a
	 * description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @see #PASSED
	 * @generated
	 * @ordered
	 */
	public static final int PASSED_VALUE = 1;

	/**
	 * The '<em><b>SKIPPED</b></em>' literal value. <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>SKIPPED</b></em>' literal object isn't clear, there really should be more of a
	 * description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @see #SKIPPED
	 * @generated
	 * @ordered
	 */
	public static final int SKIPPED_VALUE = 2;

	/**
	 * The '<em><b>FAILED</b></em>' literal value. <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>FAILED</b></em>' literal object isn't clear, there really should be more of a
	 * description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @see #FAILED
	 * @generated
	 * @ordered
	 */
	public static final int FAILED_VALUE = 3;

	/**
	 * The '<em><b>FIXED</b></em>' literal value. <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>FIXED</b></em>' literal object isn't clear, there really should be more of a
	 * description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @see #FIXED
	 * @generated
	 * @ordered
	 */
	public static final int FIXED_VALUE = 4;

	/**
	 * The '<em><b>REGRESSION</b></em>' literal value. <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>REGRESSION</b></em>' literal object isn't clear, there really should be more of a
	 * description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @see #REGRESSION
	 * @generated
	 * @ordered
	 */
	public static final int REGRESSION_VALUE = 5;

	/**
	 * An array of all the '<em><b>Test Case Result</b></em>' enumerators. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private static final TestCaseResult[] VALUES_ARRAY = new TestCaseResult[] { PASSED, SKIPPED, FAILED, FIXED,
			REGRESSION, };

	/**
	 * A public read-only list of all the '<em><b>Test Case Result</b></em>' enumerators. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @generated
	 */
	public static final List<TestCaseResult> VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

	/**
	 * Returns the '<em><b>Test Case Result</b></em>' literal with the specified literal value. <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public static TestCaseResult get(String literal) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			TestCaseResult result = VALUES_ARRAY[i];
			if (result.toString().equals(literal)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>Test Case Result</b></em>' literal with the specified name. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @generated
	 */
	public static TestCaseResult getByName(String name) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			TestCaseResult result = VALUES_ARRAY[i];
			if (result.getName().equals(name)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>Test Case Result</b></em>' literal with the specified integer value. <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public static TestCaseResult get(int value) {
		switch (value) {
		case PASSED_VALUE:
			return PASSED;
		case SKIPPED_VALUE:
			return SKIPPED;
		case FAILED_VALUE:
			return FAILED;
		case FIXED_VALUE:
			return FIXED;
		case REGRESSION_VALUE:
			return REGRESSION;
		}
		return null;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private final int value;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private final String name;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private final String literal;

	/**
	 * Only this class can construct instances. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	private TestCaseResult(int value, String name, String literal) {
		this.value = value;
		this.name = name;
		this.literal = literal;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public int getValue() {
		return value;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public String getName() {
		return name;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public String getLiteral() {
		return literal;
	}

	/**
	 * Returns the literal value of the enumerator, which is its string representation. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public String toString() {
		return literal;
	}

} //TestCaseResult

/**
 * A private implementation interface used to hide the inheritance from Enumerator. <!-- begin-user-doc --> <!--
 * end-user-doc -->
 * 
 * @generated
 */
interface InternalTestCaseResult extends org.eclipse.emf.common.util.Enumerator {
	// Empty 
}
