/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.samples;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Properties;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.ICoreRunnable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.objectteams.otdt.internal.samples.Messages;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;
import org.eclipse.ui.wizards.datatransfer.ImportOperation;
import org.eclipse.ui.wizards.datatransfer.ZipFileStructureProvider;
import org.osgi.framework.Bundle;

public class SampleOperation
implements IRunnableWithProgress {
    private static final String SAMPLE_PROPERTIES = "sample.properties";
    private IConfigurationElement sample;
    private String[] projectNames;
    private IFile sampleManifest;
    private IOverwriteQuery query;
    private boolean yesToAll;
    private boolean cancel;
    private IProject[] createdProjects;

    public SampleOperation(IConfigurationElement sample, String[] projectNames, IOverwriteQuery query) {
        this.sample = sample;
        this.query = query;
        this.projectNames = projectNames;
    }

    public IFile getSampleManifest() {
        return this.sampleManifest;
    }

    public IProject[] getCreatedProjects() {
        return this.createdProjects;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            ICoreRunnable op = new ICoreRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    IConfigurationElement[] projects = SampleOperation.this.sample.getChildren("project");
                    SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.SampleOperation_creating, (int)projects.length);
                    SampleOperation.this.createdProjects = new IProject[projects.length];
                    try {
                        int i = 0;
                        while (i < projects.length) {
                            IFile file = SampleOperation.this.importProject(SampleOperation.this.projectNames[i], projects[i], (IProgressMonitor)subMonitor.split(1));
                            if (file != null && SampleOperation.this.sampleManifest == null) {
                                SampleOperation.this.sampleManifest = file;
                            }
                            if (file != null) {
                                ((SampleOperation)SampleOperation.this).createdProjects[i] = file.getProject();
                            }
                            if (!SampleOperation.this.cancel) {
                                ++i;
                                continue;
                            }
                            break;
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        throw new OperationCanceledException();
                    }
                    catch (InvocationTargetException e) {
                        SampleOperation.this.throwCoreException(e);
                    }
                }
            };
            ResourcesPlugin.getWorkspace().run(op, monitor);
        }
        catch (CoreException e) {
            throw new InvocationTargetException(e);
        }
        catch (OperationCanceledException e) {
            throw e;
        }
    }

    private void throwCoreException(InvocationTargetException e) throws CoreException {
        Throwable t = e.getCause();
        Status status = new Status(4, "org.eclipse.objectteams.otdt.samples", 0, e.getMessage(), t);
        throw new CoreException((IStatus)status);
    }

    private IFile importProject(String name, IConfigurationElement config, IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        String path = config.getAttribute("archive");
        if (name == null || path == null) {
            return null;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        IProject project = root.getProject(name);
        boolean skip = false;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)name, (int)5);
        if (project.exists()) {
            if (!this.yesToAll) {
                String returnId = this.query.queryOverwrite(project.getFullPath().toString());
                if (returnId.equals("ALL")) {
                    this.yesToAll = true;
                    skip = false;
                } else if (returnId.equals("YES")) {
                    skip = false;
                } else if (returnId.equals("NO")) {
                    skip = true;
                } else if (returnId.equals("CANCEL")) {
                    skip = true;
                    this.cancel = true;
                }
            }
            if (!skip) {
                project.delete(true, true, (IProgressMonitor)subMonitor.split(1));
                project = root.getProject(name);
            } else {
                subMonitor.worked(1);
            }
        }
        if (skip) {
            subMonitor.worked(4);
            IFile manifest = project.getFile(SAMPLE_PROPERTIES);
            return manifest;
        }
        project.create((IProgressMonitor)subMonitor.split(1));
        project.open((IProgressMonitor)subMonitor.split(1));
        Bundle bundle = Platform.getBundle((String)this.sample.getNamespaceIdentifier());
        ZipFile zipFile = this.getZipFileFromPluginDir(path, bundle);
        this.importFilesFromZip(zipFile, project.getFullPath(), (IProgressMonitor)subMonitor.split(1));
        return this.createSampleManifest(project, config, (IProgressMonitor)subMonitor.split(1));
    }

    private IFile createSampleManifest(IProject project, IConfigurationElement config, IProgressMonitor monitor) throws CoreException {
        IFile file = project.getFile(SAMPLE_PROPERTIES);
        if (!file.exists()) {
            try {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                Properties properties = new Properties();
                this.createSampleManifestContent(config.getAttribute("name"), properties);
                properties.store(out, "");
                out.flush();
                String contents = out.toString();
                out.close();
                ByteArrayInputStream stream = new ByteArrayInputStream(contents.getBytes("UTF8"));
                file.create((InputStream)stream, true, monitor);
                stream.close();
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
            }
            catch (IOException iOException) {}
        }
        return file;
    }

    private void createSampleManifestContent(String projectName, Properties properties) {
        this.writeProperty(properties, "id", this.sample.getAttribute("id"));
        this.writeProperty(properties, "name", this.sample.getAttribute("name"));
        this.writeProperty(properties, "projectName", projectName);
        this.writeProperty(properties, "launcher", this.sample.getAttribute("launcher"));
        this.writeProperty(properties, "launchTarget", this.sample.getAttribute("launchTarget"));
        IConfigurationElement[] desc = this.sample.getChildren("description");
        if (desc.length == 1) {
            this.writeProperty(properties, "helpHref", desc[0].getAttribute("helpHref"));
            this.writeProperty(properties, "description", desc[0].getValue());
        }
    }

    private void writeProperty(Properties properties, String name, String value) {
        if (value == null) {
            return;
        }
        properties.setProperty(name, value);
    }

    private ZipFile getZipFileFromPluginDir(String pluginRelativePath, Bundle bundle) throws CoreException {
        try {
            URL starterURL = FileLocator.resolve((URL)bundle.getEntry(pluginRelativePath));
            return new ZipFile(FileLocator.toFileURL((URL)starterURL).getFile());
        }
        catch (IOException e) {
            String message = String.valueOf(pluginRelativePath) + ": " + e.getMessage();
            Status status = new Status(4, "org.eclipse.objectteams.otdt.samples", 4, message, (Throwable)e);
            throw new CoreException((IStatus)status);
        }
    }

    private void importFilesFromZip(ZipFile srcZipFile, IPath destPath, IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        ZipFileStructureProvider structureProvider = new ZipFileStructureProvider(srcZipFile);
        ImportOperation op = new ImportOperation(destPath, (Object)structureProvider.getRoot(), (IImportStructureProvider)structureProvider, this.query);
        op.run(monitor);
    }
}

