/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.uml.internal.es2as;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.AssociationClass;
import org.eclipse.ocl.pivot.BooleanLiteralExp;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.Constraint;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.EnumLiteralExp;
import org.eclipse.ocl.pivot.Enumeration;
import org.eclipse.ocl.pivot.EnumerationLiteral;
import org.eclipse.ocl.pivot.ExpressionInOCL;
import org.eclipse.ocl.pivot.IntegerLiteralExp;
import org.eclipse.ocl.pivot.LanguageExpression;
import org.eclipse.ocl.pivot.NamedElement;
import org.eclipse.ocl.pivot.Namespace;
import org.eclipse.ocl.pivot.NullLiteralExp;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.PivotFactory;
import org.eclipse.ocl.pivot.PivotPackage;
import org.eclipse.ocl.pivot.PrimitiveType;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.RealLiteralExp;
import org.eclipse.ocl.pivot.Region;
import org.eclipse.ocl.pivot.StandardLibrary;
import org.eclipse.ocl.pivot.State;
import org.eclipse.ocl.pivot.StringLiteralExp;
import org.eclipse.ocl.pivot.Transition;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.UnlimitedNaturalLiteralExp;
import org.eclipse.ocl.pivot.Vertex;
import org.eclipse.ocl.pivot.VoidType;
import org.eclipse.ocl.pivot.internal.complete.StandardLibraryInternal;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.internal.utilities.External2AS;
import org.eclipse.ocl.pivot.internal.utilities.PivotUtilInternal;
import org.eclipse.ocl.pivot.uml.internal.es2as.AssociationClassProperties;
import org.eclipse.ocl.pivot.uml.internal.es2as.UML2AS;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.LabelUtil;
import org.eclipse.ocl.pivot.values.Unlimited;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Generalization;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.InstanceValue;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.LiteralBoolean;
import org.eclipse.uml2.uml.LiteralInteger;
import org.eclipse.uml2.uml.LiteralNull;
import org.eclipse.uml2.uml.LiteralReal;
import org.eclipse.uml2.uml.LiteralString;
import org.eclipse.uml2.uml.LiteralUnlimitedNatural;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.ParameterDirectionKind;
import org.eclipse.uml2.uml.Slot;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.uml2.uml.util.UMLSwitch;

public class UML2ASUseSwitch
extends UMLSwitch<Object> {
    private static final Logger logger = Logger.getLogger(UML2ASUseSwitch.class);
    protected final @NonNull UML2AS converter;
    protected final @NonNull EnvironmentFactoryInternal environmentFactory;
    protected final @NonNull StandardLibraryInternal standardLibrary;
    private Set<EClass> doneWarnings = null;

    public UML2ASUseSwitch(@NonNull UML2AS converter) {
        this.converter = converter;
        this.environmentFactory = converter.getEnvironmentFactory();
        this.standardLibrary = converter.getStandardLibrary();
    }

    public Object caseAssociation(Association umlAssociation) {
        assert (umlAssociation != null);
        AssociationClass asAssociationClass = (AssociationClass)this.converter.getCreated(AssociationClass.class, (EObject)umlAssociation);
        if (asAssociationClass != null) {
            this.markRedefinitions(umlAssociation);
            EList invariants = umlAssociation.getOwnedRules();
            this.doSwitchAll(Constraint.class, ClassUtil.nullFree((List)asAssociationClass.getOwnedInvariants()), (List<? extends EObject>)invariants);
            this.copyConstraints((Namespace)asAssociationClass, (org.eclipse.uml2.uml.Namespace)umlAssociation, (List<org.eclipse.uml2.uml.Constraint>)invariants);
        }
        return asAssociationClass;
    }

    public Object caseAssociationClass(org.eclipse.uml2.uml.AssociationClass umlAssociationClass) {
        assert (umlAssociationClass != null);
        this.markRedefinitions((Association)umlAssociationClass);
        return this.caseClass((org.eclipse.uml2.uml.Class)umlAssociationClass);
    }

    public Class caseClass(org.eclipse.uml2.uml.Class umlClass) {
        assert (umlClass != null);
        Class pivotElement = (Class)this.converter.getCreated(Class.class, (EObject)umlClass);
        if (pivotElement != null) {
            EList invariants = umlClass.getOwnedRules();
            this.doSwitchAll(Constraint.class, ClassUtil.nullFree((List)pivotElement.getOwnedInvariants()), (List<? extends EObject>)invariants);
            this.copyConstraints((Namespace)pivotElement, (org.eclipse.uml2.uml.Namespace)umlClass, (List<org.eclipse.uml2.uml.Constraint>)invariants);
        }
        return pivotElement;
    }

    public Object caseClassifier(Classifier umlClassifier) {
        assert (umlClassifier != null);
        Class pivotElement = (Class)this.converter.getCreated(Class.class, (EObject)umlClassifier);
        if (pivotElement != null) {
            EList invariants = umlClassifier.getOwnedRules();
            this.doSwitchAll(Constraint.class, ClassUtil.nullFree((List)pivotElement.getOwnedInvariants()), (List<? extends EObject>)invariants);
            this.copyConstraints((Namespace)pivotElement, (org.eclipse.uml2.uml.Namespace)umlClassifier, (List<org.eclipse.uml2.uml.Constraint>)invariants);
        }
        return pivotElement;
    }

    public Constraint caseConstraint(org.eclipse.uml2.uml.Constraint umlConstraint) {
        assert (umlConstraint != null);
        Constraint pivotElement = this.converter.refreshNamedElement(Constraint.class, PivotPackage.Literals.CONSTRAINT, (org.eclipse.uml2.uml.NamedElement)umlConstraint);
        ValueSpecification umlSpecification = umlConstraint.getSpecification();
        Object pivotSpecification = umlSpecification != null ? this.doSwitch((EObject)umlSpecification) : null;
        pivotElement.setOwnedSpecification((LanguageExpression)((ExpressionInOCL)pivotSpecification));
        this.converter.copyNamedElement((NamedElement)pivotElement, (org.eclipse.uml2.uml.NamedElement)umlConstraint);
        this.doSwitchAllOptional(Element.class, ClassUtil.nullFree((List)pivotElement.getConstrainedElements()), (List<? extends EObject>)umlConstraint.getConstrainedElements());
        return pivotElement;
    }

    public Object caseInstanceValue(InstanceValue umlInstanceValue) {
        assert (umlInstanceValue != null);
        InstanceSpecification umlInstance = umlInstanceValue.getInstance();
        if (umlInstance instanceof org.eclipse.uml2.uml.EnumerationLiteral) {
            EnumerationLiteral pivotEnumerationLiteral = (EnumerationLiteral)this.converter.getCreated(EnumerationLiteral.class, (EObject)umlInstance);
            ExpressionInOCL pivotElement = this.converter.refreshNamedElement(ExpressionInOCL.class, PivotPackage.Literals.EXPRESSION_IN_OCL, (org.eclipse.uml2.uml.NamedElement)umlInstanceValue);
            OCLExpression body = pivotElement.getOwnedBody();
            if (!(body instanceof EnumLiteralExp)) {
                body = PivotFactory.eINSTANCE.createEnumLiteralExp();
                pivotElement.setOwnedBody(body);
                if (pivotEnumerationLiteral != null) {
                    Enumeration type = pivotEnumerationLiteral.getOwningEnumeration();
                    body.setType((Type)type);
                    pivotElement.setType((Type)type);
                }
            }
            ((EnumLiteralExp)body).setReferredLiteral(pivotEnumerationLiteral);
            this.converter.copyNamedElement((NamedElement)pivotElement, (org.eclipse.uml2.uml.NamedElement)umlInstanceValue);
            return pivotElement;
        }
        this.converter.error("Unknown InstanceValue " + umlInstance.getClass() + " for UML2ASReferenceSwitch");
        return null;
    }

    public Class caseInterface(Interface umlInterface) {
        assert (umlInterface != null);
        Class pivotElement = (Class)this.converter.getCreated(Class.class, (EObject)umlInterface);
        if (pivotElement != null) {
            EList umlGeneralizations = umlInterface.getGeneralizations();
            ArrayList<Class> newSuperTypes = new ArrayList<Class>(Math.max(1, umlGeneralizations.size()));
            for (Generalization umlGeneralization : umlGeneralizations) {
                Class pivotGeneral;
                Classifier umlGeneral = umlGeneralization.getGeneral();
                if (umlGeneral == null || newSuperTypes.contains(pivotGeneral = (Class)this.converter.getCreated(Class.class, (EObject)umlGeneral))) continue;
                newSuperTypes.add(pivotGeneral);
            }
            if (newSuperTypes.isEmpty()) {
                Class oclElementType = this.standardLibrary.getOclElementType();
                newSuperTypes.add(oclElementType);
            }
            PivotUtilInternal.refreshList((List)pivotElement.getSuperClasses(), newSuperTypes);
        }
        return pivotElement;
    }

    public Object caseLiteralBoolean(LiteralBoolean umlLiteral) {
        assert (umlLiteral != null);
        ExpressionInOCL pivotElement = this.converter.refreshNamedElement(ExpressionInOCL.class, PivotPackage.Literals.EXPRESSION_IN_OCL, (org.eclipse.uml2.uml.NamedElement)umlLiteral);
        OCLExpression body = pivotElement.getOwnedBody();
        if (!(body instanceof BooleanLiteralExp)) {
            body = PivotFactory.eINSTANCE.createBooleanLiteralExp();
            pivotElement.setOwnedBody(body);
            PrimitiveType type = this.standardLibrary.getBooleanType();
            body.setType((Type)type);
            pivotElement.setType((Type)type);
        }
        ((BooleanLiteralExp)body).setBooleanSymbol(umlLiteral.booleanValue());
        this.converter.copyNamedElement((NamedElement)pivotElement, (org.eclipse.uml2.uml.NamedElement)umlLiteral);
        return pivotElement;
    }

    public Object caseLiteralInteger(LiteralInteger umlLiteral) {
        assert (umlLiteral != null);
        ExpressionInOCL pivotElement = this.converter.refreshNamedElement(ExpressionInOCL.class, PivotPackage.Literals.EXPRESSION_IN_OCL, (org.eclipse.uml2.uml.NamedElement)umlLiteral);
        OCLExpression body = pivotElement.getOwnedBody();
        if (!(body instanceof IntegerLiteralExp)) {
            body = PivotFactory.eINSTANCE.createIntegerLiteralExp();
            pivotElement.setOwnedBody(body);
            PrimitiveType type = this.standardLibrary.getIntegerType();
            body.setType((Type)type);
            pivotElement.setType((Type)type);
        }
        ((IntegerLiteralExp)body).setIntegerSymbol((Number)umlLiteral.getValue());
        this.converter.copyNamedElement((NamedElement)pivotElement, (org.eclipse.uml2.uml.NamedElement)umlLiteral);
        return pivotElement;
    }

    public Object caseLiteralNull(LiteralNull umlLiteral) {
        assert (umlLiteral != null);
        ExpressionInOCL pivotElement = this.converter.refreshNamedElement(ExpressionInOCL.class, PivotPackage.Literals.EXPRESSION_IN_OCL, (org.eclipse.uml2.uml.NamedElement)umlLiteral);
        OCLExpression body = pivotElement.getOwnedBody();
        if (!(body instanceof NullLiteralExp)) {
            body = PivotFactory.eINSTANCE.createNullLiteralExp();
            pivotElement.setOwnedBody(body);
            VoidType type = this.standardLibrary.getOclVoidType();
            body.setType((Type)type);
            pivotElement.setType((Type)type);
        }
        this.converter.copyNamedElement((NamedElement)pivotElement, (org.eclipse.uml2.uml.NamedElement)umlLiteral);
        return pivotElement;
    }

    public Object caseLiteralReal(LiteralReal umlLiteral) {
        assert (umlLiteral != null);
        ExpressionInOCL pivotElement = this.converter.refreshNamedElement(ExpressionInOCL.class, PivotPackage.Literals.EXPRESSION_IN_OCL, (org.eclipse.uml2.uml.NamedElement)umlLiteral);
        OCLExpression body = pivotElement.getOwnedBody();
        if (!(body instanceof RealLiteralExp)) {
            body = PivotFactory.eINSTANCE.createRealLiteralExp();
            pivotElement.setOwnedBody(body);
            PrimitiveType type = this.standardLibrary.getRealType();
            body.setType((Type)type);
            pivotElement.setType((Type)type);
        }
        ((RealLiteralExp)body).setRealSymbol((Number)umlLiteral.getValue());
        this.converter.copyNamedElement((NamedElement)pivotElement, (org.eclipse.uml2.uml.NamedElement)umlLiteral);
        return pivotElement;
    }

    public Object caseLiteralString(LiteralString umlLiteral) {
        assert (umlLiteral != null);
        ExpressionInOCL pivotElement = this.converter.refreshNamedElement(ExpressionInOCL.class, PivotPackage.Literals.EXPRESSION_IN_OCL, (org.eclipse.uml2.uml.NamedElement)umlLiteral);
        OCLExpression body = pivotElement.getOwnedBody();
        if (!(body instanceof StringLiteralExp)) {
            body = PivotFactory.eINSTANCE.createStringLiteralExp();
            pivotElement.setOwnedBody(body);
            PrimitiveType type = this.standardLibrary.getStringType();
            body.setType((Type)type);
            pivotElement.setType((Type)type);
        }
        String umlValue = umlLiteral.getValue();
        ((StringLiteralExp)body).setStringSymbol(umlValue != null ? umlValue : "");
        this.converter.copyNamedElement((NamedElement)pivotElement, (org.eclipse.uml2.uml.NamedElement)umlLiteral);
        return pivotElement;
    }

    public Object caseLiteralUnlimitedNatural(LiteralUnlimitedNatural umlLiteral) {
        assert (umlLiteral != null);
        ExpressionInOCL pivotElement = this.converter.refreshNamedElement(ExpressionInOCL.class, PivotPackage.Literals.EXPRESSION_IN_OCL, (org.eclipse.uml2.uml.NamedElement)umlLiteral);
        OCLExpression body = pivotElement.getOwnedBody();
        if (!(body instanceof UnlimitedNaturalLiteralExp)) {
            body = PivotFactory.eINSTANCE.createUnlimitedNaturalLiteralExp();
            pivotElement.setOwnedBody(body);
            PrimitiveType type = this.standardLibrary.getUnlimitedNaturalType();
            body.setType((Type)type);
            pivotElement.setType((Type)type);
        }
        long value = umlLiteral.getValue();
        ((UnlimitedNaturalLiteralExp)body).setUnlimitedNaturalSymbol((Number)(value >= 0L ? Long.valueOf(value) : Unlimited.INSTANCE));
        this.converter.copyNamedElement((NamedElement)pivotElement, (org.eclipse.uml2.uml.NamedElement)umlLiteral);
        return pivotElement;
    }

    public ExpressionInOCL caseOpaqueExpression(OpaqueExpression umlExpression) {
        assert (umlExpression != null);
        ExpressionInOCL pivotElement = this.converter.refreshOpaqueExpression(umlExpression);
        return pivotElement;
    }

    public Operation caseOperation(org.eclipse.uml2.uml.Operation umlOperation) {
        assert (umlOperation != null);
        Operation pivotElement = (Operation)this.converter.getCreated(Operation.class, (EObject)umlOperation);
        if (pivotElement != null) {
            ArrayList<org.eclipse.uml2.uml.Constraint> exclusions;
            this.doSwitchAll(Type.class, ClassUtil.nullFree((List)pivotElement.getRaisedExceptions()), (List<? extends EObject>)umlOperation.getRaisedExceptions());
            this.doSwitchAll(Operation.class, ClassUtil.nullFree((List)pivotElement.getRedefinedOperations()), (List<? extends EObject>)umlOperation.getRedefinedOperations());
            for (Parameter umlParameter : umlOperation.getOwnedParameters()) {
                ParameterDirectionKind direction = umlParameter.getDirection();
                if (direction != ParameterDirectionKind.RETURN_LITERAL) continue;
                this.converter.resolveMultiplicity((TypedElement)pivotElement, (org.eclipse.uml2.uml.TypedElement)umlParameter);
            }
            EList preconditions = umlOperation.getPreconditions();
            org.eclipse.uml2.uml.Constraint bodyCondition = umlOperation.getBodyCondition();
            EList postconditions = umlOperation.getPostconditions();
            this.doSwitchAll(Constraint.class, ClassUtil.nullFree((List)pivotElement.getOwnedPreconditions()), (List<? extends EObject>)preconditions);
            this.doSwitchAll(Constraint.class, ClassUtil.nullFree((List)pivotElement.getOwnedPostconditions()), (List<? extends EObject>)postconditions);
            Constraint constraint = bodyCondition != null ? (Constraint)this.doSwitch((EObject)bodyCondition) : null;
            LanguageExpression specification = null;
            if (constraint != null) {
                specification = constraint.getOwnedSpecification();
                constraint.setOwnedSpecification(null);
            }
            pivotElement.setBodyExpression(specification);
            if (preconditions.size() > 0 || bodyCondition != null || postconditions.size() > 0) {
                exclusions = new ArrayList();
                exclusions.addAll((Collection<org.eclipse.uml2.uml.Constraint>)preconditions);
                if (bodyCondition != null) {
                    exclusions.add(bodyCondition);
                }
                exclusions.addAll((Collection<org.eclipse.uml2.uml.Constraint>)postconditions);
            } else {
                exclusions = Collections.emptyList();
            }
            this.copyConstraints((Namespace)pivotElement, (org.eclipse.uml2.uml.Namespace)umlOperation, exclusions);
        }
        return pivotElement;
    }

    public Package casePackage(org.eclipse.uml2.uml.Package umlPackage) {
        assert (umlPackage != null);
        Package pivotElement = (Package)this.converter.getCreated(Package.class, (EObject)umlPackage);
        if (pivotElement != null) {
            this.doSwitchAll(Package.class, ClassUtil.nullFree((List)pivotElement.getImportedPackages()), (List<? extends EObject>)umlPackage.getImportedPackages());
            this.copyConstraints((Namespace)pivotElement, (org.eclipse.uml2.uml.Namespace)umlPackage, null);
        }
        return pivotElement;
    }

    public Property caseProperty(org.eclipse.uml2.uml.Property umlProperty) {
        assert (umlProperty != null);
        Property pivotElement = (Property)this.converter.getCreated(Property.class, (EObject)umlProperty);
        if (pivotElement != null) {
            ValueSpecification umlValue;
            org.eclipse.uml2.uml.Class umlClass;
            this.doSwitchAll(Property.class, ClassUtil.nullFree((List)pivotElement.getRedefinedProperties()), (List<? extends EObject>)umlProperty.getRedefinedProperties());
            ExpressionInOCL asExpression = null;
            String propertyName = pivotElement.getName();
            if (propertyName != null && (umlClass = umlProperty.getClass_()) != null) {
                for (org.eclipse.uml2.uml.Operation umlOperation : umlClass.getOwnedOperations()) {
                    EList constrainedElement;
                    if (!propertyName.equals(umlOperation.getName()) || umlOperation.getOwnedParameters().size() != 1) continue;
                    org.eclipse.uml2.uml.Constraint bodyCondition = umlOperation.getBodyCondition();
                    if (bodyCondition == null || (constrainedElement = bodyCondition.getConstrainedElements()).size() < 2 || constrainedElement.get(0) != umlOperation || constrainedElement.get(1) != umlProperty) break;
                    asExpression = PivotFactory.eINSTANCE.createExpressionInOCL();
                    asExpression.setBody(String.valueOf(propertyName) + "()");
                    asExpression.setIsRequired(pivotElement.isIsRequired());
                    asExpression.setType(pivotElement.getType());
                    break;
                }
            }
            if (asExpression == null && (umlValue = umlProperty.getDefaultValue()) != null) {
                Type defaultValueType;
                asExpression = (ExpressionInOCL)this.doSwitch((EObject)umlValue);
                Type requiredType = pivotElement.getType();
                Type type = defaultValueType = asExpression != null ? asExpression.getType() : null;
                if (requiredType != null && defaultValueType != null && !defaultValueType.conformsTo((StandardLibrary)this.standardLibrary, requiredType)) {
                    this.converter.error("Incompatible '" + defaultValueType + "' initializer for " + pivotElement + " when '" + requiredType + "' required");
                }
            }
            pivotElement.setOwnedExpression(asExpression);
        }
        return pivotElement;
    }

    public Region caseRegion(org.eclipse.uml2.uml.Region umlRegion) {
        assert (umlRegion != null);
        Region pivotElement = (Region)this.converter.getCreated(Region.class, (EObject)umlRegion);
        if (pivotElement != null) {
            this.copyConstraints((Namespace)pivotElement, (org.eclipse.uml2.uml.Namespace)umlRegion, null);
        }
        return pivotElement;
    }

    public Object caseSlot(Slot umlSlot) {
        assert (umlSlot != null);
        Element asElement = this.converter.getCreated(Element.class, (EObject)umlSlot);
        return asElement;
    }

    public State caseState(org.eclipse.uml2.uml.State umlState) {
        assert (umlState != null);
        State pivotElement = (State)this.converter.getCreated(State.class, (EObject)umlState);
        if (pivotElement != null) {
            this.copyConstraints((Namespace)pivotElement, (org.eclipse.uml2.uml.Namespace)umlState, null);
        }
        return pivotElement;
    }

    public Transition caseTransition(org.eclipse.uml2.uml.Transition umlTransition) {
        assert (umlTransition != null);
        Transition pivotElement = (Transition)this.converter.getCreated(Transition.class, (EObject)umlTransition);
        if (pivotElement != null) {
            org.eclipse.uml2.uml.Vertex umlSource = umlTransition.getSource();
            org.eclipse.uml2.uml.Vertex umlTarget = umlTransition.getTarget();
            Vertex pivotSource = umlSource != null ? (Vertex)this.converter.getCreated(Vertex.class, (EObject)umlSource) : null;
            Vertex pivotTarget = umlTarget != null ? (Vertex)this.converter.getCreated(Vertex.class, (EObject)umlTarget) : null;
            pivotElement.setSource(pivotSource);
            pivotElement.setTarget(pivotTarget);
            this.copyConstraints((Namespace)pivotElement, (org.eclipse.uml2.uml.Namespace)umlTransition, null);
        }
        return pivotElement;
    }

    protected void copyConstraints(@NonNull Namespace pivotElement, @NonNull org.eclipse.uml2.uml.Namespace umlNamespace, @Nullable List<org.eclipse.uml2.uml.Constraint> exclusions) {
        Object ownedRules = umlNamespace.getOwnedRules();
        if (exclusions != null && exclusions.size() > 0) {
            ownedRules = new ArrayList(ownedRules);
            ownedRules.removeAll(exclusions);
        }
        this.doSwitchAll(Constraint.class, ClassUtil.nullFree((List)pivotElement.getOwnedConstraints()), (List<? extends EObject>)ownedRules);
    }

    public Object doInPackageSwitch(EObject eObject) {
        int classifierID = eObject.eClass().getClassifierID();
        return this.doSwitch(classifierID, eObject);
    }

    public <T extends Element> void doSwitchAll(@NonNull java.lang.Class<T> pivotClass, Collection<T> pivotElements, List<? extends EObject> eObjects) {
        assert (pivotElements != null);
        assert (eObjects != null);
        for (EObject eObject : eObjects) {
            External2AS adapter;
            Resource eResource;
            if (eObject == null) continue;
            @Nullable Element pivotElement = this.converter.getCreated(pivotClass, eObject);
            if (pivotElement == null && (eResource = eObject.eResource()) != null && (adapter = UML2AS.findAdapter((Resource)eResource, (EnvironmentFactoryInternal)this.environmentFactory)) != null) {
                pivotElement = adapter.getCreated(pivotClass, eObject);
            }
            if (pivotElement == null) {
                Element doSwitchResult;
                pivotElement = doSwitchResult = (Element)this.doSwitch(eObject);
            }
            if (pivotElement != null) {
                pivotElements.add(pivotElement);
                continue;
            }
            if (this.doneWarnings == null) {
                this.doneWarnings = new HashSet<EClass>();
            }
            EClass eClass = eObject.eClass();
            String message = "No pivot representation of " + eClass.getName() + " " + LabelUtil.getLabel((Object)eObject) + " created.";
            this.converter.error(message);
            if (!this.doneWarnings.add(eClass)) continue;
            logger.warn((Object)message);
        }
    }

    private <T extends Element> void doSwitchAllOptional(@NonNull java.lang.Class<T> pivotClass, Collection<T> pivotElements, List<? extends EObject> eObjects) {
        assert (pivotElements != null);
        assert (eObjects != null);
        for (EObject eObject : eObjects) {
            External2AS adapter;
            Resource eResource;
            if (eObject == null) continue;
            @Nullable Element pivotElement = this.converter.getCreated(pivotClass, eObject);
            if (pivotElement == null && (eResource = eObject.eResource()) != null && (adapter = UML2AS.findAdapter((Resource)eResource, (EnvironmentFactoryInternal)this.environmentFactory)) != null) {
                pivotElement = adapter.getCreated(pivotClass, eObject);
            }
            if (pivotElement == null) {
                Element doSwitchResult;
                pivotElement = doSwitchResult = (Element)this.doSwitch(eObject);
            }
            if (pivotElement == null) continue;
            pivotElements.add(pivotElement);
        }
    }

    private void markRedefinitions(@NonNull Association umlAssociation) {
        AssociationClass asAssociationClass = (AssociationClass)this.converter.getCreated(AssociationClass.class, (EObject)umlAssociation);
        if (asAssociationClass != null) {
            AssociationClassProperties asAssociationClassProperties = null;
            List<@NonNull org.eclipse.uml2.uml.Property> umlMemberEnds = this.converter.getSafeMemberEnds(umlAssociation);
            ArrayList<Association> umlRedefinedAssociations = null;
            block0: for (org.eclipse.uml2.uml.Property umlMemberProperty : umlMemberEnds) {
                for (org.eclipse.uml2.uml.Property redefinedProperty : umlMemberProperty.getRedefinedProperties()) {
                    Association umlRedefinedAssociation = redefinedProperty.getAssociation();
                    if (umlRedefinedAssociation == null) continue;
                    if (umlRedefinedAssociations == null) {
                        umlRedefinedAssociations = new ArrayList<Association>();
                    }
                    if (umlRedefinedAssociations.contains(umlRedefinedAssociation)) continue block0;
                    umlRedefinedAssociations.add(umlRedefinedAssociation);
                    AssociationClass asRedefinedAssociationClass = (AssociationClass)this.converter.getCreated(AssociationClass.class, (EObject)umlRedefinedAssociation);
                    if (asRedefinedAssociationClass == null) continue block0;
                    if (asAssociationClassProperties == null) {
                        asAssociationClassProperties = this.converter.getAssociationClassProperties(asAssociationClass);
                    }
                    AssociationClassProperties asRedefinedAssociationClassProperties = this.converter.getAssociationClassProperties(asRedefinedAssociationClass);
                    if (asAssociationClassProperties == null || asRedefinedAssociationClassProperties == null) continue block0;
                    Map<@NonNull org.eclipse.uml2.uml.Property, @NonNull org.eclipse.uml2.uml.Property> umlProperty2redefinedProperty = asAssociationClassProperties.getPropertyToRedefinedPropertyMapping(asRedefinedAssociationClassProperties);
                    int i = -1;
                    while (i < umlMemberEnds.size()) {
                        org.eclipse.uml2.uml.Property umlFromProperty = i < 0 ? null : umlMemberEnds.get(i);
                        int j = -1;
                        while (j < umlMemberEnds.size()) {
                            if (j != i) {
                                org.eclipse.uml2.uml.Property umlToProperty = j < 0 ? null : umlMemberEnds.get(j);
                                Property asAssociationClassProperty = asAssociationClassProperties.get(umlFromProperty, umlToProperty);
                                org.eclipse.uml2.uml.Property umlFromRedefinedProperty = umlFromProperty != null ? umlProperty2redefinedProperty.get(umlFromProperty) : null;
                                org.eclipse.uml2.uml.Property umlToRedefinedProperty = umlToProperty != null ? umlProperty2redefinedProperty.get(umlToProperty) : null;
                                Property asRedefinedAssociationClassProperty = asRedefinedAssociationClassProperties.get(umlFromRedefinedProperty, umlToRedefinedProperty);
                                assert (asAssociationClassProperty != asRedefinedAssociationClassProperty);
                                asAssociationClassProperty.getRedefinedProperties().add(asRedefinedAssociationClassProperty);
                            }
                            ++j;
                        }
                        ++i;
                    }
                    continue block0;
                }
            }
        }
    }

    @Deprecated
    public @Nullable org.eclipse.uml2.uml.Property getOtherEnd(@NonNull List<org.eclipse.uml2.uml.Property> umlMemberEnds, @NonNull org.eclipse.uml2.uml.Property umlProperty) {
        for (org.eclipse.uml2.uml.Property umlMemberEnd : umlMemberEnds) {
            if (umlMemberEnd == umlProperty) continue;
            return umlMemberEnd;
        }
        return null;
    }
}

