/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.emf.facet.util.ui.internal.exported.util.tree.item;

import java.util.Map;
import org.eclipse.papyrus.emf.facet.util.ui.internal.Messages;
import org.eclipse.papyrus.emf.facet.util.ui.internal.exported.dialog.IDialog;
import org.eclipse.papyrus.emf.facet.util.ui.internal.exported.util.tree.menu.AbstractTreeMenuItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTreeItem<T> {
    private AbstractTreeMenuItem<T> menuItem;
    private TreeItem treeItem;
    private Map<String, Object> extraProperties;

    public TreeItem createItem(AbstractTreeMenuItem<T> itemMenu, Tree parent) {
        this.menuItem = itemMenu;
        TreeItem item = new TreeItem(parent, 0);
        this.initialize(item);
        return item;
    }

    public TreeItem createItem(AbstractTreeMenuItem<T> itemMenu, TreeItem parent) {
        this.menuItem = itemMenu;
        TreeItem item = new TreeItem(parent, 0);
        parent.setExpanded(true);
        this.initialize(item);
        return item;
    }

    private void initialize(TreeItem item) {
        item.setChecked(true);
        if (this.getItemText() == null || "".equals(this.getItemText())) {
            item.setText(AbstractTreeItem.getDefaultItemText());
        } else {
            item.setText(this.getItemText());
        }
        this.fireChanged();
        this.setTreeItem(item);
    }

    public static String getDefaultItemText() {
        return Messages.item_todo;
    }

    public abstract String getItemText();

    public abstract T onItemCreation();

    public abstract IDialog onItemMouseSelection();

    public abstract Object returnValue();

    public void removeItem() {
        TreeItem[] treeItemArray = this.getChildren();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            this.findTreeItemExtended(item).removeItem();
            ++n2;
        }
        this.getTreeItem().dispose();
        this.fireChanged();
    }

    public TreeItem[] getChildren() {
        return this.getTreeItem().getItems();
    }

    public AbstractTreeItem<T> getParent() {
        return this.findTreeItemExtended(this.getTreeItem().getParentItem());
    }

    public void setTreeItemText(String newText) {
        this.getTreeItem().setText(newText);
    }

    protected void fireChanged() {
        this.getMenuItem().fireChanged();
    }

    public TreeItem getTreeItem() {
        return this.treeItem;
    }

    private void setTreeItem(TreeItem treeItem) {
        this.treeItem = treeItem;
    }

    public AbstractTreeMenuItem<T> getMenuItem() {
        return this.menuItem;
    }

    public AbstractTreeItem<T> findTreeItemExtended(TreeItem item) {
        return this.getMenuItem().findTreeItemExtended(item);
    }

    public Map<String, Object> getExtraProperties() {
        return this.extraProperties;
    }

    public void setExtraProperties(Map<String, Object> extraProperties) {
        this.extraProperties = extraProperties;
    }
}

