/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.assistant.internal.core.util;

import com.google.common.base.Objects;
import java.net.URL;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.gmf.runtime.emf.type.core.SpecializationType;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.infra.gmfdiag.assistant.core.util.IProxyElementType;

public class ProxyElementType
extends SpecializationType
implements IProxyElementType {
    private final IElementType semanticType;
    private final IHintedType visualType;

    private ProxyElementType(IElementType semanticType, IHintedType visualType, String name) {
        super(semanticType.getId(), semanticType.getIconURL(), name, new IElementType[]{visualType, semanticType}, null, null, null);
        this.semanticType = semanticType;
        this.visualType = visualType;
    }

    public static ProxyElementType create(IElementType semanticType, IHintedType visualType, boolean distinguishVisualType) {
        String name = semanticType.getDisplayName();
        if (distinguishVisualType) {
            name = NLS.bind((String)"{0} ({1})", (Object)name, (Object)visualType.getDisplayName());
        }
        return new ProxyElementType(semanticType, visualType, name);
    }

    public String getSemanticHint() {
        return this.visualType.getSemanticHint();
    }

    public URL getIconURL() {
        URL result = super.getIconURL();
        if (result == null && (result = this.visualType.getIconURL()) == null) {
            IElementType[] allSupertypes = this.getAllSuperTypes();
            int i = allSupertypes.length - 1;
            while (result == null && i >= 0) {
                result = allSupertypes[i].getIconURL();
                --i;
            }
        }
        return result;
    }

    @Override
    public IElementType resolveSemanticType() {
        return this.semanticType;
    }

    @Override
    public IHintedType resolveVisualType() {
        return this.visualType;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getId(), this.getSemanticHint()});
    }

    public boolean equals(Object obj) {
        boolean result = obj instanceof ProxyElementType;
        if (result) {
            ProxyElementType other = (ProxyElementType)obj;
            result = Objects.equal((Object)other.getId(), (Object)this.getId()) && Objects.equal((Object)other.getSemanticHint(), (Object)this.getSemanticHint());
        }
        return result;
    }
}

