/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.oshi;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.eclipse.passage.lic.api.LicensingReporter;
import org.eclipse.passage.lic.api.LicensingResult;
import org.eclipse.passage.lic.api.inspector.HardwareInspector;
import org.eclipse.passage.lic.base.LicensingResults;
import org.eclipse.passage.lic.base.SystemReporter;
import org.eclipse.passage.lic.internal.oshi.i18n.OshiMessages;
import org.eclipse.passage.lic.oshi.OshiHal;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import oshi.SystemInfo;
import oshi.hardware.Baseboard;
import oshi.hardware.CentralProcessor;
import oshi.hardware.ComputerSystem;
import oshi.hardware.Firmware;
import oshi.hardware.HWDiskStore;
import oshi.hardware.HardwareAbstractionLayer;
import oshi.software.os.OperatingSystem;
import oshi.software.os.OperatingSystemVersion;

@Component
public class OshiHardwareInspector
implements HardwareInspector {
    private final Map<String, String> hardware = new LinkedHashMap<String, String>();
    private final List<HWDiskStore> discs = new ArrayList<HWDiskStore>();
    private LicensingReporter licensingReporter = SystemReporter.INSTANCE;

    private Map<String, Object> inspect() {
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
        try {
            SystemInfo systemInfo = new SystemInfo();
            OperatingSystem os = systemInfo.getOperatingSystem();
            properties.put("os.manufacturer", os.getManufacturer());
            properties.put("os.family", os.getFamily());
            OperatingSystemVersion version = os.getVersion();
            properties.put("os.version", version.getVersion());
            properties.put("os.buildnumber", version.getBuildNumber());
            HardwareAbstractionLayer hal = systemInfo.getHardware();
            ComputerSystem computerSystem = hal.getComputerSystem();
            properties.put("system.manufacturer", computerSystem.getManufacturer());
            properties.put("system.model", computerSystem.getModel());
            properties.put("system.serialnumber", computerSystem.getSerialNumber());
            Baseboard baseboard = computerSystem.getBaseboard();
            properties.put("baseboard.manufacturer", baseboard.getManufacturer());
            properties.put("baseboard.model", baseboard.getModel());
            properties.put("baseboard.version", baseboard.getVersion());
            properties.put("baseboard.serialnumber", baseboard.getSerialNumber());
            Firmware firmware = computerSystem.getFirmware();
            properties.put("firmware.manufacturer", firmware.getManufacturer());
            properties.put("firmware.version", firmware.getVersion());
            properties.put("firmware.releasedate", firmware.getReleaseDate());
            properties.put("firmware.name", firmware.getName());
            properties.put("firmware.description", firmware.getDescription());
            CentralProcessor processor = hal.getProcessor();
            properties.put("cpu.vendor", processor.getVendor());
            properties.put("cpu.family", processor.getFamily());
            properties.put("cpu.model", processor.getModel());
            properties.put("cpu.name", processor.getName());
            properties.put("cpu.identifier", processor.getIdentifier());
            properties.put("cpu.processorid", processor.getProcessorID());
            HWDiskStore[] diskStores = hal.getDiskStores();
            properties.put(HWDiskStore[].class.getName(), diskStores);
            HWDiskStore[] hWDiskStoreArray = diskStores;
            if (diskStores.length != 0) {
                HWDiskStore hwDiskStore = hWDiskStoreArray[0];
                properties.put("hwdisk.model", hwDiskStore.getModel());
                properties.put("hwdisk.name", hwDiskStore.getName());
                properties.put("hwdisk.serial", hwDiskStore.getSerial());
            }
        }
        catch (Exception | NoClassDefFoundError | UnsatisfiedLinkError e) {
            String source = this.getClass().getName();
            LicensingResult result = LicensingResults.createError((String)OshiMessages.OshiHardwareInspector_e_reading_hw, (String)source, (Throwable)e);
            this.licensingReporter.logResult(result);
        }
        return properties;
    }

    @Reference
    public void bindLicensingReporter(LicensingReporter reporter) {
        this.licensingReporter = reporter;
    }

    public void unbindLicensingReporter(LicensingReporter reporter) {
        if (this.licensingReporter == reporter) {
            this.licensingReporter = SystemReporter.INSTANCE;
        }
    }

    public void dumpHardwareInfo(OutputStream output) throws IOException {
        OshiHal.dumpHardwareInfo(output, this.hardware());
    }

    public String inspectProperty(String name) {
        return this.hardware().get(name);
    }

    public Iterable<String> getKnownProperties() {
        return this.hardware().keySet();
    }

    private synchronized Map<String, String> hardware() {
        if (this.hardware.isEmpty()) {
            try {
                CompletableFuture.supplyAsync(this::inspect).get().entrySet().stream().forEach(this::fill);
            }
            catch (InterruptedException | ExecutionException e) {
                this.licensingReporter.logResult(LicensingResults.createError((String)OshiMessages.OshiHardwareInspector_e_reading_hw, (String)this.getClass().getName(), (Throwable)e));
            }
        }
        return new LinkedHashMap<String, String>(this.hardware);
    }

    private void fill(Map.Entry<String, Object> entry) {
        Object value = entry.getValue();
        if (value instanceof String) {
            this.hardware.put(entry.getKey(), (String)String.class.cast(value));
        } else if (value instanceof HWDiskStore[]) {
            this.discs.addAll(Arrays.asList((HWDiskStore[])HWDiskStore[].class.cast(value)));
        }
    }

    List<HWDiskStore> disks() {
        this.hardware();
        return new ArrayList<HWDiskStore>(this.discs);
    }
}

