/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.ui.search;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.photran.internal.ui.search.Messages;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.text.AbstractTextSearchResult;

public abstract class SearchQuery<T extends AbstractTextSearchResult>
implements ISearchQuery {
    protected List<IResource> scope;
    protected String scopeDesc;
    protected String patternDescription;
    protected String patternRegex;
    protected int searchFlags;
    protected T result;

    public SearchQuery(List<IResource> scope, String scopeDesc, String patternDescription, String patternRegex, int flags) {
        this.scope = scope;
        this.scopeDesc = scopeDesc;
        this.patternDescription = patternDescription;
        this.patternRegex = patternRegex;
        this.searchFlags = flags;
        this.result = this.createInitialSearchResult();
    }

    protected abstract T createInitialSearchResult();

    public String getLabel() {
        String description = "'" + this.patternDescription + "' - ";
        int count = this.result.getMatchCount();
        if (count == 1) {
            return String.valueOf(description) + Messages.bind((String)Messages.SearchQuery_OneMatch, (Object)this.scopeDesc);
        }
        return String.valueOf(description) + Messages.bind((String)Messages.SearchQuery_nMatches, (Object)count, (Object)this.scopeDesc);
    }

    public boolean canRerun() {
        return true;
    }

    public boolean canRunInBackground() {
        return true;
    }

    public T getSearchResult() {
        return this.result;
    }

    public final IStatus run(IProgressMonitor monitor) {
        try {
            this.prepareToSearch((IProgressMonitor)new SubProgressMonitor(monitor, 0));
            this.result.removeAll();
            this.runSearch(monitor);
            this.finishSearch();
        }
        catch (CoreException e) {
            return e.getStatus();
        }
        return Status.OK_STATUS;
    }

    protected void prepareToSearch(IProgressMonitor monitor) {
    }

    protected void runSearch(IProgressMonitor monitor) throws CoreException {
        int numResources = this.countResources();
        int numPasses = this.numPasses();
        monitor.beginTask(Messages.bind((String)Messages.SearchQuery_SearchingFor, (Object)this.patternDescription, (Object)this.scopeDesc), numResources * numPasses);
        SearchResourceVisitor visitor = new SearchResourceVisitor(monitor);
        for (IResource resource : this.scope) {
            resource.accept((IResourceVisitor)visitor);
        }
        int i = 1;
        while (i < numPasses) {
            this.runAdditionalSearchPass(i + 1, (IProgressMonitor)new SubProgressMonitor(monitor, numResources));
            ++i;
        }
        monitor.done();
    }

    private int countResources() throws CoreException {
        int[] counter = new int[1];
        CountResourceVisitor countVisitor = new CountResourceVisitor(counter);
        for (IResource resource : this.scope) {
            resource.accept((IResourceVisitor)countVisitor);
        }
        int numResources = counter[0];
        return numResources;
    }

    protected int numPasses() {
        return 1;
    }

    protected void runAdditionalSearchPass(int passNum, IProgressMonitor monitor) throws CoreException {
    }

    protected abstract boolean shouldProcess(IResource var1);

    protected abstract void search(IFile var1);

    protected void finishSearch() {
    }

    private class CountResourceVisitor
    implements IResourceVisitor {
        private int[] counter;

        public CountResourceVisitor(int[] counter) {
            this.counter = counter;
        }

        public boolean visit(IResource resource) {
            if (!SearchQuery.this.shouldProcess(resource)) {
                return false;
            }
            this.counter[0] = this.counter[0] + 1;
            return !(resource instanceof IFile);
        }
    }

    private class SearchResourceVisitor
    implements IResourceVisitor {
        private IProgressMonitor monitor;

        public SearchResourceVisitor(IProgressMonitor monitor) {
            this.monitor = monitor;
        }

        public boolean visit(IResource resource) {
            if (!SearchQuery.this.shouldProcess(resource)) {
                return false;
            }
            this.monitor.worked(1);
            if (resource instanceof IFile) {
                this.monitor.subTask(Messages.bind((String)Messages.SearchQuery_Searching, (Object)resource.getName()));
                SearchQuery.this.search((IFile)resource);
                return false;
            }
            return true;
        }
    }
}

