/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.actions;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.jface.action.ContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.php.internal.ui.editor.PHPStructuredEditor;
import org.eclipse.php.internal.ui.text.PHPWordFinder;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.QuickMenuCreator;
import org.eclipse.ui.menus.IMenuService;

public class PHPQuickMenuCreator
extends QuickMenuCreator {
    protected String id;
    protected PHPStructuredEditor editor;

    public PHPQuickMenuCreator(String id) {
        this.id = id;
    }

    public void setEditor(PHPStructuredEditor editor) {
        this.editor = editor;
    }

    protected Point computeMenuLocation(StyledText text) {
        if (this.editor == null || text != this.editor.getViewer().getTextWidget()) {
            return super.computeMenuLocation(text);
        }
        return this.computeWordStart();
    }

    protected void fillMenu(IMenuManager menu) {
        if (this.id != null && menu instanceof ContributionManager) {
            ((IMenuService)PlatformUI.getWorkbench().getService(IMenuService.class)).populateContributionManager((ContributionManager)menu, "popup:" + this.id);
        }
    }

    private Point computeWordStart() {
        ITextSelection selection = (ITextSelection)this.editor.getSelectionProvider().getSelection();
        IRegion textRegion = PHPWordFinder.findWord(this.editor.getViewer().getDocument(), selection.getOffset());
        if (textRegion == null) {
            return null;
        }
        IRegion widgetRegion = this.modelRange2WidgetRange(textRegion);
        if (widgetRegion == null) {
            return null;
        }
        int start = widgetRegion.getOffset();
        StyledText styledText = this.editor.getViewer().getTextWidget();
        Point result = styledText.getLocationAtOffset(start);
        result.y += styledText.getLineHeight(start);
        if (!styledText.getClientArea().contains(result)) {
            return null;
        }
        return result;
    }

    private IRegion modelRange2WidgetRange(IRegion region) {
        ISourceViewer viewer = this.editor.getViewer();
        if (viewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 extension = (ITextViewerExtension5)viewer;
            return extension.modelRange2WidgetRange(region);
        }
        IRegion visibleRegion = viewer.getVisibleRegion();
        int start = region.getOffset() - visibleRegion.getOffset();
        int end = start + region.getLength();
        if (end > visibleRegion.getLength()) {
            end = visibleRegion.getLength();
        }
        return new Region(start, end - start);
    }

    public IHandler createHandler() {
        return new AbstractHandler(){

            public Object execute(ExecutionEvent event) throws ExecutionException {
                PHPQuickMenuCreator.this.createMenu();
                return null;
            }
        };
    }
}

