/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.ui.actions;

import java.util.BitSet;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.ptp.internal.ui.ParallelImages;
import org.eclipse.ptp.internal.ui.actions.GotoAction;
import org.eclipse.ptp.internal.ui.actions.GotoDropDownAction;
import org.eclipse.ptp.internal.ui.messages.Messages;
import org.eclipse.ptp.internal.ui.model.IElementHandler;
import org.eclipse.ptp.internal.ui.model.IElementSet;
import org.eclipse.ptp.internal.ui.views.AbstractParallelElementView;

public class ChangeSetAction
extends GotoDropDownAction {
    public static final String name = Messages.ChangeSetAction_0;

    public ChangeSetAction(AbstractParallelElementView view) {
        super(name, view);
        this.setImageDescriptor(ParallelImages.ID_ICON_CHANGESET_NORMAL);
    }

    @Override
    protected void createDropDownMenu(MenuManager dropDownMenuMgr) {
        String curID = this.view.getCurrentSetID();
        if (curID == null || curID.length() == 0) {
            return;
        }
        this.addAction(dropDownMenuMgr, "Root", "Root", curID, null);
        IElementHandler setManager = this.view.getCurrentElementHandler();
        if (setManager == null) {
            return;
        }
        IElementSet[] sets = setManager.getSets();
        if (sets.length > 1) {
            dropDownMenuMgr.add((IContributionItem)new Separator());
        }
        IElementSet[] iElementSetArray = sets;
        int n = sets.length;
        int n2 = 0;
        while (n2 < n) {
            IElementSet set = iElementSetArray[n2];
            if (set instanceof IElementSet && !set.getID().equals("Root")) {
                this.addAction(dropDownMenuMgr, set.getID(), set.getID(), curID, null);
            }
            ++n2;
        }
    }

    @Override
    protected void addAction(MenuManager dropDownMenuMgr, String e_name, String id, String curID, Object data) {
        InternalSetAction action = new InternalSetAction(e_name, id, this.view, this);
        action.setChecked(curID.equals(id));
        action.setEnabled(true);
        dropDownMenuMgr.add((IAction)action);
    }

    @Override
    public void run(BitSet elements) {
    }

    @Override
    public void run() {
        IElementHandler setManager = this.view.getCurrentElementHandler();
        if (setManager == null) {
            return;
        }
        IElementSet[] sets = setManager.getSets();
        int i = 0;
        while (i < sets.length) {
            if (this.view.getCurrentSetID().equals(sets[i].getID())) {
                if (i + 1 < sets.length) {
                    this.run(sets[i + 1]);
                    break;
                }
                this.run(sets[0]);
                break;
            }
            ++i;
        }
    }

    private void run(IElementSet set) {
        this.view.selectSet(set);
        this.view.refresh(false);
    }

    @Override
    public void run(BitSet elements, String id, Object data) {
        IElementHandler setManager = this.view.getCurrentElementHandler();
        if (setManager == null) {
            return;
        }
        this.run(setManager.getSet(id));
    }

    private class InternalSetAction
    extends GotoAction {
        public InternalSetAction(String name, String id, AbstractParallelElementView view, GotoDropDownAction action) {
            super(name, id, view, action, null);
        }
    }
}

