/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvts2qvti;

import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.qvtd.compiler.internal.qvts2qvti.BasicPartition2Mapping;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.checks.CastEdgeCheckedCondition;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.checks.CastInitializerCheckedCondition;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.checks.CheckedCondition;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.checks.CheckedConditionVisitor;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.checks.ConstantTargetCheckedCondition;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.checks.MultipleEdgeCheckedCondition;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.checks.NavigableEdgeCheckedCondition;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.checks.NonNullInitializerCheckedCondition;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.checks.PredicateEdgeCheckedCondition;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.checks.SpeculationCheckedCondition;
import org.eclipse.qvtd.pivot.qvtschedule.Edge;
import org.eclipse.qvtd.pivot.qvtschedule.Node;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleUtil;

public class CheckedConditionWeightComparator
implements CheckedConditionVisitor<Integer>,
Comparator<CheckedCondition> {
    protected final @NonNull BasicPartition2Mapping region2mapping;
    private final @NonNull Map<@NonNull CheckedCondition, @NonNull Integer> condition2weight = new HashMap<CheckedCondition, Integer>();

    public CheckedConditionWeightComparator(@NonNull BasicPartition2Mapping region2mapping) {
        this.region2mapping = region2mapping;
    }

    protected void accumulateNode(@NonNull Set<@NonNull Node> requiredNodes, @NonNull Node node) {
        requiredNodes.addAll(this.region2mapping.getPrecedingNodes(node));
    }

    protected void accumulateNodes(@NonNull Set<@NonNull Node> requiredNodes, @NonNull Edge edge) {
        this.accumulateNode(requiredNodes, QVTscheduleUtil.getSourceNode((Edge)edge));
        this.accumulateNode(requiredNodes, QVTscheduleUtil.getTargetNode((Edge)edge));
    }

    @Override
    public int compare(@NonNull CheckedCondition o1, @NonNull CheckedCondition o2) {
        int w2;
        int w1 = this.getWeight(o1);
        int diff = w1 - (w2 = this.getWeight(o2));
        if (diff != 0) {
            return diff;
        }
        return o1.compareTo(o2);
    }

    private int getWeight(@NonNull CheckedCondition checkedCondition) {
        Integer weight = this.condition2weight.get(checkedCondition);
        if (weight == null) {
            weight = checkedCondition.accept(this);
            this.condition2weight.put(checkedCondition, weight);
        }
        return weight;
    }

    @Override
    public @NonNull Integer visitCastEdgeCheckedCondition(@NonNull CastEdgeCheckedCondition castEdgeCheckedCondition) {
        HashSet<@NonNull Node> requiredNodes = new HashSet<Node>();
        this.accumulateNodes(requiredNodes, (Edge)castEdgeCheckedCondition.getCastEdge());
        return requiredNodes.size();
    }

    @Override
    public @NonNull Integer visitCastInitializerCheckedCondition(@NonNull CastInitializerCheckedCondition castInitializerCheckedCondition) {
        HashSet<@NonNull Node> requiredNodes = new HashSet<Node>();
        this.accumulateNode(requiredNodes, (Node)castInitializerCheckedCondition.getOperationNode());
        return requiredNodes.size();
    }

    @Override
    public @NonNull Integer visitConstantTargetCheckedCondition(@NonNull ConstantTargetCheckedCondition constantTargetCheckedCondition) {
        HashSet<@NonNull Node> requiredNodes = new HashSet<Node>();
        requiredNodes.addAll(this.region2mapping.getPrecedingNodes(QVTscheduleUtil.getSourceNode((Edge)constantTargetCheckedCondition.getNavigationEdge())));
        return requiredNodes.size();
    }

    @Override
    public @NonNull Integer visitMultipleEdgeCheckedCondition(@NonNull MultipleEdgeCheckedCondition multipleEdgeCheckedCondition) {
        HashSet<@NonNull Node> requiredNodes = new HashSet<Node>();
        for (Edge edge : multipleEdgeCheckedCondition.getEdges()) {
            this.accumulateNodes(requiredNodes, edge);
        }
        return requiredNodes.size();
    }

    @Override
    public @NonNull Integer visitNavigableEdgeCheckedCondition(@NonNull NavigableEdgeCheckedCondition navigableEdgeCheckedCondition) {
        HashSet<@NonNull Node> requiredNodes = new HashSet<Node>();
        this.accumulateNodes(requiredNodes, navigableEdgeCheckedCondition.getNavigableEdge());
        return requiredNodes.size();
    }

    @Override
    public @NonNull Integer visitNonNullInitializerCheckedCondition(@NonNull NonNullInitializerCheckedCondition nonNullInitializerCheckedCondition) {
        HashSet<@NonNull Node> requiredNodes = new HashSet<Node>();
        this.accumulateNode(requiredNodes, (Node)nonNullInitializerCheckedCondition.getOperationNode());
        return requiredNodes.size();
    }

    @Override
    public @NonNull Integer visitPredicateEdgeCheckedCondition(@NonNull PredicateEdgeCheckedCondition predicateEdgeCheckedCondition) {
        HashSet<@NonNull Node> requiredNodes = new HashSet<Node>();
        this.accumulateNodes(requiredNodes, (Edge)predicateEdgeCheckedCondition.getPredicateEdge());
        return requiredNodes.size();
    }

    @Override
    public @NonNull Integer visitSpeculationCheckedCondition(@NonNull SpeculationCheckedCondition speculationCheckedCondition) {
        return 0;
    }
}

