/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvtu2qvtm;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.CompleteClass;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.NamedElement;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.VariableDeclaration;
import org.eclipse.ocl.pivot.VariableExp;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.qvtd.compiler.internal.common.AbstractQVTc2QVTc;
import org.eclipse.qvtd.pivot.qvtbase.Domain;
import org.eclipse.qvtd.pivot.qvtbase.Pattern;
import org.eclipse.qvtd.pivot.qvtbase.Predicate;
import org.eclipse.qvtd.pivot.qvtbase.QVTbaseFactory;
import org.eclipse.qvtd.pivot.qvtbase.Rule;
import org.eclipse.qvtd.pivot.qvtbase.Transformation;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtbase.utilities.QVTbaseUtil;
import org.eclipse.qvtd.pivot.qvtcore.Area;
import org.eclipse.qvtd.pivot.qvtcore.Assignment;
import org.eclipse.qvtd.pivot.qvtcore.BottomPattern;
import org.eclipse.qvtd.pivot.qvtcore.CoreDomain;
import org.eclipse.qvtd.pivot.qvtcore.CoreModel;
import org.eclipse.qvtd.pivot.qvtcore.CorePattern;
import org.eclipse.qvtd.pivot.qvtcore.GuardPattern;
import org.eclipse.qvtd.pivot.qvtcore.Mapping;
import org.eclipse.qvtd.pivot.qvtcore.NavigationAssignment;
import org.eclipse.qvtd.pivot.qvtcore.QVTcoreFactory;
import org.eclipse.qvtd.pivot.qvtcore.RealizedVariable;
import org.eclipse.qvtd.pivot.qvtcore.VariableAssignment;
import org.eclipse.qvtd.pivot.qvtcore.utilities.QVTcoreUtil;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.SymbolNameBuilder;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.SymbolNameReservation;

public class QVTu2QVTm
extends AbstractQVTc2QVTc {
    private final @NonNull Map<@NonNull Element, @NonNull Updater> element2updater = new HashMap<Element, Updater>();
    private final @NonNull SymbolNameReservation symbolNameReservation = new SymbolNameReservation();

    private static boolean isFoldable(@NonNull Mapping mapping) {
        if (mapping.getContext() == null) {
            return false;
        }
        assert (mapping.getSpecification().isEmpty()) : " Local mappings cannot be a refinement.";
        GuardPattern guardPattern = mapping.getGuardPattern();
        if (guardPattern.getOwnedVariables().size() > 0) {
            return false;
        }
        if (guardPattern.getPredicate().size() > 0) {
            return false;
        }
        for (Domain d : mapping.getDomain()) {
            CoreDomain cd = (CoreDomain)d;
            guardPattern = cd.getGuardPattern();
            if (guardPattern.getOwnedVariables().size() > 0) {
                return false;
            }
            if (guardPattern.getPredicate().size() <= 0) continue;
            return false;
        }
        return true;
    }

    public QVTu2QVTm(@NonNull EnvironmentFactory environmentFactory) {
        super(environmentFactory);
    }

    public void addUpdater(@NonNull Element mElement, @NonNull Updater updater) {
        Updater oldUpdater = this.element2updater.put(mElement, updater);
        assert (oldUpdater == null);
    }

    protected @NonNull CreateVisitor createCreateVisitor() {
        return new CreateVisitor(this);
    }

    protected @NonNull UpdateVisitor createUpdateVisitor() {
        return new UpdateVisitor(this);
    }

    public @NonNull String getMappingName(@NonNull Mapping uMapping) {
        SymbolNameBuilder s = new SymbolNameBuilder();
        String name = uMapping.getName();
        if (name != null) {
            s.appendName(name);
        } else {
            Mapping uNamedMapping = uMapping;
            while (uNamedMapping.getContext() != null) {
                uNamedMapping = uNamedMapping.getContext();
            }
            s.appendString(PivotUtil.getName((NamedElement)uNamedMapping));
            ArrayList<@NonNull String> guardVariableNames = new ArrayList<String>();
            for (VariableDeclaration guardVariable : ClassUtil.nullFree((EList)uMapping.getGuardPattern().getOwnedVariables())) {
                guardVariableNames.add(PivotUtil.getName((NamedElement)guardVariable));
            }
            for (Domain uDomain : ClassUtil.nullFree((EList)uMapping.getDomain())) {
                for (VariableDeclaration guardVariable : ClassUtil.nullFree((EList)((CoreDomain)uDomain).getGuardPattern().getOwnedVariables())) {
                    guardVariableNames.add(PivotUtil.getName((NamedElement)guardVariable));
                }
            }
            Collections.sort(guardVariableNames);
            for (String guardVariableName : guardVariableNames) {
                s.appendString("_");
                s.appendString(guardVariableName);
            }
        }
        return this.symbolNameReservation.reserveSymbolName(s, (Object)uMapping);
    }

    public @Nullable Updater getUpdater(@NonNull Element mElement) {
        return this.element2updater.get(mElement);
    }

    private boolean hasVariables(Area a) {
        return !a.getGuardPattern().getOwnedVariables().isEmpty() && !a.getBottomPattern().getOwnedVariables().isEmpty() && !a.getBottomPattern().getRealizedVariable().isEmpty();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private boolean isRequired(@NonNull Mapping m) {
        @NonNull EList refinements = ClassUtil.nullFree((EList)m.getRefinement());
        if (refinements.isEmpty()) {
            return true;
        }
        for (Mapping refining : refinements) {
            for (Domain rd : refining.getDomain()) {
                if (!this.hasVariables((Area)rd)) continue;
                return true;
            }
            if (!this.hasVariables((Area)m)) continue;
            return true;
        }
        return false;
    }

    protected static class CreateVisitor
    extends AbstractQVTc2QVTc.AbstractCreateVisitor<QVTu2QVTm> {
        public CreateVisitor(@NonNull QVTu2QVTm context) {
            super(context);
        }

        public @NonNull QVTu2QVTm getContext() {
            return (QVTu2QVTm)((Object)this.context);
        }

        @Override
        protected void doRules(@NonNull Transformation tIn, @NonNull Transformation tOut) {
            ArrayList<@NonNull Mapping> requiredMappings = new ArrayList<Mapping>();
            for (Rule rule : ClassUtil.nullFree((EList)tIn.getRule())) {
                if (!(rule instanceof Mapping)) continue;
                requiredMappings.add((Mapping)rule);
                this.gatherRequiredMappings((Mapping)rule, requiredMappings);
            }
            this.createAll(requiredMappings, tOut.getRule());
        }

        private void gatherRequiredMappings(@NonNull Mapping mapping, @NonNull List<@NonNull Mapping> requiredMappings) {
            for (Mapping localMapping : ClassUtil.nullFree((EList)mapping.getLocal())) {
                if (!QVTu2QVTm.isFoldable(localMapping)) {
                    requiredMappings.add(localMapping);
                }
                this.gatherRequiredMappings(localMapping, requiredMappings);
            }
        }

        @Override
        public @NonNull CoreModel visitCoreModel(@NonNull CoreModel mIn) {
            CoreModel mOut = super.visitCoreModel(mIn);
            mOut.setExternalURI(mIn.getExternalURI().replace(".qvtu.qvtcas", ".qvtm.qvtcas"));
            return mOut;
        }

        public @Nullable Mapping visitMapping(@NonNull Mapping mIn) {
            assert (!QVTu2QVTm.isFoldable(mIn));
            if (!((QVTu2QVTm)((Object)this.context)).isRequired(mIn)) {
                return null;
            }
            Mapping mMapping = QVTcoreFactory.eINSTANCE.createMapping();
            ((QVTu2QVTm)((Object)this.context)).addTrace((Element)mIn, (Element)mMapping);
            mMapping.setIsAbstract(mIn.isIsAbstract());
            ((QVTu2QVTm)((Object)this.context)).pushScope((NamedElement)mMapping);
            try {
                MergedMapping mergedMapping = new MergedMapping(this, mIn);
                if (!mergedMapping.analyze()) {
                    return null;
                }
                mergedMapping.synthesize(mMapping);
                Mapping mapping = mMapping;
                return mapping;
            }
            finally {
                ((QVTu2QVTm)((Object)this.context)).popScope();
            }
        }

        @Override
        public @NonNull TypedModel visitTypedModel(@NonNull TypedModel tmIn) {
            TypedModel tmOut = super.visitTypedModel(tmIn);
            if (tmOut.getName() == null) {
                tmOut.setName("middle");
            }
            return tmOut;
        }
    }

    protected static abstract class MergedArea {
        private static final boolean ASSIGNMENT = true;
        private static final boolean PREDICATE = false;
        protected final @NonNull CreateVisitor createVisitor;
        private final @NonNull List<@NonNull Predicate> guardPredicates = new ArrayList<Predicate>();
        private final @NonNull List<@NonNull Predicate> bottomPredicates = new ArrayList<Predicate>();
        private @Nullable LinkedHashMap<@NonNull String, @NonNull MergedVariable> variableName2mergedVariables = null;
        private @Nullable LinkedHashMap<@NonNull String, @NonNull List<@NonNull NavigationAssignment>> variableName_property2navigationAssignments = null;
        private @Nullable List<@NonNull NavigationAssignment> navigationAssignmentsAsPredicates = null;

        protected MergedArea(@NonNull CreateVisitor createVisitor) {
            this.createVisitor = createVisitor;
        }

        protected boolean analyze() {
            Area thisArea = this.getArea(this.getMapping());
            if (thisArea != null) {
                GuardPattern guardPattern = QVTcoreUtil.getGuardPattern((Area)thisArea);
                Iterables.addAll(this.guardPredicates, (Iterable)QVTbaseUtil.getOwnedPredicates((Pattern)guardPattern));
                this.gatherVariables(QVTcoreUtil.getOwnedVariables((CorePattern)guardPattern), true);
                BottomPattern thisBottomPattern = QVTcoreUtil.getBottomPattern((Area)thisArea);
                this.gatherVariables(QVTcoreUtil.getOwnedVariables((CorePattern)thisBottomPattern), false);
                this.gatherAssignments(QVTcoreUtil.getOwnedAssignments((BottomPattern)thisBottomPattern), true);
                Iterables.addAll(this.bottomPredicates, (Iterable)QVTbaseUtil.getOwnedPredicates((Pattern)thisBottomPattern));
                this.gatherVariables(QVTcoreUtil.getOwnedRealizedVariables((BottomPattern)thisBottomPattern), false);
            }
            for (Area area : this.getChildAreas()) {
                GuardPattern childGuardPattern = QVTcoreUtil.getGuardPattern((Area)area);
                Iterables.addAll(this.guardPredicates, (Iterable)QVTbaseUtil.getOwnedPredicates((Pattern)childGuardPattern));
                this.gatherVariables(QVTcoreUtil.getOwnedVariables((CorePattern)childGuardPattern), true);
                BottomPattern childBottomPattern = QVTcoreUtil.getBottomPattern((Area)area);
                this.gatherVariables(QVTcoreUtil.getOwnedVariables((CorePattern)childBottomPattern), false);
                this.gatherAssignments(QVTcoreUtil.getOwnedAssignments((BottomPattern)childBottomPattern), true);
                Iterables.addAll(this.bottomPredicates, (Iterable)QVTbaseUtil.getOwnedPredicates((Pattern)childBottomPattern));
                this.gatherVariables(QVTcoreUtil.getOwnedRealizedVariables((BottomPattern)childBottomPattern), false);
            }
            for (Area area : this.getParentAreas()) {
                assert (area != thisArea);
                GuardPattern parentGuardPattern = QVTcoreUtil.getGuardPattern((Area)area);
                Iterables.addAll(this.guardPredicates, (Iterable)QVTbaseUtil.getOwnedPredicates((Pattern)parentGuardPattern));
                this.gatherVariables(QVTcoreUtil.getOwnedVariables((CorePattern)parentGuardPattern), true);
                BottomPattern parentBottomPattern = QVTcoreUtil.getBottomPattern((Area)area);
                this.gatherVariables(QVTcoreUtil.getOwnedVariables((CorePattern)parentBottomPattern), true);
                this.gatherAssignments(QVTcoreUtil.getOwnedAssignments((BottomPattern)parentBottomPattern), false);
                Iterables.addAll(this.guardPredicates, (Iterable)QVTbaseUtil.getOwnedPredicates((Pattern)parentBottomPattern));
                this.gatherVariables(QVTcoreUtil.getOwnedRealizedVariables((BottomPattern)parentBottomPattern), true);
            }
            for (Area area : this.getSiblingAreas()) {
                if (area == thisArea) continue;
                GuardPattern siblingGuardPattern = QVTcoreUtil.getGuardPattern((Area)area);
                Iterables.addAll(this.guardPredicates, (Iterable)QVTbaseUtil.getOwnedPredicates((Pattern)siblingGuardPattern));
                this.gatherVariables(QVTcoreUtil.getOwnedVariables((CorePattern)siblingGuardPattern), true);
                BottomPattern siblingBottomPattern = QVTcoreUtil.getBottomPattern((Area)area);
                this.gatherVariables(QVTcoreUtil.getOwnedVariables((CorePattern)siblingBottomPattern), false);
                this.gatherAssignments(QVTcoreUtil.getOwnedAssignments((BottomPattern)siblingBottomPattern), true);
                Iterables.addAll(this.bottomPredicates, (Iterable)QVTbaseUtil.getOwnedPredicates((Pattern)siblingBottomPattern));
                this.gatherVariables(QVTcoreUtil.getOwnedRealizedVariables((BottomPattern)siblingBottomPattern), false);
            }
            return true;
        }

        protected @Nullable MergedVariable basicGetMergedVariable(@NonNull String name) {
            LinkedHashMap<@NonNull String, @NonNull MergedVariable> variableName2mergedVariables2 = this.variableName2mergedVariables;
            if (variableName2mergedVariables2 == null) {
                return null;
            }
            return variableName2mergedVariables2.get(name);
        }

        private void gatherAssignments(@NonNull Iterable<Assignment> aIns, boolean asAssignment) {
            for (Assignment aIn : aIns) {
                List<NavigationAssignment> navigationAssignments;
                if (aIn instanceof VariableAssignment) {
                    VariableAssignment vaIn = (VariableAssignment)aIn;
                    VariableDeclaration vIn = vaIn.getTargetVariable();
                    String name = vIn.getName();
                    assert (name != null);
                    MergedVariable mergedVariable = this.getMergedVariable(name);
                    mergedVariable.addAssignment(vaIn);
                    continue;
                }
                if (!(aIn instanceof NavigationAssignment)) continue;
                NavigationAssignment paIn = (NavigationAssignment)aIn;
                if (!asAssignment) {
                    List<@NonNull NavigationAssignment> navigationAssignmentsAsPredicates2 = this.navigationAssignmentsAsPredicates;
                    if (navigationAssignmentsAsPredicates2 == null) {
                        navigationAssignmentsAsPredicates2 = this.navigationAssignmentsAsPredicates = new ArrayList<NavigationAssignment>();
                    }
                    navigationAssignmentsAsPredicates2.add(paIn);
                    continue;
                }
                OCLExpression eIn = paIn.getSlotExpression();
                Property targetProperty = QVTcoreUtil.getTargetProperty((NavigationAssignment)paIn);
                if (!(eIn instanceof VariableExp)) continue;
                VariableDeclaration vIn = ((VariableExp)eIn).getReferredVariable();
                String key = String.valueOf(vIn.getName()) + "%" + targetProperty.toString();
                assert (key != null);
                LinkedHashMap<@NonNull String, @NonNull List<@NonNull Object>> variableName_property2navigationAssignments2 = this.variableName_property2navigationAssignments;
                if (variableName_property2navigationAssignments2 == null) {
                    this.variableName_property2navigationAssignments = new LinkedHashMap();
                    variableName_property2navigationAssignments2 = this.variableName_property2navigationAssignments;
                }
                if ((navigationAssignments = variableName_property2navigationAssignments2.get(key)) == null) {
                    navigationAssignments = new ArrayList<NavigationAssignment>();
                    variableName_property2navigationAssignments2.put(key, navigationAssignments);
                }
                navigationAssignments.add(paIn);
            }
        }

        private <T extends VariableDeclaration> void gatherVariables(@NonNull Iterable<? extends T> vIns, boolean isGuard) {
            for (VariableDeclaration vIn : vIns) {
                if (vIn == null) continue;
                String name = vIn.getName();
                assert (name != null);
                MergedVariable mergedVariable = this.getMergedVariable(name);
                mergedVariable.addVariable(vIn, isGuard);
            }
        }

        protected abstract @Nullable Area getArea(@NonNull Mapping var1);

        protected abstract @NonNull Iterable<? extends @NonNull Area> getChildAreas();

        public @NonNull CreateVisitor getCreateVisitor() {
            return this.createVisitor;
        }

        protected abstract @NonNull Mapping getMapping();

        protected @NonNull MergedVariable getMergedVariable(@NonNull String name) {
            MergedVariable mergedVariable;
            LinkedHashMap<@NonNull String, @NonNull MergedVariable> variableName2mergedVariables2 = this.variableName2mergedVariables;
            if (variableName2mergedVariables2 == null) {
                variableName2mergedVariables2 = new LinkedHashMap();
                this.variableName2mergedVariables = variableName2mergedVariables2;
            }
            if ((mergedVariable = variableName2mergedVariables2.get(name)) == null) {
                mergedVariable = new MergedVariable(this, name);
                variableName2mergedVariables2.put(name, mergedVariable);
            }
            return mergedVariable;
        }

        protected abstract @NonNull Iterable<? extends @NonNull Area> getParentAreas();

        protected abstract @NonNull Iterable<? extends @NonNull Area> getSiblingAreas();

        protected boolean isEnforced() {
            return false;
        }

        protected void synthesize(@NonNull Mapping mMapping, @NonNull Area mArea) {
            GuardPattern mGuardPattern = QVTcoreFactory.eINSTANCE.createGuardPattern();
            mArea.setGuardPattern(mGuardPattern);
            this.createVisitor.createAll(this.guardPredicates, mGuardPattern.getPredicate());
            if (this.navigationAssignmentsAsPredicates != null) {
                for (NavigationAssignment paIn : this.navigationAssignmentsAsPredicates) {
                    @NonNull Predicate pOut = QVTbaseFactory.eINSTANCE.createPredicate();
                    this.createVisitor.getContext().addTrace((Element)paIn, (Element)pOut);
                    this.createVisitor.createAll(paIn.getOwnedComments(), pOut.getOwnedComments());
                    mGuardPattern.getPredicate().add((Object)pOut);
                }
            }
            BottomPattern mBottomPattern = QVTcoreFactory.eINSTANCE.createBottomPattern();
            mArea.setBottomPattern(mBottomPattern);
            this.createVisitor.createAll(this.bottomPredicates, mBottomPattern.getPredicate());
            this.synthesizeNavigationAssignments(QVTcoreUtil.Internal.getOwnedAssignmentsList((BottomPattern)mBottomPattern));
            if (this.variableName2mergedVariables != null) {
                for (MergedVariable mergedVariable : this.variableName2mergedVariables.values()) {
                    mergedVariable.synthesize(mMapping, mArea);
                }
            }
            QVTu2QVTm qvtu2qvtm = this.createVisitor.getContext();
            for (Area uArea : Iterables.concat(this.getSiblingAreas(), this.getParentAreas(), this.getChildAreas())) {
                qvtu2qvtm.addTrace((Element)uArea, (Element)mArea);
                if (uArea == this.getArea(this.getMapping())) {
                    this.createVisitor.createAll(uArea.getOwnedComments(), mArea.getOwnedComments());
                }
                GuardPattern uGuardPattern = QVTcoreUtil.getGuardPattern((Area)uArea);
                qvtu2qvtm.addTrace((Element)uGuardPattern, (Element)mGuardPattern);
                this.createVisitor.createAll(uGuardPattern.getOwnedComments(), mGuardPattern.getOwnedComments());
                BottomPattern uBottomPattern = QVTcoreUtil.getBottomPattern((Area)uArea);
                qvtu2qvtm.addTrace((Element)uBottomPattern, (Element)mBottomPattern);
                this.createVisitor.createAll(uBottomPattern.getOwnedComments(), mArea.getOwnedComments());
            }
        }

        private void synthesizeNavigationAssignment(@NonNull Iterable<@NonNull NavigationAssignment> navigationAssignments, @NonNull List<Assignment> uAssignments) {
            for (NavigationAssignment navigationAssignment : navigationAssignments) {
                uAssignments.add((Assignment)this.createVisitor.create(navigationAssignment));
            }
        }

        private void synthesizeNavigationAssignments(@NonNull List<Assignment> uAssignments) {
            LinkedHashMap<@NonNull String, @NonNull List<@NonNull NavigationAssignment>> variableName_property2navigationAssignments2 = this.variableName_property2navigationAssignments;
            if (variableName_property2navigationAssignments2 != null) {
                for (Iterable iterable : variableName_property2navigationAssignments2.values()) {
                    this.synthesizeNavigationAssignment(iterable, uAssignments);
                }
            }
        }
    }

    protected static class MergedDomain
    extends MergedArea {
        protected final @NonNull MergedMapping mergedMapping;
        protected final @NonNull TypedModel uTypedModel;
        protected final @NonNull CoreDomain uExampleDomain;
        protected final @Nullable CoreDomain uLocalDomain;
        private final @NonNull List<@NonNull CoreDomain> childDomains = new ArrayList<CoreDomain>();
        private final @NonNull List<@NonNull CoreDomain> parentDomains = new ArrayList<CoreDomain>();
        private final @NonNull List<@NonNull CoreDomain> siblingDomains = new ArrayList<CoreDomain>();

        public MergedDomain(@NonNull CreateVisitor createVisitor, @NonNull MergedMapping mergedMapping, @NonNull TypedModel uTypedModel, @NonNull CoreDomain uExampleDomain) {
            super(createVisitor);
            this.mergedMapping = mergedMapping;
            this.uTypedModel = uTypedModel;
            this.uExampleDomain = uExampleDomain;
            this.uLocalDomain = QVTcoreUtil.basicGetDomain((Mapping)mergedMapping.uMapping, (TypedModel)uTypedModel);
        }

        @Override
        public boolean analyze() {
            for (Mapping childMapping : this.mergedMapping.getChildAreas()) {
                CoreDomain childDomain = QVTcoreUtil.basicGetDomain((Mapping)childMapping, (TypedModel)this.uTypedModel);
                if (childDomain == null) continue;
                this.childDomains.add(childDomain);
            }
            for (Mapping parentMapping : this.mergedMapping.getParentAreas()) {
                CoreDomain parentDomain = QVTcoreUtil.basicGetDomain((Mapping)parentMapping, (TypedModel)this.uTypedModel);
                if (parentDomain == null) continue;
                this.parentDomains.add(parentDomain);
            }
            for (Mapping siblingMapping : this.mergedMapping.getSiblingAreas()) {
                CoreDomain siblingDomain = QVTcoreUtil.basicGetDomain((Mapping)siblingMapping, (TypedModel)this.uTypedModel);
                if (siblingDomain == null) continue;
                this.siblingDomains.add(siblingDomain);
            }
            return super.analyze();
        }

        protected @Nullable CoreDomain getArea(@NonNull Mapping uMapping) {
            return QVTcoreUtil.basicGetDomain((Mapping)uMapping, (TypedModel)this.uTypedModel);
        }

        protected @NonNull Iterable<@NonNull CoreDomain> getChildAreas() {
            return this.childDomains;
        }

        @Override
        protected @NonNull Mapping getMapping() {
            return this.mergedMapping.uMapping;
        }

        protected @NonNull Iterable<@NonNull CoreDomain> getParentAreas() {
            return this.parentDomains;
        }

        protected @NonNull Iterable<@NonNull CoreDomain> getSiblingAreas() {
            return this.siblingDomains;
        }

        @Override
        protected boolean isEnforced() {
            return this.uExampleDomain.isIsEnforceable();
        }

        public @NonNull CoreDomain synthesize(@NonNull Mapping mMapping) {
            CoreDomain mDomain = QVTcoreFactory.eINSTANCE.createCoreDomain();
            mDomain.setName(this.uTypedModel.getName());
            boolean isCheckable = this.uExampleDomain.isIsCheckable();
            boolean isEnforceable = this.uExampleDomain.isIsEnforceable();
            for (CoreDomain domain : this.parentDomains) {
                if (domain.isIsCheckable()) {
                    isCheckable = true;
                }
                if (!domain.isIsEnforceable()) continue;
                isEnforceable = true;
            }
            for (CoreDomain domain : this.siblingDomains) {
                if (domain.isIsCheckable()) {
                    isCheckable = true;
                }
                if (!domain.isIsEnforceable()) continue;
                isEnforceable = true;
            }
            mDomain.setIsCheckable(isCheckable);
            mDomain.setIsEnforceable(isEnforceable);
            this.synthesize(mMapping, (Area)mDomain);
            return mDomain;
        }

        public String toString() {
            return this.uExampleDomain.toString();
        }
    }

    protected static class MergedMapping
    extends MergedArea {
        protected final @NonNull Mapping uMapping;
        private final @NonNull List<@NonNull Mapping> childMappings = new ArrayList<Mapping>();
        private final @NonNull List<@NonNull Mapping> parentMappings = new ArrayList<Mapping>();
        private final @NonNull List<@NonNull Mapping> siblingMappings = new ArrayList<Mapping>();
        private final @NonNull Map<@Nullable TypedModel, @NonNull MergedDomain> uTypedModel2mergedDomain = new HashMap<TypedModel, MergedDomain>();

        public MergedMapping(@NonNull CreateVisitor createVisitor, @NonNull Mapping uMapping) {
            super(createVisitor);
            this.uMapping = uMapping;
        }

        @Override
        public boolean analyze() {
            String name = this.uMapping.getName();
            this.computeChildMappings(this.childMappings, this.uMapping);
            this.computeSiblingMappings(this.siblingMappings, this.uMapping);
            for (Mapping contextMapping : this.siblingMappings) {
                if (contextMapping == this.uMapping) continue;
                this.computeChildMappings(this.childMappings, contextMapping);
            }
            this.computeParentMappings(this.parentMappings, this.uMapping);
            for (Mapping uMapping : Iterables.concat(this.siblingMappings, this.parentMappings, this.childMappings)) {
                for (Domain uDomain : ClassUtil.nullFree((EList)uMapping.getDomain())) {
                    TypedModel uTypedModel = QVTcoreUtil.getTypedModel((Domain)uDomain);
                    if (this.uTypedModel2mergedDomain.get(uTypedModel) != null) continue;
                    this.uTypedModel2mergedDomain.put(uTypedModel, new MergedDomain(this.createVisitor, this, uTypedModel, (CoreDomain)uDomain));
                }
            }
            for (MergedDomain mergedDomain : this.uTypedModel2mergedDomain.values()) {
                if (mergedDomain.analyze()) continue;
                return false;
            }
            return super.analyze();
        }

        private void computeChildMappings(@NonNull List<@NonNull Mapping> childMappings, @NonNull Mapping parentMapping) {
            for (Mapping childMapping : ClassUtil.nullFree((EList)parentMapping.getLocal())) {
                if (!QVTu2QVTm.isFoldable(childMapping)) continue;
                assert (!childMappings.contains(childMapping)) : "Local mappings cannot be cyclic";
                childMappings.add(childMapping);
                this.computeChildMappings(childMappings, childMapping);
            }
        }

        private void computeParentMappings(@NonNull List<@NonNull Mapping> parentMappings, @NonNull Mapping childMapping) {
            Mapping parentMapping = childMapping.getContext();
            if (parentMapping != null) {
                assert (!parentMappings.contains(parentMapping)) : "Context mappings cannot be cyclic";
                this.computeSiblingMappings(parentMappings, parentMapping);
                this.computeParentMappings(parentMappings, parentMapping);
            }
        }

        private void computeSiblingMappings(@NonNull List<@NonNull Mapping> siblingMappings, @NonNull Mapping refinedMapping) {
            if (!siblingMappings.contains(refinedMapping)) {
                siblingMappings.add(refinedMapping);
                for (Mapping specificationMapping : ClassUtil.nullFree((EList)refinedMapping.getSpecification())) {
                    assert (refinedMapping.getContext() == null) : "Local mapping cannot refine another";
                    this.computeSiblingMappings(siblingMappings, specificationMapping);
                }
            }
        }

        protected @Nullable Mapping getArea(@NonNull Mapping uMapping) {
            return uMapping;
        }

        protected @NonNull Iterable<@NonNull Mapping> getChildAreas() {
            return this.childMappings;
        }

        @Override
        protected @NonNull Mapping getMapping() {
            return this.uMapping;
        }

        @Override
        protected @NonNull MergedVariable getMergedVariable(@NonNull String name) {
            for (MergedDomain mergedDomain : this.uTypedModel2mergedDomain.values()) {
                MergedVariable mergedVariable = mergedDomain.basicGetMergedVariable(name);
                if (mergedVariable == null) continue;
                return mergedVariable;
            }
            return super.getMergedVariable(name);
        }

        protected @NonNull Iterable<@NonNull Mapping> getParentAreas() {
            return this.parentMappings;
        }

        protected @NonNull Iterable<@NonNull Mapping> getSiblingAreas() {
            return this.siblingMappings;
        }

        public void synthesize(@NonNull Mapping mMapping) {
            String name = this.createVisitor.getContext().getMappingName(this.uMapping);
            mMapping.setName(name);
            super.synthesize(mMapping, (Area)mMapping);
            Transformation uTransformation = QVTbaseUtil.getContainingTransformation((EObject)this.uMapping);
            for (TypedModel uTypedModel : QVTbaseUtil.getModelParameters((Transformation)uTransformation)) {
                MergedDomain mergedDomain = this.uTypedModel2mergedDomain.get(uTypedModel);
                if (mergedDomain == null) continue;
                CoreDomain mDomain = mergedDomain.synthesize(mMapping);
                mMapping.getDomain().add((Object)mDomain);
            }
        }

        public String toString() {
            return this.uMapping.toString();
        }
    }

    protected static class MergedVariable {
        public static final boolean GUARD = true;
        public static final boolean BOTTOM = false;
        protected final @NonNull CreateVisitor createVisitor;
        protected final @NonNull MergedArea mergedArea;
        protected final @NonNull String name;
        private boolean isGuard = false;
        private boolean isRealized = false;
        private @Nullable CompleteClass mergedType = null;
        private boolean isRequired = false;
        private @Nullable List<@NonNull VariableDeclaration> variables = null;
        private @Nullable List<@NonNull VariableAssignment> assignments = null;

        protected MergedVariable(@NonNull MergedArea mergedArea, @NonNull String name) {
            this.createVisitor = mergedArea.getCreateVisitor();
            this.mergedArea = mergedArea;
            this.name = name;
        }

        public void addAssignment(@NonNull VariableAssignment variableAssignment) {
            List<@NonNull VariableAssignment> assignments2 = this.assignments;
            if (assignments2 == null) {
                this.assignments = assignments2 = new ArrayList<VariableAssignment>();
            }
            assignments2.add(variableAssignment);
        }

        public void addVariable(@NonNull VariableDeclaration variable, boolean isGuard) {
            List<VariableDeclaration> variables2;
            if (isGuard) {
                this.isGuard = true;
            } else if (variable instanceof RealizedVariable) {
                this.isRealized = true;
            }
            if (variable.isIsRequired()) {
                this.isRequired = true;
            }
            if ((variables2 = this.variables) == null) {
                this.variables = variables2 = new ArrayList<VariableDeclaration>();
            }
            assert (!variables2.contains(variable));
            variables2.add(variable);
            EnvironmentFactory environmentFactory = this.createVisitor.getContext().getEnvironmentFactory();
            Type type = variable.getType();
            assert (type != null);
            CompleteClass completeType = environmentFactory.getCompleteModel().getCompleteClass(type);
            CompleteClass mergedType2 = this.mergedType;
            if (mergedType2 == null) {
                this.mergedType = mergedType2 = completeType;
            } else if (completeType.conformsTo(mergedType2)) {
                this.mergedType = mergedType2 = completeType;
            } else assert (mergedType2.conformsTo(completeType));
        }

        public void synthesize(@NonNull Mapping mMapping, @NonNull Area mArea) {
            List<@NonNull VariableAssignment> assignments2 = this.assignments;
            List<@NonNull VariableDeclaration> variables2 = this.variables;
            if (variables2 != null) {
                RealizedVariable mVariable = QVTcoreFactory.eINSTANCE.createRealizedVariable();
                if (this.isRealized) {
                    RealizedVariable realizedVariable;
                    mVariable = realizedVariable = QVTcoreFactory.eINSTANCE.createRealizedVariable();
                    mArea.getBottomPattern().getRealizedVariable().add((Object)realizedVariable);
                } else if (this.isGuard) {
                    mVariable = QVTcoreFactory.eINSTANCE.createGuardVariable();
                    mArea.getGuardPattern().getOwnedVariables().add((Object)mVariable);
                } else {
                    mVariable = QVTcoreFactory.eINSTANCE.createBottomVariable();
                    mArea.getBottomPattern().getOwnedVariables().add((Object)mVariable);
                }
                mVariable.setName(this.name);
                if (this.mergedType != null) {
                    mVariable.setType((Type)this.mergedType.getPrimaryClass());
                }
                mVariable.setIsRequired(this.isRequired);
                for (VariableDeclaration uVariable : variables2) {
                    this.createVisitor.getContext().addTrace((Element)uVariable, (Element)mVariable);
                    this.createVisitor.createAll(uVariable.getOwnedComments(), mVariable.getOwnedComments());
                }
                if (assignments2 != null) {
                    this.createVisitor.createAll(assignments2, mMapping.getBottomPattern().getAssignment());
                }
            } else {
                assert (assignments2 != null);
                VariableAssignment mVariableAssignment = this.createVisitor.create(assignments2.get(0));
                assert (mVariableAssignment != null);
            }
        }

        public String toString() {
            return this.name;
        }
    }

    protected static class UpdateVisitor
    extends AbstractQVTc2QVTc.AbstractUpdateVisitor<QVTu2QVTm> {
        public UpdateVisitor(@NonNull QVTu2QVTm context) {
            super(context);
        }

        @Override
        public @Nullable Object visitVariable(@NonNull Variable mVariable) {
            Updater updater = ((QVTu2QVTm)((Object)this.context)).getUpdater((Element)mVariable);
            if (updater != null) {
                updater.update(this);
                return null;
            }
            if (mVariable.eContainer() instanceof CorePattern) {
                Variable uVariable = (Variable)((QVTu2QVTm)((Object)this.context)).equivalentSource((Element)mVariable);
                mVariable.setOwnedInit(this.createCastCopy(uVariable.getOwnedInit(), uVariable.getType()));
                return null;
            }
            return super.visitVariable(mVariable);
        }
    }

    protected static interface Updater {
        public void update(@NonNull UpdateVisitor var1);
    }
}

