/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.workbench.core.lookup;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.reddeer.common.logging.Logger;
import org.eclipse.reddeer.common.util.Display;
import org.eclipse.reddeer.common.util.ResultRunnable;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.PartPane;
import org.eclipse.ui.internal.WorkbenchPartReference;
import org.hamcrest.Matcher;

public class WorkbenchPartLookup {
    private static final Logger log = Logger.getLogger(WorkbenchPartLookup.class);
    private static WorkbenchPartLookup instance;

    private WorkbenchPartLookup() {
    }

    public static WorkbenchPartLookup getInstance() {
        if (instance == null) {
            instance = new WorkbenchPartLookup();
        }
        return instance;
    }

    public IWorkbenchPart getActiveWorkbenchPart() {
        return (IWorkbenchPart)Display.syncExec((ResultRunnable)new ResultRunnable<IWorkbenchPart>(){

            public IWorkbenchPart run() {
                return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart();
            }
        });
    }

    public List<IViewPart> getOpenViews() {
        return (List)Display.syncExec((ResultRunnable)new ResultRunnable<List<IViewPart>>(){

            public List<IViewPart> run() {
                HashSet<IViewPart> views = new HashSet<IViewPart>();
                IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                if (activePage != null) {
                    log.debug("Looking up all open views");
                    activePage.getViewReferences();
                    IViewReference[] iViewReferenceArray = activePage.getViewReferences();
                    int n = iViewReferenceArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IViewReference viewReference = iViewReferenceArray[n2];
                        IViewPart view = viewReference.getView(false);
                        if (view == null) {
                            log.trace("\tView '" + viewReference.getTitle() + "' was not open or it cannot be restored");
                        } else {
                            IViewPart[] stackedViews = activePage.getViewStack(view);
                            if (stackedViews == null) {
                                log.trace("\tView '" + view.getTitle() + "' does not belong to the currently active page");
                            } else {
                                IViewPart[] iViewPartArray = viewReference.getPage().getViewStack(viewReference.getView(false));
                                int n3 = iViewPartArray.length;
                                int n4 = 0;
                                while (n4 < n3) {
                                    IViewPart part = iViewPartArray[n4];
                                    log.trace("\tFound view '" + part.getTitle() + "'");
                                    views.add(part);
                                    ++n4;
                                }
                            }
                        }
                        ++n2;
                    }
                }
                return new ArrayList<IViewPart>(views);
            }
        });
    }

    public IViewReference[] findAllViewReferences() {
        return (IViewReference[])Display.syncExec((ResultRunnable)new ResultRunnable<IViewReference[]>(){

            public IViewReference[] run() {
                return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getViewReferences();
            }
        });
    }

    public IViewReference getActiveView() {
        return (IViewReference)Display.syncExec((ResultRunnable)new ResultRunnable<IViewReference>(){

            public IViewReference run() {
                IWorkbenchPartReference activeWorkbenchPart = WorkbenchPartLookup.this.getActiveWorkbenchPartReference();
                if (activeWorkbenchPart instanceof IViewReference) {
                    return (IViewReference)activeWorkbenchPart;
                }
                return null;
            }
        });
    }

    public IViewPart getViewByTitle(final Matcher<String> name) {
        return (IViewPart)Display.syncExec((ResultRunnable)new ResultRunnable<IViewPart>(){

            public IViewPart run() {
                List<IViewPart> views = WorkbenchPartLookup.this.getOpenViews();
                for (IViewPart view : views) {
                    if (!name.matches((Object)view.getViewSite().getRegisteredName())) continue;
                    return view;
                }
                this.logAllViews(views);
                return null;
            }

            private void logAllViews(List<IViewPart> views) {
                log.debug("View matching '" + name + "' not found");
                log.debug("List of found views:");
                for (IViewPart view : views) {
                    log.debug("\t'" + view.getViewSite().getRegisteredName() + "'");
                }
            }
        });
    }

    public Control getWorkbenchControl(final IWorkbenchPartReference activeWorkbenchReference) {
        return (Control)Display.syncExec((ResultRunnable)new ResultRunnable<Control>(){

            public Control run() {
                PartPane pane = ((WorkbenchPartReference)activeWorkbenchReference).getPane();
                return pane.getControl();
            }
        });
    }

    public Shell getShellForActiveWorkbench() {
        IWorkbenchPartReference workbenchReference = this.getActiveWorkbenchPartReference();
        if (workbenchReference == null) {
            return null;
        }
        IWorkbenchPart wPart = workbenchReference.getPart(true);
        if (wPart == null) {
            return null;
        }
        IWorkbenchPartSite wSite = wPart.getSite();
        if (wSite == null) {
            return null;
        }
        return wSite.getShell();
    }

    public String getActiveWorkbenchPartTitle() {
        final IWorkbenchPartReference part = this.getActiveWorkbenchPartReference();
        if (part != null) {
            return (String)Display.syncExec((ResultRunnable)new ResultRunnable<String>(){

                public String run() {
                    return part.getTitle();
                }
            });
        }
        return null;
    }

    public Control getActiveWorkbenchPartControl() {
        IWorkbenchPartReference part = this.getActiveWorkbenchPartReference();
        if (part != null) {
            return this.getWorkbenchControl(part);
        }
        return null;
    }

    public IWorkbenchPartReference getActiveWorkbenchPartReference() {
        return (IWorkbenchPartReference)Display.syncExec((ResultRunnable)new ResultRunnable<IWorkbenchPartReference>(){

            public IWorkbenchPartReference run() {
                return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePartReference();
            }
        });
    }
}

