/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.accessibility;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.AccessibleActionListener;
import org.eclipse.swt.accessibility.AccessibleAttributeListener;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEditableTextListener;
import org.eclipse.swt.accessibility.AccessibleHyperlinkListener;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.accessibility.AccessibleObject;
import org.eclipse.swt.accessibility.AccessibleTableCellListener;
import org.eclipse.swt.accessibility.AccessibleTableListener;
import org.eclipse.swt.accessibility.AccessibleTextExtendedListener;
import org.eclipse.swt.accessibility.AccessibleTextListener;
import org.eclipse.swt.accessibility.AccessibleValueListener;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public class Accessible {
    List<AccessibleListener> accessibleListeners;
    List<AccessibleControlListener> accessibleControlListeners;
    List<AccessibleTextListener> accessibleTextListeners;
    List<AccessibleActionListener> accessibleActionListeners;
    List<AccessibleEditableTextListener> accessibleEditableTextListeners;
    List<AccessibleHyperlinkListener> accessibleHyperlinkListeners;
    List<AccessibleTableListener> accessibleTableListeners;
    List<AccessibleTableCellListener> accessibleTableCellListeners;
    List<AccessibleTextExtendedListener> accessibleTextExtendedListeners;
    List<AccessibleValueListener> accessibleValueListeners;
    List<AccessibleAttributeListener> accessibleAttributeListeners;
    Accessible parent;
    AccessibleObject accessibleObject;
    Control control;
    List<Relation> relations;
    List<Accessible> children;

    public Accessible(Accessible parent) {
        this.parent = Accessible.checkNull(parent);
        this.control = parent.control;
        if (parent.children == null) {
            parent.children = new ArrayList<Accessible>();
        }
        parent.children.add(this);
    }

    @Deprecated
    protected Accessible() {
    }

    static Accessible checkNull(Accessible parent) {
        if (parent == null) {
            SWT.error(4);
        }
        return parent;
    }

    Accessible(Control control) {
        this.control = control;
        long type = OS.G_OBJECT_TYPE(this.getControlHandle());
        this.accessibleObject = new AccessibleObject(type, this.getControlHandle(), this, false);
        this.addRelations();
    }

    public void addAccessibleListener(AccessibleListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        if (this.accessibleListeners == null) {
            this.accessibleListeners = new ArrayList<AccessibleListener>();
        }
        this.accessibleListeners.add(listener);
    }

    public void addAccessibleControlListener(AccessibleControlListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        if (this.accessibleControlListeners == null) {
            this.accessibleControlListeners = new ArrayList<AccessibleControlListener>();
        }
        this.accessibleControlListeners.add(listener);
    }

    public void addAccessibleTextListener(AccessibleTextListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        if (listener instanceof AccessibleTextExtendedListener) {
            if (this.accessibleTextExtendedListeners == null) {
                this.accessibleTextExtendedListeners = new ArrayList<AccessibleTextExtendedListener>();
            }
            this.accessibleTextExtendedListeners.add((AccessibleTextExtendedListener)listener);
        } else {
            if (this.accessibleTextListeners == null) {
                this.accessibleTextListeners = new ArrayList<AccessibleTextListener>();
            }
            this.accessibleTextListeners.add(listener);
        }
    }

    public void addAccessibleActionListener(AccessibleActionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        if (this.accessibleActionListeners == null) {
            this.accessibleActionListeners = new ArrayList<AccessibleActionListener>();
        }
        this.accessibleActionListeners.add(listener);
    }

    public void addAccessibleEditableTextListener(AccessibleEditableTextListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        if (this.accessibleEditableTextListeners == null) {
            this.accessibleEditableTextListeners = new ArrayList<AccessibleEditableTextListener>();
        }
        this.accessibleEditableTextListeners.add(listener);
    }

    public void addAccessibleHyperlinkListener(AccessibleHyperlinkListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        if (this.accessibleHyperlinkListeners == null) {
            this.accessibleHyperlinkListeners = new ArrayList<AccessibleHyperlinkListener>();
        }
        this.accessibleHyperlinkListeners.add(listener);
    }

    public void addAccessibleTableListener(AccessibleTableListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        if (this.accessibleTableListeners == null) {
            this.accessibleTableListeners = new ArrayList<AccessibleTableListener>();
        }
        this.accessibleTableListeners.add(listener);
    }

    public void addAccessibleTableCellListener(AccessibleTableCellListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        if (this.accessibleTableCellListeners == null) {
            this.accessibleTableCellListeners = new ArrayList<AccessibleTableCellListener>();
        }
        this.accessibleTableCellListeners.add(listener);
    }

    public void addAccessibleValueListener(AccessibleValueListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        if (this.accessibleValueListeners == null) {
            this.accessibleValueListeners = new ArrayList<AccessibleValueListener>();
        }
        this.accessibleValueListeners.add(listener);
    }

    public void addAccessibleAttributeListener(AccessibleAttributeListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        if (this.accessibleAttributeListeners == null) {
            this.accessibleAttributeListeners = new ArrayList<AccessibleAttributeListener>();
        }
        this.accessibleAttributeListeners.add(listener);
    }

    public void addRelation(int type, Accessible target) {
        Relation relation;
        this.checkWidget();
        if (target == null) {
            SWT.error(4);
        }
        if (this.relations == null) {
            this.relations = new ArrayList<Relation>();
        }
        if (this.relations.indexOf(relation = new Relation(type, target)) != -1) {
            return;
        }
        this.relations.add(relation);
        if (this.accessibleObject != null) {
            this.accessibleObject.addRelation(type, target);
        }
    }

    void addRelations() {
        if (this.relations == null) {
            return;
        }
        if (this.accessibleObject == null) {
            return;
        }
        int i = 0;
        while (i < this.relations.size()) {
            Relation relation = this.relations.get(i);
            this.accessibleObject.addRelation(relation.type, relation.target);
            ++i;
        }
    }

    public void dispose() {
        if (this.parent == null) {
            return;
        }
        this.release();
        this.parent.children.remove(this);
        this.parent = null;
    }

    public Control getControl() {
        return this.control;
    }

    void checkWidget() {
        if (!this.isValidThread()) {
            SWT.error(22);
        }
        if (this.control.isDisposed()) {
            SWT.error(24);
        }
    }

    AccessibleObject getAccessibleObject() {
        if (this.accessibleObject == null) {
            long widget = this.getControlHandle();
            long type = OS.G_OBJECT_TYPE(widget);
            if (this.parent == null) {
                this.accessibleObject = new AccessibleObject(type, widget, this, false);
            } else {
                this.accessibleObject = new AccessibleObject(type, 0L, this, true);
                this.accessibleObject.parent = this.parent.getAccessibleObject();
            }
        }
        return this.accessibleObject;
    }

    long getControlHandle() {
        long list;
        long result = this.control.handle;
        if (this.control instanceof Label && (list = GTK.gtk_container_get_children(result)) != 0L) {
            long temp = list;
            while (temp != 0L) {
                long widget = OS.g_list_data(temp);
                if (GTK.gtk_widget_get_visible(widget)) {
                    result = widget;
                    break;
                }
                temp = OS.g_list_next(temp);
            }
            OS.g_list_free(list);
        }
        return result;
    }

    public void internal_dispose_Accessible() {
        this.release();
    }

    public static Accessible internal_new_Accessible(Control control) {
        return new Accessible(control);
    }

    boolean isValidThread() {
        return this.control.getDisplay().getThread() == Thread.currentThread();
    }

    void release() {
        if (this.children != null) {
            ArrayList<Accessible> temp = new ArrayList<Accessible>(this.children);
            int i = 0;
            while (i < temp.size()) {
                Accessible child = (Accessible)temp.get(i);
                child.dispose();
                ++i;
            }
        }
        if (this.accessibleObject != null) {
            this.accessibleObject.release();
            this.accessibleObject = null;
        }
    }

    public void removeAccessibleControlListener(AccessibleControlListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        if (this.accessibleControlListeners != null) {
            this.accessibleControlListeners.remove(listener);
            if (this.accessibleControlListeners.isEmpty()) {
                this.accessibleControlListeners = null;
            }
        }
    }

    public void removeAccessibleListener(AccessibleListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        if (this.accessibleListeners != null) {
            this.accessibleListeners.remove(listener);
            if (this.accessibleListeners.isEmpty()) {
                this.accessibleListeners = null;
            }
        }
    }

    public void removeAccessibleTextListener(AccessibleTextListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        if (listener instanceof AccessibleTextExtendedListener) {
            if (this.accessibleTextExtendedListeners != null) {
                this.accessibleTextExtendedListeners.remove(listener);
                if (this.accessibleTextExtendedListeners.isEmpty()) {
                    this.accessibleTextExtendedListeners = null;
                }
            }
        } else if (this.accessibleTextListeners != null) {
            this.accessibleTextListeners.remove(listener);
            if (this.accessibleTextListeners.isEmpty()) {
                this.accessibleTextListeners = null;
            }
        }
    }

    public void removeAccessibleActionListener(AccessibleActionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        if (this.accessibleActionListeners != null) {
            this.accessibleActionListeners.remove(listener);
            if (this.accessibleActionListeners.isEmpty()) {
                this.accessibleActionListeners = null;
            }
        }
    }

    public void removeAccessibleEditableTextListener(AccessibleEditableTextListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        if (this.accessibleEditableTextListeners != null) {
            this.accessibleEditableTextListeners.remove(listener);
            if (this.accessibleEditableTextListeners.isEmpty()) {
                this.accessibleEditableTextListeners = null;
            }
        }
    }

    public void removeAccessibleHyperlinkListener(AccessibleHyperlinkListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        if (this.accessibleHyperlinkListeners != null) {
            this.accessibleHyperlinkListeners.remove(listener);
            if (this.accessibleHyperlinkListeners.isEmpty()) {
                this.accessibleHyperlinkListeners = null;
            }
        }
    }

    public void removeAccessibleTableListener(AccessibleTableListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        if (this.accessibleTableListeners != null) {
            this.accessibleTableListeners.remove(listener);
            if (this.accessibleTableListeners.isEmpty()) {
                this.accessibleTableListeners = null;
            }
        }
    }

    public void removeAccessibleTableCellListener(AccessibleTableCellListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        if (this.accessibleTableCellListeners != null) {
            this.accessibleTableCellListeners.remove(listener);
            if (this.accessibleTableCellListeners.isEmpty()) {
                this.accessibleTableCellListeners = null;
            }
        }
    }

    public void removeAccessibleValueListener(AccessibleValueListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        if (this.accessibleValueListeners != null) {
            this.accessibleValueListeners.remove(listener);
            if (this.accessibleValueListeners.isEmpty()) {
                this.accessibleValueListeners = null;
            }
        }
    }

    public void removeAccessibleAttributeListener(AccessibleAttributeListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        if (this.accessibleAttributeListeners != null) {
            this.accessibleAttributeListeners.remove(listener);
            if (this.accessibleAttributeListeners.isEmpty()) {
                this.accessibleAttributeListeners = null;
            }
        }
    }

    public void removeRelation(int type, Accessible target) {
        Relation relation;
        int index;
        this.checkWidget();
        if (this.relations == null) {
            return;
        }
        if (target == null) {
            SWT.error(4);
        }
        if ((index = this.relations.indexOf(relation = new Relation(type, target))) == -1) {
            return;
        }
        this.relations.remove(index);
        if (this.accessibleObject != null) {
            this.accessibleObject.removeRelation(type, target);
        }
    }

    public void sendEvent(int event, Object eventData) {
        this.checkWidget();
        if (this.accessibleObject != null) {
            this.accessibleObject.sendEvent(event, eventData);
        }
    }

    public void sendEvent(int event, Object eventData, int childID) {
        this.checkWidget();
        if (this.accessibleObject != null) {
            switch (event) {
                case 32777: 
                case 32778: 
                case 32779: 
                case 32780: 
                case 32781: 
                case 32782: 
                case 32788: {
                    this.accessibleObject.sendEvent(event, eventData, childID);
                }
            }
        }
    }

    public void selectionChanged() {
        this.checkWidget();
        if (this.accessibleObject != null) {
            this.accessibleObject.selectionChanged();
        }
    }

    public void setFocus(int childID) {
        this.checkWidget();
        if (this.accessibleObject != null) {
            this.accessibleObject.setFocus(childID);
        }
    }

    public void textCaretMoved(int index) {
        this.checkWidget();
        if (this.accessibleObject != null) {
            this.accessibleObject.textCaretMoved(index);
        }
    }

    public void textChanged(int type, int startIndex, int length) {
        this.checkWidget();
        if (this.accessibleObject != null) {
            this.accessibleObject.textChanged(type, startIndex, length);
        }
    }

    public void textSelectionChanged() {
        this.checkWidget();
        if (this.accessibleObject != null) {
            this.accessibleObject.textSelectionChanged();
        }
    }

    static class Relation {
        int type;
        Accessible target;

        public Relation(int type, Accessible target) {
            this.type = type;
            this.target = target;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof Relation)) {
                return false;
            }
            Relation relation = (Relation)object;
            return relation.type == this.type && relation.target == this.target;
        }
    }
}

