/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.terminal.view.core.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Platform;

public class Env {
    private static final Object ENV_GET_MONITOR = new Object();
    private static Map<String, String> nativeEnvironmentCasePreserved = null;

    public static String[] getEnvironment(String[] envp, boolean terminal) {
        LinkedHashMap<String, String> env;
        block17: {
            Map<String, String> nativeEnv = Env.getNativeEnvironmentCasePreserved();
            env = new LinkedHashMap<String, String>(nativeEnv);
            if (terminal) {
                env.put("TERM", "xterm");
            }
            HashMap<String, String> k2n = null;
            if ("win32".equals(Platform.getOS())) {
                k2n = new HashMap<String, String>();
                for (String name : env.keySet()) {
                    k2n.put(name.toLowerCase(), name);
                }
            }
            if (envp == null) break block17;
            int i = 0;
            while (i < envp.length) {
                block18: {
                    String name;
                    int eqIdx;
                    String envpPart;
                    block19: {
                        envpPart = envp[i];
                        eqIdx = envpPart.indexOf(61);
                        if (eqIdx < 1) break block18;
                        name = envpPart.substring(0, eqIdx);
                        if (!"win32".equals(Platform.getOS())) break block19;
                        if (k2n.containsKey(name.toLowerCase())) {
                            String candidate = (String)k2n.get(name.toLowerCase());
                            Assert.isNotNull((Object)candidate);
                            name = candidate;
                        }
                        if ("".equals(name.trim()) || name.contains(":")) break block18;
                    }
                    String value = envpPart.substring(eqIdx + 1);
                    if (!terminal || !"TERM".equals(name)) {
                        if (!env.containsKey(name) && !"<unset>".equals(value)) {
                            env.put(name, value);
                        } else if (env.containsKey(name)) {
                            if ("<unset>".equals(value)) {
                                env.remove(name);
                            } else {
                                String oldValue = (String)env.get(name);
                                if (oldValue != null && !oldValue.equals(value) || oldValue == null && value != null) {
                                    env.put(name, value);
                                }
                            }
                        }
                    }
                }
                ++i;
            }
        }
        ArrayList keys = new ArrayList(env.keySet());
        if ("win32".equals(Platform.getOS())) {
            Collections.sort(keys);
        }
        Iterator iter = keys.iterator();
        ArrayList<String> strings = new ArrayList<String>(env.size());
        StringBuilder buffer = null;
        while (iter.hasNext()) {
            String key = (String)iter.next();
            buffer = new StringBuilder(key);
            buffer.append('=').append((String)env.get(key));
            strings.add(buffer.toString());
        }
        return strings.toArray(new String[strings.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, String> getNativeEnvironmentCasePreserved() {
        Object object = ENV_GET_MONITOR;
        synchronized (object) {
            if (nativeEnvironmentCasePreserved == null) {
                nativeEnvironmentCasePreserved = new LinkedHashMap<String, String>();
                Env.cacheNativeEnvironment(nativeEnvironmentCasePreserved);
            }
            return new LinkedHashMap<String, String>(nativeEnvironmentCasePreserved);
        }
    }

    private static void cacheNativeEnvironment(Map<String, String> cache) {
        Assert.isNotNull(cache);
        try {
            String nativeCommand = null;
            if (Platform.getOS().equals("win32")) {
                nativeCommand = "cmd.exe /C set";
            } else if (!Platform.getOS().equals("unknown")) {
                nativeCommand = "env";
            }
            if (nativeCommand == null) {
                return;
            }
            Process process = Runtime.getRuntime().exec(nativeCommand);
            InputStream stream = process.getInputStream();
            InputStreamReader isreader = new InputStreamReader(stream);
            try (BufferedReader reader = new BufferedReader(isreader);){
                String line = reader.readLine();
                while (line != null) {
                    String key = null;
                    String value = null;
                    int func = line.indexOf("=()");
                    if (func > 0) {
                        key = line.substring(0, func);
                        value = line.substring(func + 1);
                        while ((line = reader.readLine()) != null) {
                            if (line.equals("}")) {
                                value = String.valueOf(value) + ';';
                            }
                            value = String.valueOf(value) + ' ' + line;
                            if (!line.equals("}")) continue;
                        }
                        line = reader.readLine();
                    } else {
                        int separator = line.indexOf(61);
                        if (separator > 0) {
                            key = line.substring(0, separator);
                            value = line.substring(separator + 1);
                            StringBuilder bufValue = new StringBuilder(value);
                            line = reader.readLine();
                            if (line != null) {
                                separator = line.indexOf(61);
                                while (separator < 0) {
                                    bufValue.append(line.trim());
                                    line = reader.readLine();
                                    if (line == null) break;
                                    separator = line.indexOf(61);
                                }
                            }
                            value = bufValue.toString();
                        }
                    }
                    if (key != null) {
                        cache.put(key, value);
                        continue;
                    }
                    line = reader.readLine();
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

