/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.terminal.view.ui.view;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.UUID;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.tm.terminal.view.ui.activator.UIPlugin;
import org.eclipse.tm.terminal.view.ui.interfaces.ITerminalsView;
import org.eclipse.tm.terminal.view.ui.nls.Messages;
import org.eclipse.tm.terminal.view.ui.tabs.TabFolderManager;
import org.eclipse.tm.terminal.view.ui.tabs.TabFolderMenuHandler;
import org.eclipse.tm.terminal.view.ui.tabs.TabFolderToolbarHandler;
import org.eclipse.tm.terminal.view.ui.view.TerminalsViewMementoHandler;
import org.eclipse.tm.terminal.view.ui.view.showin.GitShowInContextHandler;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.IShowInTarget;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.part.ViewPart;
import org.osgi.framework.Bundle;

public class TerminalsView
extends ViewPart
implements ITerminalsView,
IShowInTarget {
    private PageBook pageBookControl;
    CTabFolder tabFolderControl;
    TabFolderManager tabFolderManager;
    private TabFolderMenuHandler tabFolderMenuHandler;
    private TabFolderToolbarHandler tabFolderToolbarHandler;
    private Control emptyPageControl;
    private final TerminalsViewMementoHandler mementoHandler = new TerminalsViewMementoHandler();

    private void addDragSupport() {
        PlatformUI.getWorkbench().getDisplay().addFilter(29, event -> {
            if (!(event.widget instanceof CTabFolder)) {
                return;
            }
            if (this.tabFolderManager == null) {
                return;
            }
            if (event.widget != this.tabFolderControl) {
                return;
            }
            if (this.tabFolderControl.getData("DragSource") != null) {
                return;
            }
            final CTabFolder draggedFolder = (CTabFolder)event.widget;
            int operations = 18;
            final DragSource dragSource = new DragSource((Control)draggedFolder, operations);
            TerminalTransfer.getInstance().setDraggedFolderItem(this.tabFolderManager.getActiveTabItem());
            TerminalTransfer.getInstance().setTabFolderManager(this.tabFolderManager);
            Transfer[] transferTypes = new Transfer[]{TerminalTransfer.getInstance()};
            dragSource.setTransfer(transferTypes);
            dragSource.addDragListener(new DragSourceListener(){

                public void dragStart(DragSourceEvent event) {
                }

                public void dragSetData(DragSourceEvent event) {
                }

                public void dragFinished(DragSourceEvent event) {
                    dragSource.dispose();
                    draggedFolder.notifyListeners(4, null);
                }
            });
        });
    }

    private void addDropSupport() {
        int operations = 18;
        DropTarget target = new DropTarget((Control)this.pageBookControl, operations);
        Transfer[] transferTypes = new Transfer[]{TerminalTransfer.getInstance()};
        target.setTransfer(transferTypes);
        target.addDropListener(new DropTargetListener(){

            public void dragEnter(DropTargetEvent event) {
                event.detail = TerminalTransfer.getInstance().getTabFolderManager() == TerminalsView.this.tabFolderManager ? 0 : 2;
            }

            public void dragOver(DropTargetEvent event) {
            }

            public void dragOperationChanged(DropTargetEvent event) {
            }

            public void dragLeave(DropTargetEvent event) {
            }

            public void dropAccept(DropTargetEvent event) {
            }

            public void drop(DropTargetEvent event) {
                if (TerminalTransfer.getInstance().getDraggedFolderItem() != null && TerminalsView.this.tabFolderManager != null) {
                    CTabItem draggedItem = TerminalTransfer.getInstance().getDraggedFolderItem();
                    CTabItem item = TerminalsView.this.tabFolderManager.cloneTabItemAfterDrop(draggedItem);
                    TerminalsView.this.tabFolderManager.bringToTop(item);
                    TerminalsView.this.switchToTabFolderControl();
                    Control control = draggedItem.getControl();
                    draggedItem.setControl(null);
                    if (control != null) {
                        control.dispose();
                    }
                    DisposeListener disposeListener = (DisposeListener)draggedItem.getData("disposeListener");
                    draggedItem.removeDisposeListener(disposeListener);
                    draggedItem.dispose();
                    TerminalsView.this.setFocus();
                }
            }
        });
    }

    public void dispose() {
        if (this.tabFolderManager != null) {
            this.tabFolderManager.dispose();
            this.tabFolderManager = null;
        }
        if (this.tabFolderMenuHandler != null) {
            this.tabFolderMenuHandler.dispose();
            this.tabFolderMenuHandler = null;
        }
        if (this.tabFolderToolbarHandler != null) {
            this.tabFolderToolbarHandler.dispose();
            this.tabFolderToolbarHandler = null;
        }
        super.dispose();
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.restoreState(memento);
    }

    public void createPartControl(Composite parent) {
        this.pageBookControl = this.doCreatePageBookControl(parent);
        Assert.isNotNull((Object)this.pageBookControl);
        this.doConfigurePageBookControl(this.pageBookControl);
        this.emptyPageControl = this.doCreateEmptyPageControl((Composite)this.pageBookControl);
        Assert.isNotNull((Object)this.emptyPageControl);
        this.doConfigureEmptyPageControl(this.emptyPageControl);
        this.tabFolderControl = this.doCreateTabFolderControl((Composite)this.pageBookControl);
        Assert.isNotNull((Object)this.tabFolderControl);
        this.doConfigureTabFolderControl(this.tabFolderControl);
        this.tabFolderManager = this.doCreateTabFolderManager(this);
        Assert.isNotNull((Object)((Object)this.tabFolderManager));
        this.getSite().setSelectionProvider((ISelectionProvider)this.tabFolderManager);
        this.tabFolderMenuHandler = this.doCreateTabFolderMenuHandler(this);
        Assert.isNotNull((Object)((Object)this.tabFolderMenuHandler));
        this.doConfigureTabFolderMenuHandler(this.tabFolderMenuHandler);
        this.tabFolderToolbarHandler = this.doCreateTabFolderToolbarHandler(this);
        Assert.isNotNull((Object)((Object)this.tabFolderToolbarHandler));
        this.doConfigureTabFolderToolbarHandler(this.tabFolderToolbarHandler);
        this.switchToEmptyPageControl();
        String secondaryId = ((IViewSite)this.getSite()).getSecondaryId();
        if (secondaryId != null) {
            String defaultTitle = this.getPartName();
            this.setPartName(String.valueOf(defaultTitle) + " " + secondaryId);
        }
        this.addDragSupport();
        this.addDropSupport();
    }

    protected PageBook doCreatePageBookControl(Composite parent) {
        return new PageBook(parent, 0);
    }

    protected void doConfigurePageBookControl(PageBook pagebook) {
        Assert.isNotNull((Object)pagebook);
        if (this.getContextHelpId() != null) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)pagebook, this.getContextHelpId());
        }
    }

    @Override
    public String getContextHelpId() {
        return this.getViewSite().getId();
    }

    protected Control doCreateEmptyPageControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        return composite;
    }

    protected void doConfigureEmptyPageControl(Control control) {
        Assert.isNotNull((Object)control);
    }

    protected CTabFolder doCreateTabFolderControl(Composite parent) {
        return new CTabFolder(parent, 0x900808);
    }

    protected void doConfigureTabFolderControl(final CTabFolder tabFolder) {
        Assert.isNotNull((Object)tabFolder);
        tabFolder.setLayoutData((Object)new GridData(1808));
        if (this.useGradientTabBackgroundColor()) {
            tabFolder.setSelectionBackground(new Color[]{JFaceResources.getColorRegistry().get("org.eclipse.ui.workbench.ACTIVE_TAB_BG_START"), JFaceResources.getColorRegistry().get("org.eclipse.ui.workbench.ACTIVE_TAB_BG_END")}, new int[]{100}, true);
        }
        tabFolder.setSelectionForeground(JFaceResources.getColorRegistry().get("org.eclipse.ui.workbench.ACTIVE_TAB_TEXT_COLOR"));
        tabFolder.setSimple(PlatformUI.getPreferenceStore().getBoolean("SHOW_TRADITIONAL_STYLE_TABS"));
        tabFolder.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                CTabItem item;
                if (e.button == 2 && (item = tabFolder.getItem(new Point(e.x, e.y))) != null) {
                    item.dispose();
                }
            }
        });
    }

    protected boolean useGradientTabBackgroundColor() {
        return false;
    }

    protected TabFolderManager doCreateTabFolderManager(ITerminalsView parentView) {
        Assert.isNotNull((Object)parentView);
        return new TabFolderManager(parentView);
    }

    protected TabFolderMenuHandler doCreateTabFolderMenuHandler(ITerminalsView parentView) {
        Assert.isNotNull((Object)parentView);
        return new TabFolderMenuHandler(parentView);
    }

    protected void doConfigureTabFolderMenuHandler(TabFolderMenuHandler menuHandler) {
        Assert.isNotNull((Object)((Object)menuHandler));
        menuHandler.initialize();
    }

    protected TabFolderToolbarHandler doCreateTabFolderToolbarHandler(ITerminalsView parentView) {
        Assert.isNotNull((Object)parentView);
        return new TabFolderToolbarHandler(parentView);
    }

    protected void doConfigureTabFolderToolbarHandler(TabFolderToolbarHandler toolbarHandler) {
        Assert.isNotNull((Object)((Object)toolbarHandler));
        toolbarHandler.initialize();
    }

    public void setFocus() {
        if (this.pageBookControl != null) {
            this.pageBookControl.setFocus();
        }
    }

    @Override
    public void switchToEmptyPageControl() {
        if (this.pageBookControl != null && !this.pageBookControl.isDisposed() && this.emptyPageControl != null && !this.emptyPageControl.isDisposed()) {
            this.pageBookControl.showPage(this.emptyPageControl);
        }
    }

    @Override
    public void switchToTabFolderControl() {
        if (this.pageBookControl != null && !this.pageBookControl.isDisposed() && this.tabFolderControl != null && !this.tabFolderControl.isDisposed()) {
            this.pageBookControl.showPage((Control)this.tabFolderControl);
        }
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (CTabFolder.class.isAssignableFrom(adapter)) {
            return adapter.cast(this.tabFolderControl);
        }
        if (TabFolderManager.class.isAssignableFrom(adapter)) {
            return adapter.cast((Object)this.tabFolderManager);
        }
        if (TabFolderMenuHandler.class.isAssignableFrom(adapter)) {
            return adapter.cast((Object)this.tabFolderMenuHandler);
        }
        if (TabFolderToolbarHandler.class.isAssignableFrom(adapter)) {
            return adapter.cast((Object)this.tabFolderToolbarHandler);
        }
        if (TerminalsViewMementoHandler.class.isAssignableFrom(adapter)) {
            return adapter.cast(this.mementoHandler);
        }
        return (T)super.getAdapter(adapter);
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
        if (memento == null) {
            return;
        }
        this.mementoHandler.saveState(this, memento);
    }

    public void restoreState(IMemento memento) {
        if (memento == null) {
            return;
        }
        this.mementoHandler.restoreState(this, memento);
    }

    public boolean show(ShowInContext context) {
        if (context != null) {
            Bundle bundle;
            Object input;
            ISelection selection = context.getSelection();
            if ((!(selection instanceof IStructuredSelection) || selection.isEmpty()) && "org.eclipse.egit.ui.internal.history.HistoryPageInput".equals((input = context.getInput()).getClass().getName()) && (bundle = Platform.getBundle((String)"org.eclipse.egit.ui")) != null && bundle.getState() != 1 && bundle.getState() != 16) {
                selection = GitShowInContextHandler.getSelection(input);
            }
            if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
                boolean isValid = true;
                ArrayList<Object> elements = new ArrayList<Object>();
                Iterator iterator = ((IStructuredSelection)selection).iterator();
                while (iterator.hasNext() && isValid) {
                    Object element = iterator.next();
                    Object adapted = null;
                    if (element instanceof File) {
                        if (elements.contains(element)) continue;
                        elements.add(element);
                        continue;
                    }
                    Object object = adapted = element instanceof IAdaptable ? ((IAdaptable)element).getAdapter(File.class) : null;
                    if (adapted == null) {
                        adapted = Platform.getAdapterManager().getAdapter(element, File.class);
                    }
                    if (adapted == null) {
                        adapted = Platform.getAdapterManager().loadAdapter(element, File.class.getName());
                    }
                    if (adapted != null) {
                        if (elements.contains(adapted)) continue;
                        elements.add(adapted);
                        continue;
                    }
                    if (element instanceof IPath) {
                        if (elements.contains(element)) continue;
                        elements.add(element);
                        continue;
                    }
                    Object object2 = adapted = element instanceof IAdaptable ? ((IAdaptable)element).getAdapter(IPath.class) : null;
                    if (adapted == null) {
                        adapted = Platform.getAdapterManager().getAdapter(element, IPath.class);
                    }
                    if (adapted == null) {
                        adapted = Platform.getAdapterManager().loadAdapter(element, IPath.class.getName());
                    }
                    if (adapted != null) {
                        if (elements.contains(adapted)) continue;
                        elements.add(adapted);
                        continue;
                    }
                    Bundle bundle2 = Platform.getBundle((String)"org.eclipse.core.resources");
                    if (bundle2 != null && bundle2.getState() != 1 && bundle2.getState() != 16) {
                        if (element instanceof IResource) {
                            if (elements.contains(element)) continue;
                            elements.add(element);
                            continue;
                        }
                        Object object3 = adapted = element instanceof IAdaptable ? ((IAdaptable)element).getAdapter(IResource.class) : null;
                        if (adapted == null) {
                            adapted = Platform.getAdapterManager().getAdapter(element, IResource.class);
                        }
                        if (adapted == null) {
                            adapted = Platform.getAdapterManager().loadAdapter(element, IResource.class.getName());
                        }
                    }
                    if (adapted != null) {
                        if (elements.contains(adapted)) continue;
                        elements.add(adapted);
                        continue;
                    }
                    if (element.getClass().getName().startsWith("org.eclipse.egit.ui.internal.repository.tree") && (bundle2 = Platform.getBundle((String)"org.eclipse.egit.ui")) != null && bundle2.getState() != 1 && bundle2.getState() != 16) {
                        adapted = GitShowInContextHandler.getPath(element);
                    }
                    if (adapted != null) {
                        if (elements.contains(adapted)) continue;
                        elements.add(adapted);
                        continue;
                    }
                    isValid = false;
                }
                if (isValid) {
                    block23: {
                        Command command;
                        selection = new StructuredSelection(elements);
                        ICommandService service = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
                        Command command2 = command = service != null ? service.getCommand("org.eclipse.tm.terminal.connector.local.command.launch") : null;
                        if (command != null && command.isDefined() && command.isEnabled()) {
                            try {
                                ParameterizedCommand pCmd = ParameterizedCommand.generateCommand((Command)command, null);
                                Assert.isNotNull((Object)pCmd);
                                IHandlerService handlerSvc = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
                                Assert.isNotNull((Object)handlerSvc);
                                IEvaluationContext ctx = handlerSvc.getCurrentState();
                                ctx = new EvaluationContext(ctx, (Object)selection);
                                ctx.addVariable("selection", (Object)selection);
                                handlerSvc.executeCommandInContext(pCmd, null, ctx);
                            }
                            catch (Exception e) {
                                if (!Platform.inDebugMode()) break block23;
                                Status status = new Status(4, UIPlugin.getUniqueIdentifier(), Messages.AbstractTriggerCommandHandler_error_executionFailed, (Throwable)e);
                                UIPlugin.getDefault().getLog().log((IStatus)status);
                            }
                        }
                    }
                    return true;
                }
            }
        }
        return false;
    }

    private static class TerminalTransfer
    extends ByteArrayTransfer {
        private static final String TYPE_NAME = "terminal-transfer-format:" + UUID.randomUUID().toString();
        private static final int TYPEID = TerminalTransfer.registerType((String)TYPE_NAME);
        private CTabItem draggedFolderItem;
        private TabFolderManager draggedTabFolderManager;

        TerminalTransfer() {
        }

        public static TerminalTransfer getInstance() {
            return LazyInstanceHolder.instance;
        }

        public void setDraggedFolderItem(CTabItem tabFolderItem) {
            this.draggedFolderItem = tabFolderItem;
        }

        public CTabItem getDraggedFolderItem() {
            return this.draggedFolderItem;
        }

        public void setTabFolderManager(TabFolderManager tabFolderManager) {
            this.draggedTabFolderManager = tabFolderManager;
        }

        public TabFolderManager getTabFolderManager() {
            return this.draggedTabFolderManager;
        }

        protected int[] getTypeIds() {
            return new int[]{TYPEID};
        }

        protected String[] getTypeNames() {
            return new String[]{TYPE_NAME};
        }

        public void javaToNative(Object data, TransferData transferData) {
        }

        public Object nativeToJava(TransferData transferData) {
            return null;
        }

        private static class LazyInstanceHolder {
            public static TerminalTransfer instance = new TerminalTransfer();

            private LazyInstanceHolder() {
            }
        }
    }
}

