/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.internal;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngineOptions;
import org.eclipse.viatra.query.runtime.matchers.backend.IQueryBackendFactory;
import org.eclipse.viatra.query.runtime.matchers.backend.IQueryBackendFactoryProvider;
import org.eclipse.viatra.query.runtime.util.ViatraQueryLoggingUtil;

public class ExtensionBasedSystemDefaultBackendLoader {
    private static final String EXTENSION_ID = "org.eclipse.viatra.query.runtime.querybackend";
    private static final ExtensionBasedSystemDefaultBackendLoader INSTANCE = new ExtensionBasedSystemDefaultBackendLoader();

    public static ExtensionBasedSystemDefaultBackendLoader instance() {
        return INSTANCE;
    }

    public void loadKnownBackends() {
        IConfigurationElement[] config;
        IQueryBackendFactory defaultBackend = null;
        IQueryBackendFactory defaultCachingBackend = null;
        IQueryBackendFactory defaultSearchBackend = null;
        IConfigurationElement[] iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_ID);
        int n = config.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement e = iConfigurationElementArray[n2];
            try {
                IQueryBackendFactoryProvider provider = (IQueryBackendFactoryProvider)e.createExecutableExtension("provider");
                if (provider.isSystemDefaultEngine()) {
                    defaultBackend = provider.getFactory();
                }
                if (provider.isSystemDefaultCachingBackend()) {
                    defaultCachingBackend = provider.getFactory();
                }
                if (provider.isSystemDefaultSearchBackend()) {
                    defaultSearchBackend = provider.getFactory();
                }
            }
            catch (CoreException ex) {
                ViatraQueryLoggingUtil.getLogger(this.getClass()).error((Object)String.format("Error while initializing backend %s from plugin %s.", e.getAttribute("backend"), e.getContributor().getName()), (Throwable)ex);
            }
            ++n2;
        }
        ViatraQueryEngineOptions.setSystemDefaultBackends(defaultBackend, defaultCachingBackend, defaultSearchBackend);
    }
}

