/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.eval.evaluators;

import java.lang.reflect.Field;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wb.core.eval.AstEvaluationEngine;
import org.eclipse.wb.core.eval.EvaluationContext;
import org.eclipse.wb.core.eval.IExpressionEvaluator;
import org.eclipse.wb.internal.core.utils.ast.AstNodeUtils;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;

public final class FieldAccessEvaluator
implements IExpressionEvaluator {
    public Object evaluate(EvaluationContext context, Expression expression, ITypeBinding typeBinding, String typeQualifiedName) throws Exception {
        if (expression instanceof FieldAccess) {
            FieldAccess fieldAccess = (FieldAccess)expression;
            String fieldName = fieldAccess.getName().getIdentifier();
            Expression fieldAccessExpression = fieldAccess.getExpression();
            if (fieldAccessExpression instanceof ThisExpression) {
                TypeDeclaration typeDeclaration = AstNodeUtils.getEnclosingType((ASTNode)expression);
                VariableDeclarationFragment fragment = AstNodeUtils.getFieldFragmentByName(typeDeclaration, fieldName);
                Assert.isNotNull((Object)fragment);
                Expression fieldInitializer = fragment.getInitializer();
                if (fieldInitializer == null) {
                    FieldDeclaration fieldDeclaration = AstNodeUtils.getEnclosingNode((ASTNode)fragment, FieldDeclaration.class);
                    String className = AstNodeUtils.getFullyQualifiedName(fieldDeclaration.getType(), true);
                    return ReflectionUtils.getDefaultValue((String)className);
                }
                return AstEvaluationEngine.evaluate(context, fieldInitializer);
            }
            String expressionClassName = AstNodeUtils.getFullyQualifiedName(fieldAccessExpression, true);
            Class<?> expressionClass = context.getClassLoader().loadClass(expressionClassName);
            Object expressionValue = AstEvaluationEngine.evaluate(context, fieldAccessExpression);
            Field field = ReflectionUtils.getFieldByName(expressionClass, (String)fieldName);
            Assert.isNotNull((Object)field);
            return field.get(expressionValue);
        }
        return AstEvaluationEngine.UNKNOWN;
    }
}

