/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.componentcore.internal.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;

public class ZipFileExporter {
    private ZipOutputStream outputStream;
    private boolean useCompression = true;

    public ZipFileExporter(String filename, boolean compress) throws IOException {
        Path directoryPath = new Path(filename);
        directoryPath = (Path)directoryPath.removeLastSegments(1);
        File newZipFile = new File(directoryPath.toString());
        newZipFile.mkdirs();
        this.outputStream = new ZipOutputStream(new FileOutputStream(filename));
        this.useCompression = compress;
    }

    public void finished() throws IOException {
        this.outputStream.close();
    }

    protected void write(String pathname, byte[] contents) throws IOException {
        ZipEntry newEntry = new ZipEntry(pathname);
        if (!this.useCompression) {
            newEntry.setMethod(0);
            newEntry.setSize(contents.length);
            CRC32 checksumCalculator = new CRC32();
            checksumCalculator.update(contents);
            newEntry.setCrc(checksumCalculator.getValue());
        }
        this.outputStream.putNextEntry(newEntry);
        this.outputStream.write(contents);
        this.outputStream.closeEntry();
    }

    public void writeFolder(String destinationPath) throws IOException {
        if (!destinationPath.endsWith("/")) {
            destinationPath = String.valueOf(destinationPath) + '/';
        }
        ZipEntry newEntry = new ZipEntry(destinationPath);
        this.outputStream.putNextEntry(newEntry);
        this.outputStream.closeEntry();
    }

    public void write(IFile resource, String destinationPath) throws IOException, CoreException {
        try (InputStream contentStream = null;){
            contentStream = resource.getContents(false);
            this.write(contentStream, destinationPath);
        }
    }

    public void write(InputStream contentStream, String destinationPath) throws IOException, CoreException {
        try (ByteArrayOutputStream output = null;){
            output = new ByteArrayOutputStream();
            int chunkSize = contentStream.available();
            byte[] readBuffer = new byte[chunkSize];
            int n = contentStream.read(readBuffer);
            while (n > 0) {
                output.write(readBuffer);
                n = contentStream.read(readBuffer);
            }
        }
        this.write(destinationPath, output.toByteArray());
    }
}

