/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.internal.ui.breakpoints;

import org.eclipse.cdt.debug.core.CDIDebugModel;
import org.eclipse.cdt.debug.core.model.ICAddressBreakpoint;
import org.eclipse.cdt.debug.core.model.ICBreakpoint;
import org.eclipse.cdt.debug.core.model.ICDynamicPrintf;
import org.eclipse.cdt.debug.core.model.ICFunctionBreakpoint;
import org.eclipse.cdt.debug.internal.ui.breakpoints.BreakpointsMessages;
import org.eclipse.cdt.debug.internal.ui.breakpoints.CBreakpointContext;
import org.eclipse.cdt.debug.internal.ui.breakpoints.CBreakpointPreferenceStore;
import org.eclipse.cdt.debug.ui.breakpoints.ICBreakpointContext;
import org.eclipse.cdt.debug.ui.preferences.ReadOnlyFieldEditor;
import org.eclipse.cdt.dsf.gdb.breakpoints.GDBDynamicPrintfUtils;
import org.eclipse.cdt.dsf.gdb.internal.ui.breakpoints.Messages;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugModelProvider;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.contexts.IDebugContextProvider;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class GDBDynamicPrintfPropertyPage
extends FieldEditorPreferencePage
implements IWorkbenchPropertyPage {
    private BooleanFieldEditor fEnabled;
    private DynamicPrintfStringFieldEditor fCondition;
    private Text fIgnoreCountTextControl;
    private DynamicPrintfIntegerFieldEditor fLineEditor;
    private DynamicPrintfIntegerFieldEditor fIgnoreCount;
    private boolean fDuplicateBreakpoint;
    private DynamicPrintfStringFieldEditor fPrintString;
    private IAdaptable fElement;
    private CBreakpointPreferenceStore fDynamicPrintfPreferenceStore;

    public GDBDynamicPrintfPropertyPage() {
        super(1);
        this.noDefaultAndApplyButton();
    }

    protected void createFieldEditors() {
        ICDynamicPrintf dprintf = this.getDprintf();
        this.createMainLabel(dprintf);
        this.createTypeSpecificLabelFieldEditors(dprintf);
        this.createEnabledField(this.getFieldEditorParent());
        this.createConditionEditor(this.getFieldEditorParent());
        this.createIgnoreCountEditor(this.getFieldEditorParent());
        this.createPrintStringEditor(this.getFieldEditorParent());
    }

    private void createMainLabel(ICDynamicPrintf dprintf) {
        this.addField(this.createLabelEditor(this.getFieldEditorParent(), Messages.PropertyPage_Class, this.getDynamicPrintfMainLabel(dprintf)));
    }

    private void createTypeSpecificLabelFieldEditors(ICDynamicPrintf dprintf) {
        if (dprintf instanceof ICFunctionBreakpoint) {
            this.createFunctionEditor(this.getFieldEditorParent());
        } else if (dprintf instanceof ICAddressBreakpoint) {
            String address = this.getPreferenceStore().getString("org.eclipse.cdt.debug.core.address");
            if (address == null || address.trim().length() == 0) {
                address = Messages.PropertyPage_NotAvailable;
            }
            this.addField(this.createLabelEditor(this.getFieldEditorParent(), Messages.PropertyPage_Address, address));
        } else {
            int lNumber;
            String fileName = this.getPreferenceStore().getString("org.eclipse.cdt.debug.core.sourceHandle");
            if (fileName != null) {
                this.addField(this.createLabelEditor(this.getFieldEditorParent(), Messages.PropertyPage_File, fileName));
            }
            if ((lNumber = this.getPreferenceStore().getInt("lineNumber")) > 0) {
                this.createLineNumberEditor(this.getFieldEditorParent());
            }
        }
    }

    private String getDynamicPrintfMainLabel(ICDynamicPrintf dprintf) {
        IWorkbenchAdapter labelProvider = (IWorkbenchAdapter)this.getElement().getAdapter(IWorkbenchAdapter.class);
        if (labelProvider != null) {
            return labelProvider.getLabel((Object)this.getElement());
        }
        return CDIDebugModel.calculateMarkerType((IBreakpoint)dprintf);
    }

    protected void createFunctionEditor(Composite parent) {
        ICDynamicPrintf dprintf = this.getDprintf();
        if (dprintf == null || dprintf.getMarker() == null) {
            DynamicPrintfStringFieldEditor expressionEditor = new DynamicPrintfStringFieldEditor("org.eclipse.cdt.debug.core.function", Messages.PropertyPage_FunctionName, parent);
            expressionEditor.setErrorMessage(Messages.PropertyPage_function_value_errorMessage);
            expressionEditor.setEmptyStringAllowed(false);
            this.addField((FieldEditor)expressionEditor);
        } else {
            String function = this.getPreferenceStore().getString("org.eclipse.cdt.debug.core.function");
            if (function == null) {
                function = Messages.PropertyPage_NotAvailable;
            }
            this.addField(this.createLabelEditor(this.getFieldEditorParent(), Messages.PropertyPage_FunctionName, function));
        }
    }

    protected void createLineNumberEditor(Composite parent) {
        String title = Messages.PropertyPage_LineNumber;
        this.fLineEditor = new DynamicPrintfIntegerFieldEditor("lineNumber", title, parent);
        this.fLineEditor.setValidRange(1, Integer.MAX_VALUE);
        this.fLineEditor.setErrorMessage(Messages.PropertyPage_lineNumber_errorMessage);
        this.addField((FieldEditor)this.fLineEditor);
    }

    protected void createEnabledField(Composite parent) {
        this.fEnabled = new BooleanFieldEditor("org.eclipse.debug.core.enabled", Messages.PropertyPage_Enabled, parent);
        this.addField((FieldEditor)this.fEnabled);
    }

    protected void createConditionEditor(Composite parent) {
        this.fCondition = new DynamicPrintfStringFieldEditor("org.eclipse.cdt.debug.core.condition", Messages.PropertyPage_Condition, parent);
        this.fCondition.setEmptyStringAllowed(true);
        this.fCondition.setErrorMessage(Messages.PropertyPage_InvalidCondition);
        this.addField((FieldEditor)this.fCondition);
    }

    protected void createIgnoreCountEditor(Composite parent) {
        this.fIgnoreCount = new DynamicPrintfIntegerFieldEditor("org.eclipse.cdt.debug.core.ignoreCount", Messages.PropertyPage_IgnoreCount, parent);
        this.fIgnoreCount.setValidRange(0, Integer.MAX_VALUE);
        this.fIgnoreCountTextControl = this.fIgnoreCount.getTextControl(parent);
        this.fIgnoreCountTextControl.setEnabled(this.getPreferenceStore().getInt("org.eclipse.cdt.debug.core.ignoreCount") >= 0);
        this.addField((FieldEditor)this.fIgnoreCount);
    }

    protected void createPrintStringEditor(Composite parent) {
        this.fPrintString = new DynamicPrintfStringFieldEditor(this, "org.eclipse.cdt.debug.core.printf_string", Messages.DynamicPrintfPropertyPage_PrintString, parent){

            protected boolean doCheckState() {
                GDBDynamicPrintfUtils.GDBDynamicPrintfString parsedStr = new GDBDynamicPrintfUtils.GDBDynamicPrintfString(this.getTextControl().getText());
                boolean valid = parsedStr.isValid();
                if (!valid) {
                    this.setErrorMessage(parsedStr.getErrorMessage());
                }
                return valid;
            }
        };
        this.addField((FieldEditor)this.fPrintString);
    }

    public boolean isValid() {
        return super.isValid() && !this.fDuplicateBreakpoint;
    }

    public void propertyChange(PropertyChangeEvent event) {
        super.propertyChange(event);
        ICDynamicPrintf currentBp = this.getDprintf();
        if (!(currentBp instanceof ICFunctionBreakpoint) && !(currentBp instanceof ICAddressBreakpoint) && event.getProperty().equals("field_editor_value") && super.isValid()) {
            boolean oldValue = this.fDuplicateBreakpoint;
            this.fDuplicateBreakpoint = this.isDuplicateBreakpoint();
            if (oldValue != this.fDuplicateBreakpoint) {
                if (this.fDuplicateBreakpoint) {
                    this.setErrorMessage(BreakpointsMessages.getString((String)"CBreakpointPropertyPage.breakpoint_already_exists_errorMessage"));
                } else {
                    this.setErrorMessage(null);
                }
                if (this.getContainer() != null) {
                    this.getContainer().updateButtons();
                }
                this.updateApplyButton();
            }
        }
    }

    private boolean isDuplicateBreakpoint() {
        IBreakpoint[] breakpoints;
        String source = this.getPreferenceStore().getString("org.eclipse.cdt.debug.core.sourceHandle");
        int line = this.fLineEditor.getIntValue();
        ICDynamicPrintf currentBp = this.getDprintf();
        IBreakpoint[] iBreakpointArray = breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints();
        int n = breakpoints.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker marker;
            IBreakpoint bp = iBreakpointArray[n2];
            if (!bp.equals(currentBp) && bp instanceof ICBreakpoint && (marker = bp.getMarker()) != null) {
                String markerFile = marker.getAttribute("org.eclipse.cdt.debug.core.sourceHandle", "");
                int markerLine = marker.getAttribute("lineNumber", -1);
                if (source.equals(markerFile) && line == markerLine) {
                    return true;
                }
            }
            ++n2;
        }
        return false;
    }

    protected FieldEditor createLabelEditor(Composite parent, String title, String value) {
        return new LabelFieldEditor(parent, title, value);
    }

    protected ICDynamicPrintf getDprintf() {
        IAdaptable element = this.getElement();
        if (element instanceof ICDynamicPrintf) {
            return (ICDynamicPrintf)element;
        }
        if (element instanceof ICBreakpointContext) {
            ICBreakpoint breakpoint = ((ICBreakpointContext)element).getBreakpoint();
            if (breakpoint instanceof ICDynamicPrintf) {
                return (ICDynamicPrintf)breakpoint;
            }
            assert (false) : "Should always have a dprintf";
        }
        return (ICDynamicPrintf)element.getAdapter(ICDynamicPrintf.class);
    }

    protected Object getDebugContext() {
        IDebugContextProvider provider = (IDebugContextProvider)this.getElement().getAdapter(IDebugContextProvider.class);
        if (provider != null) {
            ISelection selection = provider.getActiveContext();
            if (selection instanceof IStructuredSelection) {
                return ((IStructuredSelection)selection).getFirstElement();
            }
            return null;
        }
        return DebugUITools.getDebugContext();
    }

    protected IResource getResource() {
        IAdaptable element = this.getElement();
        if (element instanceof ICDynamicPrintf) {
            IMarker marker = ((ICDynamicPrintf)element).getMarker();
            if (marker != null) {
                return marker.getResource();
            }
        } else if (element instanceof ICBreakpointContext) {
            return ((ICBreakpointContext)element).getResource();
        }
        return null;
    }

    public IPreferenceStore getPreferenceStore() {
        IAdaptable element = this.getElement();
        if (element instanceof ICBreakpointContext) {
            return ((ICBreakpointContext)element).getPreferenceStore();
        }
        if (this.fDynamicPrintfPreferenceStore == null) {
            CBreakpointContext bpContext = element instanceof CBreakpointContext ? (CBreakpointContext)element : null;
            this.fDynamicPrintfPreferenceStore = new CBreakpointPreferenceStore(bpContext, null);
        }
        return this.fDynamicPrintfPreferenceStore;
    }

    public boolean performCancel() {
        IPreferenceStore store = this.getPreferenceStore();
        if (store instanceof CBreakpointPreferenceStore) {
            ((CBreakpointPreferenceStore)store).setCanceled(true);
        }
        return super.performCancel();
    }

    public boolean performOk() {
        IPreferenceStore store = this.getPreferenceStore();
        if (store instanceof CBreakpointPreferenceStore) {
            ((CBreakpointPreferenceStore)store).setCanceled(false);
        }
        return super.performOk();
    }

    public IAdaptable getElement() {
        return this.fElement;
    }

    public void setElement(IAdaptable element) {
        this.fElement = element instanceof ICBreakpoint ? new CBreakpointContext((ICBreakpoint)element, null) : element;
    }

    protected String[] getDebugModelIds() {
        String[] debugModelIds = null;
        Object debugContext = this.getDebugContext();
        IDebugModelProvider debugModelProvider = (IDebugModelProvider)DebugPlugin.getAdapter((Object)debugContext, IDebugModelProvider.class);
        if (debugModelProvider != null) {
            debugModelIds = debugModelProvider.getModelIdentifiers();
        } else if (debugContext instanceof IDebugElement) {
            debugModelIds = new String[]{((IDebugElement)debugContext).getModelIdentifier()};
        }
        return debugModelIds;
    }

    private class DynamicPrintfIntegerFieldEditor
    extends IntegerFieldEditor {
        public DynamicPrintfIntegerFieldEditor(String name, String labelText, Composite parent) {
            super(name, labelText, parent);
            this.setErrorMessage(Messages.PropertyPage_integer_negative);
        }

        protected boolean checkState() {
            Text control = this.getTextControl();
            if (!control.isEnabled()) {
                this.clearErrorMessage();
                return true;
            }
            return super.checkState();
        }

        protected void doStore() {
            Text text = this.getTextControl();
            if (text.isEnabled()) {
                super.doStore();
            }
        }

        protected void clearErrorMessage() {
            if (this.getPage() != null) {
                String message = this.getPage().getErrorMessage();
                if (message != null) {
                    if (this.getErrorMessage().equals(message)) {
                        super.clearErrorMessage();
                    }
                } else {
                    super.clearErrorMessage();
                }
            }
        }
    }

    class DynamicPrintfStringFieldEditor
    extends StringFieldEditor {
        public DynamicPrintfStringFieldEditor(String name, String labelText, Composite parent) {
            super(name, labelText, parent);
        }

        protected boolean checkState() {
            Text control = this.getTextControl();
            if (!control.isEnabled()) {
                this.clearErrorMessage();
                return true;
            }
            return super.checkState();
        }

        protected void doStore() {
            Text text = this.getTextControl();
            if (text.isEnabled()) {
                super.doStore();
            }
        }

        protected void doLoad() {
            String value = this.getPreferenceStore().getString(this.getPreferenceName());
            this.setStringValue(value);
        }

        protected void clearErrorMessage() {
            if (this.getPage() != null) {
                String message = this.getPage().getErrorMessage();
                if (message != null) {
                    if (this.getErrorMessage().equals(message)) {
                        super.clearErrorMessage();
                    }
                } else {
                    super.clearErrorMessage();
                }
            }
        }
    }

    private class LabelFieldEditor
    extends ReadOnlyFieldEditor {
        private String fValue;

        public LabelFieldEditor(Composite parent, String title, String value) {
            super(title, title, parent);
            this.fValue = value;
        }

        protected void doLoad() {
            if (this.textField != null) {
                this.textField.setText(this.fValue);
            }
        }

        protected void doLoadDefault() {
        }
    }
}

