/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.emf.ui.internal.common.component;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.resources.IProject;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.tools.emf.ui.common.ImageTooltip;
import org.eclipse.e4.tools.emf.ui.common.Util;
import org.eclipse.e4.tools.emf.ui.common.component.AbstractComponentEditor;
import org.eclipse.e4.tools.emf.ui.internal.E4Properties;
import org.eclipse.e4.tools.emf.ui.internal.common.VirtualEntry;
import org.eclipse.e4.tools.emf.ui.internal.common.component.ControlFactory;
import org.eclipse.e4.tools.emf.ui.internal.common.component.UnsettableUpdateValueStrategy;
import org.eclipse.e4.tools.emf.ui.internal.common.component.dialogs.WindowIconDialogEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.uistructure.UIViewer;
import org.eclipse.e4.ui.model.application.commands.MHandler;
import org.eclipse.e4.ui.model.application.impl.ApplicationPackageImpl;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.MUILabel;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.basic.impl.BasicPackageImpl;
import org.eclipse.e4.ui.model.application.ui.impl.UiPackageImpl;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuFactory;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.databinding.EMFDataBindingContext;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.databinding.swt.IWidgetValueProperty;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class WindowEditor
extends AbstractComponentEditor<MWindow> {
    private Composite composite;
    private EMFDataBindingContext context;
    private Action addMainMenu;
    private Button createRemoveMainMenu;
    private StackLayout stackLayout;
    @Inject
    @Optional
    private IProject project;
    @Inject
    IEclipseContext eclipseContext;

    @Inject
    public WindowEditor() {
    }

    @PostConstruct
    void init() {
        this.addMainMenu = new Action(this.Messages.WindowEditor_AddMainMenu){

            public void run() {
                WindowEditor.this.addMenu();
            }
        };
    }

    @Override
    public Image getImage(Object element) {
        return this.getImage(element, "IMG_org.eclipse.e4.tools.emf.ui.modelelements.Window");
    }

    @Override
    public String getLabel(Object element) {
        return this.Messages.WindowEditor_TreeLabel;
    }

    @Override
    public String getDescription(Object element) {
        return this.Messages.WindowEditor_TreeLabelDescription;
    }

    @Override
    public Composite doGetEditor(Composite parent, Object object) {
        Control topControl;
        if (this.composite == null) {
            this.context = new EMFDataBindingContext();
            if (this.getEditor().isModelFragment()) {
                this.composite = new Composite(parent, 0);
                this.stackLayout = new StackLayout();
                this.composite.setLayout((Layout)this.stackLayout);
                this.createForm(this.composite, this.context, this.getMaster(), false);
                this.createForm(this.composite, this.context, this.getMaster(), true);
            } else {
                this.composite = this.createForm(parent, this.context, this.getMaster(), false);
            }
        }
        if (this.getEditor().isModelFragment() && this.stackLayout.topControl != (topControl = Util.isImport((EObject)object) ? this.composite.getChildren()[1] : this.composite.getChildren()[0])) {
            this.stackLayout.topControl = topControl;
            this.composite.requestLayout();
        }
        if (this.createRemoveMainMenu != null) {
            this.createRemoveMainMenu.setSelection(((MWindow)object).getMainMenu() != null);
        }
        this.getMaster().setValue((Object)((MWindow)object));
        this.enableIdGenerator(UiPackageImpl.Literals.UI_LABEL__LABEL, ApplicationPackageImpl.Literals.APPLICATION_ELEMENT__ELEMENT_ID, null);
        return this.composite;
    }

    private Composite createForm(Composite parent, EMFDataBindingContext context, WritableValue<MWindow> master, boolean isImport) {
        CTabFolder folder = new CTabFolder(parent, 1024);
        CTabItem item = new CTabItem(folder, 0);
        item.setText(this.Messages.ModelTooling_Common_TabDefault);
        parent = this.createScrollableContainer((Composite)folder);
        item.setControl((Control)parent.getParent());
        if (this.getEditor().isShowXMIId() || this.getEditor().isLiveModel()) {
            ControlFactory.createXMIId(parent, this);
        }
        IWidgetValueProperty textProp = WidgetProperties.text((int)24);
        if (isImport) {
            ControlFactory.createFindImport(parent, this.Messages, this, context);
            folder.setSelection(0);
            return folder;
        }
        ControlFactory.createTextField(parent, this.Messages.ModelTooling_Common_Id, this.getMaster(), context, (IWidgetValueProperty<Text, String>)textProp, E4Properties.elementId(this.getEditingDomain()));
        Label l = new Label(parent, 0);
        l.setText(this.Messages.WindowEditor_Bounds);
        l.setLayoutData((Object)new GridData());
        Composite comp = new Composite(parent, 0);
        GridLayout layout = new GridLayout(4, true);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        comp.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        comp.setLayoutData((Object)gd);
        Text t = new Text(comp, 133120);
        t.setLayoutData((Object)new GridData(768));
        context.bindValue((IObservableValue)textProp.observeDelayed(200, (Widget)t), E4Properties.windowX(this.getEditingDomain()).observeDetail(this.getMaster()), UnsettableUpdateValueStrategy.create(), UnsettableUpdateValueStrategy.create());
        t = new Text(comp, 133120);
        t.setLayoutData((Object)new GridData(768));
        context.bindValue((IObservableValue)textProp.observeDelayed(200, (Widget)t), E4Properties.windowY(this.getEditingDomain()).observeDetail(this.getMaster()), UnsettableUpdateValueStrategy.create(), UnsettableUpdateValueStrategy.create());
        t = new Text(comp, 133120);
        t.setLayoutData((Object)new GridData(768));
        context.bindValue((IObservableValue)textProp.observeDelayed(200, (Widget)t), E4Properties.width(this.getEditingDomain()).observeDetail(this.getMaster()), UnsettableUpdateValueStrategy.create(), UnsettableUpdateValueStrategy.create());
        t = new Text(comp, 133120);
        t.setLayoutData((Object)new GridData(768));
        context.bindValue((IObservableValue)textProp.observeDelayed(200, (Widget)t), E4Properties.height(this.getEditingDomain()).observeDetail(this.getMaster()), UnsettableUpdateValueStrategy.create(), UnsettableUpdateValueStrategy.create());
        ControlFactory.createTranslatedTextField(parent, this.Messages.WindowEditor_Label, this.getMaster(), context, (IWidgetValueProperty<? super Text, String>)textProp, E4Properties.label(this.getEditingDomain()), this.resourcePool, this.project);
        ControlFactory.createTranslatedTextField(parent, this.Messages.WindowEditor_Tooltip, this.getMaster(), context, (IWidgetValueProperty<? super Text, String>)textProp, E4Properties.tooltip(this.getEditingDomain()), this.resourcePool, this.project);
        l = new Label(parent, 0);
        l.setText(this.Messages.WindowEditor_IconURI);
        l.setLayoutData((Object)new GridData());
        Text t2 = new Text(parent, 2048);
        t2.setLayoutData((Object)new GridData(768));
        context.bindValue((IObservableValue)textProp.observeDelayed(200, (Widget)t2), E4Properties.iconUri(this.getEditingDomain()).observeDetail(master));
        new ImageTooltip((Control)t2, this.Messages, this);
        final Button b = ControlFactory.createFindButton(parent, this.resourcePool);
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WindowIconDialogEditor dialog = new WindowIconDialogEditor(b.getShell(), WindowEditor.this.eclipseContext, WindowEditor.this.project, WindowEditor.this.getEditingDomain(), (MWindow)WindowEditor.this.getMaster().getValue(), WindowEditor.this.Messages);
                dialog.open();
            }
        });
        l = new Label(parent, 0);
        l.setText(this.Messages.WindowEditor_MainMenu);
        l.setLayoutData((Object)new GridData());
        this.createRemoveMainMenu = new Button(parent, 32);
        this.createRemoveMainMenu.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MWindow window = (MWindow)WindowEditor.this.getMaster().getValue();
                if (window.getMainMenu() == null) {
                    WindowEditor.this.addMenu();
                } else {
                    WindowEditor.this.removeMenu();
                }
            }
        });
        this.createRemoveMainMenu.setLayoutData((Object)new GridData(1, 2, false, false, 2, 1));
        ControlFactory.createCheckBox(parent, this.Messages.ModelTooling_UIElement_ToBeRendered, this.getMaster(), context, (IWidgetValueProperty<Button, Boolean>)WidgetProperties.buttonSelection(), E4Properties.toBeRendered(this.getEditingDomain()));
        ControlFactory.createCheckBox(parent, "Visible", this.getMaster(), context, (IWidgetValueProperty<Button, Boolean>)WidgetProperties.buttonSelection(), E4Properties.visible(this.getEditingDomain()));
        ControlFactory.createSelectedElement(parent, this, context, this.Messages.WindowEditor_SelectedElement);
        ControlFactory.createBindingContextWiget(parent, this.Messages, this, this.Messages.WindowEditor_BindingContexts);
        ControlFactory.createMapProperties(parent, this.Messages, this, this.Messages.ModelTooling_Context_Properties, (EStructuralFeature)UiPackageImpl.Literals.CONTEXT__PROPERTIES, 10);
        item = new CTabItem(folder, 0);
        item.setText(this.Messages.ModelTooling_Common_TabSupplementary);
        parent = this.createScrollableContainer((Composite)folder);
        item.setControl((Control)parent.getParent());
        ControlFactory.createTranslatedTextField(parent, this.Messages.ModelTooling_UIElement_AccessibilityPhrase, this.getMaster(), context, (IWidgetValueProperty<? super Text, String>)textProp, E4Properties.accessibilityPhrase(this.getEditingDomain()), this.resourcePool, this.project);
        ControlFactory.createStringListWidget(parent, this.Messages, this, this.Messages.ModelTooling_Context_Variables, (EStructuralFeature)UiPackageImpl.Literals.CONTEXT__VARIABLES, 10);
        ControlFactory.createStringListWidget(parent, this.Messages, this, this.Messages.CategoryEditor_Tags, (EStructuralFeature)ApplicationPackageImpl.Literals.APPLICATION_ELEMENT__TAGS, 10);
        ControlFactory.createMapProperties(parent, this.Messages, this, this.Messages.ModelTooling_Contribution_PersistedState, (EStructuralFeature)ApplicationPackageImpl.Literals.APPLICATION_ELEMENT__PERSISTED_STATE, 10);
        if (this.project == null) {
            this.createUITreeInspection(folder);
        }
        this.createContributedEditorTabs(folder, context, this.getMaster(), MWindow.class);
        folder.setSelection(0);
        return folder;
    }

    private void createUITreeInspection(CTabFolder folder) {
        CTabItem item = new CTabItem(folder, 0);
        item.setText(this.Messages.ModelTooling_Common_RuntimeWidgetTree);
        Composite container = new Composite((Composite)folder, 0);
        container.setLayout((Layout)new GridLayout());
        item.setControl((Control)container);
        UIViewer objectViewer = new UIViewer();
        TreeViewer viewer = objectViewer.createViewer(container, (EStructuralFeature)UiPackageImpl.Literals.UI_ELEMENT__WIDGET, (IObservableValue<?>)this.getMaster(), this.resourcePool, this.Messages);
        viewer.getControl().setLayoutData((Object)new GridData(1808));
    }

    void removeMenu() {
        Command cmd = SetCommand.create((EditingDomain)this.getEditingDomain(), (Object)this.getMaster().getValue(), (Object)BasicPackageImpl.Literals.WINDOW__MAIN_MENU, null);
        if (cmd.canExecute()) {
            this.getEditingDomain().getCommandStack().execute(cmd);
        }
    }

    void addMenu() {
        MMenu menu = MMenuFactory.INSTANCE.createMenu();
        this.setElementId(menu);
        Command cmd = SetCommand.create((EditingDomain)this.getEditingDomain(), (Object)this.getMaster().getValue(), (Object)BasicPackageImpl.Literals.WINDOW__MAIN_MENU, (Object)menu);
        if (cmd.canExecute()) {
            this.getEditingDomain().getCommandStack().execute(cmd);
        }
    }

    @Override
    public IObservableList<Object> getChildList(Object element) {
        WritableList list = new WritableList();
        if (this.getEditor().isModelFragment() && Util.isImport((EObject)element)) {
            return list;
        }
        MWindow window = (MWindow)element;
        list.add(new VirtualEntry<MWindow, MHandler>("org.eclipse.e4.tools.emf.ui.VIRTUAL_HANDLER", E4Properties.handlers(), window, this.Messages.WindowEditor_Handlers));
        list.add(new VirtualEntry<MWindow, MWindow>("org.eclipse.e4.tools.emf.ui.VIRTUAL_WINDOW_WINDOWS", E4Properties.windowWindows(), window, this.Messages.WindowEditor_Windows));
        list.add(new VirtualEntry("org.eclipse.e4.tools.emf.ui.VIRTUAL_WINDOW_CONTROLS", E4Properties.children(), window, this.Messages.WindowEditor_Controls));
        list.add(new VirtualEntry<MWindow, MUIElement>("org.eclipse.e4.tools.emf.ui.VIRTUAL_WINDOW_SHARED_ELEMENTS", E4Properties.sharedElements(), window, this.Messages.WindowEditor_SharedElements));
        list.add(new VirtualEntry<MWindow, MUIElement>("org.eclipse.e4.tools.emf.ui.VIRTUAL_WINDOW_SNIPPETS", E4Properties.snippets(), window, this.Messages.WindowEditor_Snippets));
        if (window.getMainMenu() != null) {
            list.add(0, (Object)window.getMainMenu());
        }
        E4Properties.mainMenu().observe((Object)window).addValueChangeListener(event -> {
            if (this.createRemoveMainMenu.isDisposed() || this.getMaster().isDisposed()) {
                return;
            }
            if (event.diff.getOldValue() != null) {
                list.remove(event.diff.getOldValue());
                if (this.getMaster().getValue() == element) {
                    this.createRemoveMainMenu.setSelection(false);
                }
            }
            if (event.diff.getNewValue() != null) {
                list.add(0, event.diff.getNewValue());
                if (this.getMaster().getValue() == element) {
                    this.createRemoveMainMenu.setSelection(true);
                }
            }
        });
        return list;
    }

    @Override
    public String getDetailLabel(Object element) {
        return this.getLocalizedLabel((MUILabel)element);
    }

    @Override
    public FeaturePath[] getLabelProperties() {
        return new FeaturePath[]{FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{UiPackageImpl.Literals.UI_LABEL__LABEL}), FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{UiPackageImpl.Literals.UI_LABEL__ICON_URI}), FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{UiPackageImpl.Literals.UI_ELEMENT__TO_BE_RENDERED})};
    }

    @Override
    public List<Action> getActions(Object element) {
        ArrayList<Action> actions = new ArrayList<Action>();
        MWindow window = (MWindow)element;
        if (window.getMainMenu() == null) {
            actions.add(this.getActionAddMainMenu());
        }
        return actions;
    }

    protected Action getActionAddMainMenu() {
        return this.addMainMenu;
    }
}

