/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.mvc.fx.parts;

import com.google.inject.Inject;
import com.google.inject.Injector;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javafx.scene.Node;
import org.eclipse.gef.mvc.fx.models.SnappingModel;
import org.eclipse.gef.mvc.fx.parts.IContentPart;
import org.eclipse.gef.mvc.fx.parts.IFeedbackPart;
import org.eclipse.gef.mvc.fx.parts.IFeedbackPartFactory;
import org.eclipse.gef.mvc.fx.parts.IVisualPart;
import org.eclipse.gef.mvc.fx.parts.SnappingFeedbackPart;

public class DefaultSnappingFeedbackPartFactory
implements IFeedbackPartFactory {
    @Inject
    private Injector injector;

    @Override
    public List<IFeedbackPart<? extends Node>> createFeedbackParts(List<? extends IVisualPart<? extends Node>> targets, Map<Object, Object> contextMap) {
        if (targets == null || targets.isEmpty()) {
            throw new IllegalStateException("Part factory is called without target parts.");
        }
        if (targets.size() > 1) {
            throw new IllegalStateException("Expected a single target part, but got " + targets.size() + ".");
        }
        IContentPart target = (IContentPart)targets.get(0);
        ArrayList<IFeedbackPart<? extends Node>> feedback = new ArrayList<IFeedbackPart<? extends Node>>();
        SnappingModel snappingModel = (SnappingModel)target.getRoot().getViewer().getAdapter(SnappingModel.class);
        List<SnappingModel.SnappingLocation> snappingLocations = snappingModel.getSnappingLocationsFor(target);
        for (SnappingModel.SnappingLocation snappingLocation : snappingLocations) {
            SnappingFeedbackPart fb = (SnappingFeedbackPart)this.injector.getInstance(SnappingFeedbackPart.class);
            fb.setSnappingLocation(snappingLocation);
            feedback.add(fb);
        }
        return feedback;
    }
}

