/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.cmd;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jubula.client.cmd.utils.VersionStringUtils;
import org.eclipse.jubula.client.core.businessprocess.db.TestJobBP;
import org.eclipse.jubula.client.core.businessprocess.db.TestSuiteBP;
import org.eclipse.jubula.client.core.constants.TestExecutionConstants;
import org.eclipse.jubula.client.core.i18n.Messages;
import org.eclipse.jubula.client.core.model.IAUTConfigPO;
import org.eclipse.jubula.client.core.model.IAUTMainPO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.IRefTestSuitePO;
import org.eclipse.jubula.client.core.model.ITestJobPO;
import org.eclipse.jubula.client.core.model.ITestSuitePO;
import org.eclipse.jubula.client.core.model.ProjectVersion;
import org.eclipse.jubula.client.core.persistence.DatabaseConnectionInfo;
import org.eclipse.jubula.client.core.preferences.database.DatabaseConnection;
import org.eclipse.jubula.client.core.preferences.database.DatabaseConnectionConverter;
import org.eclipse.jubula.client.core.preferences.database.H2ConnectionInfo;
import org.eclipse.jubula.client.core.preferences.database.MySQLConnectionInfo;
import org.eclipse.jubula.client.core.preferences.database.OracleConnectionInfo;
import org.eclipse.jubula.client.core.preferences.database.PostGreSQLConnectionInfo;
import org.eclipse.jubula.client.core.utils.FileUtils;
import org.eclipse.jubula.tools.internal.registration.AutIdentifier;
import org.eclipse.jubula.tools.internal.utils.NetUtil;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobConfiguration {
    private static final String CONFIGURATION = "configuration";
    private String m_projectName;
    private ProjectVersion m_projectVersion;
    private String m_db;
    private DatabaseConnectionInfo m_dbConnectionInfo;
    private String m_dbConnectionName;
    private String m_dbuser;
    private String m_dbpw;
    private String m_server;
    private String m_resultDir;
    private String m_autConfigName;
    private String m_noRunOptMode;
    private List<String> m_testSuiteNames = new ArrayList<String>();
    private String m_testJobName;
    private List<ITestSuitePO> m_testSuites = new ArrayList<ITestSuitePO>();
    private List<String> m_incompleteTestSuites = new ArrayList<String>(0);
    private ITestJobPO m_testJob;
    private IAUTConfigPO m_autConfig;
    private AutIdentifier m_autId;
    private IProjectPO m_project;
    private int m_actualTestSuite = 0;
    private String m_dataDir;
    private int m_timeout = 0;
    private int m_port = 0;
    private boolean m_autoScreenshot = true;
    private int m_iterMax = 100;
    private boolean m_xmlScreenshot = true;
    private boolean m_executeJobsPartly;
    private String m_fileName;
    private boolean m_generateMonitoringReport;

    public String getDb() {
        return this.m_db;
    }

    private void setDb(String db) {
        this.m_db = db;
    }

    public String getDbpw() {
        return this.m_dbpw;
    }

    private void setDbpw(String dbpw) {
        this.m_dbpw = dbpw;
    }

    public String getDbuser() {
        return this.m_dbuser;
    }

    private void setDbuser(String dbuser) {
        this.m_dbuser = dbuser;
    }

    public DatabaseConnectionInfo getDbscheme() {
        return this.m_dbConnectionInfo;
    }

    public void setDbscheme(DatabaseConnectionInfo connectionInfo) {
        this.m_dbConnectionInfo = connectionInfo;
    }

    public String getDbConnectionName() {
        return this.m_dbConnectionName;
    }

    private void setDbConnectionName(String connectionName) {
        this.m_dbConnectionName = connectionName;
        this.setDbscheme(JobConfiguration.getConnectionInfoForName(connectionName));
    }

    public String getNoRunOptMode() {
        return this.m_noRunOptMode;
    }

    public String getProjectName() {
        return this.m_projectName;
    }

    public IProjectPO getProject() {
        return this.m_project;
    }

    public void setProject(IProjectPO actualProject) {
        this.m_project = actualProject;
    }

    public ITestSuitePO getActualTestSuite() {
        if (this.m_testSuites.size() > this.m_actualTestSuite) {
            return this.m_testSuites.get(this.m_actualTestSuite);
        }
        return null;
    }

    public int getJobSize() {
        return this.m_testSuites.size();
    }

    public ITestSuitePO getNextTestSuite() {
        ++this.m_actualTestSuite;
        if (this.m_testSuites.size() > this.m_actualTestSuite) {
            return this.m_testSuites.get(this.m_actualTestSuite);
        }
        return null;
    }

    public int getPort() {
        return this.m_port;
    }

    public String getServer() {
        return this.m_server;
    }

    public boolean isGenerateMonitoringReport() {
        return this.m_generateMonitoringReport;
    }

    public void setGenerateMonitoringReport(boolean generateMonitoringReport) {
        this.m_generateMonitoringReport = generateMonitoringReport;
    }

    public void initAndValidate() {
        block0: for (String name : this.m_testSuiteNames) {
            for (ITestSuitePO ts : TestSuiteBP.getListOfTestSuites()) {
                if (!ts.getName().equals(name)) continue;
                this.m_testSuites.add(ts);
                continue block0;
            }
        }
        Validate.isTrue((this.m_testSuiteNames.size() == this.m_testSuites.size() ? 1 : 0) != 0, (String)Messages.JobConfigurationValidateTestSuiteExist);
        if (StringUtils.isNotEmpty((String)this.m_testJobName)) {
            for (ITestJobPO tj : TestJobBP.getListOfTestJobs()) {
                if (!tj.getName().equals(this.m_testJobName)) continue;
                this.m_testJob = tj;
                List refTestSuiteList = tj.getUnmodifiableNodeList();
                for (INodePO node : refTestSuiteList) {
                    IRefTestSuitePO refTestSuite = (IRefTestSuitePO)node;
                    this.m_testSuites.add(refTestSuite.getTestSuite());
                }
            }
            Validate.notNull((Object)this.m_testJob, (String)Messages.JobConfigurationValidateTestJobExist);
        }
        if (!this.m_testSuites.isEmpty()) {
            for (ITestSuitePO ts : this.m_testSuites) {
                Validate.notNull((Object)ts.getAut(), (String)Messages.JobConfigurationValidateAnyAut);
            }
            IAUTMainPO aut = this.getActualTestSuite().getAut();
            if (this.m_autConfigName != null) {
                for (IAUTConfigPO config : aut.getAutConfigSet()) {
                    if (!this.m_autConfigName.equals(config.getName())) continue;
                    this.m_autConfig = config;
                }
                Validate.notNull((Object)this.m_autConfig, (String)NLS.bind((String)Messages.JobConfigurationValidateAutConf, (Object)this.m_autConfigName, (Object)aut.getName()));
            }
        }
    }

    public void checkProjectExistence() {
        Validate.notNull((Object)this.m_project, (String)NLS.bind((String)Messages.JobConfigurationValidateProjectExist, (Object[])new Object[]{String.valueOf(this.m_projectName), this.getProjectVersion()}));
    }

    public static JobConfiguration initJob(File configFile) throws IOException {
        JobConfiguration job;
        if (configFile != null) {
            BufferedReader in = null;
            StringWriter writer = new StringWriter();
            try {
                in = new BufferedReader(new FileReader(configFile));
                String line = null;
                while ((line = in.readLine()) != null) {
                    writer.write(line);
                }
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
            String xml = writer.toString();
            job = JobConfiguration.readFromXML(xml);
        } else {
            job = new JobConfiguration();
        }
        return job;
    }

    public static JobConfiguration readFromXML(String xml) throws IOException {
        JobConfiguration job;
        XStream xstream = new XStream();
        xstream.setClassLoader(JobConfiguration.class.getClassLoader());
        xstream.alias(CONFIGURATION, JobConfiguration.class);
        xstream.registerConverter((Converter)new XMLConverter());
        try {
            job = (JobConfiguration)xstream.fromXML(xml);
        }
        catch (Exception exception) {
            throw new IOException();
        }
        return job;
    }

    public void parseJobOptions(CommandLine cmd) {
        String autIdString;
        if (cmd.hasOption("project")) {
            this.setProjectName(cmd.getOptionValue("project"));
        }
        if (cmd.hasOption("version")) {
            try {
                ProjectVersion version;
                this.m_projectVersion = version = VersionStringUtils.createProjectVersion(cmd.getOptionValue("version"));
            }
            catch (VersionStringUtils.MalformedVersionException malformedVersionException) {
                this.m_projectVersion = new ProjectVersion(null);
            }
        }
        if (cmd.hasOption("server")) {
            this.setServer(cmd.getOptionValue("server"));
        }
        if (cmd.hasOption("port")) {
            this.setPort(JobConfiguration.validateAndParseIntPortNumber(cmd.getOptionValue("port")));
        }
        this.parseDBOptions(cmd);
        this.parseResultDirOptions(cmd);
        this.parseDataDirOptions(cmd);
        if (cmd.hasOption("autconfig")) {
            this.setAutConfigName(cmd.getOptionValue("autconfig"));
        }
        if (cmd.hasOption("autid") && (autIdString = cmd.getOptionValue("autid")) != null) {
            this.setAutId(new AutIdentifier(autIdString));
        }
        if (cmd.hasOption("testsuite")) {
            String tsName = cmd.getOptionValue("testsuite");
            ArrayList<String> tsNamesList = new ArrayList<String>();
            tsNamesList.add(tsName);
            this.setTestSuiteNames(tsNamesList);
        }
        if (cmd.hasOption("testjob")) {
            this.setTestJobName(cmd.getOptionValue("testjob"));
        }
        if (cmd.hasOption("s")) {
            this.setAutoScreenshot(false);
        }
        if (cmd.hasOption("itermax")) {
            try {
                this.setIterMax(Integer.parseInt(cmd.getOptionValue("itermax")));
            }
            catch (NumberFormatException numberFormatException) {
                this.setIterMax(-2);
            }
        }
        if (cmd.hasOption("sx")) {
            this.setXMLScreenshot(false);
        }
        if (cmd.hasOption("incompleteTJ")) {
            this.setExecuteJobsPartly(true);
        }
        if (cmd.hasOption("timeout")) {
            try {
                this.setTimeout(Integer.parseInt(cmd.getOptionValue("timeout")));
            }
            catch (NumberFormatException numberFormatException) {
                this.setTimeout(-2);
            }
        }
        this.parseJobOptsCont(cmd);
    }

    private void parseJobOptsCont(CommandLine cmd) {
        if (cmd.hasOption("n")) {
            this.setNoRunOptMode(TestExecutionConstants.RunSteps.validateRunStep((String)cmd.getOptionValue("n")));
        }
        if (cmd.hasOption("resultname")) {
            this.setFileName(cmd.getOptionValue("resultname"));
        }
        if (cmd.hasOption("generate_monitoring_report")) {
            this.setGenerateMonitoringReport(true);
        }
    }

    public static int validateAndParseIntPortNumber(String portString) {
        String errorMsg = NetUtil.isPortNumberValid((String)portString);
        if (errorMsg == null) {
            return Integer.parseInt(portString);
        }
        return -2;
    }

    private void parseDBOptions(CommandLine cmd) {
        if (cmd.hasOption("dburl")) {
            String dbURL = cmd.getOptionValue("dburl");
            this.setDb(dbURL);
            DatabaseConnectionInfo connectionInfo = JobConfiguration.getConnectionInfo(dbURL);
            this.setDbscheme(connectionInfo);
        }
        if (cmd.hasOption("dbscheme")) {
            this.setDbConnectionName(cmd.getOptionValue("dbscheme"));
        }
        if (cmd.hasOption("dbuser")) {
            this.setDbuser(cmd.getOptionValue("dbuser"));
        }
        if (cmd.hasOption("dbpw")) {
            this.setDbpw(cmd.getOptionValue("dbpw"));
        }
    }

    private void parseDataDirOptions(CommandLine cmd) {
        String baseDatadirPath = JobConfiguration.getDefaultDataDirPath();
        if (cmd.hasOption("datadir")) {
            this.setDataDir(FileUtils.resolveAgainstBasePath((String)cmd.getOptionValue("datadir"), (String)baseDatadirPath));
        }
        if (this.getDataDir() == null) {
            this.setDataDir(!StringUtils.isEmpty((String)baseDatadirPath) ? baseDatadirPath : String.valueOf(-2));
        }
    }

    private void parseResultDirOptions(CommandLine cmd) {
        if (cmd.hasOption("resultdir")) {
            this.setResultDir(FileUtils.resolveAgainstBasePath((String)cmd.getOptionValue("resultdir"), (String)JobConfiguration.getDefaultDataDirPath()));
        }
    }

    private static DatabaseConnectionInfo getConnectionInfo(final String dbURL) {
        Object connectionInfo = null;
        if (dbURL.startsWith("jdbc:oracle:thin:@")) {
            connectionInfo = new OracleConnectionInfo(){

                public String getConnectionUrl() {
                    return dbURL;
                }
            };
        } else if (dbURL.startsWith("jdbc:postgresql://")) {
            connectionInfo = new PostGreSQLConnectionInfo(){

                public String getConnectionUrl() {
                    return dbURL;
                }
            };
        } else if (dbURL.startsWith("jdbc:mysql://")) {
            connectionInfo = new MySQLConnectionInfo(){

                public String getConnectionUrl() {
                    return dbURL;
                }
            };
        } else if (dbURL.startsWith("jdbc:h2:")) {
            connectionInfo = new H2ConnectionInfo(){

                public String getConnectionUrl() {
                    return dbURL;
                }
            };
        }
        return connectionInfo;
    }

    public List<String> getTestSuiteNames() {
        return this.m_testSuiteNames;
    }

    public String getTestJobName() {
        return this.m_testJobName;
    }

    private String getTestSuiteName() {
        return this.getTestSuiteNames().get(this.m_actualTestSuite);
    }

    private void setPort(int port) {
        this.m_port = port;
    }

    private void setProjectName(String projectName) {
        this.m_projectName = projectName;
    }

    private void setNoRunOptMode(String noRunOptMode) {
        this.m_noRunOptMode = noRunOptMode;
    }

    private void setServer(String server) {
        this.m_server = server;
    }

    private void setTestSuiteNames(List<String> testSuiteNames) {
        this.m_testSuiteNames = testSuiteNames;
    }

    private void setTestJobName(String testJobName) {
        this.m_testJobName = testJobName;
    }

    private void setTestSuiteName(String testSuiteName) {
        ArrayList<String> tsNames = new ArrayList<String>(1);
        tsNames.add(testSuiteName);
        this.setTestSuiteNames(tsNames);
    }

    public String getResultDir() {
        return this.m_resultDir;
    }

    private void setResultDir(String resultDir) {
        this.m_resultDir = resultDir;
    }

    public String getAutConfigName() {
        return this.m_autConfigName;
    }

    public AutIdentifier getAutId() {
        return this.m_autId;
    }

    public void setAutConfigName(String autConfigName) {
        this.m_autConfigName = autConfigName;
    }

    public void setAutId(AutIdentifier autId) {
        this.m_autId = autId;
    }

    public IAUTConfigPO getAutConfig() {
        return this.m_autConfig;
    }

    public List<ITestSuitePO> getTestSuites() {
        return Collections.unmodifiableList(this.m_testSuites);
    }

    public boolean removeTestSuites(ITestSuitePO testsuite) {
        this.m_incompleteTestSuites.add(testsuite.getName());
        return this.m_testSuites.remove(testsuite);
    }

    public ITestJobPO getTestJob() {
        return this.m_testJob;
    }

    private void setProjectVersion(String version) {
        try {
            ProjectVersion projVers = VersionStringUtils.createProjectVersion(version);
            this.setProjectVersion(projVers);
        }
        catch (VersionStringUtils.MalformedVersionException malformedVersionException) {
            this.setProjectVersion(new ProjectVersion(null));
        }
    }

    private void setProjectVersion(ProjectVersion projVers) {
        this.m_projectVersion = projVers;
    }

    public ProjectVersion getProjectVersion() {
        return this.m_projectVersion;
    }

    public String getDataDir() {
        return this.m_dataDir;
    }

    public static String getInstanceLocationPath() {
        if (Platform.getInstanceLocation() == null) {
            return null;
        }
        return Platform.getInstanceLocation().getURL().getFile();
    }

    private static String getInstallLocationPath() {
        Location installLocation = Platform.getInstallLocation();
        if (installLocation != null) {
            return installLocation.getURL().getFile();
        }
        return null;
    }

    public static String getDefaultDataDirPath() {
        return JobConfiguration.getInstanceLocationPath() != null ? JobConfiguration.getInstanceLocationPath() : JobConfiguration.getInstallLocationPath();
    }

    public void setDataDir(String dataDir) {
        this.m_dataDir = dataDir;
    }

    public int getTimeout() {
        return this.m_timeout;
    }

    public void setTimeout(int timeout) {
        this.m_timeout = timeout;
    }

    public void setIterMax(int iterMax) {
        this.m_iterMax = iterMax;
    }

    public int getIterMax() {
        return this.m_iterMax;
    }

    public void setAutoScreenshot(boolean autoScreenshot) {
        this.m_autoScreenshot = autoScreenshot;
    }

    public boolean isAutoScreenshot() {
        return this.m_autoScreenshot;
    }

    public void setXMLScreenshot(boolean xmlScreenshot) {
        this.m_xmlScreenshot = xmlScreenshot;
    }

    public boolean isXMLScreenshot() {
        return this.m_xmlScreenshot;
    }

    public boolean isExecuteJobsPartly() {
        return this.m_executeJobsPartly;
    }

    public void setExecuteJobsPartly(boolean executeJobsPartly) {
        this.m_executeJobsPartly = executeJobsPartly;
    }

    private static DatabaseConnectionInfo getConnectionInfoForName(String name) {
        List availableConnections = DatabaseConnectionConverter.computeAvailableConnections();
        for (DatabaseConnection conn : availableConnections) {
            if (!ObjectUtils.equals((Object)conn.getName(), (Object)name)) continue;
            return conn.getConnectionInfo();
        }
        return null;
    }

    public void setEmbeddedAutAgentHostName() {
        this.setServer("localhost");
    }

    public String getFileName() {
        return this.m_fileName;
    }

    public void setFileName(String fileName) {
        this.m_fileName = StringUtils.isBlank((String)fileName) ? "invalid argument" : fileName;
    }

    public List<String> getIncompleteTSs() {
        return this.m_incompleteTestSuites;
    }

    private static final class XMLConverter
    implements Converter {
        private XMLConverter() {
        }

        public boolean canConvert(Class arg0) {
            return true;
        }

        public void marshal(Object arg0, HierarchicalStreamWriter arg1, MarshallingContext arg2) {
            JobConfiguration job = (JobConfiguration)arg0;
            arg1.startNode("project");
            arg1.setValue(job.getProjectName());
            arg1.endNode();
            arg1.startNode("version");
            arg1.setValue(job.getProjectVersion().toString());
            arg1.endNode();
            arg1.startNode("server");
            arg1.setValue(job.getServer());
            arg1.endNode();
            arg1.startNode("port");
            arg1.setValue(String.valueOf(JobConfiguration.validateAndParseIntPortNumber(Integer.toString(job.getPort()))));
            arg1.endNode();
            arg1.startNode("dburl");
            arg1.setValue(job.getDb());
            arg1.endNode();
            arg1.startNode("dbuser");
            arg1.setValue(job.getDbuser());
            arg1.endNode();
            arg1.startNode("dbpw");
            arg1.setValue(job.getDbpw());
            arg1.endNode();
            arg1.startNode("resultdir");
            arg1.setValue(job.getResultDir());
            arg1.endNode();
            arg1.startNode("testsuite");
            arg1.setValue(job.getTestSuiteName());
            arg1.endNode();
            arg1.startNode("autconfig");
            arg1.setValue(job.getAutConfigName());
            arg1.endNode();
            arg1.startNode("n");
            arg1.setValue(TestExecutionConstants.RunSteps.validateRunStep((String)job.getNoRunOptMode()));
            arg1.endNode();
            arg1.startNode("resultname");
            arg1.setValue(job.getFileName());
            arg1.endNode();
        }

        public Object unmarshal(HierarchicalStreamReader arg0, UnmarshallingContext arg1) throws IllegalArgumentException {
            JobConfiguration job = new JobConfiguration();
            while (arg0.hasMoreChildren()) {
                arg0.moveDown();
                if (arg0.getNodeName().equals("project")) {
                    job.setProjectName(arg0.getValue());
                } else if (arg0.getNodeName().equals("version")) {
                    job.setProjectVersion(arg0.getValue());
                } else if (arg0.getNodeName().equals("server")) {
                    job.setServer(arg0.getValue());
                } else if (arg0.getNodeName().equals("port")) {
                    job.setPort(JobConfiguration.validateAndParseIntPortNumber(arg0.getValue()));
                } else if (arg0.getNodeName().equals("resultdir")) {
                    job.setResultDir(FileUtils.resolveAgainstBasePath((String)arg0.getValue(), (String)JobConfiguration.getDefaultDataDirPath()));
                } else if (arg0.getNodeName().equals("dburl")) {
                    String dbURL = arg0.getValue();
                    job.setDb(dbURL);
                    DatabaseConnectionInfo connectionInfo = JobConfiguration.getConnectionInfo(dbURL);
                    job.setDbscheme(connectionInfo);
                } else if (arg0.getNodeName().equals("dbscheme")) {
                    job.setDbConnectionName(arg0.getValue());
                } else if (arg0.getNodeName().equals("dbuser")) {
                    job.setDbuser(arg0.getValue());
                } else if (arg0.getNodeName().equals("dbpw")) {
                    job.setDbpw(arg0.getValue());
                } else if (arg0.getNodeName().equals("autconfig")) {
                    job.setAutConfigName(arg0.getValue());
                } else if (arg0.getNodeName().equals("autid")) {
                    job.setAutId(new AutIdentifier(arg0.getValue()));
                } else if (arg0.getNodeName().equals("datadir")) {
                    job.setDataDir(FileUtils.resolveAgainstBasePath((String)arg0.getValue(), (String)JobConfiguration.getDefaultDataDirPath()));
                } else if (arg0.getNodeName().equals("testsuite")) {
                    job.setTestSuiteName(arg0.getValue());
                } else if (arg0.getNodeName().equals("testjob")) {
                    job.setTestJobName(arg0.getValue());
                } else if (arg0.getNodeName().equals("n")) {
                    job.setNoRunOptMode(TestExecutionConstants.RunSteps.validateRunStep((String)arg0.getValue()));
                } else if (arg0.getNodeName().equals("resultname")) {
                    job.setFileName(arg0.getValue());
                }
                arg0.moveUp();
            }
            return job;
        }
    }
}

