/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.search.result;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jubula.client.core.businessprocess.TestDataCubeBP;
import org.eclipse.jubula.client.core.businessprocess.db.NodeBP;
import org.eclipse.jubula.client.core.model.IAUTMainPO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IObjectMappingAssoziationPO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.ITestDataCubePO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.NodePM;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.controllers.MultipleTCBTracker;
import org.eclipse.jubula.client.ui.rcp.editors.AbstractJBEditor;
import org.eclipse.jubula.client.ui.rcp.editors.CentralTestDataEditor;
import org.eclipse.jubula.client.ui.rcp.editors.ObjectMappingMultiPageEditor;
import org.eclipse.jubula.client.ui.rcp.handlers.open.AbstractOpenHandler;
import org.eclipse.jubula.client.ui.rcp.search.query.ShowWhereReferencedCTDSValueQuery;
import org.eclipse.jubula.client.ui.rcp.views.AbstractJBTreeView;
import org.eclipse.jubula.client.ui.rcp.views.dataset.DataSetView;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.ISearchResultListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;

public class BasicSearchResult<DATATYPE>
implements ISearchResult {
    private List<DATATYPE> m_resultList = Collections.emptyList();
    private ISearchQuery m_query;

    public BasicSearchResult(ISearchQuery query) {
        this.setQuery(query);
    }

    public void setQuery(ISearchQuery query) {
        this.m_query = query;
    }

    public ISearchQuery getQuery() {
        return this.m_query;
    }

    public void setResultList(List<DATATYPE> resultList) {
        this.m_resultList = resultList;
    }

    public List<DATATYPE> getResultList() {
        return this.m_resultList;
    }

    public void addListener(ISearchResultListener l) {
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public String getTooltip() {
        return "";
    }

    public void removeListener(ISearchResultListener l) {
    }

    public String getLabel() {
        return this.getQuery().getLabel();
    }

    public static interface ISearchResultElementAction<DATATYPE> {
        public void jumpTo(DATATYPE var1);

        public void openView(String var1);

        public Object getObject(DATATYPE var1);
    }

    public static class NodeSearchResultElementAction
    implements ISearchResultElementAction<Long> {
        @Override
        public void openView(String viewId) {
            Plugin.showView(viewId);
        }

        @Override
        public void jumpTo(Long id) {
            IEditorPart openEditor;
            AbstractJBTreeView jbtv = MultipleTCBTracker.getInstance().getMainTCB();
            if (jbtv == null) {
                jbtv = (AbstractJBTreeView)Plugin.showView("org.eclipse.jubula.client.ui.rcp.views.TestCaseBrowser");
            } else {
                Plugin.activate((IWorkbenchPart)jbtv);
            }
            Object ob = this.getObject(id);
            if (!(ob instanceof INodePO)) {
                return;
            }
            INodePO node = (INodePO)ob;
            INodePO specNode = node.getSpecAncestor();
            if (specNode != null && NodeBP.isEditable((IPersistentObject)specNode) && (openEditor = AbstractOpenHandler.openEditor((IPersistentObject)specNode)) instanceof AbstractJBEditor) {
                AbstractJBEditor jbEditor = (AbstractJBEditor)openEditor;
                jbEditor.setSelection((ISelection)new StructuredSelection((Object)node));
            }
        }

        @Override
        public Object getObject(Long id) {
            return NodePM.findNodeById((Long)id);
        }
    }

    public static class ObjectMappingSearchResultElementAction
    implements ISearchResultElementAction<Long>,
    Serializable {
        private static final long serialVersionUID = 8171916234693719204L;
        private IAUTMainPO m_aut = null;

        @Override
        public void openView(String viewId) {
        }

        @Override
        public void jumpTo(Long id) {
            ObjectMappingMultiPageEditor omEditor;
            IObjectMappingAssoziationPO editorAssoc;
            IEditorPart editor;
            if (this.m_aut == null) {
                this.getObject(id);
            }
            if (this.m_aut != null && (editor = AbstractOpenHandler.openEditor((IPersistentObject)this.m_aut)) instanceof ObjectMappingMultiPageEditor && (editorAssoc = this.getAssocForId((omEditor = (ObjectMappingMultiPageEditor)editor).getAut(), id)) != null) {
                TreeViewer[] treeViewerArray = omEditor.getTreeViewers();
                int n = treeViewerArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeViewer viewer = treeViewerArray[n2];
                    viewer.reveal((Object)editorAssoc);
                    viewer.setSelection((ISelection)new StructuredSelection((Object)editorAssoc));
                    ++n2;
                }
            }
        }

        @Override
        public Object getObject(Long id) {
            for (IAUTMainPO aut : GeneralStorage.getInstance().getProject().getAutMainList()) {
                for (IObjectMappingAssoziationPO assoc : aut.getObjMap().getMappings()) {
                    if (!id.equals(assoc.getId())) continue;
                    this.m_aut = aut;
                    return assoc;
                }
            }
            return null;
        }

        private IObjectMappingAssoziationPO getAssocForId(IAUTMainPO aut, Long id) {
            for (IObjectMappingAssoziationPO editorAssoc : aut.getObjMap().getMappings()) {
                if (!id.equals(editorAssoc.getId())) continue;
                return editorAssoc;
            }
            return null;
        }
    }

    public static class SearchResultElement<DATATYPE> {
        private String m_name;
        private DATATYPE m_data;
        private Image m_image;
        private ISearchResultElementAction<DATATYPE> m_action;
        private String m_comment;
        private String m_viewId;

        public SearchResultElement(String name, DATATYPE data, Image image, ISearchResultElementAction<DATATYPE> action, String comment) {
            this(name, data, image, action, comment, null);
        }

        public SearchResultElement(String name, DATATYPE data, Image image, ISearchResultElementAction<DATATYPE> action, String comment, String viewId) {
            this.m_name = name;
            this.m_data = data;
            this.m_image = image;
            this.m_action = action;
            this.m_comment = comment;
            this.m_viewId = viewId;
        }

        public SearchResultElement(String name, DATATYPE data, Image image, ISearchResultElementAction<DATATYPE> action) {
            this(name, data, image, action, null);
        }

        public ISearchResultElementAction<DATATYPE> getAction() {
            return this.m_action;
        }

        public String getName() {
            return this.m_name;
        }

        public DATATYPE getData() {
            return this.m_data;
        }

        public Image getImage() {
            return this.m_image;
        }

        public String getComment() {
            return this.m_comment;
        }

        public void jumpToResult() {
            if (this.getViewId() != null) {
                this.m_action.openView(this.getViewId());
            }
            this.m_action.jumpTo(this.getData());
        }

        public String getViewId() {
            return this.m_viewId;
        }

        public Object getObject() {
            return this.m_action.getObject(this.m_data);
        }
    }

    public static class TestDataCubeExtendedAction
    implements ISearchResultElementAction<ShowWhereReferencedCTDSValueQuery.CTDSReference> {
        @Override
        public void jumpTo(ShowWhereReferencedCTDSValueQuery.CTDSReference data) {
            Object res = this.getObject(data);
            if (!(res instanceof INodePO)) {
                return;
            }
            INodePO spec = ((INodePO)res).getSpecAncestor();
            AbstractOpenHandler.openEditorAndSelectNode(spec, (INodePO)data.getNode());
            IViewPart v = Plugin.showView("org.eclipse.jubula.client.ui.rcp.views.DataSetView");
            if (!(v instanceof DataSetView)) {
                return;
            }
            ((DataSetView)v).navigateToCellUsingRowCol(data.getRow(), data.getColumn());
        }

        @Override
        public void openView(String viewId) {
        }

        @Override
        public Object getObject(ShowWhereReferencedCTDSValueQuery.CTDSReference data) {
            return data.getNode();
        }
    }

    public static class TestDataCubeSearchResultElementAction
    implements ISearchResultElementAction<Long> {
        @Override
        public void openView(String viewId) {
            Plugin.showView(viewId);
        }

        @Override
        public void jumpTo(Long id) {
            Object obj = this.getObject(id);
            if (!(obj instanceof ITestDataCubePO)) {
                return;
            }
            ITestDataCubePO testdatacube = (ITestDataCubePO)obj;
            IEditorPart editor = AbstractOpenHandler.openEditor((IPersistentObject)GeneralStorage.getInstance().getProject().getTestDataCubeCont());
            if (editor instanceof CentralTestDataEditor) {
                CentralTestDataEditor ctdEditor = (CentralTestDataEditor)editor;
                ctdEditor.getTreeViewer().setSelection((ISelection)new StructuredSelection(ctdEditor.getEditorHelper().getEditSupport().getSession().find(testdatacube.getClass(), (Object)id)));
            }
        }

        @Override
        public Object getObject(Long id) {
            IProjectPO activeProject = GeneralStorage.getInstance().getProject();
            ITestDataCubePO[] iTestDataCubePOArray = TestDataCubeBP.getAllTestDataCubesFor((IProjectPO)activeProject);
            int n = iTestDataCubePOArray.length;
            int n2 = 0;
            while (n2 < n) {
                ITestDataCubePO testdatacube = iTestDataCubePOArray[n2];
                if (id.equals(testdatacube.getId())) {
                    return testdatacube;
                }
                ++n2;
            }
            return null;
        }
    }
}

