/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.common.commands;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.lang.ref.WeakReference;
import org.eclipse.jubula.communication.internal.ICommand;
import org.eclipse.jubula.communication.internal.message.Message;
import org.eclipse.jubula.communication.internal.message.TakeScreenshotMessage;
import org.eclipse.jubula.communication.internal.message.TakeScreenshotResponseMessage;
import org.eclipse.jubula.rc.common.AUTServer;
import org.eclipse.jubula.rc.common.driver.IRobot;
import org.eclipse.jubula.rc.common.driver.RobotConfiguration;
import org.eclipse.jubula.rc.common.tester.adapter.interfaces.IComponent;
import org.eclipse.jubula.tools.internal.serialisation.SerializedImage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TakeScreenshotCommand
implements ICommand {
    private static final int TOTAL_LINE_LENGTH = 11;
    private static final int LINE_LENGTH_PER_DIRECTION = 5;
    private static final Logger LOG = LoggerFactory.getLogger(TakeScreenshotCommand.class);
    private TakeScreenshotMessage m_message;

    public Message execute() {
        WeakReference<IComponent> errorComponent;
        TakeScreenshotResponseMessage response = new TakeScreenshotResponseMessage();
        IRobot robot = AUTServer.getInstance().getRobot();
        BufferedImage createScreenCapture = robot.createFullScreenCapture();
        try {
            Point currentPointingDevicePosition = robot.getCurrentMousePosition();
            if (currentPointingDevicePosition != null) {
                int pdX = currentPointingDevicePosition.x;
                int pdY = currentPointingDevicePosition.y;
                int xStart = pdX - 5;
                int yStart = pdY - 5;
                int i = 0;
                while (i < 11) {
                    int j = 0;
                    while (j < 11) {
                        this.invertPixelAtPoint(createScreenCapture, xStart + i, yStart + j);
                        ++j;
                    }
                    ++i;
                }
            }
        }
        catch (Exception exception) {}
        if (RobotConfiguration.getInstance().isErrorHighlighting().booleanValue() && (errorComponent = AUTServer.getInstance().getErrorComponent()) != null) {
            try {
                this.highlightErrorComponent(errorComponent, robot, createScreenCapture);
            }
            catch (RuntimeException e) {
                LOG.error("Highlighting component during screenshot failed", (Throwable)e);
            }
        }
        SerializedImage computedSerializeImage = SerializedImage.computeSerializeImage((BufferedImage)createScreenCapture);
        response.setScreenshot(computedSerializeImage);
        return response;
    }

    private void highlightErrorComponent(WeakReference<IComponent> weakRefError, IRobot robot, BufferedImage screenCapture) {
        IComponent errorComp = (IComponent)weakRefError.get();
        if (errorComp != null) {
            BufferedImage image = screenCapture;
            Graphics2D graphic = image.createGraphics();
            Color recColor = new Color(0, 128, 0);
            graphic.setColor(recColor);
            graphic.setStroke(new BasicStroke(3.0f));
            Rectangle recErrorComp = robot.getComponentBounds(errorComp);
            if (recErrorComp != null) {
                graphic.drawRect((int)recErrorComp.getX() - 2, (int)recErrorComp.getY() - 2, (int)recErrorComp.getWidth() + 2, (int)recErrorComp.getHeight() + 2);
            }
        }
    }

    private void invertPixelAtPoint(BufferedImage image, int x, int y) {
        if (x < 0 || y < 0) {
            return;
        }
        if (x >= image.getWidth() || y >= image.getHeight()) {
            return;
        }
        int rgb = image.getRGB(x, y);
        Color origPxColor = new Color(rgb);
        Color newPxColor = new Color(255 - origPxColor.getRed(), 255 - origPxColor.getGreen(), 255 - origPxColor.getBlue());
        image.setRGB(x, y, newPxColor.getRGB());
    }

    public void timeout() {
        LOG.error(String.valueOf(this.getClass().getName()) + ".timeout() called");
    }

    public void setMessage(Message message) {
        this.m_message = (TakeScreenshotMessage)message;
    }

    public Message getMessage() {
        return this.m_message;
    }
}

