/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.rpm.rpmlint.resolutions;

import java.util.ArrayList;
import org.eclipse.core.resources.IMarker;
import org.eclipse.linuxtools.internal.rpm.rpmlint.resolutions.ARpmlintResolution;
import org.eclipse.linuxtools.internal.rpm.rpmlint.resolutions.HardcodedPackagerTag;
import org.eclipse.linuxtools.internal.rpm.rpmlint.resolutions.HardcodedPrefixTag;
import org.eclipse.linuxtools.internal.rpm.rpmlint.resolutions.MacroInChangelog;
import org.eclipse.linuxtools.internal.rpm.rpmlint.resolutions.NoBuildSection;
import org.eclipse.linuxtools.internal.rpm.rpmlint.resolutions.NoInstallSection;
import org.eclipse.linuxtools.internal.rpm.rpmlint.resolutions.NoPrepSection;
import org.eclipse.linuxtools.internal.rpm.rpmlint.resolutions.PatchNotApplied;
import org.eclipse.linuxtools.internal.rpm.rpmlint.resolutions.RpmBuildrootUsage;
import org.eclipse.linuxtools.internal.rpm.rpmlint.resolutions.SetupNotQuiet;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IMarkerResolutionGenerator2;

public class RpmlintMarkerResolutionGenerator
implements IMarkerResolutionGenerator2 {
    public static final String RPMLINT_ERROR_ID = "rpmlintErrorId";
    public static final String RPMLINT_REFFERED_CONTENT = "rpmlintrefferedContent";

    public boolean hasResolutions(IMarker marker) {
        String rpmlintErrorId = RpmlintMarkerResolutionGenerator.getRpmlintErrorId(marker);
        if (rpmlintErrorId.equals("setup-not-quiet")) {
            return true;
        }
        if (rpmlintErrorId.equals("patch-not-applied")) {
            return true;
        }
        if (rpmlintErrorId.equals("no-%build-section")) {
            return true;
        }
        if (rpmlintErrorId.equals("macro-in-%changelog")) {
            return true;
        }
        if (rpmlintErrorId.equals("rpm-buildroot-usage")) {
            return true;
        }
        if (rpmlintErrorId.equals("hardcoded-prefix-tag")) {
            return true;
        }
        if (rpmlintErrorId.equals("hardcoded-packager-tag")) {
            return true;
        }
        if (rpmlintErrorId.equals("no-%prep-section")) {
            return true;
        }
        return rpmlintErrorId.equals("no-%install-section");
    }

    public IMarkerResolution[] getResolutions(IMarker marker) {
        ArrayList<ARpmlintResolution> resolutions = new ArrayList<ARpmlintResolution>();
        String rpmlintErrorId = RpmlintMarkerResolutionGenerator.getRpmlintErrorId(marker);
        if (rpmlintErrorId.equals("setup-not-quiet")) {
            resolutions.add(new SetupNotQuiet());
        } else if (rpmlintErrorId.equals("patch-not-applied")) {
            resolutions.add(new PatchNotApplied());
        } else if (rpmlintErrorId.equals("no-%build-section")) {
            resolutions.add(new NoBuildSection());
        } else if (rpmlintErrorId.equals("macro-in-%changelog")) {
            resolutions.add(new MacroInChangelog());
        } else if (rpmlintErrorId.equals("rpm-buildroot-usage")) {
            resolutions.add(new RpmBuildrootUsage());
        } else if (rpmlintErrorId.equals("hardcoded-prefix-tag")) {
            resolutions.add(new HardcodedPrefixTag());
        } else if (rpmlintErrorId.equals("hardcoded-packager-tag")) {
            resolutions.add(new HardcodedPackagerTag());
        } else if (rpmlintErrorId.equals("no-%prep-section")) {
            resolutions.add(new NoPrepSection());
        } else if (rpmlintErrorId.equals("no-%install-section")) {
            resolutions.add(new NoInstallSection());
        }
        return resolutions.toArray(new IMarkerResolution[resolutions.size()]);
    }

    private static String getRpmlintErrorId(IMarker marker) {
        return marker.getAttribute(RPMLINT_ERROR_ID, "");
    }
}

