/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.filebuffers.IDocumentSetupParticipant;
import org.eclipse.core.filebuffers.IDocumentSetupParticipantExtension;
import org.eclipse.core.filebuffers.IFileBuffer;
import org.eclipse.core.filebuffers.IFileBufferListener;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.IDocument;
import org.eclipse.lsp4e.FileBufferListenerAdapter;
import org.eclipse.lsp4e.LanguageServiceAccessor;

public class ConnectDocumentToLanguageServerSetupParticipant
implements IDocumentSetupParticipant,
IDocumentSetupParticipantExtension {
    private Map<IPath, Job> locationMap = new HashMap<IPath, Job>();

    public ConnectDocumentToLanguageServerSetupParticipant() {
        ITextFileBufferManager.DEFAULT.addFileBufferListener((IFileBufferListener)new FileBufferListenerAdapter(){

            @Override
            public void bufferDisposed(IFileBuffer buffer) {
                Job job = ConnectDocumentToLanguageServerSetupParticipant.this.locationMap.remove(buffer.getLocation());
                if (job != null) {
                    job.cancel();
                }
            }
        });
    }

    public void setup(IDocument document) {
        ITextFileBuffer buffer = ITextFileBufferManager.DEFAULT.getTextFileBuffer(document);
        if (buffer == null || buffer.getLocation() == null) {
            return;
        }
        this.setup(document, buffer.getLocation(), LocationKind.IFILE);
    }

    public void setup(final IDocument document, final IPath location, LocationKind locationKind) {
        if (document == null) {
            return;
        }
        Job job = new Job("Initialize Language Servers for " + location.toFile().getName()){

            protected IStatus run(IProgressMonitor monitor) {
                ITextFileBuffer buffer = ITextFileBufferManager.DEFAULT.getTextFileBuffer(document);
                if (buffer == null || buffer.getLocation() == null) {
                    return Status.OK_STATUS;
                }
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                LanguageServiceAccessor.getLanguageServers(document, capabilities -> true);
                ConnectDocumentToLanguageServerSetupParticipant.this.locationMap.remove(location);
                return Status.OK_STATUS;
            }
        };
        this.locationMap.put(location, job);
        job.setUser(true);
        job.setPriority(10);
        job.schedule(100L);
    }
}

