/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.profiler.emfvm;

import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.m2m.atl.core.ATLCoreException;
import org.eclipse.m2m.atl.engine.emfvm.launch.EMFVMLauncher;
import org.eclipse.m2m.atl.engine.emfvm.launch.ITool;
import org.eclipse.m2m.atl.engine.parser.AtlParser;
import org.eclipse.m2m.atl.profiler.core.Messages;
import org.eclipse.m2m.atl.profiler.emfvm.ProfilingTool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProfilerLauncher
extends EMFVMLauncher {
    public Object launch(String mode, IProgressMonitor monitor, Map<String, Object> options, Object ... modules) {
        if (options.get("ATL_FILE") != null) {
            String fileName = options.get("ATL_FILE").toString();
            IFile currentAtlFile = ResourcesPlugin.getWorkspace().getRoot().getFile(Path.fromOSString((String)fileName));
            try {
                EObject atlModel = AtlParser.getDefault().parse(currentAtlFile.getContents());
                if (atlModel == null) {
                    throw new RuntimeException(Messages.getString((String)"ProfilerLauncher_INVALID_ATL_FILE"));
                }
                return this.internalLaunch(new ITool[]{new ProfilingTool(atlModel)}, (IProgressMonitor)new NullProgressMonitor(), options, modules);
            }
            catch (ATLCoreException e) {
                throw new RuntimeException(Messages.getString((String)"ProfilerLauncher_INVALID_ATL_FILE"));
            }
            catch (CoreException e) {
                throw new RuntimeException(Messages.getString((String)"ProfilerLauncher_INVALID_ATL_FILE"));
            }
        }
        throw new RuntimeException(Messages.getString((String)"ProfilerLauncher_INVALID_ATL_FILE"));
    }

    public String getName() {
        return String.valueOf(super.getName()) + " Profiler";
    }
}

