/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.inspections.threads;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.collect.ArrayInt;
import org.eclipse.mat.collect.HashMapIntObject;
import org.eclipse.mat.collect.SetInt;
import org.eclipse.mat.inspections.InspectionAssert;
import org.eclipse.mat.inspections.threads.ThreadInfoImpl;
import org.eclipse.mat.internal.Messages;
import org.eclipse.mat.query.Column;
import org.eclipse.mat.query.DetailResultProvider;
import org.eclipse.mat.query.IContextObject;
import org.eclipse.mat.query.IDecorator;
import org.eclipse.mat.query.IIconProvider;
import org.eclipse.mat.query.IQuery;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.query.IResultTree;
import org.eclipse.mat.query.ResultMetaData;
import org.eclipse.mat.query.annotations.Argument;
import org.eclipse.mat.query.annotations.CommandName;
import org.eclipse.mat.query.annotations.HelpUrl;
import org.eclipse.mat.query.annotations.Icon;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.extension.Subject;
import org.eclipse.mat.snapshot.model.GCRootInfo;
import org.eclipse.mat.snapshot.model.IClass;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.model.IStackFrame;
import org.eclipse.mat.snapshot.model.IThreadStack;
import org.eclipse.mat.snapshot.model.NamedReference;
import org.eclipse.mat.snapshot.model.ThreadToLocalReference;
import org.eclipse.mat.snapshot.query.IHeapObjectArgument;
import org.eclipse.mat.snapshot.query.Icons;
import org.eclipse.mat.snapshot.query.ObjectListResult;
import org.eclipse.mat.snapshot.query.SnapshotQuery;
import org.eclipse.mat.util.IProgressListener;

@CommandName(value="thread_overview")
@Icon(value="/META-INF/icons/threads.gif")
@HelpUrl(value="/org.eclipse.mat.ui.help/tasks/analyzingthreads.html")
@Subject(value="java.lang.Thread")
public class ThreadOverviewQuery
implements IQuery {
    @Argument
    public ISnapshot snapshot;
    @Argument(isMandatory=false, flag="none")
    public IHeapObjectArgument objects;
    private static URL THREAD_ICON_URL = Icons.getURL("thread.gif");
    private static URL STACK_FRAME_ICON_URL = Icons.getURL("stack_frame.gif");
    public static final String CLASS_THREAD = "java.lang.Thread";

    public IResult execute(IProgressListener listener) throws Exception {
        int objectId;
        int n;
        listener.subTask(Messages.ThreadOverviewQuery_SearchingThreads);
        ArrayList<ThreadOverviewNode> result = new ArrayList<ThreadOverviewNode>();
        if (this.objects != null) {
            Iterator iterator = this.objects.iterator();
            block0: while (iterator.hasNext()) {
                int[] objectIds;
                int[] nArray = objectIds = (int[])iterator.next();
                int n2 = objectIds.length;
                n = 0;
                while (n < n2) {
                    objectId = nArray[n];
                    if (listener.isCanceled()) continue block0;
                    if (ThreadOverviewQuery.isThread(this.snapshot, objectId)) {
                        result.add(this.buildThreadOverviewNode(objectId, listener));
                    }
                    ++n;
                }
            }
        } else {
            Collection<IClass> classes = this.snapshot.getClassesByName(CLASS_THREAD, true);
            if (classes != null) {
                block2: for (IClass clasz : classes) {
                    int[] nArray = clasz.getObjectIds();
                    int n3 = nArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        int id = nArray[n4];
                        if (listener.isCanceled()) continue block2;
                        result.add(this.buildThreadOverviewNode(id, listener));
                        ++n4;
                    }
                }
            }
            int[] nArray = this.snapshot.getGCRoots();
            n = nArray.length;
            objectId = 0;
            while (objectId < n) {
                int objectId2 = nArray[objectId];
                GCRootInfo[] gcs = this.snapshot.getGCRootInfo(objectId2);
                if (gcs != null) {
                    GCRootInfo[] gCRootInfoArray = gcs;
                    int n5 = gcs.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        GCRootInfo gc = gCRootInfoArray[n6];
                        if (gc.getType() == 256 && ThreadOverviewQuery.isThread(this.snapshot, objectId2)) {
                            result.add(this.buildThreadOverviewNode(objectId2, listener));
                        }
                        ++n6;
                    }
                }
                if (!listener.isCanceled()) {
                    ++objectId;
                    continue;
                }
                break;
            }
        }
        Collections.sort(result, new Comparator<ThreadOverviewNode>(){

            @Override
            public int compare(ThreadOverviewNode o1, ThreadOverviewNode o2) {
                return o1.threadInfo.getRetainedHeap().getValue() > o2.threadInfo.getRetainedHeap().getValue() ? -1 : (o1.threadInfo.getRetainedHeap().getValue() < o2.threadInfo.getRetainedHeap().getValue() ? 1 : Long.compare(o1.threadInfo.getThreadObject().getObjectAddress(), o2.threadInfo.getThreadObject().getObjectAddress()));
            }
        });
        ThreadOverviewNode prev = null;
        Iterator it = result.iterator();
        while (it.hasNext()) {
            ThreadOverviewNode node = (ThreadOverviewNode)it.next();
            if (prev != null && node.threadInfo.getThreadId() == prev.threadInfo.getThreadId()) {
                it.remove();
                continue;
            }
            prev = node;
        }
        if (result.isEmpty()) {
            return null;
        }
        return new ThreadInfoList(this.snapshot, result);
    }

    /*
     * Unable to fully structure code
     */
    public static boolean isThread(ISnapshot snapshot, int objectId) throws SnapshotException {
        block4: {
            obj = snapshot.getObject(objectId);
            cls = obj.getClazz();
            if (cls == null) break block4;
            className = cls.getName();
            if (!"java.lang.Thread".equals(className)) ** GOTO lbl10
            return true;
lbl-1000:
            // 1 sources

            {
                className = (cls = cls.getSuperClass()).getName();
                if (!"java.lang.Thread".equals(className)) continue;
                return true;
lbl10:
                // 2 sources

                ** while (cls.hasSuperClass())
            }
lbl11:
            // 1 sources

            gcs = snapshot.getGCRootInfo(objectId);
            if (gcs != null) {
                className = obj.getClazz().getName();
                var9_6 = gcs;
                var8_7 = gcs.length;
                var7_8 = 0;
                while (var7_8 < var8_7) {
                    gc = var9_6[var7_8];
                    if (gc.getType() == 256 && "java.lang.Object".equals(className)) {
                        return true;
                    }
                    ++var7_8;
                }
            }
        }
        return false;
    }

    private ThreadOverviewNode buildThreadOverviewNode(int objectId, IProgressListener listener) throws SnapshotException {
        IStackFrame[] frames;
        ThreadOverviewNode result = new ThreadOverviewNode();
        result.threadInfo = ThreadInfoImpl.build(this.snapshot.getObject(objectId), false, listener);
        result.stack = this.snapshot.getThreadStack(objectId);
        if (result.stack != null && (frames = result.stack.getStackFrames()) != null) {
            SetInt roots = new SetInt();
            IStackFrame[] iStackFrameArray = frames;
            int n = frames.length;
            int n2 = 0;
            while (n2 < n) {
                IStackFrame IStackFrame2 = iStackFrameArray[n2];
                int[] objects = IStackFrame2.getLocalObjectsIds();
                if (objects != null) {
                    int[] nArray = objects;
                    int n3 = objects.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        int i = nArray[n4];
                        roots.add(i);
                        ++n4;
                    }
                }
                ++n2;
            }
            result.stackRoots = roots.toArray();
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ThreadInfoList
    implements IResultTree,
    IIconProvider,
    IDecorator {
        ISnapshot snapshot;
        List<ThreadOverviewNode> infos;
        Column[] columns;
        HashMapIntObject<Object> root2element;
        ObjectListResult.Outbound objectList;
        int[] colMap;

        public ThreadInfoList(ISnapshot snapshot, List<ThreadOverviewNode> infos) {
            this.snapshot = snapshot;
            this.infos = infos;
            ArrayList<ThreadInfoImpl> threadInfos = new ArrayList<ThreadInfoImpl>(infos.size());
            ArrayInt roots = new ArrayInt();
            for (ThreadOverviewNode node : infos) {
                threadInfos.add(node.threadInfo);
                if (node.stackRoots == null) continue;
                roots.addAll(node.stackRoots);
            }
            this.columns = ThreadInfoImpl.getUsedColumns(threadInfos).toArray(new Column[0]);
            this.columns[0].decorator((IDecorator)this).comparing((Comparator)new NoCompareComparator());
            this.root2element = new HashMapIntObject();
            this.objectList = new ObjectListResult.Outbound(snapshot, roots.toArray());
            for (ThreadOverviewNode o : this.objectList.getElements()) {
                this.root2element.put(this.objectList.getContext(o).getObjectId(), (Object)o);
            }
            this.colMap = new int[this.columns.length];
            Column[] objColumns = this.objectList.getColumns();
            int i = 0;
            while (i < this.columns.length) {
                this.colMap[i] = i == 0 ? 0 : -1;
                int j = 0;
                while (j < objColumns.length) {
                    Column threadCol = this.columns[i];
                    Column listCol = objColumns[j];
                    if (threadCol.getLabel().equals(listCol.getLabel()) && Objects.equals(threadCol.getFormatter(), listCol.getFormatter()) && threadCol.getType().equals(listCol.getType())) {
                        this.colMap[i] = j;
                        break;
                    }
                    ++j;
                }
                ++i;
            }
        }

        public ResultMetaData getResultMetaData() {
            return new ResultMetaData.Builder().addDetailResult(new DetailResultProvider(Messages.ThreadOverviewQuery_ThreadDetails){

                public boolean hasResult(Object row) {
                    if (!(row instanceof ThreadOverviewNode)) {
                        return false;
                    }
                    try {
                        InspectionAssert.heapFormatIsNot(ThreadInfoList.this.snapshot, "phd");
                        return true;
                    }
                    catch (UnsupportedOperationException e) {
                        return false;
                    }
                }

                public URL getIcon() {
                    try {
                        return SnapshotQuery.lookup("thread_details", ThreadInfoList.this.snapshot).getDescriptor().getIcon();
                    }
                    catch (SnapshotException e) {
                        return null;
                    }
                }

                public IResult getResult(Object row, IProgressListener listener) throws SnapshotException {
                    int threadId = ((ThreadOverviewNode)row).threadInfo.getThreadId();
                    return SnapshotQuery.lookup("thread_details", ThreadInfoList.this.snapshot).setArgument("threadIds", threadId).execute(listener);
                }
            }).build();
        }

        public Column[] getColumns() {
            return this.columns;
        }

        public Object getColumnValue(Object row, int columnIndex) {
            if (row instanceof ThreadOverviewNode) {
                ThreadOverviewNode info = (ThreadOverviewNode)row;
                return info.threadInfo.getValue(this.columns[columnIndex]);
            }
            if (row instanceof ThreadStackFrameNode) {
                switch (columnIndex) {
                    case 0: {
                        IStackFrame frame = ((ThreadStackFrameNode)row).stackFrame;
                        return frame.getText();
                    }
                }
            } else {
                int newColumnIndex = this.colMap[columnIndex];
                if (newColumnIndex >= 0) {
                    if (row instanceof ThreadStackFrameLocalNode) {
                        row = this.root2element.get(((ThreadStackFrameLocalNode)row).objectId);
                    }
                    return this.objectList.getColumnValue(row, newColumnIndex);
                }
            }
            return null;
        }

        public IContextObject getContext(final Object row) {
            if (row instanceof ThreadOverviewNode) {
                return new IContextObject(){

                    public int getObjectId() {
                        return ((ThreadOverviewNode)row).threadInfo.getThreadId();
                    }
                };
            }
            if (row instanceof ThreadStackFrameNode) {
                if (((ThreadStackFrameNode)row).objectId != -1) {
                    return new IContextObject(){

                        public int getObjectId() {
                            return ((ThreadStackFrameNode)row).objectId;
                        }
                    };
                }
                return null;
            }
            if (row instanceof ThreadStackFrameLocalNode) {
                return this.objectList.getContext(this.root2element.get(((ThreadStackFrameLocalNode)row).objectId));
            }
            return this.objectList.getContext(row);
        }

        public URL getIcon(Object row) {
            if (row instanceof ThreadOverviewNode) {
                return THREAD_ICON_URL;
            }
            if (row instanceof ThreadStackFrameNode) {
                return STACK_FRAME_ICON_URL;
            }
            if (row instanceof ThreadStackFrameLocalNode) {
                row = this.root2element.get(((ThreadStackFrameLocalNode)row).objectId);
            }
            return this.objectList.getIcon(row);
        }

        public String prefix(Object row) {
            String prefix;
            if (row instanceof ThreadOverviewNode) {
                return null;
            }
            if (row instanceof ThreadStackFrameNode) {
                return null;
            }
            ThreadStackFrameLocalNode tsfmln = null;
            if (row instanceof ThreadStackFrameLocalNode) {
                tsfmln = (ThreadStackFrameLocalNode)row;
                row = this.root2element.get(tsfmln.objectId);
            }
            if ((prefix = this.objectList.prefix(row)) == null) {
                if (tsfmln != null && tsfmln.threadStackFrameNode != null) {
                    boolean topFrame = tsfmln.threadStackFrameNode.firstNonNativeFrame || tsfmln.threadStackFrameNode.depth == 0;
                    ThreadInfoImpl threadInfo = tsfmln.threadStackFrameNode.threadOverviewNode.threadInfo;
                    int objectId = this.objectList.getContext(row).getObjectId();
                    try {
                        GCRootInfo[] gcRootInfos = this.snapshot.getGCRootInfo(objectId);
                        if (gcRootInfos != null) {
                            GCRootInfo[] gCRootInfoArray = gcRootInfos;
                            int n = gcRootInfos.length;
                            int n2 = 0;
                            while (n2 < n) {
                                GCRootInfo gcRootInfo = gCRootInfoArray[n2];
                                if (gcRootInfo.getType() == 32 && gcRootInfo.getContextAddress() != 0L && gcRootInfo.getContextId() == threadInfo.getThreadId()) {
                                    return topFrame ? Messages.ThreadStackQuery_Label_Local_Probably_Blocked_On : Messages.ThreadStackQuery_Label_Local_Busy_Monitor;
                                }
                                if (gcRootInfo.getType() == 32 && gcRootInfo.getContextAddress() == 0L) {
                                    return topFrame ? Messages.ThreadStackQuery_Label_Local_Possibly_Blocked_On : Messages.ThreadStackQuery_Label_Local_Possible_Busy_Monitor;
                                }
                                ++n2;
                            }
                        }
                        List<NamedReference> refs = threadInfo.getThreadObject().getOutboundReferences();
                        for (NamedReference ref : refs) {
                            if (ref.getObjectId() != objectId || !(ref instanceof ThreadToLocalReference)) continue;
                            ThreadToLocalReference tlr = (ThreadToLocalReference)ref;
                            GCRootInfo[] gCRootInfoArray = tlr.getGcRootInfo();
                            int n = gCRootInfoArray.length;
                            int n3 = 0;
                            while (n3 < n) {
                                GCRootInfo gcRootInfo = gCRootInfoArray[n3];
                                if (gcRootInfo.getType() == 32) {
                                    return topFrame ? Messages.ThreadStackQuery_Label_Local_Probably_Blocked_On : Messages.ThreadStackQuery_Label_Local_Busy_Monitor;
                                }
                                ++n3;
                            }
                        }
                    }
                    catch (SnapshotException snapshotException) {
                        // empty catch block
                    }
                }
                return Messages.ThreadStackQuery_Label_Local;
            }
            return prefix;
        }

        public String suffix(Object row) {
            if (row instanceof ThreadOverviewNode) {
                return null;
            }
            if (row instanceof ThreadStackFrameNode) {
                return null;
            }
            if (row instanceof ThreadStackFrameLocalNode) {
                row = this.root2element.get(((ThreadStackFrameLocalNode)row).objectId);
            }
            return this.objectList.suffix(row);
        }

        public List<?> getElements() {
            return this.infos;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof ThreadOverviewNode) {
                IThreadStack stack = ((ThreadOverviewNode)element).stack;
                if (stack == null) {
                    return false;
                }
                IStackFrame[] frames = stack.getStackFrames();
                return frames != null && frames.length > 0;
            }
            if (element instanceof ThreadStackFrameNode) {
                IStackFrame frame = ((ThreadStackFrameNode)element).stackFrame;
                int[] objectIds = frame.getLocalObjectsIds();
                return objectIds != null && objectIds.length > 0;
            }
            if (element instanceof ThreadStackFrameLocalNode) {
                element = this.root2element.get(((ThreadStackFrameLocalNode)element).objectId);
            }
            return this.objectList.hasChildren(element);
        }

        public List<?> getChildren(Object parent) {
            if (parent instanceof ThreadOverviewNode) {
                ThreadOverviewNode ton = (ThreadOverviewNode)parent;
                IStackFrame[] frames = ton.stack.getStackFrames();
                int numFrames = frames.length;
                ArrayList<ThreadStackFrameNode> stackFrameNodes = new ArrayList<ThreadStackFrameNode>(numFrames);
                boolean foundNonNativeFrame = false;
                int[] frameIds = this.frameIds(ton);
                int i = 0;
                while (i < numFrames) {
                    String frameText;
                    IStackFrame frame = frames[i];
                    ThreadStackFrameNode tsfn = new ThreadStackFrameNode();
                    tsfn.stackFrame = frame;
                    tsfn.depth = i;
                    tsfn.firstNonNativeFrame = false;
                    if (!foundNonNativeFrame && (frameText = frame.getText()) != null && !frameText.contains("Native Method")) {
                        tsfn.firstNonNativeFrame = true;
                        foundNonNativeFrame = true;
                    }
                    tsfn.threadOverviewNode = ton;
                    tsfn.objectId = frameIds[tsfn.depth];
                    if (tsfn.objectId == -1) {
                        tsfn.objectId = this.frameId(frame);
                    }
                    stackFrameNodes.add(tsfn);
                    ++i;
                }
                return stackFrameNodes;
            }
            if (parent instanceof ThreadStackFrameNode) {
                ThreadStackFrameNode tsfn = (ThreadStackFrameNode)parent;
                IStackFrame frame = tsfn.stackFrame;
                int[] localIds = frame.getLocalObjectsIds();
                if (localIds != null) {
                    ArrayList<ThreadStackFrameLocalNode> stackFrameLocals = new ArrayList<ThreadStackFrameLocalNode>(localIds.length);
                    int[] nArray = localIds;
                    int n = localIds.length;
                    int n2 = 0;
                    while (n2 < n) {
                        int localId = nArray[n2];
                        ThreadStackFrameLocalNode tsfln = new ThreadStackFrameLocalNode();
                        tsfln.objectId = localId;
                        tsfln.threadStackFrameNode = tsfn;
                        stackFrameLocals.add(tsfln);
                        ++n2;
                    }
                    return stackFrameLocals;
                }
                return null;
            }
            if (parent instanceof ThreadStackFrameLocalNode) {
                parent = this.root2element.get(((ThreadStackFrameLocalNode)parent).objectId);
            }
            return this.objectList.getChildren(parent);
        }

        private int[] frameIds(ThreadOverviewNode ton) {
            int numFrames = ton.stack.getStackFrames().length;
            int[] frameIds = new int[numFrames];
            Arrays.fill(frameIds, -1);
            IObject to = ton.threadInfo.getThreadObject();
            for (NamedReference ref : to.getOutboundReferences()) {
                if (!(ref instanceof ThreadToLocalReference)) continue;
                ThreadToLocalReference tlr = (ThreadToLocalReference)ref;
                GCRootInfo[] gCRootInfoArray = tlr.getGcRootInfo();
                int n = gCRootInfoArray.length;
                int n2 = 0;
                while (n2 < n) {
                    GCRootInfo gcRootInfo = gCRootInfoArray[n2];
                    if (gcRootInfo.getType() == 4096) {
                        try {
                            int f;
                            Object fn = tlr.getObject().resolveValue("frameNumber");
                            if (fn instanceof Integer && (f = ((Integer)fn).intValue()) >= 0 && f < numFrames) {
                                frameIds[f] = tlr.getObjectId();
                            }
                        }
                        catch (SnapshotException snapshotException) {
                            // empty catch block
                        }
                    }
                    ++n2;
                }
            }
            return frameIds;
        }

        private int frameId(IStackFrame frm) {
            String fm = frm.getText();
            if (fm != null) {
                fm = fm.replaceFirst("\\s*at\\s+([^(]+)\\.[^.(]+.*", "$1");
                try {
                    Iterator<IClass> iterator;
                    Collection<IClass> clss = this.snapshot.getClassesByName(fm, false);
                    if (clss != null && clss.size() == 1 && (iterator = clss.iterator()).hasNext()) {
                        IClass cls = iterator.next();
                        return cls.getObjectId();
                    }
                }
                catch (SnapshotException snapshotException) {
                    // empty catch block
                }
            }
            return -1;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class NoCompareComparator
        implements Comparator<Object> {
            NoCompareComparator() {
            }

            @Override
            public int compare(Object o1, Object o2) {
                return 0;
            }
        }
    }

    private class ThreadOverviewNode {
        private ThreadInfoImpl threadInfo;
        private IThreadStack stack;
        private int[] stackRoots;

        private ThreadOverviewNode() {
        }
    }

    private static class ThreadStackFrameLocalNode {
        private ThreadStackFrameNode threadStackFrameNode;
        private int objectId;

        private ThreadStackFrameLocalNode() {
        }
    }

    private static class ThreadStackFrameNode {
        private ThreadOverviewNode threadOverviewNode;
        private IStackFrame stackFrame;
        private int depth;
        private boolean firstNonNativeFrame;
        private int objectId;

        private ThreadStackFrameNode() {
        }
    }
}

