/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui.internal.query.arguments;

import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.query.IQueryContext;
import org.eclipse.mat.query.registry.ArgumentDescriptor;
import org.eclipse.mat.ui.Messages;
import org.eclipse.mat.ui.internal.query.arguments.ArgumentEditor;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableItem;

public class CheckBoxEditor
extends ArgumentEditor {
    private Button checkBox;
    private Boolean value = false;
    private Type type;

    public CheckBoxEditor(Composite parent, IQueryContext context, ArgumentDescriptor descriptor, TableItem item, Type type) {
        super(parent, context, descriptor, item);
        this.type = type;
        this.setFont(item.getFont());
        this.setBackground(item.getBackground());
        this.setLayout((Layout)new FillLayout());
        this.createContents(parent);
    }

    private void createContents(Composite parent) {
        this.checkBox = new Button((Composite)this, 32);
        this.checkBox.setFont(this.item.getFont());
        this.checkBox.setBackground(this.item.getBackground());
        this.checkBox.setText(this.type.getLabel());
        this.checkBox.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                CheckBoxEditor.this.fireFocusEvent(CheckBoxEditor.this.type.getHelpText());
            }

            public void focusLost(FocusEvent e) {
                CheckBoxEditor.this.fireFocusEvent(null);
            }
        });
        this.checkBox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                CheckBoxEditor.this.editingDone();
            }
        });
        this.checkBox.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.character == '\r') {
                    CheckBoxEditor.this.editingDone();
                }
            }
        });
    }

    protected void editingDone() {
        this.value = this.checkBox.getSelection();
        this.fireValueChangedEvent(this.value, this);
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public void setValue(Object value) throws SnapshotException {
        this.value = (Boolean)value;
        this.checkBox.setSelection(this.value.booleanValue());
    }

    public boolean setFocus() {
        return this.checkBox.setFocus();
    }

    public Type getType() {
        return this.type;
    }

    public static enum Type {
        INCLUDE_CLASS_INSTANCE(Messages.CheckBoxEditor_includeClassInstance, null),
        INCLUDE_SUBCLASSES(Messages.CheckBoxEditor_includeSubclasses, Messages.CheckBoxEditor_includeSubclassesAdditional),
        INTEPRET_AS_CLASSLOADER(Messages.CheckBoxEditor_includeLoadedObjects, Messages.CheckBoxEditor_includeLoadedObjectsAdditional),
        RETAINED(Messages.CheckBoxEditor_asRetainedSet, Messages.CheckBoxEditor_asRetainedSetAdditional),
        VERBOSE(Messages.CheckBoxEditor_verbose, Messages.CheckBoxEditor_verboseAdditional);

        private String label;
        private String helpText;

        private Type(String label, String helpText) {
            this.label = label;
            this.helpText = helpText;
        }

        public String getLabel() {
            return this.label;
        }

        public String getHelpText() {
            return this.helpText;
        }
    }
}

