/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.infra.discovery.core.internal.catalog;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.modisco.infra.common.core.logging.MoDiscoLogger;
import org.eclipse.modisco.infra.discovery.catalog.CatalogFactory;
import org.eclipse.modisco.infra.discovery.catalog.DirectionKind;
import org.eclipse.modisco.infra.discovery.catalog.DiscovererDescription;
import org.eclipse.modisco.infra.discovery.catalog.DiscovererParameter;
import org.eclipse.modisco.infra.discovery.core.annotations.Parameter;
import org.eclipse.modisco.infra.discovery.core.annotations.ParameterInitialValue;
import org.eclipse.modisco.infra.discovery.core.internal.Activator;
import org.eclipse.modisco.infra.discovery.core.internal.annotations.DiscoveryAnnotationControls;
import org.eclipse.modisco.infra.discovery.core.internal.annotations.ParameterDeclarationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DiscovererParameterUtils {
    private static final String VOID_TYPE = "void";
    private static DiscovererParameterUtils singleton = new DiscovererParameterUtils();

    private DiscovererParameterUtils() {
    }

    public static synchronized DiscovererParameterUtils getInstance() {
        if (singleton == null) {
            singleton = new DiscovererParameterUtils();
        }
        return singleton;
    }

    public void computeParameters(DiscovererDescription discovererDescription) {
        HashMap<String, HashMap<Member, Parameter>> memberToParameterAnnotationMaps = new HashMap<String, HashMap<Member, Parameter>>();
        HashMap<String, HashMap<Method, ParameterInitialValue>> methodToParameterInitialValueAnnotationMaps = new HashMap<String, HashMap<Method, ParameterInitialValue>>();
        ArrayList<Member> members = new ArrayList<Member>();
        this.retrieveMembers(discovererDescription.getImplementationType(), members);
        for (Member member : members) {
            Parameter parameterAnnotation = null;
            ParameterInitialValue parameterInitialValueAnnotation = null;
            if (member instanceof Field) {
                parameterAnnotation = ((Field)member).getAnnotation(Parameter.class);
            }
            if (member instanceof Method) {
                parameterAnnotation = ((Method)member).getAnnotation(Parameter.class);
                parameterInitialValueAnnotation = ((Method)member).getAnnotation(ParameterInitialValue.class);
            }
            if (parameterAnnotation != null) {
                try {
                    DiscoveryAnnotationControls.checkAnnotation(parameterAnnotation, null, member);
                    HashMap<Member, Parameter> memberToParameterMap = (HashMap<Member, Parameter>)memberToParameterAnnotationMaps.get(parameterAnnotation.name());
                    if (memberToParameterMap == null) {
                        memberToParameterMap = new HashMap<Member, Parameter>();
                        memberToParameterAnnotationMaps.put(parameterAnnotation.name(), memberToParameterMap);
                    }
                    memberToParameterMap.put(member, parameterAnnotation);
                }
                catch (ParameterDeclarationException e) {
                    MoDiscoLogger.logError((String)("Some Discoverer parameter annotation " + parameterAnnotation + " has problems and will be ignored : " + e.getMessage()), (Plugin)Activator.getDefault());
                }
            }
            if (parameterInitialValueAnnotation == null) continue;
            try {
                DiscoveryAnnotationControls.checkAnnotation(parameterInitialValueAnnotation, null, (Method)member);
                HashMap<Method, ParameterInitialValue> methodToParameterInitialValueMap = (HashMap<Method, ParameterInitialValue>)methodToParameterInitialValueAnnotationMaps.get(parameterInitialValueAnnotation.name());
                if (methodToParameterInitialValueMap == null) {
                    methodToParameterInitialValueMap = new HashMap<Method, ParameterInitialValue>();
                    methodToParameterInitialValueAnnotationMaps.put(parameterInitialValueAnnotation.name(), methodToParameterInitialValueMap);
                }
                methodToParameterInitialValueMap.put((Method)member, parameterInitialValueAnnotation);
            }
            catch (ParameterDeclarationException e) {
                MoDiscoLogger.logError((String)("Some Discoverer parameter annotation " + parameterInitialValueAnnotation + " has problems and will be ignored : " + e.getMessage()), (Plugin)Activator.getDefault());
            }
        }
        for (Map.Entry entry : memberToParameterAnnotationMaps.entrySet()) {
            Map methodToParameterInitialValueMap = (Map)methodToParameterInitialValueAnnotationMaps.get(entry.getKey());
            try {
                DiscoveryAnnotationControls.checkAnnotationsForOneParameter(null, (Map)entry.getValue(), null, methodToParameterInitialValueMap);
            }
            catch (ParameterDeclarationException e) {
                MoDiscoLogger.logError((String)("Some Discoverer annotations have problems and will be ignored : " + e.getMessage()), (Plugin)Activator.getDefault());
            }
            Method initializer = null;
            if (methodToParameterInitialValueMap != null && methodToParameterInitialValueMap.keySet().size() > 0) {
                initializer = (Method)methodToParameterInitialValueMap.keySet().iterator().next();
            }
            DiscovererParameter discoveryParameter = CatalogFactory.eINSTANCE.createDiscovererParameter();
            DiscovererParameterUtils.unifyParameterProperties((Map)entry.getValue(), initializer, discoveryParameter);
            discovererDescription.getParameterDefinitions().add((Object)discoveryParameter);
        }
    }

    private static synchronized void unifyParameterProperties(Map<Member, Parameter> memberToAnnotationMap, Method initializer, DiscovererParameter discoveryParameter) {
        boolean required = false;
        Class<?> type = null;
        String name = null;
        String description = null;
        DirectionKind direction = null;
        Field field = null;
        Method getter = null;
        Method setter = null;
        ArrayList<Parameter> declaringAnnotations = new ArrayList<Parameter>();
        for (Map.Entry<Member, Parameter> entry : memberToAnnotationMap.entrySet()) {
            if (entry.getValue().name() != null && entry.getValue().name().length() > 0) {
                name = entry.getValue().name();
            }
            if (entry.getValue().description() != null && entry.getValue().description().length() > 0) {
                description = entry.getValue().description();
            }
            required = required || entry.getValue().requiresInputValue();
            declaringAnnotations.add(entry.getValue());
            if (entry.getKey() instanceof Field) {
                field = (Field)entry.getKey();
                if (!Modifier.isPublic((int)field.getModifiers())) continue;
                direction = DirectionKind.INOUT;
                type = field.getType();
                continue;
            }
            if (!(entry.getKey() instanceof Method)) continue;
            Method method = (Method)entry.getKey();
            if (DiscovererParameterUtils.isGetter(method)) {
                type = method.getReturnType();
                getter = method;
                if (direction == null) {
                    direction = DirectionKind.OUT;
                    continue;
                }
                direction = DirectionKind.INOUT;
                continue;
            }
            if (!DiscovererParameterUtils.isSetter(method)) continue;
            type = method.getParameterTypes()[0];
            setter = method;
            direction = direction == null ? DirectionKind.IN : DirectionKind.INOUT;
        }
        discoveryParameter.setId(name);
        discoveryParameter.setDescription(description);
        discoveryParameter.setRequiredInput(required);
        discoveryParameter.setType(type);
        discoveryParameter.setDirection(direction);
        discoveryParameter.setField(field);
        discoveryParameter.setGetter(getter);
        discoveryParameter.setSetter(setter);
        discoveryParameter.setInitializer(initializer);
    }

    private void retrieveMembers(Class<?> aClass, List<Member> members) {
        AnnotatedElement[] annotatedElementArray = aClass.getFields();
        int n = annotatedElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field aField = annotatedElementArray[n2];
            members.add(aField);
            ++n2;
        }
        annotatedElementArray = aClass.getMethods();
        n = annotatedElementArray.length;
        n2 = 0;
        while (n2 < n) {
            AccessibleObject aMethod = annotatedElementArray[n2];
            members.add((Member)((Object)aMethod));
            ++n2;
        }
        annotatedElementArray = aClass.getInterfaces();
        n = annotatedElementArray.length;
        n2 = 0;
        while (n2 < n) {
            AnnotatedElement anInterface = annotatedElementArray[n2];
            this.retrieveMembers((Class<?>)anInterface, members);
            ++n2;
        }
        if (aClass.getSuperclass() != null) {
            this.retrieveMembers(aClass.getSuperclass(), members);
        }
    }

    private static boolean isGetter(Method method) {
        return method.getReturnType() != null && !method.getReturnType().getName().equals(VOID_TYPE);
    }

    private static boolean isSetter(Method method) {
        return method.getParameterTypes().length > 0;
    }
}

