/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.infra.query.core.internal.validation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.validation.AbstractModelConstraint;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.modisco.infra.common.core.logging.MoDiscoLogger;
import org.eclipse.modisco.infra.query.JavaModelQuery;
import org.eclipse.modisco.infra.query.core.internal.Activator;
import org.eclipse.modisco.infra.query.core.internal.Messages;
import org.eclipse.modisco.infra.query.core.internal.utils.QueryUtils;
import org.eclipse.modisco.infra.query.core.java.IJavaModelQuery;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;

@Deprecated
public class ImplementationClassInterface
extends AbstractModelConstraint {
    private static final long LOG_JOB_DELAY = 5000L;
    private LogJob logJob = null;

    public IStatus validate(IValidationContext ctx) {
        JavaModelQuery modelQuery = (JavaModelQuery)ctx.getTarget();
        EMFEventType eType = ctx.getEventType();
        if (eType == EMFEventType.NULL) {
            if (modelQuery.getImplementationClassName() == null || modelQuery.eResource() == null) {
                return ctx.createSuccessStatus();
            }
            URI uri = modelQuery.eResource().getURI();
            String containerName = uri.segment(1);
            if (uri.segment(0).equals("plugin")) {
                Bundle bundle = Platform.getBundle((String)containerName);
                return this.validateInstalledQuery(ctx, modelQuery, bundle);
            }
            if (uri.segment(0).equals("resource")) {
                IWorkspace ws = ResourcesPlugin.getWorkspace();
                IWorkspaceRoot wsr = ws.getRoot();
                IProject project = wsr.getProject(containerName);
                IJavaProject javaProject = JavaCore.create((IProject)project);
                return this.validateWorkspaceQuery(ctx, modelQuery, javaProject);
            }
        }
        return ctx.createSuccessStatus();
    }

    private IStatus validateInstalledQuery(IValidationContext ctx, JavaModelQuery modelQuery, Bundle bundle) {
        try {
            Class c = bundle.loadClass(modelQuery.getImplementationClassName());
            if (!IJavaModelQuery.class.isAssignableFrom(c)) {
                return ctx.createFailureStatus(new Object[]{NLS.bind((String)Messages.ImplementationClassInterface_wrongInterface, (Object)modelQuery.getImplementationClassName())});
            }
            return ctx.createSuccessStatus();
        }
        catch (ClassNotFoundException e) {
            return ctx.createSuccessStatus();
        }
    }

    private IStatus validateWorkspaceQuery(IValidationContext ctx, final JavaModelQuery modelQuery, IJavaProject javaProject) {
        try {
            String[] superInterfaceTypeSignatures;
            IType type = javaProject.findType(modelQuery.getImplementationClassName());
            if (type == null) {
                return ctx.createSuccessStatus();
            }
            String[] stringArray = superInterfaceTypeSignatures = type.getSuperInterfaceTypeSignatures();
            int n = superInterfaceTypeSignatures.length;
            int n2 = 0;
            while (n2 < n) {
                String superInterfaceTypeSignature = stringArray[n2];
                String typeErasure = Signature.getTypeErasure((String)superInterfaceTypeSignature);
                String implementedInterface = Signature.getSignatureSimpleName((String)typeErasure);
                if (IJavaModelQuery.class.getSimpleName().equals(implementedInterface)) {
                    String[] typeArguments = Signature.getTypeArguments((String)superInterfaceTypeSignature);
                    if (typeArguments.length == 2) {
                        String contextType = typeArguments[0];
                        String returnType = typeArguments[1];
                        try {
                            IStatus contextTypeValidationResult = this.validateContextType(contextType, type, modelQuery, ctx, javaProject);
                            if (!contextTypeValidationResult.isOK()) {
                                return contextTypeValidationResult;
                            }
                        }
                        catch (UnresolvedType e) {
                            this.ifNoMarkers(type, new Runnable(){

                                public void run() {
                                    MoDiscoLogger.logWarning((Throwable)e, (String)("Unresolved type while validating query context type: " + modelQuery.getName()), (Plugin)Activator.getDefault());
                                }
                            });
                        }
                        try {
                            IStatus returnTypeValidationResult = this.validateReturnType(returnType, type, modelQuery, ctx, javaProject);
                            if (!returnTypeValidationResult.isOK()) {
                                return returnTypeValidationResult;
                            }
                        }
                        catch (UnresolvedType e) {
                            this.ifNoMarkers(type, new Runnable(){

                                public void run() {
                                    MoDiscoLogger.logWarning((Throwable)e, (String)("Unresolved type while validating query return type: " + modelQuery.getName()), (Plugin)Activator.getDefault());
                                }
                            });
                        }
                        return ctx.createSuccessStatus();
                    }
                    return ctx.createFailureStatus(new Object[]{NLS.bind((String)Messages.ImplementationClassInterface_wrongInterface2, (Object)modelQuery.getImplementationClassName())});
                }
                ++n2;
            }
            return ctx.createFailureStatus(new Object[]{NLS.bind((String)Messages.ImplementationClassInterface_wrongInterface3, (Object)modelQuery.getImplementationClassName())});
        }
        catch (JavaModelException e) {
            MoDiscoLogger.logError((Throwable)e, (Plugin)Activator.getDefault());
            return ctx.createSuccessStatus();
        }
    }

    private IStatus validateReturnType(String returnType, IType type, final JavaModelQuery modelQuery, IValidationContext ctx, IJavaProject javaProject) throws JavaModelException, UnresolvedType {
        String returnTypeQualifiedName = this.findTypeQualifiedName(returnType, type);
        if (modelQuery.getReturnType() == null) {
            return ctx.createSuccessStatus();
        }
        String instanceClassName = modelQuery.getReturnType().getInstanceClassName();
        if (instanceClassName != null) {
            String expectedReturnTypeInstanceClassName = QueryUtils.qualifiedObjectType(instanceClassName);
            String expectedReturnType = Signature.createTypeSignature((String)expectedReturnTypeInstanceClassName, (boolean)false);
            if (modelQuery.getUpperBound() != 1) {
                IType tReturnType = javaProject.findType(returnTypeQualifiedName);
                try {
                    if (!this.validateType(tReturnType, "java.util.Collection", type, javaProject)) {
                        return ctx.createFailureStatus(new Object[]{NLS.bind((String)Messages.ImplementationClassInterface_wrongInterfaceCollection, (Object)modelQuery.getImplementationClassName(), (Object)expectedReturnTypeInstanceClassName)});
                    }
                }
                catch (UnresolvedType e) {
                    this.ifNoMarkers(type, new Runnable(){

                        public void run() {
                            MoDiscoLogger.logWarning((Throwable)e, (String)("Unresolved type while validating multi-valued return type in query: " + modelQuery.getName()), (Plugin)Activator.getDefault());
                        }
                    });
                }
                String[] returnTypeArguments = Signature.getTypeArguments((String)returnType);
                if (returnTypeArguments.length == 1) {
                    char c;
                    String returnTypeArgument = returnTypeArguments[0];
                    if (returnTypeArgument.length() > 0 && ((c = returnTypeArgument.charAt(0)) == '+' || c == '-')) {
                        returnTypeArgument = returnTypeArgument.substring(1);
                    }
                    try {
                        String returnTypeArgumentQualifiedName = this.findTypeQualifiedName(returnTypeArgument, type);
                        if (returnTypeArgumentQualifiedName != null && !expectedReturnType.equals(Signature.createTypeSignature((String)returnTypeArgumentQualifiedName, (boolean)false))) {
                            return ctx.createFailureStatus(new Object[]{NLS.bind((String)Messages.ImplementationClassInterface_wrongInterfaceCollection2, (Object[])new Object[]{modelQuery.getImplementationClassName(), Signature.getSimpleName((String)returnTypeArgument), expectedReturnTypeInstanceClassName})});
                        }
                    }
                    catch (UnresolvedType e) {
                        this.ifNoMarkers(type, new Runnable(){

                            public void run() {
                                MoDiscoLogger.logWarning((Throwable)e, (String)("Unresolved type while validating multi-valued return type argument in query: " + modelQuery.getName()), (Plugin)Activator.getDefault());
                            }
                        });
                    }
                }
            } else {
                String returnTypeSignature = Signature.createTypeSignature((String)returnTypeQualifiedName, (boolean)false);
                if (!expectedReturnType.equals(returnTypeSignature)) {
                    return ctx.createFailureStatus(new Object[]{NLS.bind((String)Messages.ImplementationClassInterface_wrongReturnType, (Object[])new Object[]{modelQuery.getImplementationClassName(), returnTypeQualifiedName, expectedReturnTypeInstanceClassName})});
                }
            }
        }
        return ctx.createSuccessStatus();
    }

    private IStatus validateContextType(String contextType, IType queryImplType, final JavaModelQuery modelQuery, IValidationContext ctx, IJavaProject javaProject) throws JavaModelException, UnresolvedType {
        String contextTypeQualifiedName = this.findTypeQualifiedName(contextType, queryImplType);
        EList scopes = modelQuery.getScope();
        for (EClass scope : scopes) {
            String scopeClassName = scope.getInstanceClassName();
            if (scopeClassName != null) {
                IType tScope = javaProject.findType(scopeClassName);
                if (tScope != null) {
                    try {
                        if (this.validateType(tScope, contextTypeQualifiedName, queryImplType, javaProject)) continue;
                        return ctx.createFailureStatus(new Object[]{NLS.bind((String)Messages.ImplementationClassInterface_wrongScope, (Object[])new Object[]{modelQuery.getImplementationClassName(), contextTypeQualifiedName, scopeClassName})});
                    }
                    catch (UnresolvedType e) {
                        this.ifNoMarkers(queryImplType, new Runnable(){

                            public void run() {
                                MoDiscoLogger.logWarning((Throwable)e, (String)("Unresolved type while validating scope in query: " + modelQuery.getName()), (Plugin)Activator.getDefault());
                            }
                        });
                    }
                    continue;
                }
                MoDiscoLogger.logWarning((String)("Couldn't resolve scope type " + scopeClassName), (Plugin)Activator.getDefault());
                continue;
            }
            MoDiscoLogger.logWarning((String)("Couldn't resolve scope type because InstanceClassName is null: " + scope.getName()), (Plugin)Activator.getDefault());
        }
        return ctx.createSuccessStatus();
    }

    private boolean validateType(IType type, String expectedType, IType contextType, IJavaProject javaProject) throws JavaModelException, UnresolvedType {
        if (type == null) {
            return false;
        }
        String fullyQualifiedName = type.getFullyQualifiedName();
        if (expectedType.equals(fullyQualifiedName)) {
            return true;
        }
        String expectedTypeSignature = Signature.createTypeSignature((String)expectedType, (boolean)true);
        return this.isSubType(type, expectedTypeSignature, contextType, javaProject);
    }

    private boolean isSubType(IType type, String expectedTypeSignature, IType contextType, IJavaProject javaProject) throws JavaModelException, UnresolvedType {
        String fullyQualifiedName = type.getFullyQualifiedName();
        if (expectedTypeSignature.equals(Signature.createTypeSignature((String)fullyQualifiedName, (boolean)true)) || expectedTypeSignature.equals(Signature.createTypeSignature((String)fullyQualifiedName, (boolean)false))) {
            return true;
        }
        String[] returnTypeSuperInterfaceTypeSignatures = type.getSuperInterfaceTypeSignatures();
        ArrayList<String> allSuperTypes = new ArrayList<String>();
        String superclassTypeSignature = type.getSuperclassTypeSignature();
        if (superclassTypeSignature != null) {
            allSuperTypes.add(superclassTypeSignature);
        }
        String[] stringArray = returnTypeSuperInterfaceTypeSignatures;
        int n = returnTypeSuperInterfaceTypeSignatures.length;
        int n2 = 0;
        while (n2 < n) {
            String returnTypeSuperInterfaceTypeSignature = stringArray[n2];
            if (expectedTypeSignature.equals(Signature.getTypeErasure((String)returnTypeSuperInterfaceTypeSignature))) {
                return true;
            }
            allSuperTypes.add(returnTypeSuperInterfaceTypeSignature);
            ++n2;
        }
        for (String superType : allSuperTypes) {
            String superTypeQualifiedName = this.findTypeQualifiedName(superType, type);
            IType tSuperType = javaProject.findType(Signature.getTypeErasure((String)superTypeQualifiedName));
            if (tSuperType == null) {
                throw new UnresolvedType(superTypeQualifiedName, "project " + javaProject.getElementName());
            }
            if (!this.isSubType(tSuperType, expectedTypeSignature, contextType, javaProject)) continue;
            return true;
        }
        return false;
    }

    private String findTypeQualifiedName(String typeName, IType contextType) throws JavaModelException, UnresolvedType {
        String qualifiedName;
        String qualifier = Signature.getSignatureQualifier((String)typeName);
        String simpleName = Signature.getSignatureSimpleName((String)typeName);
        if (qualifier.length() > 0) {
            qualifiedName = String.valueOf(qualifier) + "." + simpleName;
        } else {
            String[][] resolvedTypes = contextType.resolveType(simpleName);
            if (resolvedTypes != null && resolvedTypes.length > 0) {
                qualifiedName = String.valueOf(resolvedTypes[0][0]) + "." + resolvedTypes[0][1];
            } else {
                throw new UnresolvedType(simpleName, contextType.getCompilationUnit().getElementName());
            }
        }
        return qualifiedName;
    }

    private void ifNoMarkers(IType type, Runnable runnable) {
        IResource resource = type.getResource();
        if (resource != null) {
            if (this.logJob == null) {
                this.logJob = new LogJob();
                this.logJob.setSystem(true);
                this.logJob.setPriority(50);
            } else {
                this.logJob.cancel();
            }
            this.logJob.add(new LogJobItem(resource, runnable));
            this.logJob.schedule(5000L);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean hasCompilationErrors(IResource resource) {
        try {
            IMarker[] markers;
            IMarker[] iMarkerArray = markers = resource.findMarkers("org.eclipse.jdt.core.problem", true, 2);
            int n = markers.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                IMarker marker = iMarkerArray[n2];
                if (2 == (Integer)marker.getAttribute("severity")) {
                    return true;
                }
                ++n2;
            }
        }
        catch (Exception e) {
            MoDiscoLogger.logError((Throwable)e, (Plugin)Activator.getDefault());
        }
        return false;
    }

    class LogJob
    extends Job {
        private final List<LogJobItem> items;

        public LogJob() {
            super(Messages.ImplementationClassInterface_logErrorsJobName);
            this.items = Collections.synchronizedList(new ArrayList());
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                Job.getJobManager().join(ResourcesPlugin.FAMILY_MANUAL_BUILD, null);
                Job.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_BUILD, null);
            }
            catch (InterruptedException e) {
                MoDiscoLogger.logError((Throwable)e, (Plugin)Activator.getDefault());
            }
            for (LogJobItem logJobItem : this.items) {
                if (ImplementationClassInterface.this.hasCompilationErrors(logJobItem.getResource())) continue;
                logJobItem.getRunnable().run();
            }
            return Status.OK_STATUS;
        }

        public void add(LogJobItem logJobItem) {
            this.items.add(logJobItem);
        }
    }

    class LogJobItem {
        private final IResource resource;
        private final Runnable runnable;

        public LogJobItem(IResource resource, Runnable runnable) {
            this.resource = resource;
            this.runnable = runnable;
        }

        public IResource getResource() {
            return this.resource;
        }

        public Runnable getRunnable() {
            return this.runnable;
        }
    }

    private class UnresolvedType
    extends Exception {
        private static final long serialVersionUID = -1954221535388576391L;
        private final String typeQualifiedName;
        private final String location;

        public UnresolvedType(String returnTypeName, String location) {
            this.typeQualifiedName = returnTypeName;
            this.location = " in " + location;
        }

        public String getMessage() {
            return "Couldn't resolve type " + this.typeQualifiedName + this.location;
        }
    }
}

