/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.properties;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.actions.AddRepositoryAction;
import org.eclipse.mylyn.internal.tasks.ui.properties.Messages;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskRepositoriesSorter;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskRepositoryLabelProvider;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.internal.dialogs.DialogUtil;

public class ProjectTaskRepositoryPage
extends PropertyPage {
    private static final int REPOSITORY_LIST_MULTIPLIER = 30;
    private IProject project;
    private boolean modified = false;
    private CheckboxTableViewer listViewer;

    protected Control createContents(Composite parent) {
        Font font = parent.getFont();
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768));
        composite.setFont(font);
        this.initialize();
        Label description = this.createDescriptionLabel(composite);
        description.setLayoutData((Object)new GridData(4, 128, true, false));
        this.listViewer = CheckboxTableViewer.newCheckList((Composite)composite, (int)2176);
        this.listViewer.getTable().setFont(font);
        GridData data = new GridData(1808);
        data.grabExcessHorizontalSpace = true;
        if (DialogUtil.inRegularFontMode((Composite)parent)) {
            data.heightHint = ProjectTaskRepositoryPage.getDefaultFontHeight((Control)this.listViewer.getTable(), 30);
        }
        this.listViewer.getTable().setLayoutData((Object)data);
        this.listViewer.getTable().setFont(font);
        this.listViewer.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)new TaskRepositoryLabelProvider(), PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator()));
        this.listViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer v, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object parent) {
                return TasksUi.getRepositoryManager().getAllRepositories().toArray();
            }
        });
        this.listViewer.setSorter((ViewerSorter)new TaskRepositoriesSorter());
        this.listViewer.setInput((Object)this.project.getWorkspace());
        this.listViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (event.getChecked()) {
                    ProjectTaskRepositoryPage.this.listViewer.setAllChecked(false);
                    ProjectTaskRepositoryPage.this.listViewer.setChecked(event.getElement(), event.getChecked());
                }
                ProjectTaskRepositoryPage.this.modified = true;
            }
        });
        this.updateLinkedRepository();
        final AddRepositoryAction action = new AddRepositoryAction();
        action.setPromptToAddQuery(false);
        Button button = new Button(composite, 0);
        button.setLayoutData((Object)new GridData(34));
        button.setText(AddRepositoryAction.TITLE);
        button.setEnabled(action.isEnabled());
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TaskRepository taskRepository = action.showWizard();
                if (taskRepository != null) {
                    ProjectTaskRepositoryPage.this.listViewer.setInput((Object)ProjectTaskRepositoryPage.this.project.getWorkspace());
                    ProjectTaskRepositoryPage.this.listViewer.setSelection((ISelection)new StructuredSelection((Object)taskRepository));
                    ProjectTaskRepositoryPage.this.updateLinkedRepository();
                }
            }
        });
        return composite;
    }

    void updateLinkedRepository() {
        TaskRepository repository = TasksUiPlugin.getDefault().getRepositoryForResource((IResource)this.project);
        if (repository != null) {
            this.listViewer.setCheckedElements(new Object[]{repository});
        }
        this.listViewer.getControl().setEnabled(TasksUiPlugin.getDefault().canSetRepositoryForResource((IResource)this.project));
    }

    private static int getDefaultFontHeight(Control control, int lines) {
        FontData[] viewerFontData = control.getFont().getFontData();
        int fontHeight = 10;
        if (viewerFontData.length > 0) {
            fontHeight = viewerFontData[0].getHeight();
        }
        return lines * fontHeight;
    }

    private void initialize() {
        this.project = (IProject)this.getElement().getAdapter(IResource.class);
        if (this.project == null) {
            throw new RuntimeException("org.eclipse.mylyn.tasks.ui: Can not get the project of " + this.getElement());
        }
        this.noDefaultAndApplyButton();
        this.setDescription(Messages.ProjectTaskRepositoryPage_Select_a_task_repository_to_associate_with_this_project_below);
    }

    public boolean performOk() {
        if (!this.modified) {
            return true;
        }
        if (this.listViewer.getCheckedElements().length > 0) {
            TaskRepository selectedRepository = (TaskRepository)this.listViewer.getCheckedElements()[0];
            TasksUiPlugin.getDefault().setRepositoryForResource((IResource)this.project, selectedRepository);
        } else {
            TasksUiPlugin.getDefault().setRepositoryForResource((IResource)this.project, null);
        }
        return true;
    }
}

