/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.editor.perspectiveconfiguration;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.papyrus.editor.perspectiveconfiguration.Configuration;
import org.eclipse.papyrus.editor.perspectiveconfiguration.ConfigurationService;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PerspectiveAdapter;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.IActivityManager;
import org.eclipse.ui.activities.IWorkbenchActivitySupport;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.registry.PerspectiveRegistry;

public class PapyrusPerspectiveListener
extends PerspectiveAdapter {
    private IWorkbenchWindow window;
    protected ConfigurationService configurationservice;
    protected ArrayList<PreferenceNode> hiddenRootPref = new ArrayList();

    public PapyrusPerspectiveListener(IWorkbenchWindow window) {
        this.window = window;
        this.configurationservice = new ConfigurationService();
        if (window.getActivePage() != null) {
            IPerspectiveDescriptor openedPerspectiveDescriptor = window.getActivePage().getPerspective();
            if (this.configurationservice.getConfiguration(openedPerspectiveDescriptor.getId()) != null && !this.isAlreadySave(openedPerspectiveDescriptor.getId())) {
                this.updateTooling(openedPerspectiveDescriptor);
                window.getActivePage().savePerspective();
            }
            this.updatePreferencePage(openedPerspectiveDescriptor);
        }
    }

    public boolean isAlreadySave(String perspectiveID) {
        PerspectiveRegistry perspRegistry = (PerspectiveRegistry)WorkbenchPlugin.getDefault().getPerspectiveRegistry();
        return true;
    }

    public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspectivedescriptor) {
        super.perspectiveActivated(page, perspectivedescriptor);
        if (this.configurationservice.getConfiguration(perspectivedescriptor.getId()) != null) {
            this.updateTooling(perspectivedescriptor);
        }
        this.updatePreferencePage(perspectivedescriptor);
    }

    protected void updatePreferencePage(IPerspectiveDescriptor perspectivedescriptor) {
        if (this.configurationservice.getConfiguration(perspectivedescriptor.getId()) != null) {
            Configuration configuration = this.configurationservice.getConfiguration(perspectivedescriptor.getId());
            IPreferenceNode[] preferencepagelist = this.window.getWorkbench().getPreferenceManager().getRootSubNodes();
            int i = 0;
            while (i < preferencepagelist.length) {
                if (preferencepagelist[i] instanceof PreferenceNode) {
                    PreferenceNode node = (PreferenceNode)preferencepagelist[i];
                    if (!configuration.getPreferenceID().contains(node.getId())) {
                        this.hiddenRootPref.add(node);
                    }
                }
                ++i;
            }
            Iterator<PreferenceNode> iteratorpreftoremove = this.hiddenRootPref.iterator();
            while (iteratorpreftoremove.hasNext()) {
                this.window.getWorkbench().getPreferenceManager().remove((IPreferenceNode)iteratorpreftoremove.next());
            }
        } else {
            Iterator<PreferenceNode> iteratorpreftoremove = this.hiddenRootPref.iterator();
            while (iteratorpreftoremove.hasNext()) {
                this.window.getWorkbench().getPreferenceManager().addToRoot((IPreferenceNode)iteratorpreftoremove.next());
            }
            this.hiddenRootPref.clear();
        }
    }

    protected void updateTooling(final IPerspectiveDescriptor perspectivedescriptor) {
        IWorkbenchActivitySupport workbenchActivitySupport = PlatformUI.getWorkbench().getActivitySupport();
        IActivityManager activityManager = workbenchActivitySupport.getActivityManager();
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                block13: {
                    try {
                        IContributionItem[] items;
                        IWorkbenchWindow window = Workbench.getInstance().getActiveWorkbenchWindow();
                        if (!(window instanceof WorkbenchWindow)) break block13;
                        WorkbenchPage worbenchPage = (WorkbenchPage)window.getActivePage();
                        ICommandService cmdService = (ICommandService)worbenchPage.getActivePart().getSite().getService(ICommandService.class);
                        Configuration configuration = PapyrusPerspectiveListener.this.configurationservice.getConfiguration(perspectivedescriptor.getId());
                        ArrayList<String> commandIdToRemove = new ArrayList<String>();
                        try {
                            int i = 0;
                            while (i < cmdService.getDefinedCommands().length) {
                                if (!configuration.getCategoryIDList().contains(cmdService.getDefinedCommands()[i].getCategory().getId())) {
                                    commandIdToRemove.add(cmdService.getDefinedCommands()[i].getId());
                                }
                                ++i;
                            }
                            i = 0;
                            while (i < cmdService.getDefinedCommands().length) {
                                if (!configuration.getCommandIDList().contains(cmdService.getDefinedCommands()[i].getId())) {
                                    if (!configuration.getCategoryIDList().contains(cmdService.getDefinedCommands()[i].getCategory().getId()) && !commandIdToRemove.contains(cmdService.getDefinedCommands()[i].getId())) {
                                        commandIdToRemove.add(cmdService.getDefinedCommands()[i].getId());
                                    }
                                } else if (commandIdToRemove.contains(cmdService.getDefinedCommands()[i].getId())) {
                                    commandIdToRemove.remove(cmdService.getDefinedCommands()[i].getId());
                                }
                                ++i;
                            }
                        }
                        catch (Exception e) {
                            System.err.println(e);
                        }
                        MenuManager menuManager = ((WorkbenchWindow)window).getMenuManager();
                        IContributionItem[] iContributionItemArray = items = menuManager.getItems();
                        int n = items.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IContributionItem item = iContributionItemArray[n2];
                            if (!configuration.getMenuIDList().contains(item.getId())) {
                                menuManager.remove(item.getId());
                            }
                            ++n2;
                        }
                    }
                    catch (Exception e) {
                        System.err.println(e);
                    }
                }
            }
        });
    }

    public void perspectiveDeactivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
    }
}

