/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.properties.contexts.provider;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.papyrus.infra.constraints.provider.DisplayUnitItemProvider;
import org.eclipse.papyrus.infra.properties.contexts.ContextsPackage;
import org.eclipse.papyrus.infra.properties.contexts.View;
import org.eclipse.papyrus.infra.properties.environment.provider.PropertiesEditPlugin;

public class ViewItemProvider
extends DisplayUnitItemProvider {
    public ViewItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addNamePropertyDescriptor(object);
            this.addSectionsPropertyDescriptor(object);
            this.addAutomaticContextPropertyDescriptor(object);
            this.addDatacontextsPropertyDescriptor(object);
        }
        return this.itemPropertyDescriptors;
    }

    protected void addNamePropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_View_name_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_View_name_feature", "_UI_View_type"), (EStructuralFeature)ContextsPackage.Literals.VIEW__NAME, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addSectionsPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_View_sections_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_View_sections_feature", "_UI_View_type"), (EStructuralFeature)ContextsPackage.Literals.VIEW__SECTIONS, true, false, true, null, null, null));
    }

    protected void addAutomaticContextPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_View_automaticContext_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_View_automaticContext_feature", "_UI_View_type"), (EStructuralFeature)ContextsPackage.Literals.VIEW__AUTOMATIC_CONTEXT, true, false, false, ItemPropertyDescriptor.BOOLEAN_VALUE_IMAGE, null, null));
    }

    protected void addDatacontextsPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_View_datacontexts_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_View_datacontexts_feature", "_UI_View_type"), (EStructuralFeature)ContextsPackage.Literals.VIEW__DATACONTEXTS, true, false, true, null, null, null));
    }

    public Object getImage(Object object) {
        return this.overlayImage(object, this.getResourceLocator().getImage("full/obj16/View"));
    }

    public String getText(Object object) {
        String label = ((View)object).getName();
        return label == null || label.length() == 0 ? this.getString("_UI_View_type") : String.valueOf(this.getString("_UI_View_type")) + " " + label;
    }

    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(View.class)) {
            case 2: 
            case 5: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), false, true));
                return;
            }
        }
        super.notifyChanged(notification);
    }

    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
    }

    public ResourceLocator getResourceLocator() {
        return PropertiesEditPlugin.INSTANCE;
    }
}

